/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import client.MWClient;
import client.campaign.CUnit;
import client.gui.SpringLayoutHelper;
import client.gui.WholeNumberField;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class SellUnitDialog
extends JDialog
implements ActionListener {
    private MWClient mwclient;
    private final JButton okayButton = new JButton("OK");
    private final JButton cancelButton = new JButton("Cancel");
    private final String okayCommand = "Okay";
    private JTextField commentText = new JTextField();
    private JTextField minBidText = new WholeNumberField(0, 5);
    private JTextField ticksText = new WholeNumberField(0, 5);
    private JComboBox possibleSaleUnits = new JComboBox();

    public SellUnitDialog(JFrame parent, MWClient mwclient, Vector toSell) {
        super(parent, "Sell Unit", true);
        this.mwclient = mwclient;
        this.okayButton.setActionCommand("Okay");
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        JPanel buttonFlow = new JPanel();
        buttonFlow.add(this.okayButton);
        buttonFlow.add(this.cancelButton);
        if (toSell == null || toSell.size() == 0) {
            toSell = mwclient.getPlayer().getHangar();
        }
        this.possibleSaleUnits.setModel(new DefaultComboBoxModel(toSell){

            public Object getElementAt(int index) {
                CUnit mm = (CUnit)super.getElementAt(index);
                if (mm.getType() == 0 || mm.getType() == 1) {
                    return mm.getId() + " " + mm.getModelName() + " [" + mm.getPilot().getGunnery() + "/" + mm.getPilot().getPiloting() + "]";
                }
                return mm.getId() + " " + mm.getModelName() + " [" + mm.getPilot().getGunnery() + "]";
            }
        });
        JPanel comboBoxHolder = new JPanel(new SpringLayout());
        JLabel selectUnitHeader = new JLabel("Unit to sell:", 0);
        selectUnitHeader.setAlignmentX(0.5f);
        comboBoxHolder.add(selectUnitHeader);
        comboBoxHolder.add(this.possibleSaleUnits);
        SpringLayoutHelper.setupSpringGrid(comboBoxHolder, 2, 1);
        Dimension newDim = new Dimension();
        newDim.setSize(this.possibleSaleUnits.getMinimumSize().getWidth() * 1.25, this.possibleSaleUnits.getMinimumSize().getHeight());
        this.possibleSaleUnits.setMaximumSize(newDim);
        JPanel sellTextSpring = new JPanel(new SpringLayout());
        if (!Boolean.valueOf(mwclient.getserverConfigs("DisableMarketComments")).booleanValue()) {
            sellTextSpring.add(new JLabel("Comment:", 11));
            this.commentText.setToolTipText("Comment to be shown in tooltip.");
            sellTextSpring.add(this.commentText);
        }
        sellTextSpring.add(new JLabel("Minimum Bid:", 11));
        this.minBidText.setToolTipText("Minimum bid you're willing to accept for the unit.");
        this.minBidText.setText(mwclient.getserverConfigs("MinBMSalesPrice"));
        sellTextSpring.add(this.minBidText);
        sellTextSpring.add(new JLabel("Sale Ticks:", 11));
        this.ticksText.setToolTipText("Number of ticks the unit will remain on sale.");
        this.ticksText.setText(mwclient.getserverConfigs("MinBMSalesTicks"));
        sellTextSpring.add(this.ticksText);
        if (Boolean.valueOf(mwclient.getserverConfigs("DisableMarketComments")).booleanValue()) {
            SpringLayoutHelper.setupSpringGrid(sellTextSpring, 2, 2);
        } else {
            SpringLayoutHelper.setupSpringGrid(sellTextSpring, 3, 2);
        }
        this.getRootPane().setDefaultButton(this.cancelButton);
        JPanel generalLayout = new JPanel();
        generalLayout.setLayout(new BoxLayout(generalLayout, 1));
        generalLayout.add(new JLabel("\n"));
        generalLayout.add(comboBoxHolder);
        generalLayout.add(new JLabel("\n"));
        generalLayout.add(sellTextSpring);
        generalLayout.add(new JLabel("\n"));
        generalLayout.add(buttonFlow);
        this.getContentPane().add(generalLayout);
        this.pack();
        this.checkMinimumSize();
        this.setResizable(true);
        this.setLocationRelativeTo(null);
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("Okay")) {
            int index = this.possibleSaleUnits.getSelectedIndex();
            if (index < 0) {
                return;
            }
            String result = MWClient.CAMPAIGN_PREFIX + "c sell#";
            String mms = (String)this.possibleSaleUnits.getSelectedItem();
            StringTokenizer st = new StringTokenizer(mms);
            CUnit mm = this.mwclient.getPlayer().getUnit(Integer.parseInt(st.nextToken()));
            result = result + mm.getId();
            result = !this.ticksText.getText().equalsIgnoreCase("") ? result + "#" + this.ticksText.getText() : result + "#" + this.mwclient.getserverConfigs("MinBMSalesTicks");
            result = !this.minBidText.getText().equalsIgnoreCase("") ? result + "#" + this.minBidText.getText() : result + "#" + this.mwclient.getserverConfigs("MinBMSalesPrice");
            if (!this.commentText.getText().equalsIgnoreCase("")) {
                result = result + "#" + this.commentText.getText();
            }
            this.mwclient.sendChat(result);
            this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c autobmstatus");
        }
        this.dispose();
    }

    private void checkMinimumSize() {
        Dimension curDim = this.getSize();
        int height = 0;
        int width = 0;
        boolean shouldRedraw = false;
        if (curDim.getWidth() < 250.0) {
            width = 250;
            shouldRedraw = true;
        } else {
            width = (int)curDim.getWidth();
        }
        if (curDim.getHeight() < 250.0) {
            height = 250;
            shouldRedraw = true;
        } else {
            height = (int)curDim.getHeight();
        }
        if (shouldRedraw) {
            this.setSize(new Dimension(width, height));
        }
    }
}

