/*
 * Decompiled with CFR 0.152.
 */
package client.protocol;

import client.MWClient;
import client.campaign.DefaultServerOptions;
import common.CampaignData;
import common.House;
import common.util.BinReader;
import common.util.BinWriter;
import common.util.MD5;
import common.util.MD5OutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DataFetchClient {
    private String hostAddr;
    private String cacheDir;
    private CampaignData data;
    private Map changesSinceLastRefresh;
    private Date lastTimestamp = null;
    private int dataPort = 4867;

    public DataFetchClient(int dataport) {
        this.dataPort = dataport;
        this.changesSinceLastRefresh = new HashMap();
    }

    public void getServerConfigData(MWClient mwclient) throws IOException {
        boolean md5Match = false;
        boolean localConfigExists = false;
        File localConfig = new File(this.cacheDir + "/campaignconfig.txt");
        if (localConfig.exists()) {
            try {
                localConfigExists = true;
                String localConfigMD5 = MD5.getHashString(localConfig);
                BinReader in = this.openConnection("ServerConfigMD5");
                String serverConfigMD5 = in.readLine("ServerConfigMD5");
                MWClient.mwClientLog.clientErrLog("Local Config: " + localConfigMD5 + " Server Config: " + serverConfigMD5);
                if (localConfigMD5.equals(serverConfigMD5)) {
                    md5Match = true;
                    try {
                        FileInputStream configFile = new FileInputStream(this.cacheDir + "/campaignconfig.txt");
                        mwclient.serverConfigs.load(configFile);
                        configFile.close();
                    }
                    catch (Exception ex) {
                        md5Match = false;
                    }
                }
            }
            catch (Exception exe) {
                this.loadLocalDefaultServerConfig(mwclient, exe);
                return;
            }
        }
        if (!md5Match || !localConfigExists) {
            if (localConfigExists) {
                File f = new File(this.cacheDir + "/campaignconfig.txt");
                f.delete();
            }
            try {
                BinReader in = this.openConnection("ServerConfig");
                FileOutputStream fops = new FileOutputStream(this.cacheDir + "/campaignconfig.txt");
                PrintStream out = new PrintStream(fops);
                try {
                    while (true) {
                        out.println(in.readLine("ConfigLine"));
                    }
                }
                catch (Exception e) {
                    in.close();
                    out.close();
                    fops.close();
                    try {
                        FileInputStream configFile = new FileInputStream(this.cacheDir + "/campaignconfig.txt");
                        mwclient.serverConfigs.load(configFile);
                        configFile.close();
                    }
                    catch (Exception ex) {
                        MWClient.mwClientLog.clientErrLog(ex);
                    }
                }
            }
            catch (Exception exe) {
                this.loadLocalDefaultServerConfig(mwclient, exe);
            }
        }
    }

    public void getServerBannedAmmoData(MWClient mwclient) throws IOException {
        MWClient.mwClientLog.clientErrLog("Retriving Server wide banned ammo list");
        boolean md5Match = false;
        try {
            String localMD5 = MD5.getHashString(this.data.getServerBannedAmmo().toString());
            BinReader in = this.openConnection("ServerBannedAmmoMD5");
            String serverMD5 = in.readLine("ServerBannedAmmoMD5");
            MWClient.mwClientLog.clientErrLog("Banned ammo MD5: " + localMD5 + " Server Config: " + serverMD5);
            if (localMD5.equals(serverMD5)) {
                md5Match = true;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (!md5Match) {
            BinReader in = this.openConnection("ServerBannedAmmo");
            this.data.binBannedAmmoIn(in);
        }
    }

    public void getHouseBannedAmmoData(MWClient mwclient) throws IOException {
        MWClient.mwClientLog.clientErrLog("Retriving All Houses banned ammo list");
        boolean md5Match = false;
        try {
            BinWriter banWriter = new BinWriter(new PrintWriter(new FileWriter(this.cacheDir + "/housebannedammo.dat")));
            for (House house : mwclient.getData().getAllHouses()) {
                house.HouseBannedAmmoOut(banWriter);
            }
            String localMD5 = MD5.getHashString(banWriter.toString());
            BinReader in = this.openConnection("HouseBannedAmmoMD5");
            String serverMD5 = in.readLine("HouseBannedAmmoMD5");
            MWClient.mwClientLog.clientErrLog("Banned ammo MD5: " + localMD5 + " Server Config: " + serverMD5);
            if (localMD5.equals(serverMD5)) {
                md5Match = true;
            }
        }
        catch (Exception ex) {
            MWClient.mwClientLog.clientErrLog(ex);
        }
        if (!md5Match) {
            BinReader in = this.openConnection("HouseBannedAmmo");
            this.data.binHouseBannedAmmoIn(in);
        }
    }

    public void checkForMostRecentOpList(MWClient mwclient) throws IOException {
        boolean md5Match = false;
        File localList = new File(this.cacheDir + "/OpList.txt");
        if (localList.exists()) {
            try {
                String localListMD5 = MD5.getHashString(localList);
                BinReader binIn = this.openConnection("OpListMD5");
                String serverListMD5 = binIn.readLine("OpListMD5");
                MWClient.mwClientLog.clientErrLog("Local List: " + localListMD5 + ", Server List: " + serverListMD5);
                if (localListMD5.equals(serverListMD5)) {
                    md5Match = true;
                }
            }
            catch (Exception exe) {
                MWClient.mwClientLog.clientErrLog(exe);
            }
        }
        if (!md5Match) {
            File f = new File(this.cacheDir + "/OpList.txt");
            if (f.exists()) {
                f.delete();
            }
            try {
                BinReader in = this.openConnection("OpList");
                FileOutputStream fops = new FileOutputStream(this.cacheDir + "/OpList.txt");
                PrintStream out = new PrintStream(fops);
                try {
                    while (true) {
                        out.println(in.readLine("ListLine"));
                    }
                }
                catch (Exception e) {
                    in.close();
                    out.close();
                    fops.close();
                }
            }
            catch (Exception exe) {
                MWClient.mwClientLog.clientErrLog(exe);
            }
        }
    }

    public void getServerTraitFiles() throws IOException {
        try {
            BinReader in = this.openConnection("ServerTrait");
            try {
                while (true) {
                    String faction = in.readLine("TraitLine");
                    FileOutputStream fops = new FileOutputStream(this.cacheDir + "/" + faction.toLowerCase() + "traitnames.txt");
                    PrintStream out = new PrintStream(fops);
                    for (int count = in.readInt("TraitLine"); count > 0; --count) {
                        out.println(in.readLine("TraitLine"));
                    }
                    out.close();
                    fops.close();
                }
            }
            catch (Exception e) {
                in.close();
            }
        }
        catch (Exception ex) {
            MWClient.mwClientLog.clientErrLog(ex);
        }
    }

    public String getServerMegaMekGameOptionsMD5() {
        String result = "";
        try {
            BinReader in = this.openConnection("ServerMegaMekGameOptionsMD5");
            result = in.readLine("ServerMegaMekGameOptionsMD5");
        }
        catch (Exception ex) {
            MWClient.mwClientLog.clientErrLog("Error retriving MD5 for game options");
            MWClient.mwClientLog.clientErrLog(ex);
        }
        return result;
    }

    public void getServerMegaMekGameOptions() throws IOException {
        boolean md5Match = false;
        boolean localOptionsExists = false;
        File localGameOptions = new File("mmconf/gameoptions.xml");
        try {
            if (localGameOptions.exists()) {
                MWClient.mwClientLog.clientErrLog("- local gameoptions.xml exists. checking MD5.");
                try {
                    localOptionsExists = true;
                    String localOptionsMD5 = MD5.getHashString(localGameOptions);
                    String ServerMegaMekGameOptionsMD5 = this.getServerMegaMekGameOptionsMD5();
                    if (localOptionsMD5.equals(ServerMegaMekGameOptionsMD5)) {
                        MWClient.mwClientLog.clientErrLog("- MD5 matches leaving alone.");
                        return;
                    }
                }
                catch (Exception ex) {
                    MWClient.mwClientLog.clientErrLog("- Error checkign gameoptions.xml");
                }
            }
            MWClient.mwClientLog.clientErrLog("- MD5 mismatch. Pulling gameoptions.xml from the server!");
            BinReader in = this.openConnection("ServerMegaMekGameOptions");
            FileOutputStream fops = null;
            PrintStream out = null;
            try {
                File options = new File("./mmconf/gameoptions.xml");
                fops = new FileOutputStream(options);
                out = new PrintStream(fops);
                while (true) {
                    String tempString;
                    if ((tempString = in.readStringLine("GameOption")).equals("NoFileFound")) {
                        out.close();
                        fops.close();
                        in.close();
                        options.delete();
                        return;
                    }
                    System.err.println(tempString);
                    out.println(tempString);
                }
            }
            catch (Exception e) {
                out.close();
                fops.close();
                in.close();
            }
        }
        catch (Exception ex) {
            MWClient.mwClientLog.clientErrLog(ex);
        }
    }

    public CampaignData getAllData() throws IOException {
        BinReader in = this.openConnection("All");
        CampaignData data = new CampaignData(in);
        in.close();
        this.data = data;
        this.store();
        return data;
    }

    public CampaignData getCacheData(String cachePath) throws IOException {
        BinReader in = new BinReader(new FileReader(cachePath + "/data.dat"));
        CampaignData data = new CampaignData(in);
        in.close();
        this.data = data;
        this.store();
        return data;
    }

    public boolean getPlanetsUpdate(CampaignData Data) {
        try {
            BinReader in = this.openConnection("PDiff");
            this.data = Data;
            if (this.data == null) {
                MWClient.mwClientLog.clientErrLog("data is null getPlanetsUpdate");
            }
            this.changesSinceLastRefresh = new HashMap();
            this.data.decodeMutablePlanets(in, this.changesSinceLastRefresh);
            String serverMD5 = in.readLine("md5");
            MWClient.mwClientLog.clientOutputLog("read MD5 checksum: " + serverMD5);
            MD5OutputStream md5 = new MD5OutputStream();
            BinWriter md5Writer = new BinWriter(new PrintWriter(md5));
            this.data.binOut(md5Writer);
            md5Writer.close();
            MWClient.mwClientLog.clientOutputLog("own checksum: " + md5.getHashString());
            if (!serverMD5.equals(md5.getHashString())) {
                md5.close();
                return false;
            }
            md5.close();
            in.close();
        }
        catch (IOException e) {
            MWClient.mwClientLog.clientErrLog(e);
            return false;
        }
        catch (RuntimeException e) {
            MWClient.mwClientLog.clientErrLog(e);
            return false;
        }
        this.store();
        return true;
    }

    public boolean getAccessLevels(CampaignData Data) {
        try {
            BinReader in = this.openConnection("CommandAccessLevels");
            Data.importAccessLevels(in);
            in.close();
        }
        catch (IOException e) {
            MWClient.mwClientLog.clientErrLog(e);
            return false;
        }
        catch (RuntimeException e) {
            MWClient.mwClientLog.clientErrLog(e);
            return false;
        }
        return true;
    }

    private BinReader openConnection(String cmd) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        MWClient.mwClientLog.clientOutputLog("Try to connect to " + this.hostAddr + " at port " + this.dataPort);
        Socket socket = new Socket(this.hostAddr, this.dataPort);
        BinWriter out = new BinWriter(new PrintWriter(socket.getOutputStream()));
        out.println(cmd, "cmd");
        if (this.lastTimestamp == null) {
            out.println("", "lasttimestamp");
        } else {
            MWClient.mwClientLog.clientOutputLog("writing timestamp " + sdf.format(this.lastTimestamp));
            out.println(sdf.format(this.lastTimestamp), "lasttimestamp");
        }
        out.flush();
        BinReader in = new BinReader(new InputStreamReader(socket.getInputStream()));
        try {
            this.lastTimestamp = sdf.parse(in.readLine("lasttimestamp"));
        }
        catch (ParseException e) {
            MWClient.mwClientLog.clientErrLog(e);
            MWClient.mwClientLog.clientOutputLog("Timestamp could not be parsed.. left unchanged.");
        }
        return in;
    }

    public void setData(String hostAddr, String cacheDir) {
        this.hostAddr = hostAddr;
        this.cacheDir = cacheDir;
    }

    public void store() {
        try {
            FileWriter fw = new FileWriter(this.cacheDir + "/dataLastUpdated.dat");
            fw.write(Long.toString(this.lastTimestamp.getTime()));
            fw.close();
        }
        catch (IOException e) {
            MWClient.mwClientLog.clientErrLog(e);
        }
        try {
            BinWriter binOut = new BinWriter(new PrintWriter(new FileWriter(this.cacheDir + "/data.dat")));
            this.data.binOut(binOut);
            binOut.close();
        }
        catch (Exception ex) {
            MWClient.mwClientLog.clientErrLog(ex);
            MWClient.mwClientLog.clientErrLog("Error saving data.");
        }
    }

    public Map getChangesSinceLastRefresh() {
        return this.changesSinceLastRefresh;
    }

    public void setLastTimestamp(Date lastTimestamp) {
        this.lastTimestamp = lastTimestamp;
    }

    public void loadLocalDefaultServerConfig(MWClient mwclient, Exception exe) {
        MWClient.mwClientLog.clientErrLog("* Error while loading server config file");
        MWClient.mwClientLog.clientErrLog("* Loading client side defaults from /data/defaults/ ...");
        try {
            FileInputStream configFile = new FileInputStream("./data/defaults/ServerConfig.txt");
            mwclient.serverConfigs.load(configFile);
            configFile.close();
            MWClient.mwClientLog.clientErrLog("* /data/defaults/ServerConfig.txt read succesful.");
        }
        catch (Exception ed) {
            MWClient.mwClientLog.clientErrLog("* /data/defaults/ServerConfig.txt read failed.");
            MWClient.mwClientLog.clientErrLog("* Loading hardcoded defaults from client.campaign.DefaultServerOptions");
            try {
                DefaultServerOptions defaults = new DefaultServerOptions();
                mwclient.serverConfigs = defaults.getServerDefaults();
                MWClient.mwClientLog.clientErrLog("* client.campaign.DefaultServerOptions loaded ... EXPECT IRREGULARITIES!");
            }
            catch (Exception ec) {
                MWClient.mwClientLog.clientErrLog("* client.campaign.DefaultServerOptions load failed. You're completely screwed.");
                return;
            }
        }
        MWClient.mwClientLog.clientErrLog("- stack trace for datastream failure follows:");
        MWClient.mwClientLog.clientErrLog(exe);
    }
}

