/*
 * Decompiled with CFR 0.152.
 */
package common.comm;

import common.comm.ServerDescriptionList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.util.StringTokenizer;

public class ServerDescription {
    private String name;
    private String host;
    private int port;
    private int dataPort;
    private String briefDescription;
    private String description;
    private String clientVersion;

    public String connect(ServerDescriptionList myKnownServers) {
        System.out.print("Connecting " + this.name + " (" + this.host + ":" + this.port + ") for new server descriptions...");
        try {
            Socket s = new Socket(this.host, this.port);
            PrintStream out = new PrintStream(s.getOutputStream());
            BufferedReader in = new BufferedReader(new InputStreamReader(s.getInputStream()));
            StringBuffer sb = new StringBuffer("/signon\tS\t");
            sb.append(myKnownServers.encode());
            sb.append("\r\n");
            out.print(sb.toString());
            String input = in.readLine();
            StringTokenizer st = new StringTokenizer(input, "#");
            if (st.hasMoreTokens() && st.nextToken().equals("ServerDescription")) {
                System.out.println("found.");
                if (st.hasMoreTokens()) {
                    return st.nextToken();
                }
                return "";
            }
            System.out.println("broken server. Delete from list.");
        }
        catch (IOException e) {
            System.out.println("not found. Delete from list.");
        }
        return null;
    }

    public String encode() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        sb.append("$");
        sb.append(this.host);
        sb.append("$");
        sb.append(this.port);
        sb.append("$");
        sb.append(this.dataPort);
        sb.append("$");
        sb.append(this.briefDescription);
        sb.append("$");
        sb.append(this.description);
        sb.append("$");
        sb.append(this.clientVersion);
        return sb.toString();
    }

    public void decode(StringTokenizer st) {
        try {
            this.name = st.nextToken("$");
            this.host = st.nextToken("$");
            this.port = Integer.parseInt(st.nextToken("$"));
            this.dataPort = Integer.parseInt(st.nextToken("$"));
            this.briefDescription = st.nextToken("$");
            this.description = st.nextToken("$");
            this.clientVersion = st.nextToken("$");
        }
        catch (Exception ex) {
            System.err.println("Error decoding Server Description Check Server Configuration for correct format or remove from the sever config file. So the defaults will reload");
        }
    }

    public boolean equivalent(ServerDescription sd) {
        return this.host.equals(sd.host) && this.port == sd.port;
    }
}

