/*
 * Decompiled with CFR 0.152.
 */
package common.comm;

import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import common.comm.ServerDescription;
import common.util.MMNetXStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class ServerDescriptionList {
    public static ServerDescription ownServerDescription = new ServerDescription();
    private Collection serverList;

    public ServerDescriptionList(ServerDescriptionList list) {
        this.serverList = new LinkedList(list.serverList);
    }

    public ServerDescriptionList() {
        this.serverList = new LinkedList();
    }

    public void load(String filename) {
        MMNetXStream xml = new MMNetXStream((HierarchicalStreamDriver)new DomDriver());
        try {
            this.serverList = (Collection)xml.fromXML(new FileReader(filename));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save(String filename) {
        MMNetXStream xml = new MMNetXStream((HierarchicalStreamDriver)new DomDriver());
        try {
            xml.toXML(this.serverList, new FileWriter(filename));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void merge(String otherSD) {
        StringTokenizer st = new StringTokenizer(otherSD, "#");
        while (st.hasMoreTokens()) {
            ServerDescription sd = new ServerDescription();
            sd.decode(st);
            this.update(sd);
        }
    }

    public String encode() {
        StringBuffer sb = new StringBuffer();
        for (ServerDescription sd : this.serverList) {
            sb.append(sd.encode());
            sb.append("#");
        }
        sb.append(ownServerDescription.encode());
        sb.append("\r\n");
        return sb.toString();
    }

    public String toHTMLString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<html><body><table border=\"3\"><tr><th>Name</th><th>Host</th><th>Port</th><th>Data Port</th><th>Short Description</th><th>Long Description</th><th>Client Version</th></tr>");
        for (ServerDescription sd : this.serverList) {
            sb.append("<tr><td>");
            String x = sd.encode();
            while (x.indexOf(35) != -1) {
                x = x.substring(0, x.indexOf(35)) + "</td><td>" + x.substring(x.indexOf(35) + 1);
            }
            sb.append(x);
            sb.append("</td></tr>");
        }
        sb.append("<tr><td>");
        String x = ownServerDescription.encode();
        while (x.indexOf(35) != -1) {
            x = x.substring(0, x.indexOf(35)) + "</td><td>" + x.substring(x.indexOf(35) + 1);
        }
        sb.append(x);
        sb.append("</td></tr>");
        sb.append("</tr></table></body></html>");
        return sb.toString();
    }

    public void connectAll() {
        LinkedList<ServerDescription> unreachable = new LinkedList<ServerDescription>();
        LinkedList sdOld = new LinkedList(this.serverList);
        for (ServerDescription sd : sdOld) {
            String otherSD = sd.connect(this);
            if (otherSD == null) {
                unreachable.add(sd);
                continue;
            }
            this.merge(otherSD);
        }
        Iterator it = unreachable.iterator();
        while (it.hasNext()) {
            this.remove((ServerDescription)it.next());
        }
    }

    public void update(ServerDescription sd) {
        if (sd.equivalent(ownServerDescription)) {
            return;
        }
        this.remove(sd);
        this.serverList.add(sd);
    }

    public void remove(ServerDescription sd) {
        Iterator it = this.serverList.iterator();
        while (it.hasNext()) {
            if (!sd.equivalent((ServerDescription)it.next())) continue;
            it.remove();
        }
    }
}

