/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.bot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import megamek.client.bot.MoveOption;
import megamek.client.bot.Strategy;
import megamek.client.bot.TestBot;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.MovePath;
import megamek.common.Protomech;
import megamek.common.Tank;
import megamek.common.WeaponType;

public class CEntity {
    static final double[][] TANK_ARMOR = new double[][]{{0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 0.0}};
    static final double[][] TANK_WT_ARMOR = new double[][]{{0.0, 0.8611111111111112, 0.0, 0.0, 0.0, 0.1388888888888889}, {0.0, 0.0, 0.0, 0.0, 0.8611111111111112, 0.1388888888888889}, {0.0, 0.0, 0.0, 0.8611111111111112, 0.0, 0.1388888888888889}, {0.0, 0.0, 0.8611111111111112, 0.0, 0.0, 0.1388888888888889}};
    static final double[][] INFANTRY_ARMOR = new double[][]{{1.0}, {1.0}, {1.0}, {1.0}};
    static final double[][] PROTOMECH_ARMOR = new double[][]{{0.03225806451612903, 0.5161290322580645, 0.0967741935483871, 0.0967741935483871, 0.25806451612903225}, {0.03225806451612903, 0.5161290322580645, 0.0967741935483871, 0.0967741935483871, 0.25806451612903225}, {0.03225806451612903, 0.5161290322580645, 0.0967741935483871, 0.0967741935483871, 0.25806451612903225}, {0.03225806451612903, 0.5161290322580645, 0.0967741935483871, 0.0967741935483871, 0.25806451612903225}};
    static final double[][] PROTOMECH_MG_ARMOR = new double[][]{{0.03125, 0.5, 0.09375, 0.09375, 0.25, 0.03125}, {0.03225806451612903, 0.5, 0.09375, 0.09375, 0.25, 0.03125}, {0.03225806451612903, 0.5, 0.09375, 0.09375, 0.25, 0.03125}, {0.03225806451612903, 0.5, 0.09375, 0.09375, 0.25, 0.03125}};
    static final double[][] MECH_ARMOR = new double[][]{{0.027777777777777776, 0.19444444444444445, 0.16666666666666666, 0.16666666666666666, 0.1111111111111111, 0.1111111111111111, 0.1111111111111111, 0.1111111111111111}, {0.027777777777777776, 0.19444444444444445, 0.16666666666666666, 0.16666666666666666, 0.1111111111111111, 0.1111111111111111, 0.1111111111111111, 0.1111111111111111}, {0.027777777777777776, 0.16666666666666666, 0.1111111111111111, 0.19444444444444445, 0.05555555555555555, 0.16666666666666666, 0.05555555555555555, 0.2222222222222222}, {0.027777777777777776, 0.16666666666666666, 0.19444444444444445, 0.1111111111111111, 0.16666666666666666, 0.05555555555555555, 0.2222222222222222, 0.05555555555555555}};
    public static final int MAX_RANGE = 24;
    public static final int OVERHEAT_NONE = 0;
    public static final int OVERHEAT_LOW = 1;
    public static final int OVERHEAT_HIGH = 2;
    public static final int RANGE_SHORT = 0;
    public static final int RANGE_MEDIUM = 1;
    public static final int RANGE_LONG = 2;
    public static final int RANGE_ALL = 3;
    public static final int FIRST_ARC = 0;
    public static final int LAST_PRIMARY_ARC = 3;
    public static final int LAST_ARC = 4;
    public static final int TT = 4;
    public static final int LEFT_LEG = 0;
    public static final int RIGHT_LEG = 1;
    Entity entity;
    MoveOption current;
    MoveOption last;
    private MoveOption.Table moves;
    MoveOption.Table pass = new MoveOption.Table();
    public int runMP;
    public int jumpMP;
    boolean isPhysicalTarget = false;
    int overheat = 0;
    int range = 3;
    int long_range = 0;
    double[] range_damages = new double[4];
    double base_psr_odds = 1.0;
    boolean hasTakenDamage = false;
    public Strategy strategy = new Strategy();
    double[] armor_health = new double[]{0.0, 0.0, 0.0, 0.0};
    double[] armor_percent = new double[]{0.0, 0.0, 0.0, 0.0};
    double avg_armor = 0.0;
    double avg_iarmor = 0.0;
    double[] expected_damage = new double[]{0.0, 0.0, 0.0, 0.0};
    double[] possible_damage = new double[]{0.0, 0.0, 0.0, 0.0};
    double[] leg_health = new double[]{0.0, 0.0};
    double overall_armor_percent = 0.0;
    double[][] damages = new double[6][25];
    int bv;
    int enemy_num;
    private TestBot tb;
    boolean engaged = false;
    boolean moved = false;
    boolean justMoved = false;
    boolean tsm_offset = false;
    int[] minRangeMods = new int[7];

    public CEntity(Entity entity, TestBot testBot) {
        this.entity = entity;
        this.tb = testBot;
        this.reset();
    }

    public Entity getEntity() {
        return this.entity;
    }

    public boolean canMove() {
        return !(!this.entity.isSelectableThisTurn() || this.entity.isProne() && this.base_psr_odds < 0.2 || this.entity.isImmobile());
    }

    public boolean justMoved() {
        return !this.moved && !this.entity.isSelectableThisTurn() || this.justMoved;
    }

    public void reset() {
        this.entity = this.tb.game.getEntity(this.entity.getId());
        for (int i = 0; i <= 4; ++i) {
            Arrays.fill(this.damages[i], 0.0);
        }
        this.characterize();
        this.resetPossibleDamage();
        this.moves = null;
        this.hasTakenDamage = false;
        Arrays.fill(this.expected_damage, 0.0);
        this.engaged = false;
        this.moved = false;
        this.isPhysicalTarget = false;
    }

    public void refresh() {
        this.entity = this.tb.game.getEntity(this.entity.getId());
        if (this.justMoved()) {
            for (int i = 0; i <= 4; ++i) {
                Arrays.fill(this.damages[i], 0.0);
            }
            this.characterize();
            this.resetPossibleDamage();
        }
    }

    public void resetPossibleDamage() {
        Arrays.fill(this.possible_damage, 0.0);
    }

    public void characterize() {
        int n;
        int n2;
        int n3;
        this.entity = this.tb.game.getEntity(this.entity.getId());
        this.current = new MoveOption(this.tb.game, this);
        this.bv = this.entity.calculateBattleValue();
        this.runMP = this.entity.getRunMP();
        this.jumpMP = this.entity.getJumpMP();
        this.overall_armor_percent = this.entity.getArmorRemainingPercent();
        this.base_psr_odds = Compute.oddsAbove(this.entity.getBasePilotingRoll().getValue()) / 100.0;
        if (this.entity instanceof Mech && ((Mech)this.tb.game.getEntity(this.entity.getId())).hasTSM()) {
            this.tsm_offset = true;
        }
        double d = 0.9;
        if (this.entity.heat > 7) {
            d = 0.8;
        }
        if (this.entity.heat > 12) {
            d = 0.5;
        }
        if (this.tsm_offset) {
            if (this.entity.heat == 9) {
                d = 1.0;
            }
            if (this.entity.heat < 12 && this.entity.heat > 9) {
                d = 0.8;
            }
        }
        if (this.entity.heat > 16) {
            d = 0.35;
        }
        int n4 = this.entity.getHeatCapacity();
        int n5 = 0;
        Enumeration enumeration = this.entity.getWeapons();
        int n6 = 0;
        this.minRangeMods = new int[7];
        while (enumeration.hasMoreElements()) {
            Mounted mounted;
            ++n6;
            Mounted mounted2 = (Mounted)enumeration.nextElement();
            int n7 = this.entity.getWeaponArc(this.entity.getEquipmentNum(mounted2));
            WeaponType weaponType = (WeaponType)mounted2.getType();
            boolean bl = weaponType.getAmmoType() != -1;
            Mounted mounted3 = mounted = bl ? mounted2.getLinked() : null;
            if (mounted2.isDestroyed() || bl && (mounted == null || mounted.getShotsLeft() == 0)) continue;
            n5 += weaponType.getHeat();
            int n8 = weaponType.getMinimumRange();
            int n9 = weaponType.getShortRange();
            n3 = weaponType.getMediumRange();
            int n10 = weaponType.getLongRange();
            double d2 = CEntity.getExpectedDamage(weaponType);
            double d3 = 0.0;
            int n11 = this.entity.getCrew().getGunnery();
            for (int i = 1; i <= n10 && i <= 24; ++i) {
                if (i <= n8) {
                    if (i < 7) {
                        int n12 = i;
                        this.minRangeMods[n12] = this.minRangeMods[n12] + (1 + n8 - i);
                    }
                    d3 = Compute.oddsAbove(n11 + 1 + n8 - i) / 100.0;
                } else if (i <= n9) {
                    d3 = Compute.oddsAbove(n11) / 100.0;
                } else if (i <= n3) {
                    d3 = Compute.oddsAbove(n11 + 2) / 100.0;
                } else if (i <= n10) {
                    d3 = Compute.oddsAbove(n11 + 4) / 100.0;
                }
                this.addDamage(n7, this.entity.isSecondaryArcWeapon(this.entity.getEquipmentNum(mounted2)), i, d2 * d3 * (weaponType.getHeat() > 0 ? d : 1.0));
                this.long_range = Math.max(this.long_range, i);
            }
        }
        for (n2 = 1; n2 < this.minRangeMods.length; ++n2) {
            if (n6 <= 0) continue;
            this.minRangeMods[n2] = (int)Math.round((double)this.minRangeMods[n2] / (double)n6);
        }
        n2 = n5 - n4;
        if (this.entity instanceof Mech && this.entity.isStealthActive()) {
            n2 += 10;
        }
        if (this.entity.infernos.isStillBurning()) {
            n2 += 6;
        }
        if (this.entity instanceof Mech) {
            n2 += this.entity.getEngineCritHeat();
        }
        if (this.entity.getPosition() != null && this.tb.game.getBoard().getHex(this.entity.getPosition()) != null && this.tb.game.getBoard().getHex(this.entity.getPosition()).terrainLevel(7) == 2) {
            n2 += 5;
        }
        if ((n2 += this.tb.game.getTemperatureDifference()) < 8 && n2 > 3) {
            this.overheat = 1;
        } else if (n2 > 12) {
            this.overheat = 2;
        }
        double d4 = 1.0;
        double[][] dArray = MECH_ARMOR;
        if (this.entity instanceof Tank) {
            dArray = ((Tank)this.entity).hasNoTurret() ? TANK_ARMOR : TANK_WT_ARMOR;
        } else if (this.entity instanceof Infantry) {
            dArray = INFANTRY_ARMOR;
        } else if (this.entity instanceof Protomech) {
            dArray = ((Protomech)this.entity).hasMainGun() ? PROTOMECH_MG_ARMOR : PROTOMECH_ARMOR;
        }
        for (n = 0; n <= 3; ++n) {
            double d5 = 0.0;
            for (n3 = 0; n3 < dArray[n].length; ++n3) {
                d5 += dArray[n][n3] * this.getArmorValue(n3, n == 1);
            }
            this.armor_health[n] = d5;
            d4 = Math.max(this.armor_health[n], d4);
        }
        this.avg_armor = (this.armor_health[0] + this.armor_health[1] + this.armor_health[2] + this.armor_health[3]) / 4.0;
        this.avg_iarmor = this.entity.getTotalInternal() / 5;
        for (n = 0; n <= 3; ++n) {
            this.armor_percent[n] = this.armor_health[n] / d4;
        }
        this.computeRange();
    }

    private void addDamage(int n, boolean bl, int n2, double d) {
        double[] dArray = this.damages[CEntity.firingArcToHitArc(n)];
        int n3 = n2;
        dArray[n3] = dArray[n3] + d;
        if (n != 4 && n != 0) {
            double[] dArray2 = this.damages[0];
            int n4 = n2;
            dArray2[n4] = dArray2[n4] + d;
            if (bl) {
                double[] dArray3 = this.damages[4];
                int n5 = n2;
                dArray3[n5] = dArray3[n5] + d;
            }
        }
        if (n == 0) {
            for (int i = 0; i <= 4; ++i) {
                double[] dArray4 = this.damages[i];
                int n6 = n2;
                dArray4[n6] = dArray4[n6] + d;
            }
        }
    }

    private void computeRange() {
        Arrays.fill(this.range_damages, 0.0);
        for (int i = 0; i < 3; ++i) {
            for (int j = 1 + 6 * i; j < 8 + 6 * i; ++j) {
                int n = i;
                this.range_damages[n] = this.range_damages[n] + this.damages[0][j];
            }
            int n = i;
            this.range_damages[n] = this.range_damages[n] / 8.0;
            this.range_damages[3] = this.range_damages[3] + this.range_damages[i];
        }
        this.range_damages[3] = this.range_damages[3] / 3.0;
        this.range = this.range_damages[0] > 2.5 * this.range_damages[1] ? 0 : (this.range_damages[1] > 2.5 * this.range_damages[2] ? 1 : (this.range_damages[2] > 0.25 * this.range_damages[0] ? 2 : 3));
    }

    protected double getArmorValue(int n, boolean bl) {
        double d = this.entity.getArmor(n, bl);
        double d2 = d / (double)this.entity.getOArmor(n, bl);
        if (d2 < 0.25) {
            d *= 0.5;
        } else if (d2 < 0.6) {
            d *= 0.8;
        }
        return d;
    }

    public double getThreatUtility(double d, int n) {
        double d2 = d;
        double d3 = d;
        if (this.armor_percent[n] < 0.75) {
            d2 *= 1.1;
        } else if (this.armor_percent[n] < 0.5) {
            d2 *= 1.3;
        } else if (this.armor_percent[n] < 0.25) {
            d2 *= 1.5;
        }
        if (d3 + this.expected_damage[n] > this.armor_health[n]) {
            if ((d3 + this.expected_damage[0] + this.expected_damage[1] + this.expected_damage[2] + this.expected_damage[3] > 3.0 * (this.avg_armor + this.avg_iarmor) || this.entity.isProne() && this.base_psr_odds < 0.1 && !this.entity.isImmobile()) && this.entity.isEnemyOf((Entity)this.tb.getEntitiesOwned().get(0))) {
                return Math.sqrt(d3) * this.strategy.target;
            }
            d3 *= 1.5;
        } else if (this.expected_damage[n] > 0.0) {
            d3 *= 1.3;
        } else if (this.hasTakenDamage) {
            d3 *= 1.1;
        }
        return Math.max(d2, d3) * this.strategy.target;
    }

    public Integer getKey() {
        return new Integer(this.entity.getId());
    }

    public MoveOption.Table getAllMoves() {
        if (this.moves == null) {
            this.moves = this.calculateMoveOptions(this.current);
        }
        return this.moves;
    }

    protected MoveOption.Table calculateMoveOptions(MoveOption moveOption) {
        Object object;
        ArrayList<MovePath> arrayList = new ArrayList<MovePath>();
        MoveOption.Table table = new MoveOption.Table();
        if (this.entity.getJumpMPWithTerrain() > 0) {
            arrayList.add(((MovePath)moveOption.clone()).addStep(7));
        }
        arrayList.add(moveOption);
        table.put(moveOption);
        while (arrayList.size() > 0) {
            object = (MoveOption)arrayList.remove(0);
            for (MoveOption moveOption2 : ((MovePath)object).getNextMoves(true, true)) {
                int n;
                if (moveOption2.changeToPhysical() && moveOption2.isMoveLegal()) {
                    table.put(moveOption2);
                    continue;
                }
                if (!moveOption2.isMoveLegal() || table.get(moveOption2) != null && !(moveOption2.getDistUtility() < table.get(moveOption2).getDistUtility())) continue;
                table.put(moveOption2);
                if (moveOption2.isJumping()) {
                    MoveOption moveOption3 = (MoveOption)moveOption2.clone();
                    MoveOption moveOption4 = (MoveOption)moveOption2.clone();
                    for (int i = 0; i < 2; ++i) {
                        ((MovePath)moveOption3).addStep(3);
                        ((MovePath)moveOption4).addStep(4);
                        table.put((MovePath)((MovePath)moveOption3).clone());
                        table.put((MovePath)((MovePath)moveOption4).clone());
                    }
                    ((MovePath)moveOption4).addStep(4);
                    table.put(moveOption4);
                }
                if ((n = Collections.binarySearch(arrayList, moveOption2, MoveOption.DISTANCE_COMPARATOR)) < 0) {
                    n = -n - 1;
                }
                arrayList.add(n, moveOption2);
            }
        }
        object = table.values().iterator();
        while (object.hasNext()) {
            MoveOption moveOption5 = (MoveOption)object.next();
            moveOption5.clipToPossible();
            if (!moveOption5.isMoveLegal()) {
                object.remove();
            }
            if (this.entity.heat <= 4) continue;
            moveOption5.movement_threat += (double)(this.bv / 1000 * moveOption5.getMovementheatBuildup());
            if (this.entity.heat > 7) {
                moveOption5.movement_threat += (double)(this.bv / 500 * moveOption5.getMovementheatBuildup());
            }
            if (this.tsm_offset) {
                if (this.entity.heat == 9) {
                    moveOption5.movement_threat -= (double)(this.bv / 100 * moveOption5.getMovementheatBuildup());
                }
                if (this.entity.heat < 12 && this.entity.heat > 9) {
                    moveOption5.movement_threat -= (double)(this.bv / 500 * moveOption5.getMovementheatBuildup());
                }
            }
            if (this.entity.heat <= 12) continue;
            moveOption5.movement_threat += (double)(this.bv / 100 * moveOption5.getMovementheatBuildup());
        }
        return table;
    }

    public ArrayList findMoves(Coords coords) {
        ArrayList<MoveOption> arrayList = new ArrayList<MoveOption>();
        for (int i = 0; i < 6; ++i) {
            for (int j = 1; j < 2; ++j) {
                MovePath.Key key = new MovePath.Key(coords, i, j);
                MoveOption moveOption = null;
                moveOption = (MoveOption)this.moves.get(key);
                if (moveOption == null) continue;
                arrayList.add(moveOption);
            }
        }
        return arrayList;
    }

    public double getModifiedDamage(int n, int n2, int n3) {
        if (n2 > 24) {
            return 0.0;
        }
        double d = this.damages[n][n2];
        int n4 = this.entity.getCrew().getPiloting();
        int n5 = 0;
        n5 = n2 < 7 ? this.minRangeMods[n2] : (n2 < 13 ? 2 : (n2 < 24 ? 4 : 20));
        if (n4 + n5 + n3 > this.tb.ignore) {
            return 0.0;
        }
        if (n4 + n5 + n3 == this.tb.ignore) {
            d *= 0.5;
        }
        return d / Compute.oddsAbove(n4 + n5) * Compute.oddsAbove(n5 + n3 + n4);
    }

    public static double getExpectedDamage(WeaponType weaponType) {
        if (weaponType.getDamage() != -2) {
            return weaponType.getDamage();
        }
        if (weaponType.getAmmoType() == 9) {
            switch (weaponType.getRackSize()) {
                case 2: {
                    return 2.83332;
                }
                case 4: {
                    return 5.27776;
                }
                case 6: {
                    return 8.0;
                }
            }
        } else {
            switch (weaponType.getRackSize()) {
                case 5: {
                    return 3.16666;
                }
                case 10: {
                    return 6.30555;
                }
                case 15: {
                    return 9.5;
                }
                case 20: {
                    return 12.69444;
                }
            }
        }
        return 0.0;
    }

    public static int getFiringAngle(Coords coords, int n, Coords coords2) {
        int n2 = coords.degree(coords2) - n % 6 * 60;
        if (n2 < 0) {
            n2 += 360;
        } else if (n2 >= 360) {
            n2 -= 360;
        }
        return n2;
    }

    public static int getThreatHitArc(Coords coords, int n, Coords coords2) {
        int n2 = CEntity.getFiringAngle(coords, n, coords2);
        if (n2 >= 300 || n2 <= 60) {
            return 0;
        }
        if (n2 >= 60 && n2 <= 120) {
            return 3;
        }
        if (n2 >= 240 && n2 <= 300) {
            return 2;
        }
        return 1;
    }

    public static int firingArcToHitArc(int n) {
        switch (n) {
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 3;
            }
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object instanceof Entity || object instanceof CEntity) {
            return object.hashCode() == this.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return this.entity.getId();
    }

    static class Table
    extends Hashtable {
        private TestBot tb;

        public Table(TestBot testBot) {
            this.tb = testBot;
        }

        public void put(CEntity cEntity) {
            this.put(cEntity.getKey(), cEntity);
        }

        public CEntity get(Entity entity) {
            CEntity cEntity = null;
            cEntity = (CEntity)super.get(new Integer(entity.getId()));
            if (cEntity == null) {
                cEntity = new CEntity(entity, this.tb);
                this.put(cEntity);
            }
            return cEntity;
        }

        public CEntity get(int n) {
            return (CEntity)this.get(new Integer(n));
        }
    }
}

