/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.bot.ga;

import java.util.Arrays;
import megamek.client.bot.ga.Chromosome;

public abstract class GA {
    final double mutationProb;
    final int maxGenerations;
    final double randomSelectionChance;
    final double crossoverProb;
    protected final int chromosomeDim;
    protected final int populationDim;
    protected final Chromosome[] chromosomes;
    Chromosome[] chromNextGen;
    double[] genAvgDeviation;
    double[] genAvgFitness;
    protected final int best;

    protected abstract void initPopulation();

    protected abstract void doRandomMutation(int var1);

    protected abstract double getFitness(int var1);

    protected void doHeuristicPass() {
    }

    public GA(int n, int n2, double d, double d2, int n3, double d3) {
        this.randomSelectionChance = d2;
        this.chromosomeDim = n;
        this.populationDim = n2;
        this.best = n2 - 1;
        this.chromosomes = new Chromosome[n2];
        this.chromNextGen = new Chromosome[n2];
        this.genAvgDeviation = new double[n3];
        this.genAvgFitness = new double[n3];
        this.crossoverProb = d;
        this.maxGenerations = n3;
        this.mutationProb = d3;
        for (int i = 0; i < n2; ++i) {
            this.chromosomes[i] = new Chromosome(n);
            this.chromNextGen[i] = new Chromosome(n);
        }
    }

    public double getFittestChromosomesFitness() {
        return this.chromosomes[this.best].fitness;
    }

    int getRandom(int n) {
        return (int)(Math.random() * (double)n);
    }

    double getRandom(double d) {
        return Math.random() * d;
    }

    protected boolean shouldDoExhaustive() {
        return false;
    }

    protected void doExhaustiveSearch() {
    }

    public int evolve() {
        int n;
        this.initPopulation();
        if (this.shouldDoExhaustive()) {
            this.doExhaustiveSearch();
            return 0;
        }
        boolean bl = false;
        for (n = 0; n < this.maxGenerations && !bl; ++n) {
            this.computeFitnessRankings();
            this.doGeneticMating();
            this.copyNextGenToThisGen();
            this.genAvgFitness[n] = this.getAvgFitness();
            if (n != 0 && n % 5 == 0) {
                this.doHeuristicPass();
            }
            if (n <= 5 || !(this.getESquared() - this.genAvgFitness[n] * this.genAvgFitness[n] < 0.2 * this.genAvgFitness[n]) || !(this.genAvgFitness[n] - this.genAvgFitness[n - 1] <= 0.0)) continue;
            bl = true;
        }
        this.computeFitnessRankings();
        return n;
    }

    protected double getAvgFitness() {
        double d = 0.0;
        for (int i = 0; i < this.populationDim; ++i) {
            d += this.chromosomes[i].fitness;
        }
        return d / (double)this.populationDim;
    }

    protected double getESquared() {
        double d = 0.0;
        for (int i = 0; i < this.populationDim; ++i) {
            d += this.chromosomes[i].fitness * this.chromosomes[i].fitness;
        }
        return d / (double)this.populationDim;
    }

    protected int[] selectTwoParents() {
        boolean bl = false;
        int[] nArray = new int[2];
        nArray[0] = -1;
        for (int i = 0; i < 2; ++i) {
            bl = false;
            while (!bl) {
                int n = this.getRandom(this.populationDim);
                if (n == nArray[0] || !(this.randomSelectionChance > this.getRandom(1.0)) && n + 1 <= this.getRandom(this.populationDim)) continue;
                nArray[i] = n;
                bl = true;
            }
        }
        return nArray;
    }

    void computeFitnessRankings() {
        for (int i = 0; i < this.populationDim; ++i) {
            this.chromosomes[i].fitness = this.getFitness(i);
        }
        Arrays.sort(this.chromosomes);
    }

    void doGeneticMating() {
        int n = this.populationDim - 1;
        for (int i = 0; i < n; i += 2) {
            int[] nArray = this.selectTwoParents();
            this.chromNextGen[i].copyChromGenes(this.chromosomes[nArray[0]]);
            this.chromNextGen[i + 1].copyChromGenes(this.chromosomes[nArray[1]]);
            if (!(this.getRandom(1.0) < this.crossoverProb)) continue;
            this.doUniformCrossover(this.chromNextGen[i], this.chromNextGen[i + 1]);
        }
        this.chromNextGen[this.populationDim - 1].copyChromGenes(this.chromosomes[this.best]);
    }

    void copyNextGenToThisGen() {
        for (int i = 0; i < this.populationDim; ++i) {
            this.chromosomes[i].copyChromGenes(this.chromNextGen[i]);
            if (i == this.best || i != 0 && !(this.getRandom(1.0) < this.mutationProb)) continue;
            this.doRandomMutation(i);
        }
    }

    void doUniformCrossover(Chromosome chromosome, Chromosome chromosome2) {
        for (int i = 0; i < this.chromosomeDim; ++i) {
            if (!(this.getRandom(1.0) < 0.5)) continue;
            int n = chromosome.genes[i];
            chromosome.genes[i] = chromosome2.genes[i];
            chromosome2.genes[i] = n;
        }
    }
}

