/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import gov.nist.gui.TabPanel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import megamek.client.Client;
import megamek.client.bot.BotClient;
import megamek.client.bot.TestBot;
import megamek.client.bot.ui.AWT.BotGUI;
import megamek.client.event.BoardViewListener;
import megamek.client.ui.AWT.AbstractPhaseDisplay;
import megamek.client.ui.AWT.AlertDialog;
import megamek.client.ui.AWT.CamoChoiceDialog;
import megamek.client.ui.AWT.CamoChoiceListener;
import megamek.client.ui.AWT.ClientGUI;
import megamek.client.ui.AWT.CustomMechDialog;
import megamek.client.ui.AWT.DoneButtoned;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.MechView;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.AWT.Prompt;
import megamek.client.ui.AWT.util.PlayerColors;
import megamek.client.ui.AWT.widget.BufferedPanel;
import megamek.client.ui.AWT.widget.ImageButton;
import megamek.common.Entity;
import megamek.common.IStartingPositions;
import megamek.common.Infantry;
import megamek.common.MechSummaryCache;
import megamek.common.Player;
import megamek.common.Protomech;
import megamek.common.Tank;
import megamek.common.event.GameEntityNewEvent;
import megamek.common.event.GameEntityRemoveEvent;
import megamek.common.event.GameListener;
import megamek.common.event.GamePhaseChangeEvent;
import megamek.common.event.GamePlayerChangeEvent;
import megamek.common.event.GameSettingsChangeEvent;
import megamek.common.util.Distractable;
import megamek.common.util.DistractableAdapter;

public class ChatLounge
extends AbstractPhaseDisplay
implements ActionListener,
ItemListener,
BoardViewListener,
GameListener,
DoneButtoned,
Distractable {
    private DistractableAdapter distracted = new DistractableAdapter();
    private Client client;
    private ClientGUI clientgui;
    private CamoChoiceDialog camoDialog;
    private Panel panPlayerInfo;
    private Label labPlayerInfo;
    private List lisPlayerInfo;
    private Label labTeam;
    private Choice choTeam;
    private Label labCamo;
    private ImageButton butCamo;
    private Panel panMinefield;
    private Label labMinefield;
    private List lisMinefield;
    private Label labConventional;
    private Label labCommandDetonated;
    private Label labVibrabomb;
    private TextField fldConventional;
    private TextField fldCommandDetonated;
    private TextField fldVibrabomb;
    private Button butMinefield;
    private Button butOptions;
    private Label labBoardSize;
    private Label labMapSize;
    private List lisBoardsSelected;
    private Button butChangeBoard;
    private Panel panBoardSettings;
    private Button butLoadList;
    private Button butSaveList;
    private Button butDeleteAll;
    private Button butLoad;
    private Button butLoadCustomBA;
    private Button butDelete;
    private Button butCustom;
    private Button butMechReadout;
    private List lisEntities;
    private int[] entityCorrespondance;
    private Panel panEntities;
    private Label labStarts;
    private List lisStarts;
    private Panel panStarts;
    private Button butChangeStart;
    private Label labBVs;
    private List lisBVs;
    private CheckboxGroup bvCbg;
    private Checkbox chkBV;
    private Checkbox chkTons;
    private Checkbox chkCost;
    private Panel panBVs;
    private TabPanel panTabs;
    private Panel panMain;
    private Panel panUnits;
    private Panel panTop;
    private Label labStatus;
    private Button butDone;
    private Button butAddBot;
    private Button butRemoveBot;
    MechSummaryCache.Listener mechSummaryCacheListener = new MechSummaryCache.Listener(){

        public void doneLoading() {
            ChatLounge.this.butLoad.setEnabled(true);
            ChatLounge.this.butLoadCustomBA.setEnabled(true);
        }
    };

    public ChatLounge(ClientGUI clientGUI) {
        this.client = clientGUI.getClient();
        this.clientgui = clientGUI;
        this.panTabs = new TabPanel();
        Font font = new Font("Helvetica", 1, GUIPreferences.getInstance().getInt("AdvancedChatLoungeTabFontSize"));
        this.panTabs.setTabFont(font);
        this.camoDialog = new CamoChoiceDialog(clientGUI.getFrame());
        this.client.game.addGameListener(this);
        clientGUI.getBoardView().addBoardViewListener(this);
        this.butOptions = new Button(Messages.getString("ChatLounge.butOptions"));
        this.butOptions.addActionListener(this);
        this.butDone = new Button(Messages.getString("ChatLounge.butDone"));
        Font font2 = null;
        try {
            font2 = new Font("sanserif", 1, 12);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (null == font2) {
            System.err.println("Couldn't find the new font for the 'Done' button.");
        } else {
            this.butDone.setFont(font2);
        }
        this.butDone.setActionCommand("ready");
        this.butDone.addActionListener(this);
        this.setupPlayerInfo();
        this.setupMinefield();
        this.setupBoardSettings();
        this.refreshGameSettings();
        this.setupEntities();
        this.refreshEntities();
        this.setupBVs();
        this.refreshBVs();
        this.setupStarts();
        this.refreshStarts();
        this.setupMainPanel();
        this.labStatus = new Label("", 1);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridwidth = 0;
        if (GUIPreferences.getInstance().getChatLoungeTabs()) {
            this.addBag(this.panTabs, gridBagLayout, gridBagConstraints);
        } else {
            this.addBag(this.panMain, gridBagLayout, gridBagConstraints);
        }
        this.validate();
    }

    private void addBag(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void setupPlayerInfo() {
        Player player = this.client.getLocalPlayer();
        this.panPlayerInfo = new Panel();
        this.labPlayerInfo = new Label(Messages.getString("ChatLounge.labPlayerInfo"));
        this.lisPlayerInfo = new List(5);
        this.lisPlayerInfo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ChatLounge.this.butRemoveBot.setEnabled(false);
                Client client = ChatLounge.this.getPlayerListSelected(ChatLounge.this.lisPlayerInfo);
                if (client == null) {
                    ChatLounge.this.lisPlayerInfo.select(-1);
                    return;
                }
                if (client instanceof BotClient) {
                    ChatLounge.this.butRemoveBot.setEnabled(true);
                }
                ChatLounge.this.choTeam.select(client.getLocalPlayer().getTeam());
            }
        });
        this.butAddBot = new Button(Messages.getString("ChatLounge.butAddBot"));
        this.butAddBot.setActionCommand("add_bot");
        this.butAddBot.addActionListener(this);
        this.butRemoveBot = new Button(Messages.getString("ChatLounge.butRemoveBot"));
        this.butRemoveBot.setEnabled(false);
        this.butRemoveBot.setActionCommand("remove_bot");
        this.butRemoveBot.addActionListener(this);
        this.labTeam = new Label(Messages.getString("ChatLounge.labTeam"), 2);
        this.labCamo = new Label(Messages.getString("ChatLounge.labCamo"), 2);
        this.choTeam = new Choice();
        this.choTeam.addItemListener(this);
        this.setupTeams();
        this.butCamo = new ImageButton();
        this.butCamo.setLabel(Messages.getString("ChatLounge.noCamo"));
        this.butCamo.setPreferredSize(84, 72);
        this.butCamo.setActionCommand("camo");
        this.butCamo.addActionListener(this);
        this.camoDialog.addItemListener(new CamoChoiceListener(this.camoDialog, this.butCamo, this.butOptions.getBackground(), player.getId(), this.client));
        this.refreshCamos();
        Image[] imageArray = (Image[])this.camoDialog.getSelectedObjects();
        if (null != imageArray) {
            this.butCamo.setImage(imageArray[0]);
        } else {
            this.butCamo.setBackground(PlayerColors.getColor(player.getColorIndex()));
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panPlayerInfo.setLayout(gridBagLayout);
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.labPlayerInfo, gridBagConstraints);
        this.panPlayerInfo.add(this.labPlayerInfo);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.lisPlayerInfo, gridBagConstraints);
        this.panPlayerInfo.add(this.lisPlayerInfo);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.labTeam, gridBagConstraints);
        this.panPlayerInfo.add(this.labTeam);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.choTeam, gridBagConstraints);
        this.panPlayerInfo.add(this.choTeam);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.labCamo, gridBagConstraints);
        this.panPlayerInfo.add(this.labCamo);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.butCamo, gridBagConstraints);
        this.panPlayerInfo.add(this.butCamo);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.butAddBot, gridBagConstraints);
        this.panPlayerInfo.add(this.butAddBot);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.butRemoveBot, gridBagConstraints);
        this.panPlayerInfo.add(this.butRemoveBot);
        this.refreshPlayerInfo();
    }

    private void setupMinefield() {
        this.panMinefield = new Panel();
        this.labMinefield = new Label(Messages.getString("ChatLounge.labMinefield"));
        this.lisMinefield = new List(2);
        this.labConventional = new Label(Messages.getString("ChatLounge.labConventional"), 2);
        this.labCommandDetonated = new Label(Messages.getString("ChatLounge.labCommandDetonated"), 2);
        this.labVibrabomb = new Label(Messages.getString("ChatLounge.labVibrabomb"), 2);
        this.fldConventional = new TextField(1);
        this.fldCommandDetonated = new TextField(1);
        this.fldVibrabomb = new TextField(1);
        this.butMinefield = new Button(Messages.getString("ChatLounge.butMinefield"));
        this.butMinefield.addActionListener(this);
        this.enableMinefields(this.client.game.getOptions().booleanOption("minefields"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panMinefield.setLayout(gridBagLayout);
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.labMinefield, gridBagConstraints);
        this.panMinefield.add(this.labMinefield);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.lisMinefield, gridBagConstraints);
        this.panMinefield.add(this.lisMinefield);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.labConventional, gridBagConstraints);
        this.panMinefield.add(this.labConventional);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.fldConventional, gridBagConstraints);
        this.panMinefield.add(this.fldConventional);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.labCommandDetonated, gridBagConstraints);
        this.panMinefield.add(this.labCommandDetonated);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.fldCommandDetonated, gridBagConstraints);
        this.panMinefield.add(this.fldCommandDetonated);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.labVibrabomb, gridBagConstraints);
        this.panMinefield.add(this.labVibrabomb);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.fldVibrabomb, gridBagConstraints);
        this.panMinefield.add(this.fldVibrabomb);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.butMinefield, gridBagConstraints);
        this.panMinefield.add(this.butMinefield);
        this.refreshMinefield();
    }

    public void enableMinefields(boolean bl) {
        this.fldConventional.setEnabled(bl);
        this.labConventional.setEnabled(bl);
        this.fldCommandDetonated.setEnabled(false);
        this.labCommandDetonated.setEnabled(false);
        this.fldVibrabomb.setEnabled(bl);
        this.labVibrabomb.setEnabled(bl);
        this.butMinefield.setEnabled(bl);
    }

    private void setupBoardSettings() {
        this.labBoardSize = new Label(Messages.getString("ChatLounge.labBoardSize"), 1);
        this.labMapSize = new Label(Messages.getString("ChatLounge.labMapSize"), 1);
        this.lisBoardsSelected = new List(5);
        this.lisBoardsSelected.addActionListener(this);
        this.butChangeBoard = new Button(Messages.getString("ChatLounge.butChangeBoard"));
        this.butChangeBoard.setActionCommand("change_board");
        this.butChangeBoard.addActionListener(this);
        this.panBoardSettings = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panBoardSettings.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.labBoardSize, gridBagConstraints);
        this.panBoardSettings.add(this.labBoardSize);
        gridBagLayout.setConstraints(this.labMapSize, gridBagConstraints);
        this.panBoardSettings.add(this.labMapSize);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.lisBoardsSelected, gridBagConstraints);
        this.panBoardSettings.add(this.lisBoardsSelected);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.butChangeBoard, gridBagConstraints);
        this.panBoardSettings.add(this.butChangeBoard);
        this.refreshBoardSettings();
    }

    private void refreshBoardSettings() {
        this.labBoardSize.setText(Messages.getString("ChatLounge.BoardSize", new Object[]{new Integer(this.client.getMapSettings().getBoardWidth()), new Integer(this.client.getMapSettings().getBoardHeight())}));
        this.labMapSize.setText(Messages.getString("ChatLounge.BoardSize", new Object[]{new Integer(this.client.getMapSettings().getMapWidth()), new Integer(this.client.getMapSettings().getMapHeight())}));
        this.lisBoardsSelected.removeAll();
        int n = 0;
        Enumeration enumeration = this.client.getMapSettings().getBoardsSelected();
        while (enumeration.hasMoreElements()) {
            this.lisBoardsSelected.add(n++ + ": " + (String)enumeration.nextElement());
        }
    }

    private void setupMainPanel() {
        this.panUnits = new Panel(new BorderLayout());
        this.panUnits.add((Component)this.panEntities, "Center");
        this.panUnits.add((Component)this.panBVs, "East");
        this.setupTop();
        this.panMain = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panMain.setLayout(gridBagLayout);
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.butOptions, gridBagConstraints);
        this.panMain.add(this.butOptions);
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.panUnits, gridBagConstraints);
        this.panMain.add(this.panUnits);
        if (GUIPreferences.getInstance().getChatLoungeTabs()) {
            this.panTabs.add("Select Units", this.panMain);
            this.panTabs.add("Configure", this.panTop);
        } else {
            gridBagConstraints.weighty = 0.0;
            gridBagLayout.setConstraints(this.panTop, gridBagConstraints);
            this.panMain.add(this.panTop);
        }
    }

    private void setupTop() {
        this.panTop = new Panel(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panTop.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 1, 6);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.panBoardSettings, gridBagConstraints);
        this.panTop.add(this.panBoardSettings);
        gridBagLayout.setConstraints(this.panStarts, gridBagConstraints);
        this.panTop.add(this.panStarts);
        gridBagLayout.setConstraints(this.panPlayerInfo, gridBagConstraints);
        this.panTop.add(this.panPlayerInfo);
        gridBagLayout.setConstraints(this.panMinefield, gridBagConstraints);
        this.panTop.add(this.panMinefield);
    }

    private void setupEntities() {
        this.lisEntities = new List(10);
        this.lisEntities.addActionListener(this);
        this.lisEntities.addItemListener(this);
        this.butLoadList = new Button(Messages.getString("ChatLounge.butLoadList"));
        this.butLoadList.setActionCommand("load_list");
        this.butLoadList.addActionListener(this);
        this.butSaveList = new Button(Messages.getString("ChatLounge.butSaveList"));
        this.butSaveList.setActionCommand("save_list");
        this.butSaveList.addActionListener(this);
        this.butSaveList.setEnabled(false);
        this.butLoad = new Button(Messages.getString("ChatLounge.butLoad"));
        this.butLoadCustomBA = new Button("Load Custom BA");
        MechSummaryCache mechSummaryCache = MechSummaryCache.getInstance();
        mechSummaryCache.addListener(this.mechSummaryCacheListener);
        this.butLoad.setEnabled(mechSummaryCache.isInitialized());
        this.butLoadCustomBA.setEnabled(mechSummaryCache.isInitialized());
        Font font = new Font("sanserif", 1, 18);
        if (null == font) {
            System.err.println("Couldn't find the new font for the 'Add a Unit' button.");
        } else {
            this.butLoad.setFont(font);
        }
        this.butLoad.setActionCommand("load_mech");
        this.butLoad.addActionListener(this);
        this.butLoadCustomBA.setActionCommand("load_custom_ba");
        this.butLoadCustomBA.addActionListener(this);
        this.butCustom = new Button(Messages.getString("ChatLounge.butCustom"));
        this.butCustom.setActionCommand("custom_mech");
        this.butCustom.addActionListener(this);
        this.butCustom.setEnabled(false);
        this.butMechReadout = new Button(Messages.getString("ChatLounge.butMechReadout"));
        this.butMechReadout.setActionCommand("Mech_readout");
        this.butMechReadout.addActionListener(this);
        this.butMechReadout.setEnabled(false);
        this.butDelete = new Button(Messages.getString("ChatLounge.butDelete"));
        this.butDelete.setActionCommand("delete_mech");
        this.butDelete.addActionListener(this);
        this.butDelete.setEnabled(false);
        this.butDeleteAll = new Button(Messages.getString("ChatLounge.butDeleteAll"));
        this.butDeleteAll.setActionCommand("delete_all");
        this.butDeleteAll.addActionListener(this);
        this.butDeleteAll.setEnabled(false);
        this.panEntities = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panEntities.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.lisEntities, gridBagConstraints);
        this.panEntities.add(this.lisEntities);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.butLoad, gridBagConstraints);
        this.panEntities.add(this.butLoad);
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.butCustom, gridBagConstraints);
        this.panEntities.add(this.butCustom);
        gridBagLayout.setConstraints(this.butMechReadout, gridBagConstraints);
        this.panEntities.add(this.butMechReadout);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.butDelete, gridBagConstraints);
        this.panEntities.add(this.butDelete);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.butLoadCustomBA, gridBagConstraints);
        this.panEntities.add(this.butLoadCustomBA);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = -1;
        gridBagLayout.setConstraints(this.butLoadList, gridBagConstraints);
        this.panEntities.add(this.butLoadList);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.butSaveList, gridBagConstraints);
        this.panEntities.add(this.butSaveList);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.butDeleteAll, gridBagConstraints);
        this.panEntities.add(this.butDeleteAll);
    }

    private void setupBVs() {
        this.labBVs = new Label(Messages.getString("ChatLounge.labBVs.BV"), 1);
        this.lisBVs = new List(5);
        this.panBVs = new Panel();
        this.bvCbg = new CheckboxGroup();
        this.chkBV = new Checkbox(Messages.getString("ChatLounge.chkBV"), this.bvCbg, true);
        this.chkBV.addItemListener(this);
        this.chkTons = new Checkbox(Messages.getString("ChatLounge.chkTons"), this.bvCbg, false);
        this.chkTons.addItemListener(this);
        this.chkCost = new Checkbox(Messages.getString("ChatLounge.chkCost"), this.bvCbg, false);
        this.chkCost.addItemListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panBVs.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.labBVs, gridBagConstraints);
        this.panBVs.add(this.labBVs);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.lisBVs, gridBagConstraints);
        this.panBVs.add(this.lisBVs);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.lisBVs, gridBagConstraints);
        this.panBVs.add(this.chkBV);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.lisBVs, gridBagConstraints);
        this.panBVs.add(this.chkTons);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.lisBVs, gridBagConstraints);
        this.panBVs.add(this.chkCost);
    }

    private void setupStarts() {
        this.labStarts = new Label(Messages.getString("ChatLounge.labStarts"), 1);
        this.lisStarts = new List(5);
        this.lisStarts.addActionListener(this);
        this.butChangeStart = new Button(Messages.getString("ChatLounge.butChangeStart"));
        this.butChangeStart.addActionListener(this);
        this.panStarts = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panStarts.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.labStarts, gridBagConstraints);
        this.panStarts.add(this.labStarts);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.lisStarts, gridBagConstraints);
        this.panStarts.add(this.lisStarts);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.butChangeStart, gridBagConstraints);
        this.panStarts.add(this.butChangeStart);
    }

    private void refreshGameSettings() {
        this.refreshTeams();
        this.refreshDoneButton();
    }

    public void refreshEntities() {
        this.lisEntities.removeAll();
        int n = 0;
        String string = "";
        String string2 = "";
        boolean bl = false;
        this.entityCorrespondance = new int[this.client.game.getNoOfEntities()];
        LinkedList<Entity> linkedList = new LinkedList<Entity>();
        Enumeration enumeration = this.client.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            linkedList.add(entity);
        }
        Collections.sort(linkedList, new Comparator(){

            public int compare(Object object, Object object2) {
                Entity entity = (Entity)object;
                Entity entity2 = (Entity)object2;
                Player player = entity.getOwner();
                Player player2 = entity2.getOwner();
                int n = player.getTeam();
                int n2 = player2.getTeam();
                if (player.equals(ChatLounge.this.client.getLocalPlayer()) && !player2.equals(ChatLounge.this.client.getLocalPlayer())) {
                    return -1;
                }
                if (player2.equals(ChatLounge.this.client.getLocalPlayer()) && !player.equals(ChatLounge.this.client.getLocalPlayer())) {
                    return 1;
                }
                if (n == ChatLounge.this.client.getLocalPlayer().getTeam() && n2 != ChatLounge.this.client.getLocalPlayer().getTeam()) {
                    return -1;
                }
                if (n2 == ChatLounge.this.client.getLocalPlayer().getTeam() && n != ChatLounge.this.client.getLocalPlayer().getTeam()) {
                    return 1;
                }
                if (n != n2) {
                    return n - n2;
                }
                if (!player.equals(player2)) {
                    return player.getName().compareTo(player2.getName());
                }
                return entity.getId() - entity2.getId();
            }
        });
        for (Entity entity : linkedList) {
            if (!bl && entity.getOwner().equals(this.client.getLocalPlayer())) {
                bl = true;
            }
            string = "";
            string2 = "";
            if (entity.hasC3i()) {
                if (entity.calculateFreeC3Nodes() == 5) {
                    string = "**";
                }
                string2 = " (" + entity.getC3NetId() + ")";
            } else if (entity.hasC3()) {
                if (entity.getC3Master() == null) {
                    string = entity.hasC3S() ? "***" : "*";
                } else if (!entity.C3MasterIs(entity)) {
                    string = ">";
                    if (entity.getC3Master().getC3Master() != null && !entity.getC3Master().C3MasterIs(entity.getC3Master())) {
                        string = ">>";
                    }
                    string2 = " -> " + entity.getC3Master().getDisplayName();
                }
            }
            if (!this.client.game.getOptions().booleanOption("pilot_advantages")) {
                entity.getCrew().clearAdvantages();
            }
            int n2 = entity.getCrew().countAdvantages();
            if (!entity.getOwner().equals(this.client.getLocalPlayer()) && this.client.game.getOptions().booleanOption("blind_drop") && !this.client.game.getOptions().booleanOption("real_blind_drop")) {
                String string3 = "";
                if (entity instanceof Infantry) {
                    string3 = Messages.getString("ChatLounge.0");
                } else if (entity instanceof Protomech) {
                    string3 = Messages.getString("ChatLounge.1");
                } else {
                    string3 = entity.getWeightClassName();
                    if (entity instanceof Tank) {
                        string3 = string3 + Messages.getString("ChatLounge.6");
                    }
                }
                this.lisEntities.add(Messages.getString("ChatLounge.EntityListEntry1", new Object[]{entity.getOwner().getName(), new Integer(entity.getCrew().getGunnery()), new Integer(entity.getCrew().getPiloting()), n2 > 0 ? " <" + n2 + Messages.getString("ChatLounge.advs") : "", string3, entity.isOffBoard() ? Messages.getString("ChatLounge.deploysOffBoard") : "", entity.getDeployRound() > 0 ? Messages.getString("ChatLounge.deploysAfterRound") + entity.getDeployRound() : ""}));
                this.entityCorrespondance[n++] = entity.getId();
                continue;
            }
            if (!entity.getOwner().equals(this.client.getLocalPlayer()) && (this.client.game.getOptions().booleanOption("blind_drop") || this.client.game.getOptions().booleanOption("real_blind_drop"))) continue;
            this.lisEntities.add(string + Messages.getString("ChatLounge.EntityListEntry2", new Object[]{entity.getDisplayName(), new Integer(entity.getCrew().getGunnery()), new Integer(entity.getCrew().getPiloting()), n2 > 0 ? " <" + n2 + Messages.getString("ChatLounge.advs") : "", new Integer(entity.calculateBattleValue()), string2, entity.isOffBoard() ? Messages.getString("ChatLounge.deploysOffBoard") : "", entity.getDeployRound() > 0 ? Messages.getString("ChatLounge.deploysAfterRound") + entity.getDeployRound() : "", entity.isDesignValid() ? "" : Messages.getString("ChatLounge.invalidDesign")}));
            this.entityCorrespondance[n++] = entity.getId();
        }
        this.butSaveList.setEnabled(bl);
        this.butDeleteAll.setEnabled(bl);
        this.butCustom.setEnabled(false);
        this.butMechReadout.setEnabled(false);
        this.butDelete.setEnabled(false);
    }

    private void refreshPlayerInfo() {
        this.lisPlayerInfo.removeAll();
        Enumeration enumeration = this.client.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            if (player == null) continue;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(player.getName()).append(" : ");
            stringBuffer.append(Player.teamNames[player.getTeam()]);
            String string = player.getCamoFileName();
            if (null == string || "-- No Camo --".equals(string)) {
                stringBuffer.append(", ").append(Player.colorNames[player.getColorIndex()]);
            } else {
                stringBuffer.append(", ").append(player.getCamoFileName());
            }
            this.lisPlayerInfo.add(stringBuffer.toString());
        }
    }

    private void refreshMinefield() {
        this.lisMinefield.removeAll();
        Enumeration enumeration = this.client.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            if (player == null) continue;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(player.getName()).append(" : ");
            stringBuffer.append(player.getNbrMFConventional()).append("/");
            stringBuffer.append(player.getNbrMFCommand()).append("/");
            stringBuffer.append(player.getNbrMFVibra());
            this.lisMinefield.add(stringBuffer.toString());
        }
        int n = this.client.getLocalPlayer().getNbrMFConventional();
        this.fldConventional.setText(Integer.toString(n));
        n = this.client.getLocalPlayer().getNbrMFCommand();
        this.fldCommandDetonated.setText(Integer.toString(n));
        n = this.client.getLocalPlayer().getNbrMFVibra();
        this.fldVibrabomb.setText(Integer.toString(n));
    }

    private void refreshBVs() {
        boolean bl = this.chkBV.getState();
        boolean bl2 = this.chkCost.getState();
        this.lisBVs.removeAll();
        Enumeration enumeration = this.client.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            if (player == null) continue;
            float f = 0.0f;
            Enumeration enumeration2 = this.client.getEntities();
            while (enumeration2.hasMoreElements()) {
                Entity entity = (Entity)enumeration2.nextElement();
                if (!entity.getOwner().equals(player)) continue;
                if (bl) {
                    f += (float)entity.calculateBattleValue();
                    continue;
                }
                if (bl2) {
                    f = (float)((double)f + entity.getCost());
                    continue;
                }
                f += entity.getWeight();
            }
            if (bl) {
                this.lisBVs.add(player.getName() + Messages.getString("ChatLounge.BV") + (int)f);
                continue;
            }
            if (bl2) {
                this.lisBVs.add(player.getName() + Messages.getString("ChatLounge.Cost") + (int)f);
                continue;
            }
            this.lisBVs.add(player.getName() + Messages.getString("ChatLounge.Tons") + f);
        }
    }

    private void refreshCamos() {
        String string = this.client.getLocalPlayer().getCamoCategory();
        String string2 = this.client.getLocalPlayer().getCamoFileName();
        if (null == string2) {
            string = "-- No Camo --";
            string2 = Player.colorNames[this.client.getLocalPlayer().getColorIndex()];
        }
        this.camoDialog.setCategory(string);
        this.camoDialog.setItemName(string2);
    }

    private void refreshStarts() {
        this.lisStarts.removeAll();
        Enumeration enumeration = this.client.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            if (player == null) continue;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(player.getName()).append(" : ");
            stringBuffer.append(IStartingPositions.START_LOCATION_NAMES[player.getStartingPos()]);
            this.lisStarts.add(stringBuffer.toString());
        }
    }

    private void setupTeams() {
        this.choTeam.removeAll();
        for (int i = 0; i < Player.MAX_TEAMS; ++i) {
            this.choTeam.add(Player.teamNames[i]);
        }
        if (null != this.client.getLocalPlayer()) {
            this.choTeam.select(this.client.getLocalPlayer().getTeam());
        } else {
            this.choTeam.select(0);
        }
    }

    private void refreshTeams() {
        this.choTeam.select(this.client.getLocalPlayer().getTeam());
    }

    private void refreshDoneButton(boolean bl) {
        this.butDone.setLabel(bl ? Messages.getString("ChatLounge.notDone") : Messages.getString("ChatLounge.imDone"));
    }

    private void refreshDoneButton() {
        this.refreshDoneButton(this.client.getLocalPlayer().isDone());
    }

    public void changeTeam(int n) {
        Client client = this.getPlayerListSelected(this.lisPlayerInfo);
        if (client != null && client.getLocalPlayer().getTeam() != n) {
            client.getLocalPlayer().setTeam(n);
            client.sendPlayerInfo();
        }
    }

    private void updateMinefield() {
        String string = this.fldConventional.getText();
        String string2 = this.fldCommandDetonated.getText();
        String string3 = this.fldVibrabomb.getText();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            if (string != null && string.length() != 0) {
                n = Integer.parseInt(string);
            }
            if (string2 != null && string2.length() != 0) {
                n2 = Integer.parseInt(string2);
            }
            if (string3 != null && string3.length() != 0) {
                n3 = Integer.parseInt(string3);
            }
        }
        catch (NumberFormatException numberFormatException) {
            AlertDialog alertDialog = new AlertDialog(this.clientgui.frame, Messages.getString("ChatLounge.MinefieldAlert.title"), Messages.getString("ChatLounge.MinefieldAlert.message"));
            alertDialog.show();
            return;
        }
        if (n < 0 || n2 < 0 || n3 < 0) {
            AlertDialog alertDialog = new AlertDialog(this.clientgui.frame, Messages.getString("ChatLounge.MinefieldAlert.title"), Messages.getString("ChatLounge.MinefieldAlert.message"));
            alertDialog.show();
            return;
        }
        Client client = this.getPlayerListSelected(this.lisMinefield);
        client.getLocalPlayer().setNbrMFConventional(n);
        client.getLocalPlayer().setNbrMFCommand(n2);
        client.getLocalPlayer().setNbrMFVibra(n3);
        client.sendPlayerInfo();
    }

    public void customizeMech() {
        if (this.lisEntities.getSelectedIndex() == -1) {
            return;
        }
        Entity entity = this.client.game.getEntity(this.entityCorrespondance[this.lisEntities.getSelectedIndex()]);
        this.customizeMech(entity);
    }

    public void customizeMech(Entity entity) {
        Serializable serializable;
        boolean bl = this.clientgui.getBots().get(entity.getOwner().getName()) != null;
        Client client = null;
        if (bl) {
            client = (Client)this.clientgui.getBots().get(entity.getOwner().getName());
        } else {
            bl |= entity.getOwnerId() == this.client.getLocalPlayer().getId();
            client = this.client;
        }
        Entity entity2 = entity.getC3Master();
        Vector<Serializable> vector = new Vector<Serializable>();
        Enumeration enumeration = client.game.getPlayerEntities(client.getLocalPlayer()).elements();
        while (enumeration.hasMoreElements()) {
            serializable = (Entity)enumeration.nextElement();
            if (entity.equals(serializable) || !entity.onSameC3NetworkAs((Entity)serializable)) continue;
            vector.addElement(serializable);
        }
        serializable = new CustomMechDialog(this.clientgui, client, entity, bl);
        ((CustomMechDialog)serializable).refreshOptions();
        ((Dialog)serializable).setTitle(entity.getShortName());
        ((Dialog)serializable).show();
        if (bl && ((CustomMechDialog)serializable).isOkay()) {
            client.sendUpdateEntity(entity);
            if (entity2 != null && !entity2.equals(entity.getC3Master()) || entity2 == null && entity.getC3Master() != null) {
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    Entity entity3 = (Entity)enumeration.nextElement();
                    client.sendUpdateEntity(entity3);
                }
            }
        }
    }

    public void mechReadout() {
        if (this.lisEntities.getSelectedIndex() == -1) {
            return;
        }
        Entity entity = this.client.game.getEntity(this.entityCorrespondance[this.lisEntities.getSelectedIndex()]);
        MechView mechView = new MechView(entity);
        TextArea textArea = new TextArea();
        textArea.setEditable(false);
        textArea.setFont(new Font("Monospaced", 0, 12));
        textArea.setText(mechView.getMechReadout());
        final Dialog dialog = new Dialog(this.clientgui.frame, Messages.getString("ChatLounge.quickView"), false);
        Button button = new Button(Messages.getString("Okay"));
        dialog.add("South", button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                dialog.setVisible(false);
            }
        });
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                dialog.setVisible(false);
            }
        });
        dialog.add("Center", textArea);
        BufferedPanel bufferedPanel = new BufferedPanel();
        bufferedPanel.setPreferredSize(84, 72);
        this.clientgui.loadPreviewImage(bufferedPanel, entity);
        dialog.add("North", bufferedPanel);
        dialog.setLocation(this.clientgui.frame.getLocation().x + this.clientgui.frame.getSize().width / 2 - dialog.getSize().width / 2, this.clientgui.frame.getLocation().y + this.clientgui.frame.getSize().height / 5 - dialog.getSize().height / 2);
        dialog.setSize(300, 450);
        dialog.validate();
        dialog.show();
    }

    public void loadMech() {
        this.clientgui.getMechSelectorDialog().show();
    }

    public void loadCustomBA() {
        this.clientgui.getCustomBADialog().show();
    }

    public void gamePlayerChange(GamePlayerChangeEvent gamePlayerChangeEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        this.refreshDoneButton();
        this.refreshBVs();
        this.refreshPlayerInfo();
        this.refreshStarts();
        this.refreshCamos();
        this.refreshMinefield();
    }

    public void gamePhaseChange(GamePhaseChangeEvent gamePhaseChangeEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.client.game.getPhase() == 1) {
            this.refreshDoneButton();
            this.refreshGameSettings();
            this.refreshPlayerInfo();
            this.refreshTeams();
            this.refreshCamos();
            this.refreshMinefield();
            this.refreshEntities();
            this.refreshBVs();
            this.refreshStarts();
            this.refreshBoardSettings();
        }
    }

    public void gameEntityNew(GameEntityNewEvent gameEntityNewEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        this.refreshEntities();
        this.refreshBVs();
    }

    public void gameEntityRemove(GameEntityRemoveEvent gameEntityRemoveEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        this.refreshEntities();
        this.refreshBVs();
    }

    public void gameSettingsChange(GameSettingsChangeEvent gameSettingsChangeEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        this.refreshGameSettings();
        this.refreshBoardSettings();
        this.refreshEntities();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (itemEvent.getSource() == this.choTeam) {
            this.changeTeam(this.choTeam.getSelectedIndex());
        } else if (itemEvent.getSource() == this.chkBV || itemEvent.getSource() == this.chkTons || itemEvent.getSource() == this.chkCost) {
            this.refreshBVs();
            if (itemEvent.getSource() == this.chkBV) {
                this.labBVs.setText(Messages.getString("ChatLounge.labBVs.BV"));
            } else if (itemEvent.getSource() == this.chkTons) {
                this.labBVs.setText(Messages.getString("ChatLounge.labBVs.Tons"));
            } else {
                this.labBVs.setText(Messages.getString("ChatLounge.labBVs.Cost"));
            }
        } else if (itemEvent.getSource() == this.lisEntities) {
            boolean bl = this.lisEntities.getSelectedIndex() != -1;
            this.butCustom.setEnabled(bl);
            if (bl && this.client.game.getOptions().booleanOption("blind_drop")) {
                Entity entity = this.client.game.getEntity(this.entityCorrespondance[this.lisEntities.getSelectedIndex()]);
                this.butMechReadout.setEnabled(entity.getOwner().equals(this.client.getLocalPlayer()));
                this.butCustom.setEnabled(entity.getOwner().equals(this.client.getLocalPlayer()));
            } else {
                this.butMechReadout.setEnabled(bl);
            }
            this.butDelete.setEnabled(bl);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (actionEvent.getSource() == this.butDone) {
            Serializable serializable;
            Enumeration enumeration;
            int n;
            if (this.client.game.getOptions().booleanOption("double_blind") && this.client.game.getOptions().booleanOption("exclusive_db_deployment")) {
                n = this.client.getLocalPlayer().getStartingPos();
                if (n == 0) {
                    this.clientgui.doAlertDialog("Starting Position not allowed", "In Double Blind play, you cannot choose 'Any' as starting position.");
                    return;
                }
                enumeration = this.client.game.getPlayers();
                while (enumeration.hasMoreElements()) {
                    serializable = (Player)enumeration.nextElement();
                    if (((Player)serializable).getStartingPos() == 0 || ((Player)serializable).getStartingPos() != n && ((Player)serializable).getStartingPos() + 1 != n && ((Player)serializable).getStartingPos() - 1 != n || ((Player)serializable).getId() == this.client.getLocalPlayer().getId()) continue;
                    this.clientgui.doAlertDialog("Must choose exclusive deployment zone", "When using double blind, each player needs to have an exclusive deployment zone.");
                    return;
                }
            }
            n = 0;
            enumeration = this.client.getEntities();
            while (enumeration.hasMoreElements()) {
                serializable = (Entity)enumeration.nextElement();
                if (((Entity)serializable).getDeployRound() <= 0) continue;
                n = 1;
                break;
            }
            boolean bl = !this.client.getLocalPlayer().isDone();
            this.client.sendDone(bl);
            this.refreshDoneButton(bl);
            Iterator iterator = this.clientgui.getBots().values().iterator();
            while (iterator.hasNext()) {
                ((Client)iterator.next()).sendDone(bl);
            }
        } else if (actionEvent.getSource() == this.butLoad) {
            this.loadMech();
        } else if (actionEvent.getSource() == this.butLoadCustomBA) {
            this.loadCustomBA();
        } else if (actionEvent.getSource() == this.butCustom || actionEvent.getSource() == this.lisEntities) {
            this.customizeMech();
        } else if (actionEvent.getSource() == this.butDelete) {
            Entity entity = this.client.getEntity(this.entityCorrespondance[this.lisEntities.getSelectedIndex()]);
            Client client = (Client)this.clientgui.getBots().get(entity.getOwner().getName());
            if (client == null) {
                client = this.client;
            }
            if (this.lisEntities.getSelectedIndex() != -1) {
                client.sendDeleteEntity(this.entityCorrespondance[this.lisEntities.getSelectedIndex()]);
            }
        } else if (actionEvent.getSource() == this.butDeleteAll) {
            Vector vector = this.client.game.getPlayerEntities(this.client.getLocalPlayer());
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Entity entity = (Entity)enumeration.nextElement();
                this.client.sendDeleteEntity(entity.getId());
            }
        } else if (actionEvent.getSource() == this.butChangeBoard || actionEvent.getSource() == this.lisBoardsSelected) {
            this.clientgui.getBoardSelectionDialog().update(this.client.getMapSettings(), true);
            this.clientgui.getBoardSelectionDialog().show();
        } else if (actionEvent.getSource() == this.butOptions) {
            if (!this.clientgui.getGameOptionsDialog().isEditable()) {
                this.clientgui.getGameOptionsDialog().setEditable(true);
            }
            this.clientgui.getGameOptionsDialog().update(this.client.game.getOptions());
            this.clientgui.getGameOptionsDialog().show();
        } else if (actionEvent.getSource() == this.butChangeStart || actionEvent.getSource() == this.lisStarts) {
            this.clientgui.getStartingPositionDialog().update();
            Client client = this.getPlayerListSelected(this.lisStarts);
            if (client == null) {
                this.clientgui.doAlertDialog(Messages.getString("ChatLounge.ImproperCommand"), Messages.getString("ChatLounge.SelectBotOrPlayer"));
                return;
            }
            this.clientgui.getStartingPositionDialog().setClient(client);
            this.clientgui.getStartingPositionDialog().show();
        } else if (actionEvent.getSource() == this.butMechReadout) {
            this.mechReadout();
        } else if (actionEvent.getSource() == this.butLoadList) {
            this.clientgui.loadListFile();
        } else if (actionEvent.getSource() == this.butSaveList) {
            this.clientgui.saveListFile(this.client.game.getPlayerEntities(this.client.getLocalPlayer()));
        } else if (actionEvent.getSource() == this.butMinefield) {
            this.updateMinefield();
        } else if (actionEvent.getSource() == this.butCamo) {
            this.camoDialog.show();
        } else if (actionEvent.getSource() == this.butAddBot) {
            String string = "Bot" + this.lisPlayerInfo.getItemCount();
            Prompt prompt = new Prompt(this.clientgui.frame, Messages.getString("ChatLounge.ChooseBotName"), Messages.getString("ChatLounge.Name"), string, 15);
            if (!prompt.showDialog()) {
                return;
            }
            string = prompt.getText().trim().equals("") ? "Bot" + this.lisPlayerInfo.getItemCount() : prompt.getText();
            TestBot testBot = new TestBot(string, this.client.getHost(), this.client.getPort());
            testBot.game.addGameListener(new BotGUI(testBot));
            try {
                testBot.connect();
            }
            catch (Exception exception) {
                this.clientgui.doAlertDialog(Messages.getString("ChatLounge.AlertBot.title"), Messages.getString("ChatLounge.AlertBot.message"));
            }
            testBot.retrieveServerInfo();
            this.clientgui.getBots().put(string, testBot);
        } else if (actionEvent.getSource() == this.butRemoveBot) {
            Client client = this.getPlayerListSelected(this.lisPlayerInfo);
            if (client == null || client == this.client) {
                this.clientgui.doAlertDialog(Messages.getString("ChatLounge.ImproperCommand"), Messages.getString("ChatLounge.SelectBo"));
                return;
            }
            client.die();
            this.clientgui.getBots().remove(client.getName());
        }
    }

    private Client getPlayerListSelected(List list) {
        if (list.getSelectedIndex() == -1) {
            return this.client;
        }
        String string = list.getSelectedItem().substring(0, Math.max(0, list.getSelectedItem().indexOf(" :")));
        BotClient botClient = (BotClient)this.clientgui.getBots().get(string);
        if (botClient == null && this.client.getName().equals(string)) {
            return this.client;
        }
        return botClient;
    }

    public boolean isIgnoringEvents() {
        return this.distracted.isIgnoringEvents();
    }

    public void setIgnoringEvents(boolean bl) {
        this.distracted.setIgnoringEvents(bl);
    }

    public Button getDoneButton() {
        return this.butDone;
    }

    public void removeAllListeners() {
        this.client.game.removeGameListener(this);
        this.clientgui.getBoardView().removeBoardViewListener(this);
    }

    public Component getSecondaryDisplay() {
        return this.labStatus;
    }

    public void die() {
        MechSummaryCache.getInstance().removeListener(this.mechSummaryCacheListener);
    }
}

