/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.Button;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.List;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.Enumeration;
import megamek.client.ui.AWT.ClientGUI;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.HeatEffects;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.AWT.Slider;
import megamek.client.ui.AWT.widget.BackGroundDrawer;
import megamek.client.ui.AWT.widget.BufferedPanel;
import megamek.client.ui.AWT.widget.PMUtil;
import megamek.client.ui.AWT.widget.TransparentLabel;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.Mech;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.Player;
import megamek.common.Tank;

class ExtraPanel
extends BufferedPanel
implements ItemListener,
ActionListener {
    private static final String IMAGE_DIR = "data/images/widgets";
    private TransparentLabel narcLabel;
    private TransparentLabel unusedL;
    private TransparentLabel carrysL;
    private TransparentLabel heatL;
    private TransparentLabel sinksL;
    private TransparentLabel targSysL;
    public TextArea unusedR;
    public TextArea carrysR;
    public TextArea heatR;
    public TextArea sinksR;
    public Button sinks2B;
    public List narcList;
    private int myMechId;
    private Slider prompt;
    private int sinks;
    private boolean dontChange;
    private static final Font FONT_VALUE = new Font("SansSerif", 0, GUIPreferences.getInstance().getInt("AdvancedMechDisplayLargeFontSize"));
    private ClientGUI clientgui;

    public ExtraPanel(ClientGUI clientGUI) {
        this.clientgui = clientGUI;
        this.prompt = null;
        FontMetrics fontMetrics = this.getFontMetrics(FONT_VALUE);
        this.narcLabel = new TransparentLabel(Messages.getString("MechDisplay.AffectedBy"), fontMetrics, Color.white, 0);
        this.narcList = new List(3, false);
        this.narcList.addKeyListener(clientGUI.menuBar);
        this.unusedL = new TransparentLabel(Messages.getString("MechDisplay.UnusedSpace"), fontMetrics, Color.white, 0);
        this.unusedR = new TextArea("", 2, 25, 1);
        this.unusedR.setEditable(false);
        this.unusedR.addKeyListener(clientGUI.menuBar);
        this.carrysL = new TransparentLabel(Messages.getString("MechDisplay.Carryng"), fontMetrics, Color.white, 0);
        this.carrysR = new TextArea("", 4, 25, 1);
        this.carrysR.setEditable(false);
        this.carrysR.addKeyListener(clientGUI.menuBar);
        this.sinksL = new TransparentLabel(Messages.getString("MechDisplay.activeSinksLabel"), fontMetrics, Color.white, 0);
        this.sinksR = new TextArea("", 2, 25, 1);
        this.sinksR.setEditable(false);
        this.sinksR.addKeyListener(clientGUI.menuBar);
        this.sinks2B = new Button(Messages.getString("MechDisplay.configureActiveSinksLabel"));
        this.sinks2B.setActionCommand("changeSinks");
        this.sinks2B.addActionListener(this);
        this.heatL = new TransparentLabel(Messages.getString("MechDisplay.HeatEffects"), fontMetrics, Color.white, 0);
        this.heatR = new TextArea("", 4, 25, 1);
        this.heatR.setEditable(false);
        this.heatR.addKeyListener(clientGUI.menuBar);
        this.targSysL = new TransparentLabel(Messages.getString("MechDisplay.TargSysLabel").concat(" "), fontMetrics, Color.white, 0);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagLayout = new GridBagLayout();
        gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(15, 9, 1, 9);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.narcLabel, gridBagConstraints);
        this.add(this.narcLabel);
        gridBagConstraints.insets = new Insets(1, 9, 1, 9);
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.narcList, gridBagConstraints);
        this.add(this.narcList);
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.unusedL, gridBagConstraints);
        this.add(this.unusedL);
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.unusedR, gridBagConstraints);
        this.add(this.unusedR);
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.carrysL, gridBagConstraints);
        this.add(this.carrysL);
        gridBagConstraints.insets = new Insets(1, 9, 1, 9);
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.carrysR, gridBagConstraints);
        this.add(this.carrysR);
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.sinksL, gridBagConstraints);
        this.add(this.sinksL);
        gridBagConstraints.insets = new Insets(1, 9, 1, 9);
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.sinksR, gridBagConstraints);
        this.add(this.sinksR);
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.sinks2B, gridBagConstraints);
        this.add(this.sinks2B);
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.heatL, gridBagConstraints);
        this.add(this.heatL);
        gridBagConstraints.insets = new Insets(1, 9, 18, 9);
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.heatR, gridBagConstraints);
        this.add(this.heatR);
        gridBagLayout.setConstraints(this.targSysL, gridBagConstraints);
        this.add(this.targSysL);
        this.setBackGround();
    }

    private void setBackGround() {
        Image image = this.getToolkit().getImage("data/images/widgets/tile.gif");
        PMUtil.setImage(image, this);
        int n = 8;
        this.addBgDrawer(new BackGroundDrawer(image, n));
        n = 20;
        image = this.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this);
        this.addBgDrawer(new BackGroundDrawer(image, n));
        n = 68;
        image = this.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this);
        this.addBgDrawer(new BackGroundDrawer(image, n));
        n = 258;
        image = this.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this);
        this.addBgDrawer(new BackGroundDrawer(image, n));
        n = 1026;
        image = this.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this);
        this.addBgDrawer(new BackGroundDrawer(image, n));
        n = 273;
        image = this.getToolkit().getImage("data/images/widgets/tl_corner.gif");
        PMUtil.setImage(image, this);
        this.addBgDrawer(new BackGroundDrawer(image, n));
        n = 321;
        image = this.getToolkit().getImage("data/images/widgets/bl_corner.gif");
        PMUtil.setImage(image, this);
        this.addBgDrawer(new BackGroundDrawer(image, n));
        n = 1041;
        image = this.getToolkit().getImage("data/images/widgets/tr_corner.gif");
        PMUtil.setImage(image, this);
        this.addBgDrawer(new BackGroundDrawer(image, n));
        n = 1089;
        image = this.getToolkit().getImage("data/images/widgets/br_corner.gif");
        PMUtil.setImage(image, this);
        this.addBgDrawer(new BackGroundDrawer(image, n));
    }

    public void displayMech(Entity entity) {
        Serializable serializable;
        this.narcList.removeAll();
        this.sinks = 0;
        this.myMechId = entity.getId();
        if (this.clientgui.getClient().getLocalPlayer().getId() != entity.getOwnerId()) {
            this.sinks2B.setEnabled(false);
            this.dontChange = true;
        } else {
            this.sinks2B.setEnabled(true);
            this.dontChange = false;
        }
        StringBuffer stringBuffer = null;
        Enumeration enumeration = this.clientgui.getClient().game.getPlayers();
        while (enumeration.hasMoreElements()) {
            serializable = (Player)enumeration.nextElement();
            int n = ((Player)serializable).getTeam();
            if (entity.isNarcedBy(n) && !((Player)serializable).isObserver()) {
                stringBuffer = new StringBuffer(Messages.getString("MechDisplay.NARCedBy"));
                stringBuffer.append(((Player)serializable).getName());
                stringBuffer.append(" [").append(Player.teamNames[n]).append("]");
                this.narcList.add(stringBuffer.toString());
            }
            if (!entity.isINarcedBy(n) || ((Player)serializable).isObserver()) continue;
            stringBuffer = new StringBuffer(Messages.getString("MechDisplay.INarcHoming"));
            stringBuffer.append(((Player)serializable).getName());
            stringBuffer.append(" [").append(Player.teamNames[n]).append("] ").append(Messages.getString("MechDisplay.attached")).append(".");
            this.narcList.add(stringBuffer.toString());
        }
        if (entity.isINarcedWith(2L)) {
            stringBuffer = new StringBuffer(Messages.getString("MechDisplay.iNarcECMPodAttached"));
            this.narcList.add(stringBuffer.toString());
        }
        if (entity.isINarcedWith(4L)) {
            stringBuffer = new StringBuffer(Messages.getString("MechDisplay.iNarcHaywirePodAttached"));
            this.narcList.add(stringBuffer.toString());
        }
        if (entity.isINarcedWith(8L)) {
            stringBuffer = new StringBuffer(Messages.getString("MechDisplay.iNarcNemesisPodAttached"));
            this.narcList.add(stringBuffer.toString());
        }
        if (entity.infernos.isStillBurning()) {
            stringBuffer = new StringBuffer(Messages.getString("MechDisplay.InfernoBurnRemaining"));
            stringBuffer.append(entity.infernos.getTurnsLeftToBurn());
            this.narcList.add(stringBuffer.toString());
        }
        if (entity instanceof Tank && ((Tank)entity).isOnFire()) {
            this.narcList.add(Messages.getString("MechDisplay.OnFire"));
        }
        if (Compute.isAffectedByECM(entity, (Coords)(serializable = entity.getPosition()), (Coords)serializable)) {
            this.narcList.add(Messages.getString("MechDisplay.InEnemyECMField"));
        } else if (Compute.isAffectedByAngelECM(entity, (Coords)serializable, (Coords)serializable)) {
            this.narcList.add(Messages.getString("MechDisplay.InEnemyAngelECMField"));
        }
        if (entity instanceof Tank && !((Tank)entity).hasNoTurret() && !entity.canChangeSecondaryFacing()) {
            this.narcList.add(Messages.getString("MechDisplay.Turretlocked"));
        }
        Enumeration enumeration2 = entity.getWeapons();
        while (enumeration2.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration2.nextElement();
            if (!mounted.isJammed()) continue;
            stringBuffer = new StringBuffer(mounted.getName());
            stringBuffer.append(Messages.getString("MechDisplay.isJammed"));
            this.narcList.add(stringBuffer.toString());
        }
        for (int i = 0; i < entity.locations(); ++i) {
            if (-1 != entity.getLocationStatus(i)) continue;
            stringBuffer = new StringBuffer(entity.getLocationName(i));
            stringBuffer.append(Messages.getString("MechDisplay.Breached"));
            this.narcList.add(stringBuffer.toString());
        }
        String string = entity.getUnusedString();
        if (string.equals("")) {
            string = Messages.getString("MechDisplay.None");
        }
        this.unusedR.setText(string);
        Enumeration enumeration3 = entity.getLoadedUnits().elements();
        this.carrysR.setText(null);
        boolean bl = false;
        while (enumeration3.hasMoreElements()) {
            this.carrysR.append(((Entity)enumeration3.nextElement()).getShortName());
            bl = true;
            if (!enumeration3.hasMoreElements()) continue;
            this.carrysR.append("\n");
        }
        Mounted mounted = Compute.clubMechHas(entity);
        if (null != mounted) {
            if (bl) {
                this.carrysR.append("\r\n");
            }
            this.carrysR.append(mounted.getName());
        }
        if (entity.hasSpotlight()) {
            if (entity.isUsingSpotlight()) {
                this.carrysR.append(Messages.getString("MechDisplay.SearchlightOn"));
            } else {
                this.carrysR.append(Messages.getString("MechDisplay.SearchlightOff"));
            }
        }
        this.heatR.setText("");
        this.sinksR.setText("");
        if (entity instanceof Mech) {
            Mech mech = (Mech)entity;
            this.sinks2B.setEnabled(!this.dontChange);
            this.sinks = mech.getActiveSinks();
            if (mech.hasDoubleHeatSinks()) {
                this.sinksR.append(Messages.getString("MechDisplay.activeSinksTextDouble", new Object[]{new Integer(this.sinks), new Integer(this.sinks * 2)}));
            } else {
                this.sinksR.append(Messages.getString("MechDisplay.activeSinksTextSingle", new Object[]{new Integer(this.sinks)}));
            }
            boolean bl2 = false;
            boolean bl3 = false;
            if (((Mech)entity).hasTSM()) {
                bl2 = true;
            }
            if (this.clientgui.getClient().game.getOptions().booleanOption("maxtech_heat")) {
                bl3 = true;
            }
            this.heatR.append(HeatEffects.getHeatEffects(entity.heat, bl3, bl2));
        } else {
            this.sinks2B.setEnabled(false);
        }
        this.targSysL.setText(Messages.getString("MechDisplay.TargSysLabel").concat(" ").concat(MiscType.getTargetSysName(entity.getTargSysType())));
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("changeSinks") && !this.dontChange) {
            this.prompt = new Slider(this.clientgui.frame, Messages.getString("MechDisplay.changeSinks"), Messages.getString("MechDisplay.changeSinks"), this.sinks, 0, ((Mech)this.clientgui.getClient().game.getEntity(this.myMechId)).getNumberOfSinks());
            if (!this.prompt.showDialog()) {
                return;
            }
            this.clientgui.menuBar.actionPerformed(actionEvent);
            int n = this.prompt.getValue();
            ((Mech)this.clientgui.getClient().game.getEntity(this.myMechId)).setActiveSinksNextRound(n);
            this.clientgui.getClient().sendUpdateEntity(this.clientgui.getClient().game.getEntity(this.myMechId));
        }
    }
}

