/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import gov.nist.gui.TabPanel;
import java.awt.Button;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import megamek.client.Client;
import megamek.client.ui.AWT.DoneButtoned;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.MechDisplay;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.AWT.StatusBarPhaseDisplay;
import megamek.common.MovePath;
import megamek.common.event.GamePhaseChangeEvent;
import megamek.common.util.Distractable;
import megamek.common.util.DistractableAdapter;

public class ReportDisplay
extends StatusBarPhaseDisplay
implements ActionListener,
KeyListener,
DoneButtoned,
Distractable {
    private DistractableAdapter distracted = new DistractableAdapter();
    public Client client;
    private TabPanel tabs;
    private Vector vTextArea;
    private Window mechw;
    private MechDisplay mechd;
    private boolean mechdOn;
    private Button readyB;
    private Button rerollInitiativeB;
    private int cen;
    private MovePath md;
    private MovePath cmd;
    private boolean rerolled;

    public ReportDisplay(Client client) {
        this.client = client;
        client.game.addGameListener(this);
        this.tabs = new TabPanel();
        Font font = new Font("Helvetica", 1, GUIPreferences.getInstance().getInt("AdvancedChatLoungeTabFontSize"));
        this.tabs.setTabFont(font);
        this.resetTabs();
        this.setupStatusBar("");
        this.readyB = new Button(Messages.getString("ReportDisplay.Done"));
        this.readyB.setActionCommand("ready");
        this.readyB.addActionListener(this);
        this.rerollInitiativeB = new Button(Messages.getString("ReportDisplay.Reroll"));
        this.rerollInitiativeB.setActionCommand("reroll_initiative");
        this.rerollInitiativeB.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridwidth = 0;
        this.addBag(this.tabs, gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 8));
        panel.add(this.rerollInitiativeB);
        for (int i = 0; i < 6; ++i) {
            panel.add(new Label(""));
        }
        this.addBag(panel, gridBagLayout, gridBagConstraints);
        this.addKeyListener(this);
    }

    private void addBag(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
        component.addKeyListener(this);
    }

    public void showRerollButton(boolean bl) {
        this.rerollInitiativeB.setVisible(bl);
    }

    public void ready() {
        this.rerollInitiativeB.setEnabled(false);
        this.readyB.setEnabled(false);
        this.client.sendDone(true);
    }

    public void rerollInitiative() {
        this.rerolled = true;
        this.rerollInitiativeB.setEnabled(false);
        this.readyB.setEnabled(false);
        this.client.sendRerollInitiativeRequest();
    }

    public boolean hasRerolled() {
        return this.rerolled;
    }

    public void resetButtons() {
        this.resetReadyButton();
        if (this.client.game.getPhase() == 6 && this.client.game.hasTacticalGenius(this.client.getLocalPlayer())) {
            this.showRerollButton(true);
        } else {
            this.showRerollButton(false);
        }
        this.rerollInitiativeB.setEnabled(true);
    }

    public void resetReadyButton() {
        this.readyB.setEnabled(true);
    }

    public void resetRerollButton() {
        this.rerollInitiativeB.setEnabled(true);
    }

    public void setReportTab(int n, String string, String string2) {
        if (n == 0) {
            n = 1;
        }
        if (n >= this.vTextArea.size()) {
            TextArea textArea;
            this.tabs.remove((Component)this.vTextArea.elementAt(this.vTextArea.size() - 1));
            this.vTextArea.removeElementAt(this.vTextArea.size() - 1);
            while (n > this.vTextArea.size()) {
                textArea = new TextArea(this.client.receiveReport(this.client.game.getReports(this.vTextArea.size() + 1)), 40, 25, 1);
                textArea.setEditable(false);
                this.tabs.add("Round " + (this.vTextArea.size() + 1), textArea);
                this.vTextArea.addElement(textArea);
            }
            textArea = new TextArea(string2, 40, 25, 1);
            textArea.setEditable(false);
            this.tabs.add("Phase", textArea);
            this.vTextArea.addElement(textArea);
            this.tabs.last();
        } else {
            ((TextArea)this.vTextArea.elementAt(n - 1)).setText(string);
            ((TextArea)this.vTextArea.elementAt(n)).setText(string2);
        }
    }

    public void appendReportTab(String string) {
        ((TextArea)this.vTextArea.elementAt(this.vTextArea.size() - 1)).append(string);
        ((TextArea)this.vTextArea.elementAt(this.vTextArea.size() - 2)).append(string);
    }

    public void resetTabs() {
        this.tabs.removeAll();
        this.vTextArea = new Vector();
        TextArea textArea = new TextArea("", 40, 25, 1);
        textArea.setEditable(false);
        this.vTextArea.addElement(textArea);
        this.tabs.add("Phase", textArea);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equalsIgnoreCase("ready")) {
            this.ready();
        }
        if (actionEvent.getActionCommand().equalsIgnoreCase("reroll_initiative")) {
            this.rerollInitiative();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            // empty if block
        }
        if (keyEvent.getKeyCode() == 10 && keyEvent.isControlDown()) {
            this.ready();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void gamePhaseChange(GamePhaseChangeEvent gamePhaseChangeEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        this.setReportTab(this.client.game.getRoundCount(), this.client.roundReport, this.client.phaseReport);
        this.resetButtons();
        this.rerolled = false;
    }

    public boolean isIgnoringEvents() {
        return this.distracted.isIgnoringEvents();
    }

    public void setIgnoringEvents(boolean bl) {
        this.distracted.setIgnoringEvents(bl);
    }

    public void removeAllListeners() {
        this.client.game.removeGameListener(this);
    }

    public Button getDoneButton() {
        return this.readyB;
    }

    public Component getSecondaryDisplay() {
        return this.panStatus;
    }
}

