/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.Enumeration;
import megamek.client.ui.AWT.ClientGUI;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.AWT.widget.BackGroundDrawer;
import megamek.client.ui.AWT.widget.BufferedPanel;
import megamek.client.ui.AWT.widget.PMUtil;
import megamek.client.ui.AWT.widget.TransparentLabel;
import megamek.common.AmmoType;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.EquipmentMode;
import megamek.common.Mech;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.Protomech;
import megamek.common.Tank;

class SystemPanel
extends BufferedPanel
implements ItemListener,
ActionListener {
    private static final String IMAGE_DIR = "data/images/widgets";
    private static Object SYSTEM = new Object();
    private TransparentLabel locLabel;
    private TransparentLabel slotLabel;
    private TransparentLabel modeLabel;
    public List slotList;
    public List locList;
    public Choice m_chMode;
    public Button m_bDumpAmmo;
    private ClientGUI clientgui;
    private static final Font FONT_VALUE = new Font("SansSerif", 0, GUIPreferences.getInstance().getInt("AdvancedMechDisplayLargeFontSize"));
    Entity en;

    public SystemPanel(ClientGUI clientGUI) {
        FontMetrics fontMetrics = this.getFontMetrics(FONT_VALUE);
        this.clientgui = clientGUI;
        this.locLabel = new TransparentLabel(Messages.getString("MechDisplay.Location"), fontMetrics, Color.white, 0);
        this.slotLabel = new TransparentLabel(Messages.getString("MechDisplay.Slot"), fontMetrics, Color.white, 0);
        this.locList = new List(8, false);
        this.locList.addItemListener(this);
        this.locList.addKeyListener(clientGUI.menuBar);
        this.slotList = new List(12, false);
        this.slotList.addItemListener(this);
        this.slotList.addKeyListener(clientGUI.menuBar);
        this.m_chMode = new Choice();
        this.m_chMode.add("   ");
        this.m_chMode.setEnabled(false);
        this.m_chMode.addItemListener(this);
        this.m_chMode.addKeyListener(clientGUI.menuBar);
        this.m_bDumpAmmo = new Button(Messages.getString("MechDisplay.m_bDumpAmmo"));
        this.m_bDumpAmmo.setEnabled(false);
        this.m_bDumpAmmo.setActionCommand("dump");
        this.m_bDumpAmmo.addActionListener(this);
        this.m_bDumpAmmo.addKeyListener(clientGUI.menuBar);
        this.modeLabel = new TransparentLabel(Messages.getString("MechDisplay.modeLabel"), fontMetrics, Color.white, 1);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(15, 9, 1, 1);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.locLabel, gridBagConstraints);
        this.add(this.locLabel);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(15, 1, 1, 9);
        gridBagLayout.setConstraints(this.slotLabel, gridBagConstraints);
        this.add(this.slotLabel);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(1, 9, 15, 1);
        gridBagConstraints.gridheight = 0;
        gridBagLayout.setConstraints(this.locList, gridBagConstraints);
        this.add(this.locList);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 9);
        gridBagLayout.setConstraints(this.slotList, gridBagConstraints);
        this.add(this.slotList);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.modeLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add(this.modeLabel);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 9);
        gridBagLayout.setConstraints(this.m_chMode, gridBagConstraints);
        this.add(this.m_chMode);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 4, 15, 9);
        gridBagLayout.setConstraints(this.m_bDumpAmmo, gridBagConstraints);
        this.add(this.m_bDumpAmmo);
        this.setBackGround();
    }

    public int getSelectedLocation() {
        return this.locList.getSelectedIndex();
    }

    public CriticalSlot getSelectedCritical() {
        int n = this.locList.getSelectedIndex();
        int n2 = this.slotList.getSelectedIndex();
        if (n == -1 || n2 == -1) {
            return null;
        }
        return this.en.getCritical(n, n2);
    }

    public Mounted getSelectedEquipment() {
        Object object;
        if (this.en instanceof Tank && this.en.hasTargComp()) {
            object = this.en.getEquipment();
            while (object.hasMoreElements()) {
                Mounted mounted = (Mounted)object.nextElement();
                if (!(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(2048)) continue;
                return mounted;
            }
        }
        if (null == (object = this.getSelectedCritical())) {
            return null;
        }
        if (((CriticalSlot)object).getType() == 0) {
            return null;
        }
        return this.en.getEquipment(((CriticalSlot)object).getIndex());
    }

    public void displayMech(Entity entity) {
        this.en = entity;
        this.locList.removeAll();
        for (int i = 0; i < entity.locations(); ++i) {
            if (entity.getNumberOfCriticals(i) <= 0) continue;
            this.locList.add(entity.getLocationName(i), i);
        }
        if (entity instanceof Tank && entity.hasTargComp()) {
            this.locList.add(entity.getLocationName(0));
        }
        this.locList.select(0);
        this.displaySlots();
    }

    public void displaySlots() {
        StringBuffer stringBuffer;
        Serializable serializable;
        int n = this.locList.getSelectedIndex();
        this.slotList.removeAll();
        for (int i = 0; i < this.en.getNumberOfCriticals(n); ++i) {
            serializable = this.en.getCritical(n, i);
            stringBuffer = new StringBuffer(32);
            if (serializable == null) {
                stringBuffer.append("---");
            } else {
                switch (((CriticalSlot)serializable).getType()) {
                    case 0: {
                        stringBuffer.append(((CriticalSlot)serializable).isDestroyed() ? "*" : "").append(((CriticalSlot)serializable).isBreached() ? "x" : "");
                        if (this.en instanceof Protomech) {
                            stringBuffer.append(Protomech.systemNames[((CriticalSlot)serializable).getIndex()]);
                            break;
                        }
                        stringBuffer.append(((Mech)this.en).getSystemName(((CriticalSlot)serializable).getIndex()));
                        break;
                    }
                    case 1: {
                        Mounted mounted = this.en.getEquipment(((CriticalSlot)serializable).getIndex());
                        stringBuffer.append(((CriticalSlot)serializable).isDestroyed() ? "*" : "").append(((CriticalSlot)serializable).isBreached() ? "x" : "").append(mounted.getDesc());
                        if (!mounted.getType().hasModes()) break;
                        stringBuffer.append(" (").append(mounted.curMode().getDisplayableName()).append(")");
                    }
                }
            }
            this.slotList.add(stringBuffer.toString());
        }
        if (this.en instanceof Tank && this.en.hasTargComp()) {
            Enumeration enumeration = this.en.getEquipment();
            while (enumeration.hasMoreElements()) {
                serializable = (Mounted)enumeration.nextElement();
                if (!(((Mounted)serializable).getType() instanceof MiscType) || !((Mounted)serializable).getType().hasFlag(2048)) continue;
                stringBuffer = new StringBuffer(32);
                stringBuffer.append(((Mounted)serializable).isDestroyed() ? "*" : "").append(((Mounted)serializable).isBreached() ? "x" : "").append(((Mounted)serializable).getDesc());
                if (((Mounted)serializable).getType().hasModes()) {
                    stringBuffer.append(" (").append(((Mounted)serializable).curMode().getDisplayableName()).append(")");
                }
                this.slotList.add(stringBuffer.toString());
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getItemSelectable() == this.locList) {
            this.m_chMode.removeAll();
            this.m_chMode.setEnabled(false);
            this.displaySlots();
        } else if (itemEvent.getItemSelectable() == this.slotList) {
            boolean bl;
            this.m_bDumpAmmo.setEnabled(false);
            this.m_chMode.setEnabled(false);
            this.modeLabel.setEnabled(false);
            Mounted mounted = this.getSelectedEquipment();
            boolean bl2 = bl = this.clientgui.getClient().getLocalPlayer() == this.en.getOwner();
            if (mounted != null && bl && mounted.getType() instanceof AmmoType && !mounted.getType().hasInstantModeSwitch() && 4 != this.clientgui.getClient().game.getPhase() && mounted.getShotsLeft() > 0 && !mounted.isDumping() && this.en.isActive()) {
                this.m_bDumpAmmo.setEnabled(true);
            } else if (mounted != null && bl && mounted.getType().hasModes()) {
                if (!mounted.isDestroyed() && this.en.isActive()) {
                    this.m_chMode.setEnabled(true);
                }
                if (!mounted.isDestroyed() && mounted.getType().hasFlag(262144)) {
                    this.m_chMode.setEnabled(true);
                }
                this.modeLabel.setEnabled(true);
                this.m_chMode.removeAll();
                Enumeration enumeration = mounted.getType().getModes();
                while (enumeration.hasMoreElements()) {
                    EquipmentMode equipmentMode = (EquipmentMode)enumeration.nextElement();
                    this.m_chMode.add(equipmentMode.getDisplayableName());
                }
                this.m_chMode.select(mounted.curMode().getDisplayableName());
            } else {
                CriticalSlot criticalSlot = this.getSelectedCritical();
                if (criticalSlot != null && criticalSlot.getType() == 0 && criticalSlot.getIndex() == 2 && this.en.hasEiCockpit() && this.en instanceof Mech) {
                    this.m_chMode.removeAll();
                    this.m_chMode.setEnabled(true);
                    this.m_chMode.add("EI Off");
                    this.m_chMode.add("EI On");
                    this.m_chMode.add("Aimed shot");
                    this.m_chMode.select(((Mech)this.en).getCockpitStatusNextRound());
                }
            }
        } else if (itemEvent.getItemSelectable() == this.m_chMode) {
            int n;
            Mounted mounted = this.getSelectedEquipment();
            CriticalSlot criticalSlot = this.getSelectedCritical();
            if (mounted != null && mounted.getType().hasModes()) {
                int n2 = this.m_chMode.getSelectedIndex();
                if (n2 >= 0) {
                    mounted.setMode(n2);
                    this.clientgui.getClient().sendModeChange(this.en.getId(), this.en.getEquipmentNum(mounted), n2);
                    if (mounted.getType().hasInstantModeSwitch()) {
                        this.clientgui.systemMessage(Messages.getString("MechDisplay.switched", new Object[]{mounted.getName(), mounted.curMode().getDisplayableName()}));
                    } else if (4 == this.clientgui.getClient().game.getPhase()) {
                        this.clientgui.systemMessage(Messages.getString("MechDisplay.willSwitchAtStart", new Object[]{mounted.getName(), mounted.pendingMode().getDisplayableName()}));
                    } else {
                        this.clientgui.systemMessage(Messages.getString("MechDisplay.willSwitchAtEnd", new Object[]{mounted.getName(), mounted.pendingMode().getDisplayableName()}));
                    }
                }
            } else if (criticalSlot != null && criticalSlot.getType() == 0 && (n = this.m_chMode.getSelectedIndex()) >= 0 && criticalSlot.getIndex() == 2 && this.en.hasEiCockpit() && this.en instanceof Mech) {
                Mech mech = (Mech)this.en;
                mech.setCockpitStatus(n);
                this.clientgui.getClient().sendSystemModeChange(this.en.getId(), 2, n);
                if (mech.getCockpitStatus() == mech.getCockpitStatusNextRound()) {
                    this.clientgui.systemMessage(Messages.getString("MechDisplay.switched", new Object[]{"Cockpit", this.m_chMode.getSelectedItem()}));
                } else {
                    this.clientgui.systemMessage(Messages.getString("MechDisplay.willSwitchAtEnd", new Object[]{"Cockpit", this.m_chMode.getSelectedItem()}));
                }
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("dump")) {
            boolean bl;
            boolean bl2;
            Mounted mounted = this.getSelectedEquipment();
            boolean bl3 = bl2 = this.clientgui.getClient().getLocalPlayer() == this.en.getOwner();
            if (mounted == null || !bl2 || !(mounted.getType() instanceof AmmoType) || mounted.getShotsLeft() <= 0) {
                return;
            }
            boolean bl4 = false;
            if (mounted.isPendingDump()) {
                bl = false;
                String string = Messages.getString("MechDisplay.CancelDumping.title");
                String string2 = Messages.getString("MechDisplay.CancelDumping.message", new Object[]{mounted.getName()});
                bl4 = this.clientgui.doYesNoDialog(string, string2);
            } else {
                bl = true;
                String string = Messages.getString("MechDisplay.Dump.title");
                String string3 = Messages.getString("MechDisplay.Dump.message", new Object[]{mounted.getName()});
                bl4 = this.clientgui.doYesNoDialog(string, string3);
            }
            if (bl4) {
                mounted.setPendingDump(bl);
                this.clientgui.getClient().sendModeChange(this.en.getId(), this.en.getEquipmentNum(mounted), bl ? 1 : 0);
            }
        }
    }

    private void setBackGround() {
        Image image = this.getToolkit().getImage("data/images/widgets/tile.gif");
        PMUtil.setImage(image, this);
        int n = 8;
        this.addBgDrawer(new BackGroundDrawer(image, n));
        n = 20;
        image = this.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this);
        this.addBgDrawer(new BackGroundDrawer(image, n));
        n = 68;
        image = this.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this);
        this.addBgDrawer(new BackGroundDrawer(image, n));
        n = 258;
        image = this.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this);
        this.addBgDrawer(new BackGroundDrawer(image, n));
        n = 1026;
        image = this.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this);
        this.addBgDrawer(new BackGroundDrawer(image, n));
        n = 273;
        image = this.getToolkit().getImage("data/images/widgets/tl_corner.gif");
        PMUtil.setImage(image, this);
        this.addBgDrawer(new BackGroundDrawer(image, n));
        n = 321;
        image = this.getToolkit().getImage("data/images/widgets/bl_corner.gif");
        PMUtil.setImage(image, this);
        this.addBgDrawer(new BackGroundDrawer(image, n));
        n = 1041;
        image = this.getToolkit().getImage("data/images/widgets/tr_corner.gif");
        PMUtil.setImage(image, this);
        this.addBgDrawer(new BackGroundDrawer(image, n));
        n = 1089;
        image = this.getToolkit().getImage("data/images/widgets/br_corner.gif");
        PMUtil.setImage(image, this);
        this.addBgDrawer(new BackGroundDrawer(image, n));
    }
}

