/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import megamek.client.Client;
import megamek.client.event.BoardViewEvent;
import megamek.client.event.BoardViewListener;
import megamek.client.ui.AWT.ClientGUI;
import megamek.client.ui.AWT.ConfirmDialog;
import megamek.client.ui.AWT.DoneButtoned;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.AWT.StatusBarPhaseDisplay;
import megamek.client.ui.AWT.TriggerAPPodDialog;
import megamek.client.ui.AWT.VibrabombSettingDialog;
import megamek.common.AmmoType;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.GameTurn;
import megamek.common.Mounted;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.WeaponType;
import megamek.common.actions.FlipArmsAction;
import megamek.common.actions.SearchlightAttackAction;
import megamek.common.actions.TorsoTwistAction;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.event.GameListener;
import megamek.common.event.GamePhaseChangeEvent;
import megamek.common.event.GameTurnChangeEvent;
import megamek.common.util.Distractable;
import megamek.common.util.DistractableAdapter;

public class TargetingPhaseDisplay
extends StatusBarPhaseDisplay
implements GameListener,
ActionListener,
DoneButtoned,
KeyListener,
ItemListener,
BoardViewListener,
Distractable {
    private DistractableAdapter distracted = new DistractableAdapter();
    public static final String FIRE_FIRE = "fireFire";
    public static final String FIRE_MODE = "fireMode";
    public static final String FIRE_FLIP_ARMS = "fireFlipArms";
    public static final String FIRE_NEXT = "fireNext";
    public static final String FIRE_NEXT_TARG = "fireNextTarg";
    public static final String FIRE_SKIP = "fireSkip";
    public static final String FIRE_TWIST = "fireTwist";
    public static final String FIRE_CANCEL = "fireCancel";
    public static final String FIRE_SEARCHLIGHT = "fireSearchlight";
    public ClientGUI clientgui;
    private Client client;
    private Container panButtons;
    private Button butFire;
    private Button butTwist;
    private Button butSkip;
    private Button butFlipArms;
    private Button butFireMode;
    private Button butSpace;
    private Button butNext;
    private Button butNextTarg;
    private Button butDone;
    private Button butSearchlight;
    private int buttonLayout;
    private int cen = -1;
    private Targetable target;
    private Vector attacks;
    private boolean shiftheld;
    private boolean twisting;
    private final int phase;
    private Entity[] visibleTargets = null;
    private int lastTargetID = -1;
    private boolean showTargetChoice = true;

    public TargetingPhaseDisplay(ClientGUI clientGUI, boolean bl) {
        this.clientgui = clientGUI;
        this.client = clientGUI.getClient();
        this.phase = bl ? 10 : 7;
        this.shiftheld = false;
        this.attacks = new Vector();
        this.setupStatusBar(Messages.getString("TargetingPhaseDisplay.waitingForTargetingPhase"));
        this.butFire = new Button(Messages.getString("TargetingPhaseDisplay.Fire"));
        this.butFire.addActionListener(this);
        this.butFire.setActionCommand(FIRE_FIRE);
        this.butFire.setEnabled(false);
        this.butSkip = new Button(Messages.getString("TargetingPhaseDisplay.Skip"));
        this.butSkip.addActionListener(this);
        this.butSkip.setActionCommand(FIRE_SKIP);
        this.butSkip.setEnabled(false);
        this.butTwist = new Button(Messages.getString("TargetingPhaseDisplay.Twist"));
        this.butTwist.addActionListener(this);
        this.butTwist.setActionCommand(FIRE_TWIST);
        this.butTwist.setEnabled(false);
        this.butFlipArms = new Button(Messages.getString("TargetingPhaseDisplay.FlipArms"));
        this.butFlipArms.addActionListener(this);
        this.butFlipArms.setActionCommand(FIRE_FLIP_ARMS);
        this.butFlipArms.setEnabled(false);
        this.butFireMode = new Button(Messages.getString("TargetingPhaseDisplay.Mode"));
        this.butFireMode.addActionListener(this);
        this.butFireMode.setActionCommand(FIRE_MODE);
        this.butFireMode.setEnabled(false);
        this.butNextTarg = new Button(Messages.getString("FiringDisplay.NextTarget"));
        this.butNextTarg.addActionListener(this);
        this.butNextTarg.addKeyListener(this);
        this.butNextTarg.setActionCommand(FIRE_NEXT_TARG);
        this.butNextTarg.setEnabled(false);
        this.butSearchlight = new Button(Messages.getString("FiringDisplay.Searchlight"));
        this.butSearchlight.addActionListener(this);
        this.butSearchlight.addKeyListener(this);
        this.butSearchlight.setActionCommand(FIRE_SEARCHLIGHT);
        this.butSearchlight.setEnabled(false);
        this.butSpace = new Button(".");
        this.butSpace.setEnabled(false);
        this.butDone = new Button(Messages.getString("TargetingPhaseDisplay.Done"));
        this.butDone.addActionListener(this);
        this.butDone.setEnabled(false);
        this.butNext = new Button(Messages.getString("TargetingPhaseDisplay.NextUnit"));
        this.butNext.addActionListener(this);
        this.butNext.setActionCommand(FIRE_NEXT);
        this.butNext.setEnabled(false);
        this.panButtons = new Panel();
        this.buttonLayout = 0;
        this.setupButtonPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addBag(this.panButtons, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        this.addBag(this.panStatus, gridBagLayout, gridBagConstraints);
    }

    public void initializeListeners() {
        this.client.game.addGameListener(this);
        this.clientgui.getBoardView().addBoardViewListener(this);
        this.clientgui.bv.addKeyListener(this);
        this.addKeyListener(this);
        this.clientgui.mechD.wPan.weaponList.addItemListener(this);
        this.clientgui.mechD.wPan.weaponList.addKeyListener(this);
    }

    private void addBag(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
        component.addKeyListener(this);
    }

    private void setupButtonPanel() {
        this.panButtons.removeAll();
        this.panButtons.setLayout(new GridLayout(0, 8));
        switch (this.buttonLayout) {
            case 0: {
                this.panButtons.add(this.butNext);
                this.panButtons.add(this.butFire);
                this.panButtons.add(this.butSkip);
                this.panButtons.add(this.butNextTarg);
                this.panButtons.add(this.butFlipArms);
                this.panButtons.add(this.butTwist);
                this.panButtons.add(this.butFireMode);
                this.panButtons.add(this.butSearchlight);
            }
        }
        this.validate();
    }

    public void selectEntity(int n) {
        if (n != this.cen) {
            this.clearAttacks();
            this.refreshAll();
        }
        if (this.client.game.getEntity(n) != null) {
            this.cen = n;
            this.clientgui.setSelectedEntityNum(n);
            if (null == this.ce().getPosition()) {
                int n2 = this.client.getNextEntityNum(n);
                while (n2 != n) {
                    if (null != this.client.game.getEntity(n2).getPosition()) {
                        this.cen = n2;
                        break;
                    }
                    n2 = this.client.getNextEntityNum(n2);
                }
                if (null == this.ce().getPosition()) {
                    System.err.println("FiringDisplay: could not find an on-board entity: " + n);
                    return;
                }
            }
            this.target(null);
            this.clientgui.getBoardView().highlight(this.ce().getPosition());
            this.clientgui.getBoardView().select(null);
            this.clientgui.getBoardView().cursor(null);
            this.refreshAll();
            this.cacheVisibleTargets();
            if (!this.clientgui.bv.isMovingUnits()) {
                this.clientgui.bv.centerOnHex(this.ce().getPosition());
            }
            this.clientgui.getMenuBar().setEntity(this.ce());
            this.setTwistEnabled(this.ce().canChangeSecondaryFacing() && this.ce().getCrew().isActive());
            this.setFlipArmsEnabled(this.ce().canFlipArms());
            this.updateSearchlight();
            this.setFireModeEnabled(true);
        } else {
            System.err.println("FiringDisplay: tried to select non-existant entity: " + n);
        }
    }

    private void beginMyTurn() {
        this.target = null;
        this.selectEntity(this.client.getFirstEntityNum());
        if (!this.clientgui.bv.isMovingUnits()) {
            this.clientgui.setDisplayVisible(true);
        }
        if (this.client.game.getTurn() instanceof GameTurn.TriggerAPPodTurn && null != this.ce()) {
            this.disableButtons();
            TriggerAPPodDialog triggerAPPodDialog = new TriggerAPPodDialog(this.clientgui.getFrame(), this.ce());
            triggerAPPodDialog.show();
            this.attacks.removeAllElements();
            Enumeration enumeration = triggerAPPodDialog.getActions();
            while (enumeration.hasMoreElements()) {
                this.attacks.addElement(enumeration.nextElement());
            }
            this.ready();
        } else {
            this.setNextEnabled(true);
            this.butDone.setEnabled(true);
            this.clientgui.getBoardView().select(null);
        }
    }

    private void endMyTurn() {
        Entity entity = this.client.game.getNextEntity(this.client.game.getTurnIndex());
        if (this.phase == this.client.game.getPhase() && null != entity && null != this.ce() && entity.getOwnerId() != this.ce().getOwnerId()) {
            this.clientgui.setDisplayVisible(false);
        }
        this.cen = -1;
        this.target(null);
        this.clientgui.getBoardView().select(null);
        this.clientgui.getBoardView().highlight(null);
        this.clientgui.getBoardView().cursor(null);
        this.clientgui.bv.clearMovementData();
        this.disableButtons();
    }

    private void disableButtons() {
        this.setFireEnabled(false);
        this.setSkipEnabled(false);
        this.setTwistEnabled(false);
        this.setNextEnabled(false);
        this.butDone.setEnabled(false);
        this.setFlipArmsEnabled(false);
        this.setFireModeEnabled(false);
        this.setNextTargetEnabled(false);
    }

    private void changeMode() {
        int n = this.clientgui.mechD.wPan.getSelectedWeaponNum();
        if (null == this.ce()) {
            return;
        }
        Mounted mounted = this.ce().getEquipment(n);
        if (mounted == null || !mounted.getType().hasModes()) {
            return;
        }
        int n2 = mounted.switchMode();
        this.client.sendModeChange(this.cen, n, n2);
        if (mounted.getType().hasInstantModeSwitch()) {
            this.clientgui.systemMessage(Messages.getString("FiringDisplay.switched", new Object[]{mounted.getName(), mounted.curMode().getDisplayableName()}));
        } else {
            this.clientgui.systemMessage(Messages.getString("FiringDisplay.willSwitch", new Object[]{mounted.getName(), mounted.pendingMode().getDisplayableName()}));
        }
        this.updateTarget();
        this.clientgui.mechD.wPan.displayMech(this.ce());
        this.clientgui.mechD.wPan.selectWeapon(n);
    }

    private void ready() {
        if (this.attacks.isEmpty() && GUIPreferences.getInstance().getNagForNoAction()) {
            String string;
            String string2 = Messages.getString("TargetingPhaseDisplay.DontFireDialog.title");
            ConfirmDialog confirmDialog = this.clientgui.doYesNoBotherDialog(string2, string = Messages.getString("TargetingPhaseDisplay.DontFireDialog.message"));
            if (!confirmDialog.getShowAgain()) {
                GUIPreferences.getInstance().setNagForNoAction(false);
            }
            if (!confirmDialog.getAnswer()) {
                return;
            }
        }
        this.disableButtons();
        this.removeTempAttacks();
        this.client.sendAttackData(this.cen, this.attacks);
        this.attacks.removeAllElements();
        this.clientgui.getMenuBar().setEntity(null);
    }

    private void doSearchlight() {
        if (this.ce() == null || this.target == null) {
            throw new IllegalArgumentException("current searchlight parameters are invalid");
        }
        if (!SearchlightAttackAction.isPossible(this.client.game, this.cen, this.target, null)) {
            return;
        }
        SearchlightAttackAction searchlightAttackAction = new SearchlightAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId());
        this.attacks.addElement(searchlightAttackAction);
        this.client.game.addAction(searchlightAttackAction);
        this.clientgui.bv.addAttack(searchlightAttackAction);
        this.clientgui.bv.repaint(100L);
        this.clientgui.minimap.drawMap();
        this.updateTarget();
    }

    private void fire() {
        int n = this.clientgui.mechD.wPan.getSelectedWeaponNum();
        Mounted mounted = this.ce().getEquipment(n);
        if (this.ce() == null || this.target == null || mounted == null || !(mounted.getType() instanceof WeaponType)) {
            throw new IllegalArgumentException("current fire parameters are invalid");
        }
        if (GUIPreferences.getInstance().getAutoDeclareSearchlight()) {
            this.doSearchlight();
        }
        WeaponAttackAction weaponAttackAction = new WeaponAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId(), n);
        if (null != mounted.getLinked() && ((WeaponType)mounted.getType()).getAmmoType() != -1) {
            Mounted mounted2 = mounted.getLinked();
            weaponAttackAction.setAmmoId(this.ce().getEquipmentNum(mounted2));
            if (((AmmoType)mounted2.getType()).getMunitionType() == 0x100000000L) {
                VibrabombSettingDialog vibrabombSettingDialog = new VibrabombSettingDialog(this.clientgui.frame);
                vibrabombSettingDialog.show();
                weaponAttackAction.setOtherAttackInfo(vibrabombSettingDialog.getSetting());
            }
        }
        this.attacks.addElement(weaponAttackAction);
        this.client.game.addAction(weaponAttackAction);
        this.clientgui.bv.addAttack(weaponAttackAction);
        this.clientgui.bv.repaint(100L);
        this.clientgui.minimap.drawMap();
        mounted.setUsedThisRound(true);
        int n2 = this.ce().getNextWeapon(n);
        if (n2 == -1 && GUIPreferences.getInstance().getAutoEndFiring()) {
            this.ready();
            return;
        }
        this.clientgui.mechD.wPan.displayMech(this.ce());
        this.clientgui.mechD.wPan.selectWeapon(n2);
        this.updateTarget();
    }

    private void nextWeapon() {
        int n = this.ce().getNextWeapon(this.clientgui.mechD.wPan.getSelectedWeaponNum());
        if (n == -1) {
            return;
        }
        this.clientgui.mechD.wPan.displayMech(this.ce());
        this.clientgui.mechD.wPan.selectWeapon(n);
        this.updateTarget();
    }

    private void clearAttacks() {
        if (this.ce() == null) {
            return;
        }
        Enumeration enumeration = this.attacks.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof WeaponAttackAction)) continue;
            WeaponAttackAction weaponAttackAction = (WeaponAttackAction)e;
            this.ce().getEquipment(weaponAttackAction.getWeaponId()).setUsedThisRound(false);
        }
        this.attacks.removeAllElements();
        this.removeTempAttacks();
        this.ce().setSecondaryFacing(this.ce().getFacing());
        this.ce().setArmsFlipped(false);
    }

    private void removeTempAttacks() {
        this.client.game.removeActionsFor(this.cen);
        this.clientgui.bv.removeAttacksFor(this.cen);
        this.clientgui.bv.repaint(100L);
    }

    private void refreshAll() {
        if (this.ce() == null) {
            return;
        }
        this.clientgui.bv.redrawEntity(this.ce());
        this.clientgui.mechD.displayEntity(this.ce());
        this.clientgui.mechD.showPanel("weapons");
        this.clientgui.mechD.wPan.selectWeapon(this.ce().getFirstWeapon());
        this.updateTarget();
    }

    void target(Targetable targetable) {
        this.target = targetable;
        this.updateTarget();
    }

    protected void updateTarget() {
        this.setFireEnabled(false);
        if (this.ce() != null && !this.ce().equals(this.clientgui.mechD.getCurrentEntity())) {
            this.clientgui.mechD.displayEntity(this.ce());
        }
        int n = this.clientgui.mechD.wPan.getSelectedWeaponNum();
        if (this.target != null && n != -1) {
            ToHitData toHitData = WeaponAttackAction.toHit(this.client.game, this.cen, this.target, n, -1, 0);
            this.clientgui.mechD.wPan.wTargetR.setText(this.target.getDisplayName());
            this.clientgui.mechD.wPan.wRangeR.setText("" + this.ce().getPosition().distance(this.target.getPosition()));
            Mounted mounted = this.ce().getEquipment(n);
            if (mounted.isUsedThisRound()) {
                this.clientgui.mechD.wPan.wToHitR.setText(Messages.getString("TargetingPhaseDisplay.alreadyFired"));
                this.setFireEnabled(false);
            } else if (mounted.getType().hasFlag(16)) {
                this.clientgui.mechD.wPan.wToHitR.setText(Messages.getString("TargetingPhaseDisplay.autoFiringWeapon"));
                this.setFireEnabled(false);
            } else if (toHitData.getValue() == Integer.MAX_VALUE) {
                this.clientgui.mechD.wPan.wToHitR.setText(toHitData.getValueAsString());
                this.setFireEnabled(false);
            } else if (toHitData.getValue() == 0x7FFFFFFE) {
                this.clientgui.mechD.wPan.wToHitR.setText(toHitData.getValueAsString());
                this.setFireEnabled(true);
            } else {
                this.clientgui.mechD.wPan.wToHitR.setText(toHitData.getValueAsString() + " (" + Compute.oddsAbove(toHitData.getValue()) + "%)");
                this.setFireEnabled(true);
            }
            this.clientgui.mechD.wPan.toHitText.setText(toHitData.getDesc());
            this.setSkipEnabled(true);
        } else {
            this.clientgui.mechD.wPan.wTargetR.setText("---");
            this.clientgui.mechD.wPan.wRangeR.setText("---");
            this.clientgui.mechD.wPan.wToHitR.setText("---");
            this.clientgui.mechD.wPan.toHitText.setText("");
        }
        this.updateSearchlight();
    }

    private void torsoTwist(Coords coords) {
        int n = this.ce().getFacing();
        if (null != coords) {
            n = this.ce().clipSecondaryFacing(this.ce().getPosition().direction(coords));
        }
        if (n != this.ce().getSecondaryFacing()) {
            this.clearAttacks();
            this.attacks.addElement(new TorsoTwistAction(this.cen, n));
            this.ce().setSecondaryFacing(n);
            this.refreshAll();
        }
    }

    private void torsoTwist(int n) {
        int n2 = this.ce().getSecondaryFacing();
        if (n == 0) {
            this.clearAttacks();
            n2 = this.ce().clipSecondaryFacing((n2 + 5) % 6);
            this.attacks.addElement(new TorsoTwistAction(this.cen, n2));
            this.ce().setSecondaryFacing(n2);
            this.refreshAll();
        } else if (n == 1) {
            this.clearAttacks();
            n2 = this.ce().clipSecondaryFacing((n2 + 7) % 6);
            this.attacks.addElement(new TorsoTwistAction(this.cen, n2));
            this.ce().setSecondaryFacing(n2);
            this.refreshAll();
        }
    }

    private void cacheVisibleTargets() {
        this.clearVisibleTargets();
        Vector vector = this.client.game.getValidTargets(this.ce());
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                Entity entity = (Entity)object;
                Entity entity2 = (Entity)object2;
                int n2 = TargetingPhaseDisplay.this.ce().getPosition().distance(entity.getPosition());
                if (n2 == (n = TargetingPhaseDisplay.this.ce().getPosition().distance(entity2.getPosition()))) {
                    return entity.getId() < entity2.getId() ? -1 : 1;
                }
                return n2 < n ? -1 : 1;
            }
        };
        TreeSet treeSet = new TreeSet(comparator);
        this.visibleTargets = new Entity[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            treeSet.add(vector.elementAt(i));
        }
        Iterator iterator = treeSet.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this.visibleTargets[n++] = (Entity)iterator.next();
        }
        this.setNextTargetEnabled(this.visibleTargets.length > 0);
    }

    private void clearVisibleTargets() {
        this.visibleTargets = null;
        this.lastTargetID = -1;
        this.setNextTargetEnabled(false);
    }

    private Entity getNextTarget() {
        if (null == this.visibleTargets) {
            return null;
        }
        ++this.lastTargetID;
        if (this.lastTargetID >= this.visibleTargets.length) {
            this.lastTargetID = 0;
        }
        return this.visibleTargets[this.lastTargetID];
    }

    private void jumpToNextTarget() {
        Entity entity = this.getNextTarget();
        if (null == entity) {
            return;
        }
        this.showTargetChoice = false;
        this.clientgui.bv.centerOnHex(entity.getPosition());
        this.clientgui.getBoardView().select(entity.getPosition());
        this.showTargetChoice = true;
        this.target(entity);
    }

    private Entity ce() {
        return this.client.game.getEntity(this.cen);
    }

    public void hexMoused(BoardViewEvent boardViewEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (!this.client.isMyTurn() || (boardViewEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        if ((boardViewEvent.getModifiers() & 2) != 0 || (boardViewEvent.getModifiers() & 8) != 0) {
            return;
        }
        if (this.shiftheld != ((boardViewEvent.getModifiers() & 1) != 0)) {
            boolean bl = this.shiftheld = (boardViewEvent.getModifiers() & 1) != 0;
        }
        if (boardViewEvent.getType() == 2) {
            if (this.shiftheld || this.twisting) {
                this.updateFlipArms(false);
                this.torsoTwist(boardViewEvent.getCoords());
            }
            this.clientgui.getBoardView().cursor(boardViewEvent.getCoords());
        } else if (boardViewEvent.getType() == 0) {
            this.twisting = false;
            this.clientgui.getBoardView().select(boardViewEvent.getCoords());
        }
    }

    public void hexSelected(BoardViewEvent boardViewEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.client.isMyTurn() && boardViewEvent.getCoords() != null && this.ce() != null && !boardViewEvent.getCoords().equals(this.ce().getPosition())) {
            boolean bl = this.client.game.getOptions().booleanOption("friendly_fire");
            if (this.shiftheld) {
                this.updateFlipArms(false);
                this.torsoTwist(boardViewEvent.getCoords());
            } else if (bl && this.client.game.getFirstEntity(boardViewEvent.getCoords()) != null) {
                this.target(this.client.game.getFirstEntity(boardViewEvent.getCoords()));
            } else if (this.client.game.getFirstEnemyEntity(boardViewEvent.getCoords(), this.ce()) != null) {
                this.target(this.client.game.getFirstEnemyEntity(boardViewEvent.getCoords(), this.ce()));
            }
        }
    }

    public void gameTurnChange(GameTurnChangeEvent gameTurnChangeEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.client.game.getPhase() == this.phase) {
            this.endMyTurn();
            if (this.client.isMyTurn()) {
                this.beginMyTurn();
                this.setStatusBarText(Messages.getString("TargetingPhaseDisplay.its_your_turn"));
            } else {
                this.setStatusBarText(Messages.getString("TargetingPhaseDisplay.its_others_turn", new Object[]{gameTurnChangeEvent.getPlayer().getName()}));
            }
        }
    }

    public void gamePhaseChange(GamePhaseChangeEvent gamePhaseChangeEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.client.isMyTurn() && this.client.game.getPhase() != this.phase) {
            this.endMyTurn();
        }
        if (this.client.game.getPhase() == this.phase) {
            this.setStatusBarText(Messages.getString("TargetingPhaseDisplay.waitingForFiringPhase"));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.statusBarActionPerformed(actionEvent, this.client)) {
            return;
        }
        if (!this.client.isMyTurn()) {
            return;
        }
        if (actionEvent.getSource() == this.butDone) {
            this.ready();
        } else if (actionEvent.getActionCommand().equalsIgnoreCase("viewGameOptions")) {
            if (this.clientgui.getGameOptionsDialog().isEditable()) {
                this.clientgui.getGameOptionsDialog().setEditable(false);
            }
            this.clientgui.getGameOptionsDialog().update(this.client.game.getOptions());
            this.clientgui.getGameOptionsDialog().show();
        } else if (actionEvent.getActionCommand().equals(FIRE_FIRE)) {
            this.fire();
        } else if (actionEvent.getActionCommand().equals(FIRE_SKIP)) {
            this.nextWeapon();
        } else if (actionEvent.getActionCommand().equals(FIRE_TWIST)) {
            this.twisting = true;
        } else if (actionEvent.getActionCommand().equals(FIRE_NEXT)) {
            this.selectEntity(this.client.getNextEntityNum(this.cen));
        } else if (actionEvent.getActionCommand().equals(FIRE_NEXT_TARG)) {
            this.jumpToNextTarget();
        } else if (actionEvent.getActionCommand().equals(FIRE_FLIP_ARMS)) {
            this.updateFlipArms(!this.ce().getArmsFlipped());
        } else if (actionEvent.getActionCommand().equals(FIRE_MODE)) {
            this.changeMode();
        } else if (actionEvent.getActionCommand().equals(FIRE_CANCEL)) {
            this.clearAttacks();
            this.clientgui.getBoardView().select(null);
            this.clientgui.getBoardView().cursor(null);
            this.refreshAll();
        } else if (actionEvent.getActionCommand().equals(FIRE_SEARCHLIGHT)) {
            this.doSearchlight();
        }
    }

    private void updateFlipArms(boolean bl) {
        if (bl == this.ce().getArmsFlipped()) {
            return;
        }
        this.twisting = false;
        this.torsoTwist(null);
        this.clearAttacks();
        this.ce().setArmsFlipped(bl);
        this.attacks.addElement(new FlipArmsAction(this.cen, bl));
        this.updateTarget();
        this.refreshAll();
    }

    private void updateSearchlight() {
        this.setSearchlightEnabled(this.ce() != null && this.target != null && this.ce().isUsingSpotlight() && this.ce().getCrew().isActive() && SearchlightAttackAction.isPossible(this.client.game, this.cen, this.target, null));
    }

    private void setFireEnabled(boolean bl) {
        this.butFire.setEnabled(bl);
        this.clientgui.getMenuBar().setFireFireEnabled(bl);
    }

    private void setTwistEnabled(boolean bl) {
        this.butTwist.setEnabled(bl);
        this.clientgui.getMenuBar().setFireTwistEnabled(bl);
    }

    private void setSkipEnabled(boolean bl) {
        this.butSkip.setEnabled(bl);
        this.clientgui.getMenuBar().setFireSkipEnabled(bl);
    }

    private void setFlipArmsEnabled(boolean bl) {
        this.butFlipArms.setEnabled(bl);
        this.clientgui.getMenuBar().setFireFlipArmsEnabled(bl);
    }

    private void setNextEnabled(boolean bl) {
        this.butNext.setEnabled(bl);
        this.clientgui.getMenuBar().setFireNextEnabled(bl);
    }

    private void setSearchlightEnabled(boolean bl) {
        this.butSearchlight.setEnabled(bl);
        this.clientgui.getMenuBar().setFireSearchlightEnabled(bl);
    }

    private void setFireModeEnabled(boolean bl) {
        this.butFireMode.setEnabled(bl);
        this.clientgui.getMenuBar().setFireModeEnabled(bl);
    }

    private void setNextTargetEnabled(boolean bl) {
        this.butNextTarg.setEnabled(bl);
        this.clientgui.getMenuBar().setFireNextTargetEnabled(bl);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (keyEvent.getKeyCode() == 27) {
            this.clearAttacks();
            this.clientgui.getBoardView().select(null);
            this.clientgui.getBoardView().cursor(null);
            this.refreshAll();
        }
        if (keyEvent.getKeyCode() != 10 || !keyEvent.isControlDown() || this.client.isMyTurn()) {
            // empty if block
        }
        if (keyEvent.getKeyCode() == 16 && !this.shiftheld) {
            this.shiftheld = true;
            if (this.client.isMyTurn() && this.clientgui.getBoardView().getLastCursor() != null) {
                this.updateFlipArms(false);
                this.torsoTwist(this.clientgui.getBoardView().getLastCursor());
            }
        }
        if (keyEvent.getKeyCode() == 37 && this.shiftheld) {
            this.updateFlipArms(false);
            this.torsoTwist(0);
        }
        if (keyEvent.getKeyCode() == 39 && this.shiftheld) {
            this.updateFlipArms(false);
            this.torsoTwist(1);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (keyEvent.getKeyCode() == 16 && this.shiftheld) {
            this.shiftheld = false;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (itemEvent.getItemSelectable() == this.clientgui.mechD.wPan.weaponList) {
            this.updateTarget();
        }
    }

    public void finishedMovingUnits(BoardViewEvent boardViewEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.client.isMyTurn() && this.ce() != null) {
            this.clientgui.setDisplayVisible(true);
            this.clientgui.bv.centerOnHex(this.ce().getPosition());
        }
    }

    public void unitSelected(BoardViewEvent boardViewEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        Entity entity = this.client.game.getEntity(boardViewEvent.getEntityId());
        if (this.client.isMyTurn()) {
            if (this.client.game.getTurn().isValidEntity(entity, this.client.game)) {
                this.selectEntity(entity.getId());
            }
        } else {
            this.clientgui.setDisplayVisible(true);
            this.clientgui.mechD.displayEntity(entity);
            if (entity.isDeployed()) {
                this.clientgui.bv.centerOnHex(entity.getPosition());
            }
        }
    }

    public boolean isIgnoringEvents() {
        return this.distracted.isIgnoringEvents();
    }

    public void setIgnoringEvents(boolean bl) {
        this.distracted.setIgnoringEvents(bl);
    }

    public Button getDoneButton() {
        return this.butDone;
    }

    public void removeAllListeners() {
        this.client.game.removeGameListener(this);
        this.clientgui.getBoardView().removeBoardViewListener(this);
        this.clientgui.mechD.wPan.weaponList.removeItemListener(this);
    }
}

