/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.widget;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import megamek.client.ui.AWT.widget.BackGroundDrawer;
import megamek.client.ui.AWT.widget.PMAreasGroup;
import megamek.client.ui.AWT.widget.PMElement;
import megamek.client.ui.AWT.widget.PMHotArea;
import megamek.client.ui.AWT.widget.PMLabel;

public abstract class PicMap
extends Component {
    private Vector bgDrawers = new Vector();
    private PMAreasGroup otherAreas = new PMAreasGroup();
    private PMAreasGroup hotAreas = new PMAreasGroup();
    private PMAreasGroup labels = new PMAreasGroup();
    private int areascount = 0;
    private PMAreasGroup rootGroup = new PMAreasGroup();
    private Image offScr;
    private int topMargin = 0;
    private int leftMargin = 0;
    private int bottomMargin = 0;
    private int rightMargin = 0;
    private PMHotArea activeHotArea = null;
    int minWidth = 1;
    int minHeight = 1;
    private boolean bgIsOpaque = true;

    public PicMap() {
        this.rootGroup.addArea(this.otherAreas);
        this.rootGroup.addArea(this.hotAreas);
        this.rootGroup.addArea(this.labels);
        this.enableEvents(49L);
    }

    public abstract void onResize();

    public void addElement(PMElement pMElement) {
        if (pMElement instanceof PMLabel) {
            this.labels.addArea(pMElement);
        } else if (pMElement instanceof PMHotArea) {
            this.hotAreas.addArea(pMElement);
            ++this.areascount;
        } else if (pMElement instanceof PMAreasGroup) {
            PMAreasGroup pMAreasGroup = (PMAreasGroup)pMElement;
            Enumeration enumeration = pMAreasGroup.elements();
            while (enumeration.hasMoreElements()) {
                this.addElement((PMElement)enumeration.nextElement());
            }
        } else {
            this.otherAreas.addArea(pMElement);
        }
    }

    public void removeElement(PMElement pMElement) {
        if (pMElement instanceof PMLabel) {
            this.labels.removeArea(pMElement);
        } else if (pMElement instanceof PMHotArea) {
            if (this.hotAreas.removeArea(pMElement)) {
                --this.areascount;
            }
        } else {
            this.otherAreas.removeArea(pMElement);
        }
    }

    public void removeAll() {
        this.otherAreas.removeAll();
        this.hotAreas.removeAll();
        this.labels.removeAll();
        this.bgDrawers.removeAllElements();
        this.areascount = 0;
        this.activeHotArea = null;
    }

    public void addBgDrawer(BackGroundDrawer backGroundDrawer) {
        this.bgDrawers.addElement(backGroundDrawer);
    }

    public void removeBgDrawer(BackGroundDrawer backGroundDrawer) {
        this.bgDrawers.removeElement(backGroundDrawer);
    }

    public void setContentMargins(int n, int n2, int n3, int n4) {
        this.leftMargin = n < 0 ? 0 : n;
        this.topMargin = n2 < 0 ? 0 : n2;
        this.rightMargin = n3 < 0 ? 0 : n3;
        this.bottomMargin = n4 < 0 ? 0 : n4;
        Rectangle rectangle = this.rootGroup.getBounds();
        this.rootGroup.translate(this.leftMargin - rectangle.x, this.topMargin - rectangle.y);
    }

    public Rectangle getContentBounds() {
        return this.rootGroup.getBounds();
    }

    public void addNotify() {
        super.addNotify();
        this.update();
    }

    public void update() {
        if (this.bgIsOpaque) {
            int n = Math.max(this.getSize().width, this.minWidth);
            int n2 = Math.max(this.getSize().height, this.minHeight);
            this.offScr = this.createImage(n, n2);
            if (this.offScr == null) {
                return;
            }
            Graphics graphics = this.offScr.getGraphics();
            this.drawInto(graphics);
            this.repaint();
            graphics.dispose();
        } else {
            this.repaint();
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.bgIsOpaque) {
            graphics.drawImage(this.offScr, 0, 0, null);
        } else {
            this.drawInto(graphics);
        }
    }

    private void drawInto(Graphics graphics) {
        Object object;
        int n = Math.max(this.getSize().width, this.minWidth);
        int n2 = Math.max(this.getSize().height, this.minHeight);
        Enumeration enumeration = this.bgDrawers.elements();
        while (enumeration.hasMoreElements()) {
            object = (BackGroundDrawer)enumeration.nextElement();
            ((BackGroundDrawer)object).drawInto(graphics, n, n2);
        }
        object = (Rectangle)graphics.getClip();
        graphics.setClip(new Rectangle(this.leftMargin, this.topMargin, n - this.leftMargin - this.rightMargin, n2 - this.topMargin - this.bottomMargin));
        this.hotAreas.drawInto(graphics);
        if (this.activeHotArea != null) {
            this.activeHotArea.drawInto(graphics);
        }
        this.labels.drawInto(graphics);
        graphics.setClip((Shape)object);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        Rectangle rectangle = this.rootGroup.getBounds();
        if (rectangle != null) {
            return new Dimension(rectangle.x + rectangle.width + this.rightMargin, rectangle.y + rectangle.height + this.bottomMargin);
        }
        return new Dimension(this.minWidth, this.minHeight);
    }

    public PMHotArea getAreaUnder(int n, int n2) {
        for (int i = this.areascount - 1; i >= 0; --i) {
            PMHotArea pMHotArea = (PMHotArea)this.hotAreas.elementAt(i);
            if (pMHotArea == null || !this.intersects(pMHotArea.getAreaShape(), n, n2)) continue;
            return pMHotArea;
        }
        return null;
    }

    private boolean intersects(Shape shape, int n, int n2) {
        if (shape instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)shape;
            return rectangle.contains(n, n2);
        }
        if (shape instanceof Polygon) {
            Polygon polygon = (Polygon)shape;
            return polygon.contains(n, n2);
        }
        return false;
    }

    public void setBackgroundOpaque(boolean bl) {
        this.bgIsOpaque = bl;
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        PMHotArea pMHotArea = this.getAreaUnder(mouseEvent.getX(), mouseEvent.getY());
        switch (mouseEvent.getID()) {
            case 500: {
                if (pMHotArea == null) break;
                pMHotArea.onMouseClick(mouseEvent);
                break;
            }
            case 501: {
                if (pMHotArea == null) break;
                pMHotArea.onMouseDown(mouseEvent);
                break;
            }
            case 502: {
                if (pMHotArea == null) break;
                pMHotArea.onMouseUp(mouseEvent);
            }
        }
        this.update();
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 503: {
                PMHotArea pMHotArea = this.getAreaUnder(mouseEvent.getX(), mouseEvent.getY());
                if (pMHotArea == this.activeHotArea) break;
                if (this.activeHotArea != null) {
                    this.activeHotArea.onMouseExit(mouseEvent);
                }
                this.activeHotArea = pMHotArea;
                if (pMHotArea != null) {
                    pMHotArea.onMouseOver(mouseEvent);
                    this.setCursor(pMHotArea.getCursor());
                } else {
                    this.setCursor(Cursor.getDefaultCursor());
                }
                this.update();
            }
        }
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        switch (componentEvent.getID()) {
            case 101: {
                this.onResize();
                this.update();
            }
        }
    }
}

