/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import megamek.common.CriticalSlot;
import megamek.common.EquipmentType;
import megamek.common.Mech;
import megamek.common.PilotingRollData;

public class BipedMech
extends Mech {
    public static final String[] LOCATION_NAMES = new String[]{"Head", "Center Torso", "Right Torso", "Left Torso", "Right Arm", "Left Arm", "Right Leg", "Left Leg"};
    public static final String[] LOCATION_ABBRS = new String[]{"HD", "CT", "RT", "LT", "RA", "LA", "RL", "LL"};
    private static final int[] NUM_OF_SLOTS = new int[]{6, 12, 12, 12, 12, 12, 6, 6};

    public BipedMech(String string, String string2) {
        this(BipedMech.getGyroTypeForString(string), BipedMech.getCockpitTypeForString(string2));
    }

    public BipedMech() {
        this(0, 0);
    }

    public BipedMech(int n, int n2) {
        super(n, n2);
        this.movementMode = 1;
        this.setCritical(4, 0, new CriticalSlot(0, 7));
        this.setCritical(4, 1, new CriticalSlot(0, 8));
        this.setCritical(4, 2, new CriticalSlot(0, 9));
        this.setCritical(4, 3, new CriticalSlot(0, 10));
        this.setCritical(5, 0, new CriticalSlot(0, 7));
        this.setCritical(5, 1, new CriticalSlot(0, 8));
        this.setCritical(5, 2, new CriticalSlot(0, 9));
        this.setCritical(5, 3, new CriticalSlot(0, 10));
    }

    public boolean canFlipArms() {
        boolean bl;
        boolean bl2 = bl = !this.isProne();
        if (this.hasSystem(10, 5)) {
            bl = false;
        } else if (this.hasSystem(9, 5)) {
            bl = false;
        } else if (this.hasSystem(10, 4)) {
            bl = false;
        } else if (this.hasSystem(9, 4)) {
            bl = false;
        }
        return bl;
    }

    public int getWalkMP() {
        return this.getWalkMP(true);
    }

    public int getWalkMP(boolean bl) {
        int n = this.getOriginalWalkMP();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.locations(); ++i) {
            if (!this.locationIsLeg(i)) continue;
            if (!this.isLocationBad(i)) {
                if (this.legHasHipCrit(i)) {
                    ++n3;
                    if (!this.game.getOptions().booleanOption("maxtech_leg_damage")) continue;
                }
                n4 += this.countLegActuatorCrits(i);
                continue;
            }
            ++n2;
        }
        if (n2 > 0) {
            n = n2 == 1 ? 1 : 0;
        } else {
            if (n3 > 0) {
                n = this.game.getOptions().booleanOption("maxtech_leg_damage") ? (n3 >= 1 ? n - 2 * n3 : 0) : (n3 == 1 ? (int)Math.ceil((double)n / 2.0) : 0);
            }
            n -= n4;
        }
        n -= this.heat / 5;
        if (this.heat >= 9 && this.hasTSM()) {
            n = this.heat == 9 ? (n += 2) : ++n;
        }
        if (bl) {
            n = this.applyGravityEffectsOnMP(n);
        }
        n = Math.max(0, n);
        return n;
    }

    public int getRunMP(boolean bl) {
        if (this.countBadLegs() == 0) {
            return super.getRunMP(bl);
        }
        return this.getWalkMP(bl);
    }

    public int getRunMPwithoutMASC(boolean bl) {
        if (this.countBadLegs() == 0) {
            return super.getRunMPwithoutMASC(bl);
        }
        return this.getWalkMP(bl);
    }

    public void setInternal(int n, int n2, int n3, int n4, int n5) {
        this.initializeInternal(n, 0);
        this.initializeInternal(n2, 1);
        this.initializeInternal(n3, 2);
        this.initializeInternal(n3, 3);
        this.initializeInternal(n4, 4);
        this.initializeInternal(n4, 5);
        this.initializeInternal(n5, 6);
        this.initializeInternal(n5, 7);
    }

    public PilotingRollData addEntityBonuses(PilotingRollData pilotingRollData) {
        int[] nArray = new int[]{6, 7};
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (this.isLocationBad(n)) {
                pilotingRollData.addModifier(5, this.getLocationName(n) + " destroyed");
                continue;
            }
            if (this.getBadCriticals(0, 11, n) > 0) {
                pilotingRollData.addModifier(2, this.getLocationName(n) + " Hip Actuator destroyed");
                if (!this.game.getOptions().booleanOption("maxtech_leg_damage")) continue;
            }
            if (this.getBadCriticals(0, 12, n) > 0) {
                pilotingRollData.addModifier(1, this.getLocationName(n) + " Upper Leg Actuator destroyed");
            }
            if (this.getBadCriticals(0, 13, n) > 0) {
                pilotingRollData.addModifier(1, this.getLocationName(n) + " Lower Leg Actuator destroyed");
            }
            if (this.getBadCriticals(0, 14, n) <= 0) continue;
            pilotingRollData.addModifier(1, this.getLocationName(n) + " Foot Actuator destroyed");
        }
        return super.addEntityBonuses(pilotingRollData);
    }

    protected int[] getNoOfSlots() {
        return NUM_OF_SLOTS;
    }

    protected String[] getLocationNames() {
        return LOCATION_NAMES;
    }

    protected String[] getLocationAbbrs() {
        return LOCATION_ABBRS;
    }

    public double getCost() {
        double d = 0.0;
        d = this.getCockpitType() == 1 ? (d += 750000.0) : (this.getCockpitType() == 2 ? (d += 175000.0) : (d += 200000.0));
        if (this.hasEiCockpit()) {
            d += 200000.0;
        }
        d += 50000.0;
        d += (double)(this.weight * 2000.0f);
        int n = this.hasTSM() ? 16000 : 2000;
        d += (double)((float)n * this.weight);
        int n2 = 400;
        if (this.hasEndo() || this.hasCompositeStructure()) {
            n2 = 1600;
        }
        if (this.hasReinforcedStructure()) {
            n2 = 6400;
        }
        d += (double)((float)n2 * this.weight);
        d += (double)(700.0f * this.weight);
        int n3 = 0;
        int n4 = 0;
        if (this.hasSystem(10, 5)) {
            ++n4;
        }
        if (this.hasSystem(9, 5)) {
            ++n3;
        }
        if (this.hasSystem(10, 4)) {
            ++n4;
        }
        if (this.hasSystem(9, 4)) {
            ++n3;
        }
        d += (double)((float)(200 + n3 * 50 + n4 * 80) * this.weight);
        int n5 = 5000;
        if (this.hasXL()) {
            n5 = 20000;
        }
        if (this.hasLightEngine()) {
            n5 = 15000;
        }
        d += (double)(this.weight * (float)this.getOriginalWalkMP() * this.weight * (float)n5 / 75.0f);
        d = this.getGyroType() == 1 ? (d += (double)(750000 * (int)Math.ceil((float)this.getOriginalWalkMP() * this.weight / 100.0f)) * 0.5) : (this.getGyroType() == 2 ? (d += (double)(400000 * (int)Math.ceil((float)this.getOriginalWalkMP() * this.weight / 100.0f)) * 1.5) : (this.getGyroType() == 3 ? (d += (double)(500000 * (int)Math.ceil((float)this.getOriginalWalkMP() * this.weight / 100.0f) * 2)) : (d += (double)(300000 * (int)Math.ceil((float)this.getOriginalWalkMP() * this.weight / 100.0f)))));
        d += (double)((float)(this.getOriginalJumpMP() * this.getOriginalJumpMP()) * this.weight * 200.0f);
        int n6 = this.hasDoubleHeatSinks() ? 0 : 10;
        int n7 = this.hasDoubleHeatSinks() ? 6000 : 2000;
        d += (double)(n7 * (this.heatSinks() - n6));
        d += this.getArmorWeight() * EquipmentType.getArmorCost(this.armorType);
        d += (double)this.getWeaponsAndEquipmentCost();
        double d2 = 0.0;
        if (this.isOmni()) {
            d2 = d * 0.25;
        }
        d += d2;
        return Math.round(d *= (double)(1.0f + this.weight / 100.0f));
    }

    public double getArmorWeight() {
        double d = 16.0 * EquipmentType.getArmorPointMultiplier(this.armorType, this.techLevel);
        double d2 = 0.0;
        while ((int)Math.round(d2 * d) < this.getTotalOArmor()) {
            d2 += 0.5;
        }
        return d2;
    }
}

