/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.util.Enumeration;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.Building;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Infantry;
import megamek.common.LosEffects;
import megamek.common.MMRandom;
import megamek.common.MMRoll;
import megamek.common.Mech;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.Protomech;
import megamek.common.QuadMech;
import megamek.common.RangeType;
import megamek.common.Roll;
import megamek.common.Tank;
import megamek.common.TargetRoll;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.UnitType;
import megamek.common.VTOL;
import megamek.common.WeaponType;
import megamek.common.actions.BrushOffAttackAction;
import megamek.common.actions.ClubAttackAction;
import megamek.common.actions.KickAttackAction;
import megamek.common.actions.ProtomechPhysicalAttackAction;
import megamek.common.actions.PunchAttackAction;
import megamek.common.actions.PushAttackAction;
import megamek.common.actions.ThrashAttackAction;
import megamek.common.actions.WeaponAttackAction;

public class Compute {
    public static final int ARC_360 = 0;
    public static final int ARC_FORWARD = 1;
    public static final int ARC_LEFTARM = 2;
    public static final int ARC_RIGHTARM = 3;
    public static final int ARC_REAR = 4;
    public static final int ARC_LEFTSIDE = 5;
    public static final int ARC_RIGHTSIDE = 6;
    public static final int ARC_MAINGUN = 7;
    private static MMRandom random = MMRandom.generate(1);
    private static float[] expectedHitsByRackSize = new float[]{0.0f, 1.0f, 1.58f, 2.0f, 2.63f, 3.17f, 4.0f, 4.49f, 4.98f, 5.47f, 6.31f, 7.23f, 8.14f, 8.59f, 9.04f, 9.5f, 10.1f, 10.8f, 11.42f, 12.1f, 12.7f};

    public static int d6(int n) {
        Roll roll = random.d6(n);
        return roll.getIntValue();
    }

    public static int d6() {
        Roll roll = random.d6();
        return roll.getIntValue();
    }

    public static int randomInt(int n) {
        MMRoll mMRoll = new MMRoll(random, n);
        return ((Roll)mMRoll).getIntValue();
    }

    public static void setRNG(int n) {
        random = MMRandom.generate(n);
    }

    public static double oddsAbove(int n) {
        if (n <= 2) {
            return 100.0;
        }
        if (n > 12) {
            return 0.0;
        }
        double[] dArray = new double[]{100.0, 100.0, 100.0, 97.2, 91.6, 83.3, 72.2, 58.3, 41.6, 27.7, 16.6, 8.3, 2.78, 0.0};
        return dArray[n];
    }

    public static Entity stackingViolation(IGame iGame, int n, Coords coords) {
        Entity entity = iGame.getEntity(n);
        return Compute.stackingViolation(iGame, entity, coords, null);
    }

    public static Entity stackingViolation(IGame iGame, Entity entity, Coords coords, Entity entity2) {
        boolean bl = entity instanceof Mech;
        Entity entity3 = entity2;
        int n = 1;
        int n2 = entity.getElevation();
        if (coords != null && entity.getPosition() != null) {
            n2 = entity.calcElevation(iGame.getBoard().getHex(entity.getPosition()), iGame.getBoard().getHex(coords));
        }
        int n3 = n2 + entity.height();
        Enumeration enumeration = iGame.getEntities(coords);
        while (enumeration.hasMoreElements()) {
            Entity entity4 = (Entity)enumeration.nextElement();
            int n4 = entity4.getElevation();
            int n5 = n4 + entity4.height();
            if (n2 > n5 || n3 < n4 || entity4.equals(entity) || entity4.equals(entity2) || entity4.isMakingDfa()) continue;
            if (bl && entity4 instanceof Mech) {
                return entity4;
            }
            if (++n > 4) {
                return entity4;
            }
            if (entity4.getOwner().isEnemyOf(entity.getOwner())) continue;
            if (entity3 == null) {
                entity3 = entity4;
                continue;
            }
            return Compute.d6() > 3 ? entity3 : entity4;
        }
        return null;
    }

    public static boolean isEnemyIn(IGame iGame, int n, Coords coords, boolean bl) {
        return Compute.isEnemyIn(iGame, n, coords, bl, iGame.getEntity(n).getElevation());
    }

    public static boolean isEnemyIn(IGame iGame, int n, Coords coords, boolean bl, int n2) {
        Entity entity = iGame.getEntity(n);
        int n3 = n2 + entity.getHeight();
        Enumeration enumeration = iGame.getEntities(coords);
        while (enumeration.hasMoreElements()) {
            Entity entity2 = (Entity)enumeration.nextElement();
            int n4 = entity2.getElevation();
            int n5 = n4 + entity2.getHeight();
            if (bl && !(entity2 instanceof Mech) || !entity2.isEnemyOf(entity) || entity2.isMakingDfa() || n2 > n5 || n3 < n4) continue;
            return true;
        }
        return false;
    }

    public static boolean isPilotingSkillNeeded(IGame iGame, int n, Coords coords, Coords coords2, int n2, boolean bl, boolean bl2, int n3, int n4) {
        Entity entity = iGame.getEntity(n);
        IHex iHex = iGame.getBoard().getHex(coords);
        IHex iHex2 = iGame.getBoard().getHex(coords2);
        boolean bl3 = entity instanceof Infantry;
        boolean bl4 = Compute.canMoveOnPavement(iGame, coords, coords2);
        if (entity == null) {
            throw new IllegalArgumentException("Entity invalid.");
        }
        if (coords.distance(coords2) > 1) {
            throw new IllegalArgumentException("Coordinates must be adjacent.");
        }
        if (coords.equals(coords2)) {
            return false;
        }
        if (n2 != 3 && iHex2.terrainLevel(3) > 0 && entity.getMovementMode() != 6 && !bl3) {
            return true;
        }
        if (iHex2.containsTerrain(9) && entity.getElevation() <= iHex2.getElevation() && entity.getMovementMode() != 5 && entity.getMovementMode() != 6 && n2 != 3) {
            return true;
        }
        if (iHex2.containsTerrain(20) && iHex2.containsTerrain(4) && entity.getElevation() <= iHex2.getElevation() && !bl4 && n2 != 3) {
            return true;
        }
        if (n2 != 3 && entity.getElevation() <= iHex2.surface() && entity.getMovementMode() != 5 && entity.getMovementMode() != 7 && entity.getMovementMode() != 8 && entity.getMovementMode() != 9 && iHex2.terrainLevel(4) > 0 && !bl4) {
            return true;
        }
        if ((bl2 && n2 == 2 || iHex.containsTerrain(20) && n2 != 3) && bl && !bl3) {
            return true;
        }
        if (!(n3 >= iHex.terrainLevel(12) && n4 >= iHex2.terrainLevel(12) || entity instanceof Infantry)) {
            return true;
        }
        return entity instanceof VTOL && bl && (n2 == 2 || n2 == 5);
    }

    public static boolean isValidDisplacement(IGame iGame, int n, Coords coords, int n2) {
        return Compute.isValidDisplacement(iGame, n, coords, coords.translated(n2));
    }

    public static boolean isValidDisplacement(IGame iGame, int n, Coords coords, Coords coords2) {
        Entity entity = iGame.getEntity(n);
        IHex iHex = iGame.getBoard().getHex(coords);
        IHex iHex2 = iGame.getBoard().getHex(coords2);
        Coords[] coordsArray = Coords.intervening(coords, coords2);
        int n2 = coords.direction(coords2);
        if (entity == null) {
            throw new IllegalArgumentException("Entity invalid.");
        }
        if (!iGame.getBoard().contains(coords2)) {
            return iGame.getOptions().booleanOption("push_off_board");
        }
        if (entity.isHexProhibited(iHex2) && (!(entity instanceof Tank) || !iHex2.containsTerrain(4) || entity.movementMode != 3 && entity.movementMode != 4)) {
            return false;
        }
        for (int i = 0; i < coordsArray.length; ++i) {
            IHex iHex3 = iGame.getBoard().getHex(coordsArray[i]);
            int n3 = entity.elevationOccupied(iHex3) - entity.elevationOccupied(iHex);
            if (n3 <= entity.getMaxElevationChange()) continue;
            return false;
        }
        Entity entity2 = Compute.stackingViolation(iGame, n, coords2);
        if (entity2 != null) {
            return Compute.isValidDisplacement(iGame, entity2.getId(), entity2.getPosition(), n2);
        }
        return true;
    }

    public static Coords getValidDisplacement(IGame iGame, int n, Coords coords, int n2) {
        int[] nArray = new int[]{0, 1, 5, 2, 4, 3};
        for (int i = 0; i < nArray.length; ++i) {
            Coords coords2 = coords.translated((n2 + nArray[i]) % 6);
            if (!Compute.isValidDisplacement(iGame, n, coords, coords2)) continue;
            return coords2;
        }
        return null;
    }

    public static Coords getPreferredDisplacement(IGame iGame, int n, Coords coords, int n2) {
        Entity entity = iGame.getEntity(n);
        int n3 = Integer.MIN_VALUE;
        Coords coords2 = null;
        int[] nArray = new int[]{0, 1, 5, 2, 4, 3};
        for (int i = 0; i < nArray.length; ++i) {
            Coords coords3 = coords.translated((n2 + nArray[i]) % 6);
            if (!Compute.isValidDisplacement(iGame, n, coords, coords3) || !iGame.getBoard().contains(coords3)) continue;
            IHex iHex = iGame.getBoard().getHex(coords3);
            int n4 = entity.elevationOccupied(iHex);
            if (n4 > n3) {
                n3 = n4;
                coords2 = coords3;
            }
            if (n4 != entity.getElevation()) continue;
            return coords3;
        }
        return coords2;
    }

    public static Coords getMissedChargeDisplacement(IGame iGame, int n, Coords coords, int n2) {
        Coords coords2 = coords.translated((n2 + 1) % 6);
        Coords coords3 = coords.translated((n2 + 5) % 6);
        IHex iHex = iGame.getBoard().getHex(coords2);
        IHex iHex2 = iGame.getBoard().getHex(coords3);
        Entity entity = iGame.getEntity(n);
        if (iHex != null && iHex2 != null && entity.elevationOccupied(iHex) <= entity.elevationOccupied(iHex2)) {
            if (entity.elevationOccupied(iHex) < entity.elevationOccupied(iHex2)) {
                Coords coords4 = coords2;
                coords2 = coords3;
                coords3 = coords4;
            } else if (Compute.d6() > 3) {
                Coords coords5 = coords2;
                coords2 = coords3;
                coords3 = coords5;
            }
        }
        if (Compute.isValidDisplacement(iGame, n, coords, coords.direction(coords2)) && iGame.getBoard().contains(coords2)) {
            return coords2;
        }
        if (Compute.isValidDisplacement(iGame, n, coords, coords.direction(coords3)) && iGame.getBoard().contains(coords3)) {
            return coords3;
        }
        return coords;
    }

    public static Entity findSpotter(IGame iGame, Entity entity, Targetable targetable) {
        Entity entity2 = null;
        ToHitData toHitData = new ToHitData(Integer.MAX_VALUE, "");
        Enumeration enumeration = iGame.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity3 = (Entity)enumeration.nextElement();
            if (!entity3.isSpotting() || entity.isEnemyOf(entity3)) continue;
            LosEffects losEffects = LosEffects.calculateLos(iGame, entity3.getId(), targetable);
            ToHitData toHitData2 = losEffects.losModifiers(iGame);
            losEffects.setTargetCover(0);
            toHitData2.append(Compute.getAttackerMovementModifier(iGame, entity3.getId()));
            if (entity2 != null && toHitData2.getValue() >= toHitData.getValue()) continue;
            entity2 = entity3;
            toHitData = toHitData2;
        }
        return entity2;
    }

    public static ToHitData getImmobileMod(Targetable targetable) {
        return Compute.getImmobileMod(targetable, -1, 0);
    }

    public static ToHitData getImmobileMod(Targetable targetable, int n, int n2) {
        if (targetable.isImmobile()) {
            if (n == 0 && n2 == 1) {
                return new ToHitData(3, "aiming at head");
            }
            return new ToHitData(-4, "target immobile");
        }
        return null;
    }

    public static ToHitData getRangeMods(IGame iGame, Entity entity, int n, Targetable targetable) {
        TargetRoll targetRoll;
        int n2;
        int n3;
        int n4;
        boolean bl;
        Object object;
        Mounted mounted = entity.getEquipment(n);
        WeaponType weaponType = (WeaponType)mounted.getType();
        int[] nArray = weaponType.getRanges();
        boolean bl2 = entity instanceof Infantry;
        boolean bl3 = weaponType.hasFlag(2048);
        boolean bl4 = bl3 && weaponType.getAmmoType() == 7;
        boolean bl5 = (weaponType.getAmmoType() == 7 || weaponType.getAmmoType() == 8) && mounted.curMode().equals("Indirect");
        boolean bl6 = iGame.getOptions().booleanOption("maxtech_range");
        ToHitData toHitData = new ToHitData();
        if (weaponType.getAmmoType() == 29) {
            object = (AmmoType)mounted.getLinked().getType();
            if (((AmmoType)object).getAmmoType() == 29 && ((AmmoType)object).getMunitionType() == 32L) {
                nArray = new int[]{4, 9, 18, 27, 36};
            } else if (((AmmoType)object).getAmmoType() == 29 && ((AmmoType)object).getMunitionType() == 64L) {
                nArray = new int[]{0, 3, 6, 9, 12};
            }
        }
        if (weaponType.getName().equals("Particle Cannon") && iGame.getOptions().booleanOption("maxtech_ppc_inhibitors") && mounted.curMode().equals("Field Inhibitor OFF")) {
            nArray[0] = 0;
        }
        object = iGame.getBoard().getHex(entity.getPosition());
        IHex iHex = iGame.getBoard().getHex(targetable.getPosition());
        int n5 = 0;
        int n6 = 0;
        if (targetable != null) {
            n5 = targetable.absHeight();
            n6 = targetable.getElevation();
        }
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = bl = entity.getLocationStatus(mounted.getLocation()) == 2;
        if (iHex.containsTerrain(4) && n6 < 0) {
            if (n5 >= 0) {
                bl7 = true;
            } else {
                bl8 = true;
            }
        }
        Entity entity2 = null;
        if (targetable instanceof Entity) {
            entity2 = (Entity)targetable;
            if (n6 == 0 && UnitType.determineUnitTypeCode(entity2) == 5) {
                bl7 = true;
            }
        }
        if ((bl8 || weaponType.getAmmoType() == 8 || weaponType.getAmmoType() == 10) && UnitType.determineUnitTypeCode(entity) == 5) {
            bl = true;
            nArray = weaponType.getWRanges();
        }
        if (iHex.containsTerrain(4) && targetable.getTargetType() == 1) {
            bl7 = true;
        }
        if (bl) {
            nArray = weaponType.getWRanges();
            if (nArray[1] == 0) {
                return new ToHitData(Integer.MAX_VALUE, "Weapon cannot fire underwater.");
            }
            if (!bl8 && !bl7) {
                return new ToHitData(Integer.MAX_VALUE, "Weapon underwater, but not target.");
            }
            if (entity2 != null && UnitType.determineUnitTypeCode(entity2) == 5 && entity instanceof Mech && entity.height() > 0 && entity.getElevation() == -1) {
                return new ToHitData(Integer.MAX_VALUE, "Partially submerged mech cannot fire leg weapons at surface naval vessels.");
            }
        } else {
            if (bl8) {
                return new ToHitData(Integer.MAX_VALUE, "Target underwater, but not weapon.");
            }
            if (weaponType.getAmmoType() == 8 || weaponType.getAmmoType() == 10) {
                return new ToHitData(Integer.MAX_VALUE, "Weapon can only fire underwater.");
            }
        }
        if ((n4 = RangeType.rangeBracket(n3 = Compute.effectiveDistance(iGame, entity, targetable), nArray, bl6)) == Integer.MAX_VALUE) {
            return new ToHitData(0x7FFFFFFE, "Target out of range");
        }
        if (n3 == 0 && !bl2) {
            return new ToHitData(0x7FFFFFFE, "Only infantry shoot at zero range");
        }
        Entity entity3 = Compute.findC3Spotter(iGame, entity, targetable);
        if (bl5) {
            entity3 = entity;
        }
        if (bl5 && iGame.getOptions().booleanOption("indirect_fire") && !iGame.getOptions().booleanOption("indirect_always_possible") && LosEffects.calculateLos(iGame, entity.getId(), targetable).canSee()) {
            return new ToHitData(Integer.MAX_VALUE, "Indirect fire impossible with direct LOS");
        }
        int n7 = Compute.effectiveDistance(iGame, entity3, targetable);
        int n8 = RangeType.rangeBracket(n7, nArray, bl6);
        int n9 = Math.min(n4, n8);
        String string = "";
        if (entity.getTargSysType() == 2 && entity.getTargSysType() == 3) {
            string = " (w/" + MiscType.getTargetSysName(entity.getTargSysType()) + ")";
        }
        if (n9 == n4) {
            if ((n4 == 1 || n4 == 0) && entity.getShortRangeModifier() != 0) {
                toHitData.addModifier(entity.getShortRangeModifier(), "short range" + string);
            } else if (n4 == 2) {
                toHitData.addModifier(entity.getMediumRangeModifier(), "medium range");
            } else if (n4 == 3) {
                if (entity instanceof Protomech && 2 == ((Protomech)entity).getCritsHit(0)) {
                    toHitData.addModifier(Integer.MAX_VALUE, "No long range attacks with destroyed head sensors.");
                } else {
                    toHitData.addModifier(entity.getLongRangeModifier(), "long range" + string);
                }
            } else if (n4 == 4) {
                if (entity instanceof Protomech && 2 == ((Protomech)entity).getCritsHit(0)) {
                    toHitData.addModifier(Integer.MAX_VALUE, "No extreme range attacks with destroyed head sensors.");
                } else {
                    toHitData.addModifier(entity.getExtremeRangeModifier(), "extreme range" + string);
                }
            }
        } else if (n8 == 1 || n4 == 0) {
            toHitData.addModifier(entity.getShortRangeModifier(), "short range due to C3 spotter" + string);
        } else if (n8 == 2) {
            toHitData.addModifier(entity.getMediumRangeModifier(), "medium range due to C3 spotter" + string);
        } else if (n8 == 3) {
            toHitData.addModifier(entity.getLongRangeModifier(), "long range due to C3 spotter" + string);
        }
        if (bl4 && n3 == nArray[3]) {
            toHitData.addModifier(1, "infantry LRM maximum range");
        }
        if (bl3 && n3 == 0) {
            if (weaponType.hasFlag(2)) {
                toHitData.addModifier(-1, "infantry flamer assault");
            } else if (weaponType.getAmmoType() == 9) {
                toHitData.addModifier(-1, "infantry SRM assault");
            } else if (weaponType.getAmmoType() != 7) {
                toHitData.addModifier(-2, "infantry assault");
            }
        }
        if ((n2 = nArray[0]) > 0 && n3 <= n2) {
            int n10 = n2 - n3 + 1;
            if (bl4) {
                toHitData.addModifier(n10 * 2, "infantry LRM minimum range");
            } else {
                toHitData.addModifier(n10, "minimum range");
            }
        }
        if (targetable instanceof Entity && (targetRoll = ((Entity)targetable).getStealthModifier(n9)).getValue() != 0) {
            toHitData.append(((Entity)targetable).getStealthModifier(n9));
        }
        return toHitData;
    }

    public static int effectiveDistance(IGame iGame, Entity entity, Targetable targetable) {
        int n = entity.getPosition().distance(targetable.getPosition());
        if (Compute.isInSameBuilding(iGame, entity, targetable)) {
            int n2 = entity.getElevation();
            int n3 = targetable.getElevation();
            n += Math.abs(n2 - n3);
        }
        return n;
    }

    private static Entity findC3Spotter(IGame iGame, Entity entity, Targetable targetable) {
        if (!entity.hasC3() && !entity.hasC3i()) {
            return entity;
        }
        Entity entity2 = entity;
        int n = entity.getPosition().distance(targetable.getPosition());
        Enumeration enumeration = iGame.getEntities();
        while (enumeration.hasMoreElements()) {
            int n2;
            Entity entity3 = (Entity)enumeration.nextElement();
            if (entity.equals(entity3) || !entity3.isActive() || !entity.onSameC3NetworkAs(entity3) || !Compute.canSee(iGame, entity3, targetable) || (n2 = Compute.effectiveDistance(iGame, entity3, targetable)) >= n) continue;
            n = n2;
            entity2 = entity3;
        }
        return entity2;
    }

    public static ToHitData getProneMods(IGame iGame, Entity entity, int n) {
        if (!entity.isProne()) {
            return null;
        }
        ToHitData toHitData = new ToHitData();
        Mounted mounted = entity.getEquipment(n);
        if (entity.entityIsQuad()) {
            int n2 = ((Mech)entity).countBadLegs();
            if (n2 == 0) {
                return null;
            }
            if (n2 >= 3) {
                return new ToHitData(Integer.MAX_VALUE, "Prone with three or more legs destroyed.");
            }
            if (entity.isLocationBad(4) && entity.isLocationBad(5)) {
                return new ToHitData(Integer.MAX_VALUE, "Prone with both front legs destroyed.");
            }
            if (mounted.getLocation() == 4 || mounted.getLocation() == 5) {
                int n3;
                int n4 = n3 = mounted.getLocation() == 4 ? 5 : 4;
                if (Compute.isFiringFromArmAlready(iGame, n, entity, n3)) {
                    return new ToHitData(Integer.MAX_VALUE, "Prone and firing from other front leg already.");
                }
            }
            if (mounted.getLocation() == 7 || mounted.getLocation() == 6) {
                return new ToHitData(Integer.MAX_VALUE, "Can't fire rear leg-mounted weapons while prone with destroyed legs.");
            }
            toHitData.addModifier(2, "attacker prone");
        } else {
            int n5 = -1;
            if (entity.isLocationBad(4) || entity.isLocationBad(5)) {
                if (iGame.getOptions().booleanOption("maxtech_prone_fire")) {
                    if (entity.isLocationBad(4) && entity.isLocationBad(5)) {
                        return new ToHitData(Integer.MAX_VALUE, "Prone with both arms destroyed.");
                    }
                    n5 = entity.isLocationBad(4) ? 5 : 4;
                } else {
                    return new ToHitData(Integer.MAX_VALUE, "Prone with one or both arms destroyed.");
                }
            }
            if (mounted.getLocation() == 4 || mounted.getLocation() == 5) {
                int n6;
                if (n5 == mounted.getLocation()) {
                    return new ToHitData(Integer.MAX_VALUE, "Prone and propping up with this arm.");
                }
                int n7 = n6 = mounted.getLocation() == 4 ? 5 : 4;
                if (Compute.isFiringFromArmAlready(iGame, n, entity, n6)) {
                    return new ToHitData(Integer.MAX_VALUE, "Prone and firing from other arm already.");
                }
            }
            if (mounted.getLocation() == 7 || mounted.getLocation() == 6) {
                return new ToHitData(Integer.MAX_VALUE, "Can't fire leg-mounted weapons while prone.");
            }
            toHitData.addModifier(2, "attacker prone");
            if (n5 != -1) {
                toHitData.addModifier(1, "attacker propping on single arm");
            }
        }
        return toHitData;
    }

    private static boolean isFiringFromArmAlready(IGame iGame, int n, Entity entity, int n2) {
        Enumeration enumeration = iGame.getActions();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof WeaponAttackAction)) continue;
            WeaponAttackAction weaponAttackAction = (WeaponAttackAction)e;
            if (weaponAttackAction.getEntityId() == entity.getId() && weaponAttackAction.getWeaponId() == n) break;
            if (weaponAttackAction.getEntityId() != entity.getId() || entity.getEquipment(weaponAttackAction.getWeaponId()).getLocation() != n2) continue;
            return true;
        }
        return false;
    }

    public static ToHitData getDamageWeaponMods(Entity entity, Mounted mounted) {
        int n;
        ToHitData toHitData = new ToHitData();
        if (entity instanceof Protomech) {
            n = ((Protomech)entity).getCritsHit(0);
            if (n > 0) {
                toHitData.addModifier(n, n + " head critical(s)");
            }
            switch (mounted.getLocation()) {
                case 2: 
                case 3: {
                    n = ((Protomech)entity).getCritsHit(mounted.getLocation());
                    if (n <= 0) break;
                    toHitData.addModifier(n, n + " arm critical(s)");
                    break;
                }
                case 5: {
                    n = ((Protomech)entity).getCritsHit(3);
                    if (4 == (n += ((Protomech)entity).getCritsHit(2))) {
                        toHitData.addModifier(Integer.MAX_VALUE, "Cannot fire main gun with no arms.");
                        break;
                    }
                    if (n <= 0) break;
                    toHitData.addModifier(n, n + " arm critical(s)");
                }
            }
        } else if (entity.getBadCriticals(0, 7, mounted.getLocation()) > 0) {
            toHitData.addModifier(4, "shoulder actuator destroyed");
        } else {
            n = 0;
            if (entity.getBadCriticals(0, 8, mounted.getLocation()) > 0) {
                ++n;
            }
            if (entity.getBadCriticals(0, 9, mounted.getLocation()) > 0) {
                ++n;
            }
            if (n > 0) {
                toHitData.addModifier(n, n + " destroyed arm actuators");
            }
        }
        n = entity.getBadCriticals(0, 1, 0);
        if (n > 0) {
            toHitData.addModifier(2, "attacker sensors damaged");
        }
        return toHitData;
    }

    public static ToHitData getSecondaryTargetMod(IGame iGame, Entity entity, Targetable targetable) {
        return Compute.getSecondaryTargetMod(iGame, entity, targetable, false);
    }

    public static ToHitData getSecondaryTargetMod(IGame iGame, Entity entity, Targetable targetable, boolean bl) {
        boolean bl2 = Compute.isInArc(entity.getPosition(), entity.getSecondaryFacing(), targetable.getPosition(), 1);
        int n = -1;
        Enumeration enumeration = iGame.getActions();
        while (enumeration.hasMoreElements()) {
            Targetable targetable2;
            WeaponAttackAction weaponAttackAction;
            Object e = enumeration.nextElement();
            if (!(e instanceof WeaponAttackAction) || (weaponAttackAction = (WeaponAttackAction)e).getEntityId() != entity.getId() || (targetable2 = iGame.getTarget(weaponAttackAction.getTargetType(), weaponAttackAction.getTargetId())) == null) continue;
            if (targetable2 instanceof Mech && ((Entity)targetable2).isStealthActive() && targetable2 != targetable && !bl) {
                return new ToHitData(Integer.MAX_VALUE, "When targeting a stealthed Mech, can not attack secondary targets");
            }
            if (Compute.isInArc(entity.getPosition(), entity.getSecondaryFacing(), targetable2.getPosition(), 1)) {
                n = weaponAttackAction.getTargetId();
                break;
            }
            if (n != -1 || bl2) continue;
            n = weaponAttackAction.getTargetId();
        }
        if (n == -1 || n == targetable.getTargetId()) {
            return null;
        }
        if (entity instanceof Infantry) {
            return new ToHitData(Integer.MAX_VALUE, "Can't have multiple targets.");
        }
        if (targetable instanceof Entity && ((Entity)targetable).isStealthActive()) {
            return new ToHitData(Integer.MAX_VALUE, "Can't target Mech with active stealth armor as secondary target");
        }
        if (bl2) {
            return new ToHitData(1, "secondary target modifier");
        }
        return new ToHitData(2, "secondary target modifier");
    }

    public static int getAffaDamageFor(Entity entity) {
        return (int)entity.getWeight() / 10;
    }

    public static ToHitData getAttackerMovementModifier(IGame iGame, int n) {
        return Compute.getAttackerMovementModifier(iGame, n, iGame.getEntity((int)n).moved);
    }

    public static ToHitData getAttackerMovementModifier(IGame iGame, int n, int n2) {
        Entity entity = iGame.getEntity(n);
        ToHitData toHitData = new ToHitData();
        if (entity instanceof Infantry) {
            if (n2 == 4 || n2 == 5) {
                toHitData.addModifier(3, "attacker flew");
            }
            return toHitData;
        }
        if (n2 == 1 || n2 == 4) {
            toHitData.addModifier(1, "attacker walked");
        } else if (n2 == 2 || n2 == 5 || n2 == -2) {
            toHitData.addModifier(2, "attacker ran");
        } else if (n2 == 3) {
            toHitData.addModifier(3, "attacker jumped");
        }
        return toHitData;
    }

    public static ToHitData getSpotterMovementModifier(IGame iGame, int n) {
        return Compute.getSpotterMovementModifier(iGame, n, iGame.getEntity((int)n).moved);
    }

    public static ToHitData getSpotterMovementModifier(IGame iGame, int n, int n2) {
        Entity entity = iGame.getEntity(n);
        ToHitData toHitData = new ToHitData();
        if (n2 == 1 || n2 == 4) {
            toHitData.addModifier(1, "spotter walked");
        } else if (n2 == 2 || n2 == 5 || n2 == -2) {
            toHitData.addModifier(2, "spotter ran");
        } else if (n2 == 3) {
            toHitData.addModifier(3, "spotter jumped");
        }
        return toHitData;
    }

    public static void modifyPhysicalBTHForAdvantages(Entity entity, Entity entity2, ToHitData toHitData, IGame iGame) {
        if (entity.getCrew().getOptions().booleanOption("melee_specialist") && entity instanceof Mech && Compute.getTargetMovementModifier(iGame, entity2.getId()).getValue() > 0) {
            toHitData.addModifier(-1, "melee specialist");
        }
        if (entity2 != null && entity2 instanceof Mech && entity2.getCrew().getOptions().booleanOption("dodge_maneuver") && entity2.dodging) {
            toHitData.addModifier(2, "target is dodging");
        }
    }

    public static ToHitData getTargetMovementModifier(IGame iGame, int n) {
        Entity entity = iGame.getEntity(n);
        ToHitData toHitData = Compute.getTargetMovementModifier(entity.delta_distance, entity.moved == 3 || entity.moved == 5 || entity.moved == 4, iGame.getOptions().booleanOption("maxtech_target_modifiers"), entity.moved == 5 || entity.moved == 4 || entity.getMovementMode() == 6);
        if (entity.moved == -2) {
            toHitData.addModifier(2, "target skidded");
        }
        return toHitData;
    }

    public static ToHitData getTargetMovementModifier(int n, boolean bl, boolean bl2, boolean bl3) {
        ToHitData toHitData = new ToHitData();
        if (!bl2) {
            if (n >= 3 && n <= 4) {
                toHitData.addModifier(1, "target moved 3-4 hexes");
            } else if (n >= 5 && n <= 6) {
                toHitData.addModifier(2, "target moved 5-6 hexes");
            } else if (n >= 7 && n <= 9) {
                toHitData.addModifier(3, "target moved 7-9 hexes");
            } else if (n >= 10) {
                toHitData.addModifier(4, "target moved 10+ hexes");
            }
        } else if (n >= 3 && n <= 4) {
            toHitData.addModifier(1, "target moved 3-4 hexes");
        } else if (n >= 5 && n <= 6) {
            toHitData.addModifier(2, "target moved 5-6 hexes");
        } else if (n >= 7 && n <= 9) {
            toHitData.addModifier(3, "target moved 7-9 hexes");
        } else if (n >= 10 && n <= 13) {
            toHitData.addModifier(4, "target moved 10-13 hexes");
        } else if (n >= 14 && n <= 18) {
            toHitData.addModifier(5, "target moved 14-18 hexes");
        } else if (n >= 19 && n <= 24) {
            toHitData.addModifier(6, "target moved 19-24 hexes");
        } else if (n >= 25) {
            toHitData.addModifier(7, "target moved 25+ hexes");
        }
        if (bl) {
            if (bl3) {
                toHitData.addModifier(1, "target VTOL used MPs");
            } else {
                toHitData.addModifier(1, "target jumped");
            }
        }
        return toHitData;
    }

    public static ToHitData getAttackerTerrainModifier(IGame iGame, int n) {
        Entity entity = iGame.getEntity(n);
        IHex iHex = iGame.getBoard().getHex(entity.getPosition());
        ToHitData toHitData = new ToHitData();
        if (iHex.terrainLevel(4) > 0 && entity.getElevation() < 0 && entity instanceof Mech) {
            toHitData.addModifier(1, "attacker in water");
        }
        return toHitData;
    }

    public static ToHitData getTargetTerrainModifier(IGame iGame, Targetable targetable) {
        return Compute.getTargetTerrainModifier(iGame, targetable, 0);
    }

    public static ToHitData getTargetTerrainModifier(IGame iGame, Targetable targetable, int n) {
        Entity entity = null;
        IHex iHex = iGame.getBoard().getHex(targetable.getPosition());
        if (targetable.getTargetType() == 0) {
            entity = (Entity)targetable;
            if (iHex == null) {
                entity.setPosition(iGame.getEntity(entity.getId()).getPosition());
                iHex = iGame.getBoard().getHex(iGame.getEntity(entity.getId()).getPosition());
            }
        }
        boolean bl = entity != null && iHex != null && entity.absHeight() >= 2;
        ToHitData toHitData = new ToHitData();
        int n2 = iHex.terrainLevel(1);
        int n3 = iHex.terrainLevel(23);
        String string = "woods";
        if (n2 < n3) {
            n2 = n3;
            string = "jungle";
        }
        if (n2 == 1) {
            string = "target in light " + string;
        } else if (n2 == 2) {
            string = "target in heavy " + string;
        } else if (n2 == 3) {
            string = "target in ultra heavy " + string;
        }
        if (!iGame.getOptions().booleanOption("maxtech_fire")) {
            if (iHex.containsTerrain(8)) {
                if (n > 0) {
                    toHitData.addModifier(1, "target in smoke");
                } else {
                    toHitData.addModifier(2, "target in smoke");
                }
            } else if (iHex.terrainLevel(22) == 2) {
                if (n > 0) {
                    toHitData.addModifier(1, "target in erupting geyser");
                } else {
                    toHitData.addModifier(2, "target in erupting geyser");
                }
            } else if (!bl && targetable.getTargetType() != 1 && targetable.getTargetType() != 2 && targetable.getTargetType() != 14 && targetable.getTargetType() != 7 && targetable.getTargetType() != 8 && targetable.getTargetType() != 9 && targetable.getTargetType() != 10 && targetable.getTargetType() != 6) {
                if (n2 == 1 && n != 2) {
                    toHitData.addModifier(1, string);
                } else if (n2 > 1) {
                    if (n > 0) {
                        toHitData.addModifier(n2 - 1, string);
                    } else {
                        toHitData.addModifier(n2, string);
                    }
                }
            }
        } else {
            if (iHex.terrainLevel(8) == 1) {
                toHitData.addModifier(1, "target in light smoke");
            } else if (iHex.terrainLevel(8) > 1) {
                if (n > 0) {
                    toHitData.addModifier(1, "target in heavy smoke");
                } else {
                    toHitData.addModifier(2, "target in heavy smoke");
                }
            }
            if (iHex.terrainLevel(22) == 2) {
                if (n > 0) {
                    toHitData.addModifier(1, "target in erupting geyser");
                } else {
                    toHitData.addModifier(2, "target in erupting geyser");
                }
            }
            if (!bl && targetable.getTargetType() != 1 && targetable.getTargetType() != 2 && targetable.getTargetType() != 14 && targetable.getTargetType() != 7 && targetable.getTargetType() != 8 && targetable.getTargetType() != 9 && targetable.getTargetType() != 10 && targetable.getTargetType() != 6) {
                if (n2 == 1 && n != 2) {
                    toHitData.addModifier(1, string);
                } else if (n2 > 1) {
                    if (n > 0) {
                        toHitData.addModifier(n2 - 1, string);
                    } else {
                        toHitData.addModifier(n2, string);
                    }
                }
            }
        }
        if (entity == null) {
            return toHitData;
        }
        if (entity.isMakingDfa()) {
            return toHitData;
        }
        if (iHex.containsTerrain(21) && entity instanceof Infantry) {
            toHitData.addModifier(2, "infantry dug in");
        }
        if (iHex.terrainLevel(4) > 0 && entity.getElevation() < 0 && entity instanceof Mech) {
            toHitData.addModifier(-1, "target in water");
        }
        if (entity.isStuck()) {
            toHitData.addModifier(-2, "target stuck in swamp");
        }
        return toHitData;
    }

    public static WeaponAttackAction getHighestExpectedDamage(IGame iGame, Vector vector) {
        float f = -1.0f;
        WeaponAttackAction weaponAttackAction = null;
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            WeaponAttackAction weaponAttackAction2 = (WeaponAttackAction)vector.elementAt(i);
            float f2 = Compute.getExpectedDamage(iGame, weaponAttackAction2);
            if (!(f2 > f)) continue;
            f = f2;
            weaponAttackAction = weaponAttackAction2;
        }
        return weaponAttackAction;
    }

    public static float getExpectedDamage(IGame iGame, WeaponAttackAction weaponAttackAction) {
        IHex iHex;
        boolean bl = false;
        AmmoType ammoType = new AmmoType();
        Entity entity = iGame.getEntity(weaponAttackAction.getEntityId());
        Infantry infantry = new Infantry();
        BattleArmor battleArmor = new BattleArmor();
        Mounted mounted = entity.getEquipment(weaponAttackAction.getWeaponId());
        ToHitData toHitData = weaponAttackAction.toHit(iGame);
        if (entity instanceof BattleArmor) {
            battleArmor = (BattleArmor)iGame.getEntity(weaponAttackAction.getEntityId());
        }
        if (entity instanceof Infantry && !(entity instanceof BattleArmor)) {
            infantry = (Infantry)iGame.getEntity(weaponAttackAction.getEntityId());
        }
        float f = 0.0f;
        WeaponType weaponType = (WeaponType)mounted.getType();
        if (toHitData.getValue() == Integer.MAX_VALUE || toHitData.getValue() == 0x7FFFFFFE) {
            return 0.0f;
        }
        float f2 = 0.0f;
        f2 = toHitData.getValue() == Integer.MIN_VALUE ? 1.0f : (float)Compute.oddsAbove(toHitData.getValue()) / 100.0f;
        if (weaponType.getDamage() == -2) {
            bl = true;
        }
        if (!(weaponType.getAmmoType() != 19 && weaponType.getAmmoType() != 33 || (ammoType = (AmmoType)mounted.getLinked().getType()).getAmmoType() != 19 && ammoType.getAmmoType() != 33 || ammoType.getMunitionType() != 1L)) {
            bl = true;
        }
        if (!(weaponType.getAmmoType() != 20 && weaponType.getAmmoType() != 34 && weaponType.getAmmoType() != 23 || mounted.curMode().getName() != "Ultra" && mounted.curMode().getName() != "2-shot" && mounted.curMode().getName() != "4-shot" && mounted.curMode().getName() != "6-shot")) {
            bl = true;
        }
        if (entity instanceof BattleArmor && weaponType.getInternalName() != "SwarmMek" && weaponType.getInternalName() != "LegAttack") {
            bl = true;
        }
        if (bl) {
            Vector vector;
            if (!(entity instanceof BattleArmor) && mounted.getLinked() == null) {
                return 0.0f;
            }
            AmmoType ammoType2 = null;
            if (mounted.getLinked() != null) {
                ammoType2 = (AmmoType)mounted.getLinked().getType();
                f = ammoType2.getDamagePerShot();
            }
            float f3 = 0.0f;
            f3 = weaponType.getRackSize() != 40 && weaponType.getRackSize() != 30 ? expectedHitsByRackSize[weaponType.getRackSize()] : 2.0f * expectedHitsByRackSize[weaponType.getRackSize() / 2];
            if (weaponType.getAmmoType() == 11 || weaponType.getAmmoType() == 32 && !Compute.isAffectedByAngelECM(entity, entity.getPosition(), weaponAttackAction.getTarget(iGame).getPosition())) {
                f3 = weaponType.getRackSize();
            }
            if (weaponType.getAmmoType() == 20 || weaponType.getAmmoType() == 34 || weaponType.getAmmoType() == 23) {
                if (mounted.curMode().getName() == "Ultra" || mounted.curMode().getName() == "2-shot") {
                    f3 = expectedHitsByRackSize[2];
                }
                if (mounted.curMode().getName() == "4-shot") {
                    f3 = expectedHitsByRackSize[4];
                }
                if (mounted.curMode().getName() == "6-shot") {
                    f3 = expectedHitsByRackSize[6];
                }
            }
            if (entity instanceof BattleArmor) {
                f3 = expectedHitsByRackSize[battleArmor.getShootingStrength()];
                if (weaponType.getDamage() == -2) {
                    f3 *= expectedHitsByRackSize[weaponType.getRackSize()];
                }
                if (weaponType.getDamage() != -2) {
                    f = weaponType.getDamage() != -3 ? (float)weaponType.getDamage() : (float)weaponType.getRackSize();
                }
                if (weaponType.hasFlag(8192)) {
                    f3 *= 2.0f;
                }
                if (weaponType.hasFlag(16384)) {
                    f3 *= expectedHitsByRackSize[weaponType.getRackSize()];
                }
            }
            if (!Compute.isAffectedByECM(entity, entity.getPosition(), iGame.getEntity(weaponAttackAction.getTargetId()).getPosition()) && weaponType.getDamage() == -2) {
                Mounted mounted2;
                if (!(weaponType.getAmmoType() != 7 && weaponType.getAmmoType() != 9 || (mounted2 = mounted.getLinkedBy()) == null || !(mounted2.getType() instanceof MiscType) || mounted2.isDestroyed() || mounted2.isMissing() || mounted2.isBreached() || !mounted2.getType().hasFlag(512) || mounted.curMode() != null && mounted.curMode().equals("Indirect") || ammoType2.getMunitionType() != 2048L)) {
                    f3 *= 1.2f;
                }
                if (weaponType.getAmmoType() == 29) {
                    f3 *= 1.2f;
                }
                if ((iGame.getEntity(weaponAttackAction.getTargetId()).isNarcedBy(entity.getOwner().getTeam()) || iGame.getEntity(weaponAttackAction.getTargetId()).isINarcedBy(entity.getOwner().getTeam())) && (ammoType2.getAmmoType() == 7 || ammoType2.getAmmoType() == 9) && ammoType2.getMunitionType() == 1024L) {
                    f3 *= 1.2f;
                }
            }
            if (weaponType.getDamage() == -2 && (vector = weaponAttackAction.getCounterEquipment()) != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    Mounted mounted3 = (Mounted)vector.elementAt(i);
                    if (!(mounted3.getType() instanceof WeaponType) || !mounted3.getType().hasFlag(0x1000000)) continue;
                    float f4 = 3.5f * (float)((WeaponType)mounted3.getType()).getDamage();
                    f3 = Math.max(0.0f, f3 - f4);
                }
            }
            f *= f3;
            if (weaponType.getAmmoType() == 20 || weaponType.getAmmoType() == 34 || weaponType.getAmmoType() == 23) {
                f = f3 * (float)weaponType.getDamage();
            }
        } else {
            f = weaponType.getDamage();
            if (entity.getPosition() != null && iGame.getEntity(weaponAttackAction.getTargetId()).getPosition() != null && weaponType.getAmmoType() == 22) {
                f = 25.0f;
                int n = entity.getPosition().distance(iGame.getEntity(weaponAttackAction.getTargetId()).getPosition());
                if (n > 6) {
                    f = 20.0f;
                }
                if (n > 13) {
                    f = 10.0f;
                }
            }
            if (entity instanceof Infantry) {
                if (weaponType.getInternalName() == "LegAttack") {
                    f = 10.0f;
                }
                if (infantry.isPlatoon()) {
                    f = weaponType.getInternalName() == "SwarmMek" ? (iGame.getEntity(weaponAttackAction.getTargetId()).getSwarmAttackerId() == -1 && iGame.getEntity(weaponAttackAction.getTargetId()) instanceof Mech ? 1.5f * (float)infantry.getDamage(infantry.getShootingStrength()) : 0.0f) : (float)infantry.getDamage(infantry.getShootingStrength());
                } else if (weaponType.getInternalName() == "SwarmMek") {
                    f = iGame.getEntity(weaponAttackAction.getTargetId()).getSwarmAttackerId() == -1 && iGame.getEntity(weaponAttackAction.getTargetId()) instanceof Mech ? 5.0f * (float)battleArmor.getShootingStrength() : 0.0f;
                }
            }
        }
        f *= f2;
        if (!(!(iGame.getEntity(weaponAttackAction.getTargetId()) instanceof Infantry) || iGame.getEntity(weaponAttackAction.getTargetId()) instanceof BattleArmor || (iHex = iGame.getBoard().getHex(iGame.getEntity((int)weaponAttackAction.getTargetId()).getPosition().x, iGame.getEntity((int)weaponAttackAction.getTargetId()).getPosition().y)).containsTerrain(1) || iHex.containsTerrain(23) || iHex.containsTerrain(10))) {
            f *= 2.0f;
        }
        return f;
    }

    public static double getAmmoAdjDamage(IGame iGame, WeaponAttackAction weaponAttackAction) {
        Mounted mounted;
        boolean bl = true;
        boolean bl2 = false;
        int n = 0;
        boolean bl3 = false;
        AmmoType ammoType = new AmmoType();
        AmmoType ammoType2 = new AmmoType();
        WeaponType weaponType = new WeaponType();
        WeaponType weaponType2 = new WeaponType();
        Entity entity = iGame.getEntity(weaponAttackAction.getTargetId());
        Entity entity2 = weaponAttackAction.getEntity(iGame);
        weaponType = (WeaponType)entity2.getEquipment(weaponAttackAction.getWeaponId()).getType();
        double d = 0.0;
        if (weaponType.hasFlag(262144) || weaponType.hasFlag(32768) || weaponType.hasFlag(2048) || weaponType.getAmmoType() == -1) {
            return Compute.getExpectedDamage(iGame, weaponAttackAction);
        }
        Mounted mounted2 = null;
        Mounted mounted3 = null;
        Enumeration enumeration = entity2.getAmmo();
        while (enumeration.hasMoreElements()) {
            mounted = (Mounted)enumeration.nextElement();
            if (!entity2.loadWeapon(entity2.getEquipment(weaponAttackAction.getWeaponId()), mounted) || mounted.getShotsLeft() <= 0 || AmmoType.canDeliverMinefield(ammoType = (AmmoType)mounted.getType())) continue;
            mounted2 = mounted;
            ammoType2 = (AmmoType)mounted2.getType();
            break;
        }
        enumeration = entity2.getAmmo();
        while (enumeration.hasMoreElements()) {
            mounted = (Mounted)enumeration.nextElement();
            if (!entity2.loadWeapon(entity2.getEquipment(weaponAttackAction.getWeaponId()), mounted) || mounted.getShotsLeft() <= 0 || AmmoType.canDeliverMinefield(ammoType = (AmmoType)mounted.getType())) continue;
            ++n;
            bl = false;
            if (ammoType.getMunitionType() == ammoType2.getMunitionType()) continue;
            bl2 = true;
            break;
        }
        if (bl) {
            return 0.0;
        }
        if (!bl2) {
            return Compute.getExpectedDamage(iGame, weaponAttackAction);
        }
        if (bl2) {
            d = 0.0;
            mounted3 = mounted2;
            enumeration = entity2.getAmmo();
            while (enumeration.hasMoreElements()) {
                mounted = (Mounted)enumeration.nextElement();
                if (!entity2.loadWeapon(entity2.getEquipment(weaponAttackAction.getWeaponId()), mounted) || mounted.getShotsLeft() <= 0 || AmmoType.canDeliverMinefield(ammoType = (AmmoType)mounted.getType())) continue;
                entity2.loadWeapon(entity2.getEquipment(weaponAttackAction.getWeaponId()), mounted);
                weaponAttackAction.setAmmoId(entity2.getEquipmentNum(mounted));
                double d2 = Compute.getExpectedDamage(iGame, weaponAttackAction);
                double d3 = 1.0;
                if ((ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 9) && ammoType.getMunitionType() == 128L || ammoType.getAmmoType() == 1 && ammoType.getMunitionType() == 4L) {
                    d3 = 0.0;
                    if (entity instanceof Infantry && !(entity instanceof BattleArmor)) {
                        d3 = 2.0;
                    }
                }
                if ((ammoType.getAmmoType() == 19 || ammoType.getAmmoType() == 33) && ammoType.getMunitionType() == 1L) {
                    if (entity.getArmorRemainingPercent() <= 0.25) {
                        d3 = 1.0 + (double)(weaponType.getRackSize() / 10);
                    }
                    if (entity instanceof Tank) {
                        d3 += 1.0;
                    }
                }
                if (ammoType.getAmmoType() == 1 && ammoType.getMunitionType() == 2L) {
                    if (entity instanceof Mech || entity instanceof Tank) {
                        d3 = 1.0 + (double)(weaponType.getRackSize() / 10);
                    }
                    if (entity instanceof Infantry) {
                        d3 = 0.6;
                    }
                }
                if ((ammoType.getAmmoType() == 9 || ammoType.getAmmoType() == 25) && ammoType.getMunitionType() == 0x400000L) {
                    d3 = 0.5;
                    if (entity instanceof Mech && entity.infernos.getTurnsLeftToBurn() < 4 && entity.heat >= 5) {
                        d3 = 1.1;
                    }
                    if (entity instanceof Tank && !iGame.getOptions().booleanOption("vehicles_safe_from_infernos")) {
                        d3 = 1.1;
                    }
                    if (entity instanceof Protomech && !iGame.getOptions().booleanOption("protos_safe_from_infernos")) {
                        d3 = 1.1;
                    }
                }
                if (weaponType.getAmmoType() == 13 && ammoType.getMunitionType() == 0L) {
                    d2 = !entity.isNarcedBy(entity2.getOwner().getTeam()) && !(entity instanceof Infantry) ? 5.0 : 0.5;
                }
                if (weaponType.getAmmoType() == 31) {
                    if (ammoType.getMunitionType() == 0L && !(entity instanceof Infantry)) {
                        d2 = !entity.isINarcedBy(entity2.getOwner().getTeam()) ? 7.0 : 1.0;
                    }
                    if (ammoType.getAmmoType() == 31 && ammoType.getMunitionType() == 0x2000000L && !(entity instanceof Infantry) && !entity.isINarcedWith(0x2000000L)) {
                        d2 = entity.getC3MasterId() != -1 || entity.hasC3M() || entity.hasC3MM() || entity.hasC3i() ? 8.0 : 0.5;
                        Enumeration enumeration2 = entity.getWeapons();
                        while (enumeration2.hasMoreElements()) {
                            weaponType2 = (WeaponType)((Mounted)enumeration2.nextElement()).getType();
                            if (weaponType2.getAmmoType() != 7 && weaponType2.getAmmoType() != 9) continue;
                            d2 += (double)(weaponType2.getRackSize() / 2);
                        }
                    }
                    if (ammoType.getAmmoType() == 31 && ammoType.getMunitionType() == 0x8000000L && !(entity instanceof Infantry)) {
                        d2 = !entity.isINarcedWith(0x8000000L) ? (double)(entity.getOriginalWalkMP() + entity.getOriginalJumpMP()) / 2.0 : 0.5;
                    }
                }
                if (!(d2 * d3 > d)) continue;
                d = d2 * d3;
                mounted3 = mounted;
            }
            entity2.loadWeapon(entity2.getEquipment(weaponAttackAction.getWeaponId()), mounted3);
            weaponAttackAction.setAmmoId(entity2.getEquipmentNum(mounted3));
        }
        return d;
    }

    public static int spinUpCannon(IGame iGame, WeaponAttackAction weaponAttackAction) {
        int n = 12;
        WeaponType weaponType = new WeaponType();
        Entity entity = weaponAttackAction.getEntity(iGame);
        Mounted mounted = entity.getEquipment(weaponAttackAction.getWeaponId());
        weaponType = (WeaponType)entity.getEquipment(weaponAttackAction.getWeaponId()).getType();
        if (weaponType.getAmmoType() != 20 && weaponType.getAmmoType() != 34 && weaponType.getAmmoType() != 23) {
            return 0;
        }
        n = weaponAttackAction.toHit(iGame).getValue();
        mounted.setMode("Single");
        int n2 = 0;
        if (n == Integer.MAX_VALUE || n == 0x7FFFFFFE) {
            return n2;
        }
        int n3 = Compute.d6(2);
        if (n3 >= n + 1) {
            n2 = 1;
            if (weaponType.getAmmoType() == 20 || weaponType.getAmmoType() == 34) {
                mounted.setMode("Ultra");
            }
            if (weaponType.getAmmoType() == 23) {
                mounted.setMode("2-shot");
            }
        }
        if (weaponType.getAmmoType() == 23) {
            if (n3 >= n + 2) {
                n2 = 2;
                mounted.setMode("4-shot");
            }
            if (n3 >= n + 3) {
                n2 = 3;
                mounted.setMode("6-shot");
            }
        }
        return n2;
    }

    public static boolean isInArc(IGame iGame, int n, int n2, Targetable targetable) {
        Entity entity = iGame.getEntity(n);
        int n3 = entity.isSecondaryArcWeapon(n2) ? entity.getSecondaryFacing() : entity.getFacing();
        return Compute.isInArc(entity.getPosition(), n3, targetable.getPosition(), entity.getWeaponArc(n2));
    }

    public static boolean isThroughFrontHex(IGame iGame, int n, Entity entity) {
        Entity entity2 = iGame.getEntity(n);
        Coords coords = entity2.getPosition();
        Coords coords2 = entity.getPosition();
        int n2 = coords2.degree(coords) - entity.getFacing() * 60;
        if (n2 < 0) {
            n2 += 360;
        }
        return n2 > 330 || n2 < 30;
    }

    public static boolean isInArc(Coords coords, int n, Coords coords2, int n2) {
        int n3 = coords.degree(coords2) - n * 60;
        if (n3 < 0) {
            n3 += 360;
        }
        switch (n2) {
            case 1: {
                return n3 >= 300 || n3 <= 60;
            }
            case 3: {
                return n3 >= 300 || n3 <= 120;
            }
            case 2: {
                return n3 >= 240 || n3 <= 60;
            }
            case 4: {
                return n3 > 120 && n3 < 240;
            }
            case 6: {
                return n3 > 60 && n3 <= 120;
            }
            case 5: {
                return n3 < 300 && n3 >= 240;
            }
            case 7: {
                return n3 >= 240 || n3 <= 120;
            }
            case 0: {
                return true;
            }
        }
        return false;
    }

    public static boolean canSee(IGame iGame, Entity entity, Targetable targetable) {
        Entity entity2;
        if (targetable.getTargetType() == 0 && (entity2 = (Entity)targetable).isOffBoard()) {
            return false;
        }
        return LosEffects.calculateLos(iGame, entity.getId(), targetable).canSee() && entity.getCrew().isActive();
    }

    public static int targetSideTable(Entity entity, Targetable targetable) {
        return targetable.sideTable(entity.getPosition());
    }

    public static Mounted clubMechHas(Entity entity) {
        Enumeration enumeration = entity.getMisc();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (!mounted.getType().hasFlag(0x8000000)) continue;
            return mounted;
        }
        return null;
    }

    public static int missilesHit(int n) {
        return Compute.missilesHit(n, 0);
    }

    public static int missilesHit(int n, int n2, boolean bl) {
        int n3 = Compute.d6(2) + n2;
        int n4 = bl ? 1 : 2;
        n3 = Math.min(Math.max(n3, n4), 12);
        if (bl && n3 == 1) {
            return 1;
        }
        if (n3 < 2) {
            n3 = 2;
        }
        int[][] nArrayArray = new int[][]{{2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2}, {3, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3}, {4, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4}, {5, 1, 2, 2, 3, 3, 3, 3, 4, 4, 5, 5}, {6, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6}, {8, 2, 3, 3, 4, 4, 5, 5, 6, 7, 8, 8}, {9, 3, 3, 4, 5, 5, 5, 5, 7, 7, 9, 9}, {10, 3, 3, 4, 6, 6, 6, 6, 8, 8, 10, 10}, {12, 4, 4, 5, 8, 8, 8, 8, 10, 10, 12, 12}, {15, 5, 5, 6, 9, 9, 9, 9, 12, 12, 15, 15}, {20, 6, 6, 9, 12, 12, 12, 12, 16, 16, 20, 20}};
        for (int i = 0; i < nArrayArray.length; ++i) {
            if (nArrayArray[i][0] < n) continue;
            return Math.min(n, nArrayArray[i][n3 - 1]);
        }
        throw new RuntimeException("Could not find number of missles in hit table");
    }

    public static int missilesHit(int n, int n2) {
        return Compute.missilesHit(n, n2, false);
    }

    public static int getConsciousnessNumber(int n) {
        switch (n) {
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 7;
            }
            case 4: {
                return 10;
            }
            case 5: {
                return 11;
            }
        }
        return Integer.MAX_VALUE;
    }

    public static boolean isAffectedByECM(Entity entity, Coords coords, Coords coords2) {
        Object object;
        Object object2;
        Object object3;
        if (coords == null || coords2 == null) {
            return false;
        }
        if (entity.isINarcedWith(2L)) {
            return true;
        }
        Vector<Object> vector = new Vector<Object>(16);
        Vector<Integer> vector2 = new Vector<Integer>(16);
        Coords[] coordsArray = entity.game.getEntities();
        while (coordsArray.hasMoreElements()) {
            Entity entity2 = (Entity)coordsArray.nextElement();
            object3 = entity2.getPosition();
            if (entity2.isEnemyOf(entity) && entity2.hasActiveECM() && object3 != null) {
                vector.addElement(object3);
                vector2.addElement(new Integer(entity2.getECMRange()));
            }
            object2 = entity2.getLoadedUnits();
            object = ((Vector)object2).elements();
            while (object.hasMoreElements()) {
                Entity entity3 = (Entity)object.nextElement();
                if (!entity3.isEnemyOf(entity) || !entity3.hasActiveECM() || object3 == null) continue;
                vector.addElement(object3);
                vector2.addElement(new Integer(entity3.getECMRange()));
            }
        }
        if (vector.size() == 0) {
            return false;
        }
        coordsArray = Coords.intervening(coords, coords2);
        boolean bl = coords.degree(coords2) % 60 == 30;
        object3 = vector2.elements();
        object2 = vector.elements();
        block2: while (object2.hasMoreElements()) {
            object = (Coords)object2.nextElement();
            int n = (Integer)object3.nextElement();
            int n2 = -1;
            for (int i = 0; i < coordsArray.length; ++i) {
                int n3 = ((Coords)object).distance(coordsArray[i]);
                if (n3 <= n) {
                    return true;
                }
                if (bl && i % 3 != 0) continue;
                if (n2 == -1) {
                    n2 = n3;
                    continue;
                }
                if (n3 > n2) continue block2;
            }
        }
        return false;
    }

    public static boolean isAffectedByAngelECM(Entity entity, Coords coords, Coords coords2) {
        Object object;
        if (coords == null || coords2 == null) {
            return false;
        }
        Vector<Object> vector = new Vector<Object>(16);
        Vector<Integer> vector2 = new Vector<Integer>(16);
        for (Object e : entity.game.getEntitiesVector()) {
            object = (Entity)e;
            Coords coords3 = ((Entity)object).getPosition();
            if (((Entity)object).isEnemyOf(entity) && ((Entity)object).hasActiveAngelECM() && coords3 != null) {
                vector.addElement(coords3);
                vector2.addElement(((Entity)object).getAngelECMRange());
            }
            Vector serializable = ((Entity)object).getLoadedUnits();
            for (Entity entity2 : serializable) {
                if (!entity2.isEnemyOf(entity) || !entity2.hasActiveAngelECM() || coords3 == null) continue;
                vector.addElement(coords3);
                vector2.addElement(entity2.getAngelECMRange());
            }
        }
        if (vector.size() == 0) {
            return false;
        }
        Coords[] coordsArray = Coords.intervening(coords, coords2);
        boolean bl = coords.degree(coords2) % 60 == 30;
        object = vector2.elements();
        block2: for (Coords coords3 : vector) {
            int n = (Integer)object.nextElement();
            int n2 = -1;
            for (int i = 0; i < coordsArray.length; ++i) {
                int n3 = coords3.distance(coordsArray[i]);
                if (n3 <= n) {
                    return true;
                }
                if (bl && i % 3 != 0) continue;
                if (n2 == -1) {
                    n2 = n3;
                    continue;
                }
                if (n3 > n2) continue block2;
            }
        }
        return false;
    }

    public static ToHitData getLegAttackBaseToHit(Entity entity, Entity entity2) {
        int n;
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = n = entity.game.getOptions().booleanOption("night_battle") ? 2 : 0;
        if (!(entity2 instanceof Mech)) {
            stringBuffer.append("Defender is not a Mek.");
        } else if (-1 != entity2.getTransportId()) {
            stringBuffer.append("Target is a passenger.");
        } else if (-1 != entity2.getSwarmTargetId()) {
            stringBuffer.append("Target is swarming a Mek.");
        } else if (-1 != entity.getSwarmTargetId()) {
            stringBuffer.append("Attacker is swarming.");
        } else if (entity instanceof BattleArmor) {
            BattleArmor battleArmor = (BattleArmor)entity;
            if (battleArmor.isBurdened()) {
                stringBuffer.append("Launcher not jettisoned.");
            } else {
                n2 = battleArmor.getShootingStrength();
                if (n2 >= 4) {
                    n3 = 4;
                } else if (n2 >= 3) {
                    n3 = 7;
                } else if (n2 >= 2) {
                    n3 = 10;
                } else if (n2 >= 1) {
                    n3 = 12;
                }
                stringBuffer.append(n2);
                stringBuffer.append(" trooper(s) active");
            }
        } else if (entity instanceof Infantry) {
            Infantry infantry = (Infantry)entity;
            n2 = infantry.getShootingStrength();
            if (n2 >= 22) {
                n3 = 4;
            } else if (n2 >= 16) {
                n3 = 7;
            } else if (n2 >= 10) {
                n3 = 10;
            } else if (n2 >= 5) {
                n3 = 12;
            }
            stringBuffer.append(n2);
            stringBuffer.append(" men alive");
        } else {
            stringBuffer.append("Attacker is not infantry.");
        }
        if (n > 0) {
            n3 += n;
            stringBuffer.append("Night Battle, no Spotlights");
        }
        return new ToHitData(n3, stringBuffer.toString(), 2, 0);
    }

    public static ToHitData getSwarmMekBaseToHit(Entity entity, Entity entity2) {
        int n;
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = n = entity.game.getOptions().booleanOption("night_battle") ? 2 : 0;
        if (!(entity2 instanceof Mech)) {
            stringBuffer.append("Defender is not a Mek.");
        } else if (-1 != entity2.getTransportId()) {
            stringBuffer.append("Target is a passenger.");
        } else if (-1 != entity.getSwarmTargetId()) {
            stringBuffer.append("Attacker is swarming.");
        } else if (-1 != entity2.getSwarmAttackerId()) {
            stringBuffer.append("Target is already being swarmed.");
        } else if (-1 != entity2.getSwarmTargetId()) {
            stringBuffer.append("Target is swarming a Mek.");
        } else if (!entity.isEnemyOf(entity2)) {
            stringBuffer.append("Can only swarm an enemy.");
        } else if (entity instanceof BattleArmor) {
            BattleArmor battleArmor = (BattleArmor)entity;
            if (battleArmor.isBurdened()) {
                stringBuffer.append("Launcher not jettisoned.");
            } else {
                n2 = battleArmor.getShootingStrength();
                if (n2 >= 4) {
                    n3 = 7;
                } else if (n2 >= 1) {
                    n3 = 10;
                }
                stringBuffer.append(n2);
                stringBuffer.append(" trooper(s) active");
            }
        } else if (entity instanceof Infantry) {
            Infantry infantry = (Infantry)entity;
            n2 = infantry.getShootingStrength();
            if (n2 >= 22) {
                n3 = 7;
            } else if (n2 >= 16) {
                n3 = 10;
            }
            stringBuffer.append(n2);
            stringBuffer.append(" men alive");
        } else {
            stringBuffer.append("Attacker is not infantry.");
        }
        if (n > 0) {
            n3 += n;
            stringBuffer.append("Night Battle, no Spotlights");
        }
        return new ToHitData(n3, stringBuffer.toString());
    }

    public static int getBattleArmorHits(int n) {
        int n2 = Compute.d6(2);
        if (n == 1) {
            return 1;
        }
        if (n > 5) {
            throw new IllegalArgumentException("shots were greater than 5");
        }
        int[][] nArrayArray = new int[][]{{1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2}, {1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3}, {1, 2, 2, 2, 2, 3, 3, 3, 4, 4, 4}, {1, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5}};
        return nArrayArray[n - 2][n2 - 2];
    }

    public static boolean canPhysicalTarget(IGame iGame, int n, Targetable targetable) {
        boolean bl = false;
        bl |= PunchAttackAction.toHit(iGame, n, targetable, 1).getValue() != Integer.MAX_VALUE;
        bl |= PunchAttackAction.toHit(iGame, n, targetable, 2).getValue() != Integer.MAX_VALUE;
        bl |= KickAttackAction.toHit(iGame, n, targetable, 1).getValue() != Integer.MAX_VALUE;
        bl |= KickAttackAction.toHit(iGame, n, targetable, 2).getValue() != Integer.MAX_VALUE;
        if (iGame.getOptions().booleanOption("maxtech_mulekicks") && iGame.getEntity(n) instanceof QuadMech) {
            bl |= KickAttackAction.toHit(iGame, n, targetable, 3).getValue() != Integer.MAX_VALUE;
            bl |= KickAttackAction.toHit(iGame, n, targetable, 4).getValue() != Integer.MAX_VALUE;
        }
        bl |= BrushOffAttackAction.toHit(iGame, n, targetable, 1).getValue() != Integer.MAX_VALUE;
        bl |= BrushOffAttackAction.toHit(iGame, n, targetable, 2).getValue() != Integer.MAX_VALUE;
        bl |= new ThrashAttackAction(n, targetable).toHit(iGame).getValue() != Integer.MAX_VALUE;
        bl |= ProtomechPhysicalAttackAction.toHit(iGame, n, targetable).getValue() != Integer.MAX_VALUE;
        Mounted mounted = Compute.clubMechHas(iGame.getEntity(n));
        if (null != mounted) {
            bl |= ClubAttackAction.toHit(iGame, n, targetable, mounted).getValue() != Integer.MAX_VALUE;
        }
        return bl |= PushAttackAction.toHit(iGame, n, targetable).getValue() != Integer.MAX_VALUE;
    }

    public static boolean canMoveOnPavement(IGame iGame, Coords coords, Coords coords2) {
        IHex iHex = iGame.getBoard().getHex(coords);
        IHex iHex2 = iGame.getBoard().getHex(coords2);
        int n = coords.direction(coords2);
        int n2 = (n + 3) % 6;
        boolean bl = false;
        if (coords.equals(coords2) && (iHex.containsTerrain(5) || iHex.containsTerrain(6) || iHex.containsTerrain(14))) {
            bl = true;
        } else if (iHex.containsTerrain(5) && (iHex2.containsTerrain(5) || iHex2.containsTerrainExit(6, n2) || iHex2.containsTerrainExit(14, n2))) {
            bl = true;
        } else if (iHex.containsTerrainExit(6, n) || iHex.containsTerrainExit(14, n)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isInSameBuilding(IGame iGame, Entity entity, Targetable targetable) {
        if (!(targetable instanceof Entity)) {
            return false;
        }
        Entity entity2 = (Entity)targetable;
        if (!Compute.isInBuilding(iGame, entity) || !Compute.isInBuilding(iGame, entity2)) {
            return false;
        }
        Building building = iGame.getBoard().getBuildingAt(entity.getPosition());
        Building building2 = iGame.getBoard().getBuildingAt(targetable.getPosition());
        return building.equals(building2);
    }

    public static boolean isInBuilding(IGame iGame, Entity entity) {
        if (iGame == null) {
            return false;
        }
        if (entity == null) {
            return false;
        }
        return Compute.isInBuilding(iGame, entity, entity.getPosition());
    }

    public static boolean isInBuilding(IGame iGame, Entity entity, Coords coords) {
        if (iGame == null) {
            return false;
        }
        if (entity == null) {
            return false;
        }
        if (coords == null) {
            return false;
        }
        IHex iHex = iGame.getBoard().getHex(coords);
        return Compute.isInBuilding(iGame, entity.elevationOccupied(iHex), coords);
    }

    static boolean isInBuilding(IGame iGame, int n, Coords coords) {
        IHex iHex = iGame.getBoard().getHex(coords);
        if (!iHex.containsTerrain(12)) {
            return false;
        }
        int n2 = iHex.surface();
        int n3 = iHex.terrainLevel(12);
        int n4 = 0;
        if (iHex.containsTerrain(13)) {
            n4 = iHex.terrainLevel(13);
        }
        return n >= n2 - n4 && n < n2 + n3;
    }

    public static Coords scatter(Coords coords, int n) {
        int n2 = Compute.d6(1) - 1;
        int n3 = 0;
        n3 = n > 0 ? n : Compute.d6(1);
        for (int i = 0; i < n3; ++i) {
            coords = coords.translated(n2);
        }
        return coords;
    }

    public static Entity getSwarmTarget(IGame iGame, int n, Entity entity, int n2) {
        Coords coords = entity.getPosition();
        Entity entity2 = null;
        Entity entity3 = null;
        Enumeration enumeration = iGame.getEnemyEntities(coords, entity);
        while (enumeration.hasMoreElements()) {
            entity3 = (Entity)enumeration.nextElement();
            if (entity3.getTargetedBySwarm(n, n2)) continue;
            return entity3;
        }
        for (int i = 0; i <= 5; ++i) {
            Coords coords2 = coords.translated(i);
            if (!iGame.getBoard().contains(coords2) || coords.equals(coords2)) continue;
            enumeration = iGame.getEnemyEntities(coords2, entity);
            if (enumeration.hasMoreElements() && !(entity3 = (Entity)enumeration.nextElement()).getTargetedBySwarm(n, n2)) {
                return entity3;
            }
            enumeration = iGame.getFriendlyEntities(coords2, entity);
            if (!enumeration.hasMoreElements() || (entity3 = (Entity)enumeration.nextElement()).getTargetedBySwarm(n, n2)) continue;
            return entity3;
        }
        return entity2;
    }
}

