/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.Entity;
import megamek.common.EquipmentMessages;
import megamek.common.EquipmentMode;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.WeaponType;
import megamek.debug.Assert;

public class EquipmentType {
    public static final float TONNAGE_VARIABLE = Float.MIN_VALUE;
    public static final int CRITICALS_VARIABLE = Integer.MIN_VALUE;
    public static final int BV_VARIABLE = Integer.MIN_VALUE;
    public static final int COST_VARIABLE = Integer.MIN_VALUE;
    public static final int T_ENGINE_UNKNOWN = -1;
    public static final int T_ENGINE_ICE = 0;
    public static final int T_ENGINE_FUSION = 1;
    public static final int T_ENGINE_XL = 2;
    public static final int T_ENGINE_LIGHT = 4;
    public static final int T_ENGINE_XXL = 3;
    public static final int T_ARMOR_UNKNOWN = -1;
    public static final int T_ARMOR_STANDARD = 0;
    public static final int T_ARMOR_FERRO_FIBROUS = 1;
    public static final int T_ARMOR_REACTIVE = 2;
    public static final int T_ARMOR_REFLECTIVE = 3;
    public static final int T_ARMOR_HARDENED = 4;
    public static final int T_ARMOR_LIGHT_FERRO = 5;
    public static final int T_ARMOR_HEAVY_FERRO = 6;
    public static final int T_ARMOR_PATCHWORK = 7;
    public static final int T_ARMOR_STEALTH = 8;
    public static final int T_ARMOR_FERRO_FIBROUS_PROTO = 9;
    public static final int T_STRUCTURE_UNKNOWN = -1;
    public static final int T_STRUCTURE_STANDARD = 0;
    public static final int T_STRUCTURE_ENDO_STEEL = 1;
    public static final int T_STRUCTURE_ENDO_PROTOTYPE = 2;
    public static final int T_STRUCTURE_REINFORCED = 3;
    public static final int T_STRUCTURE_COMPOSITE = 4;
    public static final String[] armorNames = new String[]{"Standard", "Ferro-Fibrous", "Reactive", "Reflective", "Hardened", "Light Ferro-Fibrous", "Heavy Ferro-Fibrous", "Patchwork", "Stealth", "Ferro-Fibrous Prototype"};
    public static final String[] structureNames = new String[]{"Standard", "Endo Steel", "Endo Steel Prototype", "Reinforced", "Composite"};
    public static final int[] structureLevels = new int[]{1, 2, 3, 3, 3};
    public static final double[] structureCosts = new double[]{400.0, 1600.0, 1600.0, 6400.0, 1600.0};
    public static final double[] armorCosts = new double[]{10000.0, 20000.0, 30000.0, 20000.0, 15000.0, 15000.0, 25000.0, 10000.0, 50000.0, 20000.0};
    public static final double[] armorPointMultipliers = new double[]{1.0, 1.12, 1.0, 1.0, 1.0, 1.06, 1.24, 1.0, 1.0, 1.12};
    public static final double POINT_MULTIPLIER_UNKNOWN = 1.0;
    public static final double POINT_MULTIPLIER_CLAN_FF = 1.2;
    protected String name = null;
    protected String internalName = null;
    private Vector namesVector = new Vector();
    protected float tonnage = 0.0f;
    protected int criticals = 0;
    protected boolean explosive = false;
    protected boolean hittable = true;
    protected boolean spreadable = false;
    protected int toHitModifier = 0;
    protected int techLevel = -1;
    protected int flags = 0;
    protected int subType = 0;
    protected double bv = 0.0;
    protected double cost = 0.0;
    protected Vector modes = null;
    protected boolean instantModeSwitch = true;
    protected static Vector allTypes;
    protected static Hashtable lookupHash;

    public void setFlags(int n) {
        this.flags = n;
    }

    public void setSubType(int n) {
        this.subType = n;
    }

    public void addSubType(int n) {
        this.subType |= n;
    }

    public boolean hasSubType(int n) {
        return (this.subType & n) != 0;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        String string = EquipmentMessages.getString("EquipmentType." + this.name);
        if (string != null) {
            return string;
        }
        return this.name;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public int getTechLevel() {
        return this.techLevel;
    }

    public float getTonnage(Entity entity) {
        return this.tonnage;
    }

    public int getCriticals(Entity entity) {
        return this.criticals;
    }

    public boolean isExplosive() {
        return this.explosive;
    }

    public boolean isHittable() {
        return this.hittable;
    }

    public boolean isSpreadable() {
        return this.spreadable;
    }

    public int getToHitModifier() {
        return this.toHitModifier;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean hasFlag(int n) {
        return (this.flags & n) != 0;
    }

    public double getBV(Entity entity) {
        return this.bv;
    }

    public boolean hasModes() {
        return this.modes != null;
    }

    public int getModesCount() {
        if (this.modes != null) {
            return this.modes.size();
        }
        return 0;
    }

    public Enumeration getModes() {
        if (this.modes != null) {
            return this.modes.elements();
        }
        return new Enumeration(){

            public boolean hasMoreElements() {
                return false;
            }

            public Object nextElement() {
                return null;
            }
        };
    }

    protected void setModes(String[] stringArray) {
        Assert.assertTrue(stringArray != null && stringArray.length >= 0, "List of modes must not be null or empty");
        Vector<EquipmentMode> vector = new Vector<EquipmentMode>(stringArray.length);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            vector.addElement(EquipmentMode.getMode(stringArray[i]));
        }
        this.modes = vector;
    }

    public EquipmentMode getMode(int n) {
        Assert.assertTrue(this.modes != null && n >= 0 && n < this.modes.size());
        return (EquipmentMode)this.modes.elementAt(n);
    }

    public void setInstantModeSwitch(boolean bl) {
        this.instantModeSwitch = bl;
    }

    public boolean hasInstantModeSwitch() {
        return this.instantModeSwitch;
    }

    public void setInternalName(String string) {
        this.internalName = string;
        this.addLookupName(string);
    }

    public void addLookupName(String string) {
        lookupHash.put(string, this);
        this.namesVector.addElement(string);
    }

    public static EquipmentType get(String string) {
        if (null == lookupHash) {
            EquipmentType.initializeTypes();
        }
        return (EquipmentType)lookupHash.get(string);
    }

    public Enumeration getNames() {
        return this.namesVector.elements();
    }

    public static void initializeTypes() {
        allTypes = new Vector();
        lookupHash = new Hashtable();
        WeaponType.initializeTypes();
        AmmoType.initializeTypes();
        MiscType.initializeTypes();
    }

    public static Enumeration getAllTypes() {
        if (null == allTypes) {
            EquipmentType.initializeTypes();
        }
        return allTypes.elements();
    }

    protected static void addType(EquipmentType equipmentType) {
        if (null == allTypes) {
            EquipmentType.initializeTypes();
        }
        allTypes.addElement(equipmentType);
    }

    public static int getArmorType(String string) {
        for (int i = 0; i < armorNames.length; ++i) {
            if (armorNames[i].indexOf(string) < 0 && string.indexOf(armorNames[i]) < 0) continue;
            return i;
        }
        return -1;
    }

    public static String getArmorTypeName(int n) {
        if (n < 0 || n >= armorNames.length) {
            return null;
        }
        return armorNames[n];
    }

    public static int getStructureType(String string) {
        for (int i = 0; i < structureNames.length; ++i) {
            if (structureNames[i].indexOf(string) < 0 && string.indexOf(structureNames[i]) < 0) continue;
            return i;
        }
        return -1;
    }

    public static String getStructureTypeName(int n) {
        if (n < 0 || n >= structureNames.length) {
            return null;
        }
        return structureNames[n];
    }

    public double getCost() {
        return this.cost;
    }

    public static double getArmorCost(int n) {
        if (n < 0 || n >= armorCosts.length) {
            return -1.0;
        }
        return armorCosts[n];
    }

    public static double getStructureCost(int n) {
        if (n < 0 || n >= structureCosts.length) {
            return -1.0;
        }
        return structureCosts[n];
    }

    public static double getArmorPointMultiplier(int n) {
        return EquipmentType.getArmorPointMultiplier(n, 1);
    }

    public static double getArmorPointMultiplier(int n, int n2) {
        return EquipmentType.getArmorPointMultiplier(n, n2 == 2 || n2 == 6);
    }

    public static double getArmorPointMultiplier(int n, boolean bl) {
        if (n < 0 || n >= armorPointMultipliers.length) {
            return 1.0;
        }
        if (n == 1 && bl) {
            return 1.2;
        }
        return armorPointMultipliers[n];
    }

    public int resolveVariableCost(Entity entity) {
        int n = 0;
        if (this instanceof MiscType) {
            if (this.hasFlag(16)) {
                int n2 = 0;
                if (this.getInternalName().equals("ISMASC")) {
                    n2 = Math.round(entity.getWeight() / 20.0f);
                } else if (this.getInternalName().equals("CLMASC")) {
                    n2 = Math.round(entity.getWeight() / 25.0f);
                }
                n = n2 * entity.getOriginalWalkMP() * (int)entity.getWeight() * 1000;
            } else if (this.hasFlag(2048)) {
                int n3 = 0;
                float f = 0.0f;
                Enumeration enumeration = entity.getWeapons();
                while (enumeration.hasMoreElements()) {
                    Mounted mounted = (Mounted)enumeration.nextElement();
                    WeaponType weaponType = (WeaponType)mounted.getType();
                    if (!weaponType.hasFlag(1)) continue;
                    f += weaponType.getTonnage(entity);
                }
                if (this.getInternalName().equals("ISTargeting Computer")) {
                    n3 = (int)Math.ceil(f / 4.0f);
                } else if (this.getInternalName().equals("CLTargeting Computer")) {
                    n3 = (int)Math.ceil(f / 5.0f);
                }
                n = n3 * 10000;
            } else if (this.hasFlag(0x8000000) && (this.hasSubType(4) || this.hasSubType(16))) {
                int n4 = (int)Math.ceil((double)entity.getWeight() / 15.0);
                n = n4 * 5000;
            } else if (this.hasFlag(0x8000000) && this.hasSubType(8)) {
                int n5 = (int)Math.ceil((double)entity.getWeight() / 15.0);
                n = n5 * 10000;
            }
        } else if (n == 0) {
            System.out.println("I don't know how much " + this.name + " costs.");
        }
        return n;
    }
}

