/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import megamek.common.Coords;
import megamek.common.Targetable;

public class INarcPod
implements Serializable,
Targetable {
    public static final int HOMING = 1;
    public static final int ECM = 2;
    public static final int HAYWIRE = 4;
    public static final int NEMESIS = 8;
    private int team;
    private int type;

    public INarcPod(int n, int n2) {
        this.team = n;
        this.type = n2;
    }

    public int getTeam() {
        return this.team;
    }

    public int getType() {
        return this.type;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof INarcPod) {
            INarcPod iNarcPod = (INarcPod)object;
            if (this.type == iNarcPod.type && this.team == iNarcPod.team) {
                bl = true;
            }
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.type) {
            case 1: {
                stringBuffer.append("Homing");
                break;
            }
            case 2: {
                stringBuffer.append("ECM");
                break;
            }
            case 4: {
                stringBuffer.append("Haywire");
                break;
            }
            case 8: {
                stringBuffer.append("Nemesis");
            }
        }
        stringBuffer.append(" iNarc pod from Team #").append(this.team);
        return stringBuffer.toString();
    }

    public static INarcPod idToInstance(int n) {
        return new INarcPod((n & 0xFFF0) >>> 4, n & 0xF);
    }

    public int getTargetType() {
        return 11;
    }

    public int getTargetId() {
        return (this.team << 4) + this.type;
    }

    public Coords getPosition() {
        throw new IllegalStateException("Never ask for the coords of an INarcPod.");
    }

    public int absHeight() {
        return 0;
    }

    public int getHeight() {
        return 0;
    }

    public int getElevation() {
        return 0;
    }

    public boolean isImmobile() {
        return false;
    }

    public String getDisplayName() {
        return this.toString();
    }

    public int sideTable(Coords coords) {
        return 0;
    }
}

