/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.util.Enumeration;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.Mounted;
import megamek.common.WeaponType;

public class MiscType
extends EquipmentType {
    public static final int F_HEAT_SINK = 1;
    public static final int F_DOUBLE_HEAT_SINK = 2;
    public static final int F_JUMP_JET = 4;
    public static final int F_CASE = 8;
    public static final int F_MASC = 16;
    public static final int F_TSM = 32;
    public static final int F_LASER_HEAT_SINK = 64;
    public static final int F_C3S = 128;
    public static final int F_C3I = 256;
    public static final int F_ARTEMIS = 512;
    public static final int F_ECM = 1024;
    public static final int F_TARGCOMP = 2048;
    public static final int F_ANGEL_ECM = 4096;
    public static final int F_BAP = 8192;
    public static final int F_BOARDING_CLAW = 16384;
    public static final int F_VACUUM_PROTECTION = 32768;
    public static final int F_ASSAULT_CLAW = 65536;
    public static final int F_FIRE_RESISTANT = 131072;
    public static final int F_STEALTH = 262144;
    public static final int F_MINE = 524288;
    public static final int F_MINESWEEPER = 0x100000;
    public static final int F_MAGNETIC_CLAMP = 0x200000;
    public static final int F_PARAFOIL = 0x400000;
    public static final int F_FERRO_FIBROUS = 0x800000;
    public static final int F_ENDO_STEEL = 0x1000000;
    public static final int F_AP_POD = 0x2000000;
    public static final int F_SEARCHLIGHT = 0x4000000;
    public static final int F_CLUB = 0x8000000;
    public static final int F_HAND_WEAPON = 0x10000000;
    public static final int F_COWL = 0x20000000;
    public static final int S_CLUB = 1;
    public static final int S_TREE_CLUB = 2;
    public static final int S_HATCHET = 4;
    public static final int S_SWORD = 8;
    public static final int S_MACE_THB = 16;
    public static final int S_CLAW_THB = 32;
    public static final int S_MACE = 64;
    public static final int S_DUAL_SAW = 128;
    public static final int S_FLAIL = 256;
    public static final int S_PILE_DRIVER = 512;
    public static final int S_SHIELD_SMALL = 1024;
    public static final int S_SHIELD_MEDIUM = 2048;
    public static final int S_SHIELD_LARGE = 4096;
    public static final int S_LANCE = 8192;
    public static final int S_VIBRO_SMALL = 16384;
    public static final int S_VIBRO_MEDIUM = 32768;
    public static final int S_VIBRO_LARGE = 65536;
    public static final int S_WRECKING_BALL = 131072;
    public static final int S_BACKHOE = 262144;
    public static final int S_COMBINE = 524288;
    public static final int S_CHAINSAW = 0x100000;
    public static final int S_ROCK_CUTTER = 0x200000;
    public static final int S_CLAW = 1;
    public static final int S_MINING_DRILL = 2;
    public static final int T_TARGSYS_UNKNOWN = -1;
    public static final int T_TARGSYS_STANDARD = 0;
    public static final int T_TARGSYS_TARGCOMP = 1;
    public static final int T_TARGSYS_LONGRANGE = 2;
    public static final int T_TARGSYS_SHORTRANGE = 3;
    public static final int T_TARGSYS_VARIABLE_RANGE = 4;
    public static final int T_TARGSYS_ANTI_AIR = 5;
    public static final int T_TARGSYS_MULTI_TRAC = 6;
    public static final int T_TARGSYS_MULTI_TRAC_II = 7;
    public static final String[] targSysNames = new String[]{"Standard Targetting System", "Targetting Computer", "Long-Range Targetting System", "Short-Range Targetting System", "Variable-Range Targetting System", "Anti-Air Targetting System", "Multi-Trac Targetting System", "Multi-Trac II Targetting System"};

    public float getTonnage(Entity entity) {
        if (this.tonnage != Float.MIN_VALUE) {
            return this.tonnage;
        }
        if (this.hasFlag(4)) {
            if (this.getTechLevel() == 5 || this.getTechLevel() == 6) {
                if ((double)entity.getWeight() <= 55.0) {
                    return 1.0f;
                }
                if ((double)entity.getWeight() <= 85.0) {
                    return 2.0f;
                }
                return 4.0f;
            }
            if ((double)entity.getWeight() <= 55.0) {
                return 0.5f;
            }
            if ((double)entity.getWeight() <= 85.0) {
                return 1.0f;
            }
            return 2.0f;
        }
        if (this.hasFlag(0x8000000) && (this.hasSubType(4) || this.hasSubType(16))) {
            return (float)Math.ceil((double)entity.getWeight() / 15.0);
        }
        if (this.hasFlag(0x8000000) && this.hasSubType(8)) {
            return (float)(Math.ceil((double)entity.getWeight() / 20.0 * 2.0) / 2.0);
        }
        if (this.hasFlag(0x8000000) && this.hasSubType(64)) {
            return (float)Math.ceil((double)entity.getWeight() / 10.0);
        }
        if (this.hasFlag(16)) {
            if (entity.isClan()) {
                return Math.round(entity.getWeight() / 25.0f);
            }
            return Math.round(entity.getWeight() / 20.0f);
        }
        if (this.hasFlag(2048)) {
            double d = 0.0;
            Enumeration enumeration = entity.getWeapons();
            while (enumeration.hasMoreElements()) {
                Mounted mounted = (Mounted)enumeration.nextElement();
                WeaponType weaponType = (WeaponType)mounted.getType();
                if (!weaponType.hasFlag(1)) continue;
                d += (double)weaponType.getTonnage(entity);
            }
            if (entity.isClan()) {
                return (float)Math.ceil(d / 5.0);
            }
            return (float)Math.ceil(d / 4.0);
        }
        if (EquipmentType.getArmorTypeName(1).equals(this.internalName)) {
            double d = 0.0;
            d = entity.isClanArmor() ? (double)entity.getTotalOArmor() / 19.2 : (double)entity.getTotalOArmor() / 17.92;
            d = Math.ceil(d * 2.0) / 2.0;
            return (float)d;
        }
        if (EquipmentType.getArmorTypeName(5).equals(this.internalName)) {
            double d = (double)entity.getTotalOArmor() / 16.96;
            d = Math.ceil(d * 2.0) / 2.0;
            return (float)d;
        }
        if (EquipmentType.getArmorTypeName(6).equals(this.internalName)) {
            double d = (double)entity.getTotalOArmor() / 19.84;
            d = Math.ceil(d * 2.0) / 2.0;
            return (float)d;
        }
        if (EquipmentType.getStructureTypeName(1).equals(this.internalName)) {
            double d = 0.0;
            d = Math.ceil((double)entity.getWeight() / 10.0) / 2.0;
            return (float)d;
        }
        if (EquipmentType.getStructureTypeName(2).equals(this.internalName)) {
            double d = 0.0;
            d = Math.ceil((double)entity.getWeight() / 10.0) / 2.0;
            return (float)d;
        }
        if (EquipmentType.getStructureTypeName(3).equals(this.internalName)) {
            double d = 0.0;
            d = Math.ceil((double)entity.getWeight() / 10.0) * 2.0;
            return (float)d;
        }
        if (EquipmentType.getStructureTypeName(4).equals(this.internalName)) {
            double d = 0.0;
            d = Math.ceil((double)entity.getWeight() / 10.0) / 2.0;
            return (float)d;
        }
        if (this.hasFlag(32768)) {
            return (float)Math.ceil((double)entity.getWeight() / 10.0);
        }
        return 1.0f;
    }

    public int getCriticals(Entity entity) {
        if (this.criticals != Integer.MIN_VALUE) {
            return this.criticals;
        }
        if (this.hasFlag(0x8000000) && (this.hasSubType(4) || this.hasSubType(8) || this.hasSubType(16))) {
            return (int)Math.ceil((double)entity.getWeight() / 15.0);
        }
        if (this.hasFlag(0x8000000) && this.hasSubType(64)) {
            return (int)Math.ceil((double)entity.getWeight() / 10.0);
        }
        if (this.hasFlag(16)) {
            if (entity.isClan()) {
                return Math.round(entity.getWeight() / 25.0f);
            }
            return Math.round(entity.getWeight() / 20.0f);
        }
        if (this.hasFlag(2048)) {
            double d = 0.0;
            Enumeration enumeration = entity.getWeapons();
            while (enumeration.hasMoreElements()) {
                Mounted mounted = (Mounted)enumeration.nextElement();
                WeaponType weaponType = (WeaponType)mounted.getType();
                if (!weaponType.hasFlag(1)) continue;
                d += (double)weaponType.getTonnage(entity);
            }
            if (entity.isClan()) {
                return (int)Math.ceil(d / 5.0);
            }
            return (int)Math.ceil(d / 4.0);
        }
        if (EquipmentType.getArmorTypeName(1).equals(this.internalName)) {
            if (entity.isClanArmor()) {
                return 7;
            }
            return 14;
        }
        if (EquipmentType.getArmorTypeName(9).equals(this.internalName)) {
            return 16;
        }
        if (EquipmentType.getArmorTypeName(5).equals(this.internalName)) {
            return 7;
        }
        if (EquipmentType.getArmorTypeName(6).equals(this.internalName)) {
            return 21;
        }
        if (EquipmentType.getStructureTypeName(1).equals(this.internalName)) {
            if (entity.isClan()) {
                return 7;
            }
            return 14;
        }
        if (EquipmentType.getStructureTypeName(2).equals(this.internalName)) {
            return 16;
        }
        if (EquipmentType.getStructureTypeName(3).equals(this.internalName)) {
            return 0;
        }
        if (EquipmentType.getStructureTypeName(4).equals(this.internalName)) {
            return 0;
        }
        return 1;
    }

    public double getBV(Entity entity) {
        if (this.bv != -2.147483648E9) {
            return this.bv;
        }
        if (this.hasFlag(0x8000000) && this.hasSubType(4)) {
            return Math.ceil((double)entity.getWeight() / 5.0) * 1.5;
        }
        if (this.hasFlag(0x8000000) && this.hasSubType(16)) {
            return Math.ceil((double)entity.getWeight() / 5.0) * 1.5;
        }
        if (this.hasFlag(0x8000000) && this.hasSubType(64)) {
            return Math.ceil((double)entity.getWeight() / 4.0);
        }
        if (this.hasFlag(0x8000000) && this.hasSubType(8)) {
            return (Math.ceil((double)entity.getWeight() / 10.0) + 1.0) * 1.725;
        }
        if (this.hasFlag(2048)) {
            double d = 0.0;
            double d2 = 0.0;
            Enumeration enumeration = entity.getWeapons();
            while (enumeration.hasMoreElements()) {
                Mounted mounted = (Mounted)enumeration.nextElement();
                WeaponType weaponType = (WeaponType)mounted.getType();
                if (!weaponType.hasFlag(1)) continue;
                if (mounted.isRearMounted()) {
                    d2 += weaponType.getBV(entity);
                    continue;
                }
                d += weaponType.getBV(entity);
            }
            if (d > d2) {
                return d * 0.2 + d2 * 0.1;
            }
            return d2 * 0.2 + d * 0.1;
        }
        return 0.0;
    }

    public static void initializeTypes() {
        EquipmentType.addType(MiscType.createHeatSink());
        EquipmentType.addType(MiscType.createJumpJet());
        EquipmentType.addType(MiscType.createTreeClub());
        EquipmentType.addType(MiscType.createGirderClub());
        EquipmentType.addType(MiscType.createLimbClub());
        EquipmentType.addType(MiscType.createHatchet());
        EquipmentType.addType(MiscType.createVacuumProtection());
        EquipmentType.addType(MiscType.createISDoubleHeatSink());
        EquipmentType.addType(MiscType.createCLDoubleHeatSink());
        EquipmentType.addType(MiscType.createISCASE());
        EquipmentType.addType(MiscType.createCLCASE());
        EquipmentType.addType(MiscType.createISMASC());
        EquipmentType.addType(MiscType.createCLMASC());
        EquipmentType.addType(MiscType.createTSM());
        EquipmentType.addType(MiscType.createC3S());
        EquipmentType.addType(MiscType.createC3I());
        EquipmentType.addType(MiscType.createISArtemis());
        EquipmentType.addType(MiscType.createCLArtemis());
        EquipmentType.addType(MiscType.createGECM());
        EquipmentType.addType(MiscType.createCLECM());
        EquipmentType.addType(MiscType.createISTargComp());
        EquipmentType.addType(MiscType.createCLTargComp());
        EquipmentType.addType(MiscType.createMekStealth());
        EquipmentType.addType(MiscType.createFerroFibrous());
        EquipmentType.addType(MiscType.createEndoSteel());
        EquipmentType.addType(MiscType.createBeagleActiveProbe());
        EquipmentType.addType(MiscType.createBloodhoundActiveProbe());
        EquipmentType.addType(MiscType.createTHBBloodhoundActiveProbe());
        EquipmentType.addType(MiscType.createCLActiveProbe());
        EquipmentType.addType(MiscType.createCLLightActiveProbe());
        EquipmentType.addType(MiscType.createISAPPod());
        EquipmentType.addType(MiscType.createCLAPPod());
        EquipmentType.addType(MiscType.createSword());
        EquipmentType.addType(MiscType.createImprovedJumpJet());
        EquipmentType.addType(MiscType.createCLImprovedJumpJet());
        EquipmentType.addType(MiscType.createFerroFibrousPrototype());
        EquipmentType.addType(MiscType.createLightFerroFibrous());
        EquipmentType.addType(MiscType.createHeavyFerroFibrous());
        EquipmentType.addType(MiscType.createEndoSteelPrototype());
        EquipmentType.addType(MiscType.createReinforcedStructure());
        EquipmentType.addType(MiscType.createCompositeStructure());
        EquipmentType.addType(MiscType.createIS1CompactHeatSink());
        EquipmentType.addType(MiscType.createIS2CompactHeatSinks());
        EquipmentType.addType(MiscType.createCLLaserHeatSink());
        EquipmentType.addType(MiscType.createISAngelECM());
        EquipmentType.addType(MiscType.createISTHBAngelECM());
        EquipmentType.addType(MiscType.createCLAngelECM());
        EquipmentType.addType(MiscType.createWatchdogECM());
        EquipmentType.addType(MiscType.createTHBMace());
        EquipmentType.addType(MiscType.createMace());
        EquipmentType.addType(MiscType.createDualSaw());
        EquipmentType.addType(MiscType.createChainsaw());
        EquipmentType.addType(MiscType.createBackhoe());
        EquipmentType.addType(MiscType.createPileDriver());
        EquipmentType.addType(MiscType.createArmoredCowl());
        EquipmentType.addType(MiscType.createNullSignatureSystem());
        EquipmentType.addType(MiscType.createBABoardingClaw());
        EquipmentType.addType(MiscType.createBAAssaultClaws());
        EquipmentType.addType(MiscType.createBAFireResistantArmor());
        EquipmentType.addType(MiscType.createBasicStealth());
        EquipmentType.addType(MiscType.createStandardStealth());
        EquipmentType.addType(MiscType.createImprovedStealth());
        EquipmentType.addType(MiscType.createMine());
        EquipmentType.addType(MiscType.createMinesweeper());
        EquipmentType.addType(MiscType.createBAMagneticClamp());
        EquipmentType.addType(MiscType.createSingleHexECM());
        EquipmentType.addType(MiscType.createMimeticCamo());
        EquipmentType.addType(MiscType.createSimpleCamo());
        EquipmentType.addType(MiscType.createParafoil());
        EquipmentType.addType(MiscType.createBASearchlight());
    }

    public static MiscType createHeatSink() {
        MiscType miscType = new MiscType();
        miscType.techLevel = -2;
        miscType.name = "Heat Sink";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = 1.0f;
        miscType.criticals = 1;
        miscType.flags |= 1;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createJumpJet() {
        MiscType miscType = new MiscType();
        miscType.techLevel = -2;
        miscType.name = "Jump Jet";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = 1;
        miscType.flags |= 4;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createImprovedJumpJet() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 5;
        miscType.name = "Improved Jump Jet";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("ImprovedJump Jet");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = 2;
        miscType.flags |= 4;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createCLImprovedJumpJet() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 6;
        miscType.name = "Clan Improved Jump Jet";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("CLImprovedJump Jet");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = 2;
        miscType.flags |= 4;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createTreeClub() {
        MiscType miscType = new MiscType();
        miscType.name = "Tree Club";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.flags |= 0x8000000;
        miscType.subType |= 3;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createGirderClub() {
        MiscType miscType = new MiscType();
        miscType.name = "Girder Club";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.flags |= 0x8000000;
        miscType.subType |= 1;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createLimbClub() {
        MiscType miscType = new MiscType();
        miscType.name = "Limb Club";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.flags |= 0x8000000;
        miscType.subType |= 1;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createHatchet() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 0;
        miscType.name = "Hatchet";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.cost = -2.147483648E9;
        miscType.flags |= 0x8000000;
        miscType.subType |= 4;
        miscType.bv = -2.147483648E9;
        return miscType;
    }

    public static MiscType createISDoubleHeatSink() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 1;
        miscType.name = "Double Heat Sink";
        miscType.setInternalName("ISDoubleHeatSink");
        miscType.addLookupName("IS Double Heat Sink");
        miscType.addLookupName("ISDouble Heat Sink");
        miscType.tonnage = 1.0f;
        miscType.criticals = 3;
        miscType.flags |= 2;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createCLDoubleHeatSink() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 2;
        miscType.name = "Double Heat Sink";
        miscType.setInternalName("CLDoubleHeatSink");
        miscType.addLookupName("Clan Double Heat Sink");
        miscType.addLookupName("CLDouble Heat Sink");
        miscType.tonnage = 1.0f;
        miscType.criticals = 2;
        miscType.flags |= 2;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createISCASE() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 1;
        miscType.name = "CASE";
        miscType.setInternalName("ISCASE");
        miscType.addLookupName("IS CASE");
        miscType.tonnage = 0.5f;
        miscType.criticals = 1;
        miscType.hittable = false;
        miscType.flags |= 8;
        miscType.cost = 50000.0;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createCLCASE() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 2;
        miscType.name = "CASE";
        miscType.setInternalName("CLCASE");
        miscType.addLookupName("Clan CASE");
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.flags |= 8;
        miscType.cost = 50000.0;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createISMASC() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 1;
        miscType.name = "MASC";
        miscType.setInternalName("ISMASC");
        miscType.addLookupName("IS MASC");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.cost = -2.147483648E9;
        miscType.hittable = false;
        miscType.spreadable = true;
        miscType.flags |= 0x10;
        miscType.bv = 0.0;
        String[] stringArray = new String[]{"Armed", "Off"};
        miscType.setModes(stringArray);
        return miscType;
    }

    public static MiscType createCLMASC() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 2;
        miscType.name = "MASC";
        miscType.setInternalName("CLMASC");
        miscType.addLookupName("Clan MASC");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.hittable = false;
        miscType.cost = -2.147483648E9;
        miscType.spreadable = true;
        miscType.flags |= 0x10;
        miscType.bv = 0.0;
        String[] stringArray = new String[]{"Armed", "Off"};
        miscType.setModes(stringArray);
        return miscType;
    }

    public static MiscType createTSM() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 1;
        miscType.name = "TSM";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("IS TSM");
        miscType.addLookupName("Triple Strength Myomer");
        miscType.tonnage = 0.0f;
        miscType.criticals = 6;
        miscType.hittable = false;
        miscType.spreadable = true;
        miscType.flags |= 0x20;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createC3S() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 1;
        miscType.name = "C3 Slave";
        miscType.setInternalName("ISC3SlaveUnit");
        miscType.addLookupName("IS C3 Slave");
        miscType.tonnage = 1.0f;
        miscType.criticals = 1;
        miscType.hittable = true;
        miscType.spreadable = false;
        miscType.cost = 250000.0;
        miscType.flags |= 0x80;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createC3I() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 1;
        miscType.name = "C3i Computer";
        miscType.setInternalName("ISC3iUnit");
        miscType.addLookupName("ISImprovedC3CPU");
        miscType.addLookupName("IS C3i Computer");
        miscType.tonnage = 2.5f;
        miscType.criticals = 2;
        miscType.hittable = true;
        miscType.spreadable = false;
        miscType.cost = 750000.0;
        miscType.flags |= 0x100;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createISArtemis() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 1;
        miscType.name = "Artemis IV FCS";
        miscType.setInternalName("ISArtemisIV");
        miscType.addLookupName("IS Artemis IV FCS");
        miscType.tonnage = 1.0f;
        miscType.criticals = 1;
        miscType.cost = 100000.0;
        miscType.flags |= 0x200;
        return miscType;
    }

    public static MiscType createCLArtemis() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 2;
        miscType.name = "Artemis IV FCS";
        miscType.setInternalName("CLArtemisIV");
        miscType.addLookupName("Clan Artemis IV FCS");
        miscType.tonnage = 1.0f;
        miscType.cost = 100000.0;
        miscType.criticals = 1;
        miscType.flags |= 0x200;
        return miscType;
    }

    public static MiscType createGECM() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 1;
        miscType.name = "Guardian ECM Suite";
        miscType.setInternalName("ISGuardianECMSuite");
        miscType.addLookupName("IS Guardian ECM");
        miscType.addLookupName("ISGuardianECM");
        miscType.addLookupName("IS Guardian ECM Suite");
        miscType.tonnage = 1.5f;
        miscType.criticals = 2;
        miscType.hittable = true;
        miscType.cost = 200000.0;
        miscType.spreadable = false;
        miscType.flags |= 0x400;
        miscType.bv = 61.0;
        return miscType;
    }

    public static MiscType createCLECM() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 2;
        miscType.name = "ECM Suite";
        miscType.setInternalName("CLECMSuite");
        miscType.addLookupName("Clan ECM Suite");
        miscType.tonnage = 1.0f;
        miscType.criticals = 1;
        miscType.cost = 200000.0;
        miscType.hittable = true;
        miscType.spreadable = false;
        miscType.flags |= 0x400;
        miscType.bv = 61.0;
        return miscType;
    }

    public static MiscType createISAngelECM() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 5;
        miscType.name = "Angel ECM Suite";
        miscType.setInternalName("ISAngelECMSuite");
        miscType.addLookupName("IS Angel ECM Suite");
        miscType.addLookupName("ISAngelECM");
        miscType.tonnage = 2.0f;
        miscType.criticals = 2;
        miscType.cost = 750000.0;
        miscType.hittable = true;
        miscType.spreadable = false;
        miscType.flags |= 0x1400;
        miscType.bv = 100.0;
        return miscType;
    }

    public static MiscType createISTHBAngelECM() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 5;
        miscType.name = "THB Angel ECM Suite";
        miscType.setInternalName("ISTHBAngelECMSuite");
        miscType.addLookupName("IS THB Angel ECM Suite");
        miscType.addLookupName("ISTHBAngelECM");
        miscType.tonnage = 1.5f;
        miscType.criticals = 2;
        miscType.cost = 1000000.0;
        miscType.hittable = true;
        miscType.spreadable = false;
        miscType.flags |= 0x1400;
        miscType.bv = 100.0;
        return miscType;
    }

    public static MiscType createCLAngelECM() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 6;
        miscType.name = "Clan Angel ECM Suite";
        miscType.setInternalName("CLAngelECMSuite");
        miscType.addLookupName("Clan Angel ECM Suite");
        miscType.addLookupName("CLAngelECM");
        miscType.tonnage = 1.5f;
        miscType.criticals = 2;
        miscType.cost = 750000.0;
        miscType.hittable = true;
        miscType.spreadable = false;
        miscType.flags |= 0x1400;
        miscType.bv = 100.0;
        return miscType;
    }

    public static MiscType createWatchdogECM() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 6;
        miscType.name = "Watchdog ECM Suite";
        miscType.setInternalName("WatchdogECMSuite");
        miscType.addLookupName("Watchdog ECM Suite");
        miscType.addLookupName("WatchdogECM");
        miscType.addLookupName("CLWatchdogECM");
        miscType.tonnage = 1.0f;
        miscType.criticals = 1;
        miscType.cost = 500000.0;
        miscType.hittable = true;
        miscType.spreadable = false;
        miscType.flags |= 0x2400;
        miscType.bv = 73.0;
        return miscType;
    }

    public static MiscType createSword() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 1;
        miscType.name = "Sword";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.cost = -2.147483648E9;
        miscType.flags |= 0x8000000;
        miscType.subType |= 8;
        miscType.bv = -2.147483648E9;
        return miscType;
    }

    public static MiscType createTHBMace() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 5;
        miscType.name = "Mace (THB)";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("THB Mace");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.cost = -2.147483648E9;
        miscType.flags |= 0x8000000;
        miscType.subType |= 0x10;
        miscType.bv = -2.147483648E9;
        return miscType;
    }

    public static MiscType createMace() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 5;
        miscType.name = "Mace";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.cost = 130000.0;
        miscType.flags |= 0x8000000;
        miscType.subType |= 0x40;
        miscType.bv = -2.147483648E9;
        return miscType;
    }

    public static MiscType createBackhoe() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 5;
        miscType.name = "Backhoe";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = 5.0f;
        miscType.criticals = 6;
        miscType.cost = 50000.0;
        miscType.flags |= 0x8000000;
        miscType.subType |= 0x40000;
        miscType.bv = 8.0;
        return miscType;
    }

    public static MiscType createDualSaw() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 5;
        miscType.name = "Dual Saw";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = 7.0f;
        miscType.criticals = 7;
        miscType.cost = 100000.0;
        miscType.flags |= 0x8000000;
        miscType.subType |= 0x80;
        miscType.bv = 9.0;
        return miscType;
    }

    public static MiscType createPileDriver() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 5;
        miscType.name = "Pile Driver";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("PileDriver");
        miscType.tonnage = 10.0f;
        miscType.criticals = 8;
        miscType.cost = 100000.0;
        miscType.flags |= 0x8000000;
        miscType.subType |= 0x200;
        miscType.bv = 5.0;
        return miscType;
    }

    public static MiscType createChainsaw() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 5;
        miscType.name = "Chainsaw";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = 5.0f;
        miscType.criticals = 5;
        miscType.cost = 100000.0;
        miscType.flags |= 0x8000000;
        miscType.subType |= 0x100000;
        miscType.bv = 7.0;
        return miscType;
    }

    public static MiscType createArmoredCowl() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 5;
        miscType.name = "Armored Cowl";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = 1.0f;
        miscType.criticals = 1;
        miscType.cost = 10000.0;
        miscType.flags |= 0x20000000;
        miscType.bv = 10.0;
        return miscType;
    }

    public static MiscType createISTargComp() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 1;
        miscType.name = "Targeting Computer";
        miscType.setInternalName("ISTargeting Computer");
        miscType.addLookupName("IS Targeting Computer");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.cost = -2.147483648E9;
        miscType.bv = -2.147483648E9;
        miscType.flags |= 0x800;
        miscType.spreadable = true;
        String[] stringArray = new String[]{"Normal", "Aimed shot"};
        miscType.setModes(stringArray);
        return miscType;
    }

    public static MiscType createCLTargComp() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 2;
        miscType.name = "Targeting Computer";
        miscType.setInternalName("CLTargeting Computer");
        miscType.addLookupName("Clan Targeting Computer");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.cost = -2.147483648E9;
        miscType.bv = -2.147483648E9;
        miscType.flags |= 0x800;
        miscType.spreadable = true;
        String[] stringArray = new String[]{"Normal", "Aimed shot"};
        miscType.setModes(stringArray);
        return miscType;
    }

    public static MiscType createBABoardingClaw() {
        MiscType miscType = new MiscType();
        miscType.name = "Boarding Claw";
        miscType.setInternalName("BA-Boarding Claw");
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.spreadable = false;
        miscType.flags |= 0x4000;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createBAAssaultClaws() {
        MiscType miscType = new MiscType();
        miscType.name = "Assault Claws";
        miscType.setInternalName("BA-Assault Claws");
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.spreadable = false;
        miscType.flags |= 0x10000;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createBAFireResistantArmor() {
        MiscType miscType = new MiscType();
        miscType.name = "Fire Resistant Armor";
        miscType.setInternalName("BA-Fire Resistant Armor");
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.spreadable = false;
        miscType.flags |= 0x20000;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createBasicStealth() {
        MiscType miscType = new MiscType();
        miscType.name = "Basic Stealth";
        miscType.setInternalName("Basic Stealth");
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.spreadable = false;
        miscType.flags |= 0x40000;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createStandardStealth() {
        MiscType miscType = new MiscType();
        miscType.name = "Standard Stealth";
        miscType.setInternalName("Standard Stealth");
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.spreadable = false;
        miscType.flags |= 0x40000;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createImprovedStealth() {
        MiscType miscType = new MiscType();
        miscType.name = "Improved Stealth";
        miscType.setInternalName("Improved Stealth");
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.spreadable = false;
        miscType.flags |= 0x40000;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createMine() {
        MiscType miscType = new MiscType();
        miscType.name = "Mine";
        miscType.setInternalName("Mine");
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = true;
        miscType.spreadable = false;
        miscType.flags |= 0x80000;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createMinesweeper() {
        MiscType miscType = new MiscType();
        miscType.name = "Minesweeper";
        miscType.setInternalName("Minesweeper");
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.spreadable = false;
        miscType.flags |= 0x100000;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createBAMagneticClamp() {
        MiscType miscType = new MiscType();
        miscType.name = "Magnetic Clamp";
        miscType.setInternalName("BA-Magnetic Clamp");
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.spreadable = false;
        miscType.flags |= 0x200000;
        String[] stringArray = new String[]{"On", "Off"};
        miscType.setModes(stringArray);
        miscType.setInstantModeSwitch(true);
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createSingleHexECM() {
        MiscType miscType = new MiscType();
        miscType.name = "Single-Hex ECM";
        miscType.setInternalName("Single-Hex ECM");
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.spreadable = false;
        miscType.flags |= 0x400;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createMimeticCamo() {
        MiscType miscType = new MiscType();
        miscType.name = "Mimetic Armor";
        miscType.setInternalName("Mimetic Armor");
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.spreadable = false;
        miscType.flags |= 0x40000;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createSimpleCamo() {
        MiscType miscType = new MiscType();
        miscType.name = "Simple Camo";
        miscType.setInternalName("Simple Camo");
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.spreadable = false;
        miscType.flags |= 0x40000;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createParafoil() {
        MiscType miscType = new MiscType();
        miscType.name = "Parafoil";
        miscType.setInternalName("Parafoil");
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.spreadable = false;
        miscType.flags |= 0x400000;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createMekStealth() {
        MiscType miscType = new MiscType();
        miscType.name = "Stealth Armor";
        miscType.setInternalName("Mek Stealth");
        miscType.addLookupName("Stealth Armor");
        miscType.tonnage = 0.0f;
        miscType.criticals = 12;
        miscType.hittable = false;
        miscType.spreadable = true;
        miscType.flags |= 0x40000;
        String[] stringArray = new String[]{"Off", "On"};
        miscType.setModes(stringArray);
        miscType.setInstantModeSwitch(false);
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createNullSignatureSystem() {
        MiscType miscType = new MiscType();
        miscType.name = "Null Signature System";
        miscType.setInternalName("Mek Null Signature System");
        miscType.addLookupName("Null Signature System");
        miscType.tonnage = 0.0f;
        miscType.criticals = 7;
        miscType.hittable = true;
        miscType.spreadable = true;
        miscType.flags |= 0x40000;
        String[] stringArray = new String[]{"Off", "On"};
        miscType.setModes(stringArray);
        miscType.setInstantModeSwitch(false);
        miscType.bv = 0.0;
        miscType.techLevel = 5;
        return miscType;
    }

    public static MiscType createFerroFibrous() {
        MiscType miscType = new MiscType();
        miscType.name = EquipmentType.getArmorTypeName(1);
        miscType.setInternalName(EquipmentType.getArmorTypeName(1));
        miscType.addLookupName("Ferro-Fibrous Armor");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.hittable = false;
        miscType.spreadable = true;
        miscType.flags |= 0x800000;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createFerroFibrousPrototype() {
        MiscType miscType = new MiscType();
        miscType.name = EquipmentType.getArmorTypeName(9);
        miscType.setInternalName(EquipmentType.getArmorTypeName(9));
        miscType.addLookupName("Ferro-Fibrous Armor Prototype");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.hittable = false;
        miscType.spreadable = true;
        miscType.flags |= 0x800000;
        miscType.bv = 0.0;
        miscType.techLevel = 5;
        return miscType;
    }

    public static MiscType createLightFerroFibrous() {
        MiscType miscType = new MiscType();
        miscType.name = EquipmentType.getArmorTypeName(5);
        miscType.setInternalName(EquipmentType.getArmorTypeName(5));
        miscType.addLookupName("Light Ferro-Fibrous Armor");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = 7;
        miscType.hittable = false;
        miscType.spreadable = true;
        miscType.flags |= 0x800000;
        miscType.bv = 0.0;
        miscType.techLevel = 5;
        return miscType;
    }

    public static MiscType createHeavyFerroFibrous() {
        MiscType miscType = new MiscType();
        miscType.name = EquipmentType.getArmorTypeName(6);
        miscType.setInternalName(EquipmentType.getArmorTypeName(6));
        miscType.addLookupName("Heavy Ferro-Fibrous Armor");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = 21;
        miscType.hittable = false;
        miscType.spreadable = true;
        miscType.flags |= 0x800000;
        miscType.bv = 0.0;
        miscType.techLevel = 5;
        return miscType;
    }

    public static MiscType createEndoSteel() {
        MiscType miscType = new MiscType();
        miscType.name = EquipmentType.getStructureTypeName(1);
        miscType.setInternalName(EquipmentType.getStructureTypeName(1));
        miscType.addLookupName("Endo-Steel");
        miscType.addLookupName("EndoSteel");
        miscType.addLookupName("Endosteel");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.hittable = false;
        miscType.spreadable = true;
        miscType.flags |= 0x1000000;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createEndoSteelPrototype() {
        MiscType miscType = new MiscType();
        miscType.name = EquipmentType.getStructureTypeName(2);
        miscType.setInternalName(EquipmentType.getStructureTypeName(2));
        miscType.addLookupName("Endo-Steel Prototype");
        miscType.addLookupName("EndoSteelPrototype");
        miscType.addLookupName("Endosteelprototype");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.hittable = false;
        miscType.spreadable = true;
        miscType.flags |= 0x1000000;
        miscType.bv = 0.0;
        miscType.techLevel = 5;
        return miscType;
    }

    public static MiscType createReinforcedStructure() {
        MiscType miscType = new MiscType();
        miscType.name = EquipmentType.getStructureTypeName(3);
        miscType.setInternalName(EquipmentType.getStructureTypeName(3));
        miscType.addLookupName("Reinforced");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.spreadable = true;
        miscType.bv = 0.0;
        miscType.techLevel = 5;
        return miscType;
    }

    public static MiscType createCompositeStructure() {
        MiscType miscType = new MiscType();
        miscType.name = EquipmentType.getStructureTypeName(4);
        miscType.setInternalName(EquipmentType.getStructureTypeName(4));
        miscType.addLookupName("Composite");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.spreadable = true;
        miscType.bv = 0.0;
        miscType.techLevel = 5;
        return miscType;
    }

    public static MiscType createCLLaserHeatSink() {
        MiscType miscType = new MiscType();
        miscType.name = "Laser Heat Sink";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("CLLaser Heat Sink");
        miscType.tonnage = 1.0f;
        miscType.criticals = 2;
        miscType.flags |= 0x42;
        miscType.bv = 0.0;
        miscType.techLevel = 6;
        return miscType;
    }

    public static MiscType createIS1CompactHeatSink() {
        MiscType miscType = new MiscType();
        miscType.name = "1 Compact Heat Sink";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("IS1 Compact Heat Sink");
        miscType.tonnage = 1.5f;
        miscType.criticals = 1;
        miscType.flags |= 1;
        miscType.bv = 0.0;
        miscType.techLevel = 5;
        return miscType;
    }

    public static MiscType createIS2CompactHeatSinks() {
        MiscType miscType = new MiscType();
        miscType.name = "2 Compact Heat Sinks";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("IS2 Compact Heat Sinks");
        miscType.tonnage = 3.0f;
        miscType.criticals = 1;
        miscType.flags |= 2;
        miscType.bv = 0.0;
        miscType.techLevel = 5;
        return miscType;
    }

    public static MiscType createBeagleActiveProbe() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 1;
        miscType.name = "Beagle Active Probe";
        miscType.setInternalName("BeagleActiveProbe");
        miscType.addLookupName("Beagle Active Probe");
        miscType.addLookupName("ISBeagleActiveProbe");
        miscType.addLookupName("IS Beagle Active Probe");
        miscType.tonnage = 1.5f;
        miscType.criticals = 2;
        miscType.hittable = true;
        miscType.cost = 200000.0;
        miscType.spreadable = false;
        miscType.flags |= 0x2000;
        miscType.bv = 10.0;
        return miscType;
    }

    public static MiscType createBloodhoundActiveProbe() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 5;
        miscType.name = "Bloodhound Active Probe";
        miscType.setInternalName("BloodhoundActiveProbe");
        miscType.addLookupName("Bloodhound Active Probe");
        miscType.addLookupName("ISBloodhoundActiveProbe");
        miscType.addLookupName("IS Bloodhound Active Probe");
        miscType.tonnage = 2.0f;
        miscType.criticals = 3;
        miscType.hittable = true;
        miscType.cost = 500000.0;
        miscType.spreadable = false;
        miscType.flags |= 0x2000;
        miscType.bv = 25.0;
        return miscType;
    }

    public static MiscType createTHBBloodhoundActiveProbe() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 5;
        miscType.name = "Bloodhound Active Probe (THB)";
        miscType.setInternalName("THBBloodhoundActiveProbe");
        miscType.addLookupName("THB Bloodhound Active Probe");
        miscType.addLookupName("ISTHBBloodhoundActiveProbe");
        miscType.addLookupName("IS THB Bloodhound Active Probe");
        miscType.tonnage = 5.0f;
        miscType.criticals = 2;
        miscType.hittable = true;
        miscType.cost = 750000.0;
        miscType.spreadable = false;
        miscType.flags |= 0x2000;
        miscType.bv = 25.0;
        return miscType;
    }

    public static MiscType createCLActiveProbe() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 2;
        miscType.name = "Clan Active Probe";
        miscType.setInternalName("CLActiveProbe");
        miscType.addLookupName("Active Probe");
        miscType.addLookupName("Clan Active Probe");
        miscType.tonnage = 1.0f;
        miscType.criticals = 1;
        miscType.hittable = true;
        miscType.spreadable = false;
        miscType.cost = 200000.0;
        miscType.flags |= 0x2000;
        miscType.bv = 12.0;
        return miscType;
    }

    public static MiscType createCLLightActiveProbe() {
        MiscType miscType = new MiscType();
        miscType.name = "Light Active Probe";
        miscType.setInternalName("CLLightActiveProbe");
        miscType.addLookupName("CL Light Active Probe");
        miscType.addLookupName("Light Active Probe");
        miscType.addLookupName("Clan Light Active Probe");
        miscType.tonnage = 0.5f;
        miscType.criticals = 1;
        miscType.hittable = true;
        miscType.cost = 150000.0;
        miscType.spreadable = false;
        miscType.flags |= 0x2000;
        miscType.bv = 7.0;
        return miscType;
    }

    public static MiscType createISAPPod() {
        MiscType miscType = new MiscType();
        miscType.name = "IS AP Pod";
        miscType.setInternalName("ISAntiPersonnelPod");
        miscType.addLookupName("IS A-Pod");
        miscType.tonnage = 0.5f;
        miscType.criticals = 1;
        miscType.hittable = true;
        miscType.cost = 1500.0;
        miscType.spreadable = false;
        miscType.flags |= 0x2000000;
        miscType.bv = 1.0;
        return miscType;
    }

    public static MiscType createCLAPPod() {
        MiscType miscType = new MiscType();
        miscType.name = "CL AP Pod";
        miscType.setInternalName("CLAntiPersonnelPod");
        miscType.addLookupName("Clan A-Pod");
        miscType.tonnage = 0.5f;
        miscType.criticals = 1;
        miscType.hittable = true;
        miscType.cost = 1500.0;
        miscType.spreadable = false;
        miscType.flags |= 0x2000000;
        miscType.bv = 1.0;
        return miscType;
    }

    public static MiscType createBASearchlight() {
        MiscType miscType = new MiscType();
        miscType.name = "Searchlight";
        miscType.setInternalName("BASearchlight");
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.spreadable = false;
        miscType.flags |= 0x4000000;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createVacuumProtection() {
        MiscType miscType = new MiscType();
        miscType.name = "Vacuum Protection";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = 0;
        miscType.cost = 0.0;
        miscType.flags |= 0x8000;
        miscType.bv = 0.0;
        return miscType;
    }

    public static String getTargetSysName(int n) {
        if (n < 0 || n >= targSysNames.length) {
            return null;
        }
        return targSysNames[n];
    }

    public static int getTargetSysType(String string) {
        for (int i = 0; i < targSysNames.length; ++i) {
            if (targSysNames[i].compareTo(string) != 0) continue;
            return i;
        }
        return -1;
    }
}

