/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import megamek.common.AmmoType;
import megamek.common.Entity;
import megamek.common.EquipmentMode;
import megamek.common.EquipmentType;
import megamek.common.Messages;
import megamek.common.MiscType;
import megamek.common.RoundUpdated;
import megamek.common.WeaponType;
import megamek.debug.Assert;

public class Mounted
implements Serializable,
RoundUpdated {
    private boolean usedThisRound = false;
    private boolean destroyed = false;
    private boolean hit = false;
    private boolean missing = false;
    private boolean jammed = false;
    private boolean useless = false;
    private boolean fired = false;
    private boolean rapidfire = false;
    private int mode;
    private int pendingMode = -1;
    private int location;
    private boolean rearMounted;
    private Mounted linked = null;
    private Mounted linkedBy = null;
    private Entity entity;
    private transient EquipmentType type;
    private String typeName;
    private int shotsLeft;
    private boolean m_bPendingDump;
    private boolean m_bDumping;
    private boolean bSplit = false;
    private int nFoundCrits = 0;
    private int mineType = -1;
    private int vibraSetting = 20;
    private int phase = -1;
    public static final int MINE_NONE = -1;
    public static final int MINE_CONVENTIONAL = 0;
    public static final int MINE_VIBRABOMB = 1;
    public static final int MINE_COMMAND_DETONATED = 2;

    public Mounted(Entity entity, EquipmentType equipmentType) {
        this.entity = entity;
        this.type = equipmentType;
        this.typeName = equipmentType.getInternalName();
        if (equipmentType instanceof AmmoType) {
            this.shotsLeft = ((AmmoType)equipmentType).getShots();
        }
        if (equipmentType instanceof MiscType && equipmentType.hasFlag(524288)) {
            this.mineType = 0;
        }
    }

    public void changeAmmoType(AmmoType ammoType) {
        if (!(this.type instanceof AmmoType)) {
            System.out.println("Attempted to change ammo type of non-ammo");
            return;
        }
        this.type = ammoType;
        this.typeName = ammoType.getInternalName();
        this.shotsLeft = this.location == -1 ? 1 : ammoType.getShots();
    }

    public void restore() {
        if (this.typeName == null) {
            this.typeName = this.type.getName();
        } else {
            this.type = EquipmentType.get(this.typeName);
        }
        if (this.type == null) {
            System.err.println("Mounted.restore: could not restore equipment type \"" + this.typeName + "\"");
        }
    }

    public EquipmentType getType() {
        return this.type;
    }

    public EquipmentMode curMode() {
        if (this.mode >= 0 && this.mode < this.type.getModesCount()) {
            return this.type.getMode(this.mode);
        }
        return null;
    }

    public EquipmentMode pendingMode() {
        if (this.pendingMode < 0 || this.pendingMode >= this.type.getModesCount()) {
            return EquipmentMode.getMode("None");
        }
        return this.type.getMode(this.pendingMode);
    }

    public int switchMode() {
        if (this.type.hasModes()) {
            int n = 0;
            n = this.pendingMode > -1 ? (this.pendingMode + 1) % this.type.getModesCount() : (this.mode + 1) % this.type.getModesCount();
            this.setMode(n);
            return n;
        }
        return -1;
    }

    public int setMode(String string) {
        int n = this.type.getModesCount();
        for (int i = 0; i < n; ++i) {
            if (!this.type.getMode(i).equals(string)) continue;
            this.setMode(i);
            return i;
        }
        return -1;
    }

    public void setMode(int n) {
        if (this.type.hasModes()) {
            Assert.assertTrue(n >= 0 && n < this.type.getModesCount(), "Invalid mode, mode=" + n + ", modesCount=" + this.type.getModesCount());
            if (this.type.hasInstantModeSwitch()) {
                this.mode = n;
            } else if (this.pendingMode != n) {
                this.pendingMode = n;
            }
        }
    }

    public void newRound(int n) {
        this.setUsedThisRound(false);
        if (this.type != null && this.type.hasModes() && this.pendingMode != -1) {
            this.mode = this.pendingMode;
            this.pendingMode = -1;
        }
    }

    public String getName() {
        return this.type.getName();
    }

    public String getDesc() {
        StringBuffer stringBuffer;
        switch (this.getMineType()) {
            case 0: {
                stringBuffer = new StringBuffer(Messages.getString("Mounted.ConventionalMine"));
                break;
            }
            case 1: {
                stringBuffer = new StringBuffer(Messages.getString("Mounted.VibraBombMine"));
                break;
            }
            case 2: {
                stringBuffer = new StringBuffer(Messages.getString("Mounted.CommandDetonatedMine"));
                break;
            }
            default: {
                stringBuffer = new StringBuffer(this.type.getDesc());
            }
        }
        if (this.destroyed) {
            stringBuffer.insert(0, "*");
        } else if (this.useless) {
            stringBuffer.insert(0, "x ");
        } else if (this.usedThisRound) {
            stringBuffer.insert(0, "+");
        } else if (this.jammed) {
            stringBuffer.insert(0, "j ");
        } else if (this.fired) {
            stringBuffer.insert(0, "x ");
        }
        if (this.rearMounted) {
            stringBuffer.append(" (R)");
        }
        if (this.type instanceof AmmoType && this.location != -1) {
            stringBuffer.append(" (");
            stringBuffer.append(this.shotsLeft);
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public boolean isReady() {
        return !this.usedThisRound && !this.destroyed && !this.jammed && !this.useless;
    }

    public boolean isUsedThisRound() {
        return this.usedThisRound;
    }

    public void setUsedThisRound(boolean bl) {
        this.usedThisRound = bl;
        this.phase = bl ? this.entity.game.getPhase() : -1;
    }

    public int usedInPhase() {
        if (this.usedThisRound) {
            return this.phase;
        }
        return -1;
    }

    public boolean isBreached() {
        return this.useless;
    }

    public void setBreached(boolean bl) {
        this.useless = bl;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void setDestroyed(boolean bl) {
        this.destroyed = bl;
    }

    public boolean isHit() {
        return this.hit;
    }

    public void setHit(boolean bl) {
        this.hit = bl;
    }

    public boolean isMissing() {
        return this.missing;
    }

    public void setMissing(boolean bl) {
        this.missing = bl;
    }

    public boolean isJammed() {
        return this.jammed;
    }

    public void setJammed(boolean bl) {
        this.jammed = bl;
    }

    public int getShotsLeft() {
        return this.shotsLeft;
    }

    public void setShotsLeft(int n) {
        this.shotsLeft = n;
    }

    public int howManyShots() {
        WeaponType weaponType = (WeaponType)this.getType();
        int n = 1;
        if ((weaponType.getAmmoType() == 20 || weaponType.getAmmoType() == 34) && this.curMode().equals("Ultra")) {
            n = 2;
        } else if (weaponType.getAmmoType() == 23 || weaponType.getInternalName().equals("BAMineLauncher")) {
            if (this.curMode().equals("2-shot")) {
                n = 2;
            } else if (this.curMode().equals("4-shot")) {
                n = 4;
            } else if (this.curMode().equals("6-shot")) {
                n = 6;
            }
        }
        return n;
    }

    public boolean isPendingDump() {
        return this.m_bPendingDump;
    }

    public void setPendingDump(boolean bl) {
        this.m_bPendingDump = bl;
    }

    public boolean isDumping() {
        return this.m_bDumping;
    }

    public void setDumping(boolean bl) {
        this.m_bDumping = bl;
    }

    public boolean isRapidfire() {
        return this.rapidfire;
    }

    public void setRapidfire(boolean bl) {
        this.rapidfire = bl;
    }

    public int getLocation() {
        return this.location;
    }

    public boolean isRearMounted() {
        return this.rearMounted;
    }

    public void setLocation(int n) {
        this.setLocation(n, false);
    }

    public void setLocation(int n, boolean bl) {
        this.location = n;
        this.rearMounted = bl;
    }

    public Mounted getLinked() {
        return this.linked;
    }

    public Mounted getLinkedBy() {
        return this.linkedBy;
    }

    public void setLinked(Mounted mounted) {
        this.linked = mounted;
        mounted.setLinkedBy(this);
    }

    protected void setLinkedBy(Mounted mounted) {
        if (mounted.getLinked() != this) {
            return;
        }
        this.linkedBy = mounted;
    }

    public int getFoundCrits() {
        return this.nFoundCrits;
    }

    public void setFoundCrits(int n) {
        this.nFoundCrits = n;
    }

    public boolean isSplit() {
        return this.bSplit;
    }

    public void setSplit(boolean bl) {
        this.bSplit = bl;
    }

    public int getExplosionDamage() {
        if (this.type instanceof AmmoType) {
            AmmoType ammoType = (AmmoType)this.type;
            return ammoType.getDamagePerShot() * ammoType.getRackSize() * this.shotsLeft;
        }
        if (this.type instanceof WeaponType) {
            WeaponType weaponType = (WeaponType)this.type;
            if (weaponType.getAmmoType() == 6) {
                return 20;
            }
            if (weaponType.getAmmoType() == 21) {
                return 16;
            }
            if (weaponType.getAmmoType() == 22) {
                return 25;
            }
            if (weaponType.getAmmoType() == 23 || weaponType.getAmmoType() == 1) {
                return weaponType.getDamage();
            }
        }
        System.err.println("mounted: unable to determine explosion damage for " + this.getName());
        return 0;
    }

    public boolean isFired() {
        return this.fired;
    }

    public void setFired(boolean bl) {
        this.fired = bl;
    }

    public boolean canFire() {
        if (!this.isReady() || this.isBreached() || this.isMissing()) {
            return false;
        }
        return !this.entity.isShutDown() && this.entity.getCrew().isActive();
    }

    public boolean isAmmoUsable() {
        return !this.destroyed && !this.m_bDumping && !this.useless && this.shotsLeft > 0 && this.location != -1;
    }

    public int getMineType() {
        return this.mineType;
    }

    public void setMineType(int n) {
        this.mineType = n;
    }

    public void setVibraSetting(int n) {
        this.vibraSetting = n;
    }

    public int getVibraSetting() {
        return this.vibraSetting;
    }
}

