/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.Enumeration;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.MovePath;
import megamek.common.Protomech;
import megamek.common.QuadMech;
import megamek.common.Tank;
import megamek.common.Targetable;
import megamek.common.VTOL;

public class MoveStep
implements Serializable {
    private int type = 0;
    private int targetId = -1;
    private int targetType = 0;
    private Coords position;
    private int facing;
    private int mp;
    private int mpUsed;
    private int heat;
    private int totalHeat;
    private int distance;
    private int elevation = -999;
    private int mineToLay = -1;
    private int movementType;
    private boolean isProne;
    private boolean isHullDown;
    private boolean danger;
    private boolean pastDanger;
    private boolean isUsingMASC;
    private int targetNumberMASC;
    private boolean firstStep;
    private boolean isTurning;
    private boolean isUnloaded;
    private boolean hasEverUnloaded;
    private boolean prevStepOnPavement;
    private boolean hasJustStood;
    private boolean thisStepBackwards;
    private boolean onlyPavement;
    private boolean isPavementStep;
    private boolean isRunProhibited = false;
    private boolean isStackingViolation = false;
    private MovePath parent = null;
    private boolean terrainInvalid = false;
    private boolean isEndPos = true;

    public MoveStep(MovePath movePath, int n) {
        this.type = n;
        this.parent = movePath;
        this.hasEverUnloaded = n == 17;
    }

    public MoveStep(MovePath movePath, int n, Targetable targetable) {
        this(movePath, n);
        this.targetId = targetable.getTargetId();
        this.targetType = targetable.getTargetType();
        this.hasEverUnloaded = n == 17;
    }

    public MoveStep(MovePath movePath, int n, int n2) {
        this(movePath, n);
        this.mineToLay = n2;
    }

    void setParent(MovePath movePath) {
        this.parent = movePath;
    }

    public String toString() {
        switch (this.type) {
            case 2: {
                return "B";
            }
            case 8: {
                return "Ch";
            }
            case 9: {
                return "DFA";
            }
            case 1: {
                return "F";
            }
            case 5: {
                return "Up";
            }
            case 6: {
                return "Prone";
            }
            case 7: {
                return "StrJump";
            }
            case 3: {
                return "L";
            }
            case 4: {
                return "R";
            }
            case 11: {
                return "ShL";
            }
            case 12: {
                return "ShR";
            }
            case 13: {
                return "ShLB";
            }
            case 14: {
                return "ShRB";
            }
            case 15: {
                return "Unjam";
            }
            case 22: {
                return "SLight";
            }
            case 16: {
                return "Load";
            }
            case 17: {
                return "Unload";
            }
            case 18: {
                return "Eject";
            }
            case 20: {
                return "U";
            }
            case 21: {
                return "D";
            }
            case 24: {
                return "HullDown";
            }
        }
        return "???";
    }

    public int getType() {
        return this.type;
    }

    public MovePath getParent() {
        return this.parent;
    }

    public void setTarget(Targetable targetable) {
        if (targetable == null) {
            this.targetId = -1;
            this.targetType = 0;
        } else {
            this.targetId = targetable.getTargetId();
            this.targetType = targetable.getTargetType();
        }
    }

    public Targetable getTarget(IGame iGame) {
        if (this.targetId == -1) {
            return null;
        }
        return iGame.getTarget(this.targetType, this.targetId);
    }

    protected void compile(IGame iGame, Entity entity, MoveStep moveStep) {
        boolean bl = entity instanceof Infantry;
        this.copy(iGame, moveStep);
        if (moveStep == null) {
            this.setFirstStep(true);
            moveStep = new MoveStep(this.parent, 1);
            moveStep.setFromEntity(entity, iGame);
        }
        IHex iHex = iGame.getBoard().getHex(this.getPosition());
        switch (this.getType()) {
            case 17: {
                this.hasEverUnloaded = true;
                break;
            }
            case 16: {
                this.setMp(1);
                break;
            }
            case 3: 
            case 4: {
                if (Compute.canMoveOnPavement(iGame, moveStep.getPosition(), this.getPosition())) {
                    this.setPavementStep(true);
                } else {
                    this.setPavementStep(false);
                    this.setOnlyPavement(false);
                }
                this.setMp(this.parent.isJumping() || this.isHasJustStood() || bl ? 0 : 1);
                this.adjustFacing(this.getType());
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: {
                if (this.getType() == 2) {
                    this.moveInDir((this.getFacing() + 3) % 6);
                    this.setThisStepBackwards(true);
                    this.setRunProhibited(true);
                } else {
                    this.moveInDir(this.getFacing());
                    this.setThisStepBackwards(false);
                }
                if (Compute.canMoveOnPavement(iGame, moveStep.getPosition(), this.getPosition())) {
                    this.setPavementStep(true);
                } else {
                    this.setPavementStep(false);
                    this.setOnlyPavement(false);
                }
                this.calcMovementCostFor(iGame, moveStep.getPosition());
                if (!(this.isPavementStep() || iHex.terrainLevel(4) <= 0 || iHex.containsTerrain(20) && this.elevation >= 0 || entity.getMovementMode() == 5 || entity.getMovementMode() == 7 || entity.getMovementMode() == 8 || entity.getMovementMode() == 9 || entity.getMovementMode() == 6)) {
                    this.setRunProhibited(true);
                }
                this.setHasJustStood(false);
                if (moveStep.isThisStepBackwards() != this.isThisStepBackwards()) {
                    this.setDistance(0);
                }
                this.addDistance(1);
                this.setElevation(entity.calcElevation(iGame.getBoard().getHex(moveStep.getPosition()), iGame.getBoard().getHex(this.getPosition()), this.elevation));
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                if (this.getType() == 13 || this.getType() == 14) {
                    this.moveInDir((MovePath.getAdjustedFacing(this.getFacing(), MovePath.turnForLateralShift(this.getType())) + 3) % 6);
                    this.setThisStepBackwards(true);
                    this.setRunProhibited(true);
                } else {
                    this.moveInDir(MovePath.getAdjustedFacing(this.getFacing(), MovePath.turnForLateralShift(this.getType())));
                    this.setThisStepBackwards(false);
                }
                if (Compute.canMoveOnPavement(iGame, moveStep.getPosition(), this.getPosition())) {
                    this.setPavementStep(true);
                } else {
                    this.setPavementStep(false);
                    this.setOnlyPavement(false);
                }
                this.calcMovementCostFor(iGame, moveStep.getPosition());
                this.setMp(this.getMp() + 1);
                if (!(this.isPavementStep() || iHex.terrainLevel(4) <= 0 || iHex.containsTerrain(20) && this.elevation >= 0 || entity.getMovementMode() == 6)) {
                    this.setRunProhibited(true);
                }
                this.setHasJustStood(false);
                if (moveStep.isThisStepBackwards() != this.isThisStepBackwards()) {
                    this.setDistance(0);
                }
                this.addDistance(1);
                break;
            }
            case 5: {
                this.setMp(entity.getRunMP() == 1 ? 1 : 2);
                this.setHasJustStood(true);
                break;
            }
            case 6: {
                this.setMp(1);
                break;
            }
            case 7: {
                break;
            }
            case 20: {
                this.setElevation(this.elevation + 1);
                this.setMp(1);
                break;
            }
            case 21: {
                this.setElevation(this.elevation - 1);
                this.setMp(1);
                break;
            }
            case 24: {
                this.setMp(2);
                break;
            }
            default: {
                this.setMp(0);
            }
        }
        this.addMpUsed(this.getMp());
        int n = iHex.terrainLevel(24);
        if (iHex.containsTerrain(7) || n == 1) {
            this.heat = 2;
            this.totalHeat += 2;
        } else if (n == 2) {
            this.heat = 5;
            this.totalHeat += 5;
        }
        Entity entity2 = Compute.stackingViolation(iGame, entity.getId(), this.getPosition());
        if (entity2 != null && this.getType() != 8 && this.getType() != 9) {
            this.setStackingViolation(true);
        }
        this.compileIllegal(iGame, entity, moveStep);
    }

    boolean oppositeTurn(MoveStep moveStep) {
        switch (this.type) {
            case 3: {
                return moveStep.getType() == 4;
            }
            case 4: {
                return moveStep.getType() == 3;
            }
        }
        return false;
    }

    public void setElevation(int n) {
        this.elevation = n;
    }

    public void copy(IGame iGame, MoveStep moveStep) {
        if (moveStep == null) {
            this.setFromEntity(this.parent.getEntity(), iGame);
            return;
        }
        this.hasJustStood = moveStep.hasJustStood;
        this.facing = moveStep.getFacing();
        this.position = moveStep.getPosition();
        this.distance = moveStep.getDistance();
        this.mpUsed = moveStep.mpUsed;
        this.totalHeat = moveStep.totalHeat;
        this.isPavementStep = moveStep.isPavementStep;
        this.onlyPavement = moveStep.onlyPavement;
        this.thisStepBackwards = moveStep.thisStepBackwards;
        this.isProne = moveStep.isProne;
        this.isHullDown = moveStep.isHullDown;
        this.isRunProhibited = moveStep.isRunProhibited;
        this.hasEverUnloaded = moveStep.hasEverUnloaded;
        this.elevation = moveStep.elevation;
    }

    public void setFromEntity(Entity entity, IGame iGame) {
        IHex iHex;
        this.position = entity.getPosition();
        this.facing = entity.getFacing();
        this.mpUsed = entity.mpUsed;
        this.distance = entity.delta_distance;
        this.isProne = entity.isProne();
        this.isHullDown = entity.isHullDown();
        this.elevation = entity.getElevation();
        if (this.position != null && (iHex = iGame.getBoard().getHex(this.position)).hasPavement()) {
            this.onlyPavement = true;
            this.isPavementStep = true;
        }
    }

    public void adjustFacing(int n) {
        this.facing = MovePath.getAdjustedFacing(this.facing, n);
    }

    public void moveInDir(int n) {
        this.position = this.position.translated(n);
        if (!this.parent.game.getBoard().contains(this.position)) {
            throw new RuntimeException("Coordinate off the board.");
        }
    }

    public void addDistance(int n) {
        this.distance += n;
    }

    public void addMpUsed(int n) {
        this.mpUsed += n;
    }

    public boolean isDanger() {
        return this.danger;
    }

    public int getDistance() {
        return this.distance;
    }

    public int getFacing() {
        return this.facing;
    }

    public boolean isFirstStep() {
        return this.firstStep;
    }

    public boolean isHasJustStood() {
        return this.hasJustStood;
    }

    public boolean isPavementStep() {
        return this.isPavementStep;
    }

    public boolean isProne() {
        return this.isProne;
    }

    public boolean isHullDown() {
        return this.isHullDown;
    }

    public boolean isTurning() {
        return this.isTurning;
    }

    public boolean isUnloaded() {
        return this.isUnloaded;
    }

    public boolean isUsingMASC() {
        return this.isUsingMASC;
    }

    public boolean isLegal() {
        return this.movementType != -1 && (this.isLegalEndPos() || !this.isEndPos);
    }

    public int getMovementType() {
        int n = this.movementType;
        if (!this.isLegalEndPos() && this.isEndPos) {
            n = -1;
        }
        return n;
    }

    public boolean isLegalEndPos() {
        boolean bl = true;
        if (this.isStackingViolation) {
            bl = false;
        } else if (this.terrainInvalid) {
            bl = false;
        } else if (this.parent.isJumping() && this.distance == 0) {
            bl = false;
        } else if (this.hasEverUnloaded && this.type != 17) {
            bl = false;
        }
        return bl;
    }

    public boolean setEndPos(boolean bl) {
        if (-1 == this.movementType) {
            bl = true;
        }
        boolean bl2 = this.isEndPos != bl;
        this.isEndPos = bl;
        return bl2;
    }

    public int getMpUsed() {
        return this.mpUsed;
    }

    public boolean isOnlyPavement() {
        return this.onlyPavement;
    }

    public boolean isPastDanger() {
        return this.pastDanger;
    }

    public Coords getPosition() {
        return this.position;
    }

    public boolean isPrevStepOnPavement() {
        return this.prevStepOnPavement;
    }

    public int getTargetNumberMASC() {
        return this.targetNumberMASC;
    }

    public boolean isThisStepBackwards() {
        return this.thisStepBackwards;
    }

    public void setDanger(boolean bl) {
        this.danger = bl;
    }

    public void setDistance(int n) {
        this.distance = n;
    }

    public void setFacing(int n) {
        this.facing = n;
    }

    public void setFirstStep(boolean bl) {
        this.firstStep = bl;
    }

    public void setHasJustStood(boolean bl) {
        this.hasJustStood = bl;
    }

    public void setPavementStep(boolean bl) {
        this.isPavementStep = bl;
    }

    public void setProne(boolean bl) {
        this.isProne = bl;
    }

    public void setHullDown(boolean bl) {
        this.isHullDown = bl;
    }

    public void setTurning(boolean bl) {
        this.isTurning = bl;
    }

    public void setUnloaded(boolean bl) {
        this.isUnloaded = bl;
        if (bl) {
            this.hasEverUnloaded = true;
        }
    }

    public void setUsingMASC(boolean bl) {
        this.isUsingMASC = bl;
    }

    public void setMovementType(int n) {
        this.movementType = n;
    }

    public void setOnlyPavement(boolean bl) {
        this.onlyPavement = bl;
    }

    public void setTargetNumberMASC(int n) {
        this.targetNumberMASC = n;
    }

    public void setThisStepBackwards(boolean bl) {
        this.thisStepBackwards = bl;
    }

    public int getMp() {
        return this.mp;
    }

    public void setMp(int n) {
        this.mp = n;
    }

    void setRunProhibited(boolean bl) {
        this.isRunProhibited = bl;
    }

    boolean isRunProhibited() {
        return this.isRunProhibited;
    }

    void setStackingViolation(boolean bl) {
        this.isStackingViolation = bl;
    }

    boolean isStackingViolation() {
        return this.isStackingViolation;
    }

    void compileIllegal(IGame iGame, Entity entity, MoveStep moveStep) {
        Targetable targetable;
        int n = this.getType();
        boolean bl = entity instanceof Infantry;
        Coords coords = this.getPosition();
        Coords coords2 = moveStep.getPosition();
        boolean bl2 = entity.isUnjammingRAC();
        this.prevStepOnPavement = moveStep.isPavementStep();
        this.isTurning = moveStep.isTurning();
        this.isUnloaded = moveStep.isUnloaded();
        if (bl && this.getMpUsed() - this.getMp() == 0) {
            this.setFirstStep(true);
        }
        this.movementType = -1;
        if (this.type == 10 && entity.canFlee()) {
            this.movementType = -3;
        }
        if (this.type == 23 && entity.canLayMine()) {
            this.movementType = -3;
        }
        if (this.type == 18) {
            this.movementType = 0;
        }
        if (this.type == 22) {
            this.movementType = 0;
        }
        if (this.type == 15) {
            this.movementType = 0;
        }
        if (this.type == 19 && entity instanceof Infantry) {
            this.movementType = 0;
        }
        if (!(!this.parent.isJumping() || this.getMpUsed() > entity.getJumpMPWithTerrain() || this.isProne() || this.isHullDown() || entity instanceof Protomech && entity.getInternal(4) == -3 || entity.isStuck() && !entity.canUnstickByJumping())) {
            this.movementType = 3;
        }
        if (this.isFirstStep() && entity instanceof Protomech && entity.getInternal(4) == -3 && (n == 3 || n == 4) && !entity.isStuck()) {
            this.movementType = 1;
        }
        if (bl && (n == 3 || n == 4) && this.isFirstStep()) {
            this.movementType = this.parent.isJumping() ? 3 : 1;
        }
        int n2 = entity.getWalkMP();
        if (this.parent.getEntity().getMovementMode() == 6 && this.getElevation() != 0 && !(this.parent.getEntity() instanceof VTOL)) {
            n2 = entity.getJumpMP();
        }
        if (!(this.parent.isJumping() || entity.isStuck() || n2 <= 0 || this.getMpUsed() <= 0 || (this.isProne() || this.isHullDown()) && !this.parent.contains(5) && n != 3 && n != 4)) {
            if (this.getMpUsed() <= n2) {
                this.movementType = this.parent.getEntity().getMovementMode() == 6 && this.getElevation() > 0 ? 4 : 1;
            } else if (entity instanceof Tank && !(entity instanceof VTOL) && this.isOnlyPavement() && this.getMpUsed() == n2 + 1) {
                this.movementType = 1;
                entity.gotPavementBonus = true;
            } else if (this.getMpUsed() <= entity.getRunMPwithoutMASC() && !this.isRunProhibited()) {
                this.movementType = this.parent.getEntity().getMovementMode() == 6 ? 5 : 2;
            } else if (this.getMpUsed() <= entity.getRunMP() && !this.isRunProhibited()) {
                this.setUsingMASC(true);
                targetable = (Mech)entity;
                this.setTargetNumberMASC(((Mech)targetable).getMASCTarget());
                this.movementType = 2;
            } else if (entity instanceof Tank && !(entity instanceof VTOL) && this.isOnlyPavement() && this.getMpUsed() <= entity.getRunMP() + 1 && !this.isRunProhibited()) {
                this.movementType = 2;
                entity.gotPavementBonus = true;
            }
        }
        if (entity.getBadCriticals(0, 4, 1) > 1 && !this.isFirstStep()) {
            this.movementType = -1;
        }
        if (5 == n && 1 == entity.getRunMP() && entity.mpUsed < 1 && !entity.isStuck()) {
            this.movementType = 2;
        }
        if (this.isFirstStep() && this.movementType == -1 && entity.getWalkMP() > 0 && !entity.isProne() && !entity.isHullDown() && !entity.isStuck() && n == 1) {
            this.movementType = 2;
        }
        if (n == 17) {
            if (this.isFirstStep() && this.getMpUsed() <= entity.getRunMP()) {
                this.movementType = 2;
                if (this.getMpUsed() <= entity.getWalkMP()) {
                    this.movementType = 1;
                }
            }
            if (this.getMpUsed() <= entity.getRunMP() && (entity.isProne() || entity.isHullDown()) && this.movementType == -1) {
                this.movementType = 2;
                if (this.getMpUsed() <= entity.getWalkMP()) {
                    this.movementType = 1;
                }
            }
            if ((targetable = this.getTarget(iGame)) instanceof Entity) {
                Entity entity2 = (Entity)targetable;
                if (null != Compute.stackingViolation(iGame, entity2, coords, entity) || entity2.isHexProhibited(iGame.getBoard().getHex(coords))) {
                    this.movementType = -1;
                }
            } else {
                this.movementType = -1;
            }
        }
        if (bl2 && (this.movementType == 2 || this.movementType == 5 || this.parent.isJumping())) {
            this.movementType = -1;
        }
        if (n == 6 && (this.isProne() || !(entity instanceof Mech) || entity.isStuck())) {
            this.movementType = -1;
        }
        if (n == 24) {
            if (this.isProne() || this.isHullDown() || !(entity instanceof QuadMech) && !(entity instanceof Tank) || entity.isStuck()) {
                this.movementType = -1;
            }
            if (entity instanceof Tank && !iGame.getBoard().getHex(coords).containsTerrain(21)) {
                this.movementType = -1;
            }
        }
        if (!this.isMovementPossible(iGame, coords2) || this.isUnloaded) {
            this.movementType = -1;
        }
        if (moveStep != null && -1 == moveStep.movementType) {
            this.movementType = -1;
        }
        if (this.movementType == -1) {
            return;
        }
        int n3 = this.getElevation();
        if (moveStep != null) {
            n3 = moveStep.getElevation();
        }
        this.danger |= Compute.isPilotingSkillNeeded(iGame, entity.getId(), coords2, coords, this.movementType, this.isTurning, this.prevStepOnPavement, n3, this.getElevation());
        if (n == 5) {
            this.danger = true;
        }
        this.pastDanger |= this.danger;
        switch (n) {
            case 3: 
            case 4: {
                this.setTurning(true);
                break;
            }
            case 17: {
                this.setUnloaded(true);
                break;
            }
            default: {
                this.setTurning(false);
            }
        }
        if (n == 6) {
            this.setProne(true);
            this.setHullDown(false);
        } else if (n == 5) {
            this.setProne(false);
            this.setHullDown(false);
        } else if (n == 24) {
            this.setProne(false);
            this.setHullDown(true);
        }
    }

    public int getTotalHeat() {
        return this.totalHeat;
    }

    public int getHeat() {
        return this.heat;
    }

    protected void calcMovementCostFor(IGame iGame, Coords coords) {
        int n = this.parent.getEntity().getMovementMode();
        IHex iHex = iGame.getBoard().getHex(coords);
        IHex iHex2 = iGame.getBoard().getHex(this.getPosition());
        boolean bl = this.parent.getEntity() instanceof Infantry;
        int n2 = this.parent.getEntity().elevationOccupied(iHex);
        int n3 = this.parent.getEntity().elevationOccupied(iHex2);
        int n4 = this.parent.getEntity().getMovementMode();
        this.mp = 1;
        if (this.parent.isJumping()) {
            return;
        }
        if (this.parent.getEntity().getMovementMode() == 6) {
            return;
        }
        if (!this.isPavementStep) {
            this.mp += iHex2.movementCost(n);
            if (!(n == 5 || n == 7 || n == 8 || n == 9 || n == 6 || iHex2.containsTerrain(20) && n3 >= iHex2.surface())) {
                if (iHex2.terrainLevel(4) == 1) {
                    ++this.mp;
                } else if (iHex2.terrainLevel(4) > 1) {
                    this.mp += 3;
                }
            }
        }
        if (n2 != n3) {
            int n5 = Math.abs(n2 - n3);
            if (bl && this.movementType != 4 && this.movementType != 5 || n4 == 3 || n4 == 4 || n4 == 5) {
                n5 *= 2;
            }
            this.mp += n5;
        }
        if (n3 < iHex2.terrainLevel(12) && !bl) {
            Building building = iGame.getBoard().getBuildingAt(this.getPosition());
            this.mp += building.getType();
        }
    }

    public boolean isMovementPossible(IGame iGame, Coords coords) {
        Enumeration enumeration;
        IHex iHex = iGame.getBoard().getHex(coords);
        Coords coords2 = this.getPosition();
        IHex iHex2 = iGame.getBoard().getHex(coords2);
        Entity entity = this.parent.getEntity();
        if (null == coords2) {
            throw new IllegalStateException("Step has no position.");
        }
        if (coords.distance(coords2) > 1) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Coordinates ").append(coords.toString()).append(" and ").append(coords2.toString()).append(" are not adjacent.");
            throw new IllegalArgumentException(stringBuffer.toString());
        }
        if (entity instanceof Tank && !entity.getCrew().isUnconscious() && (this.type == 15 || this.type == 18 || this.type == 22)) {
            return true;
        }
        if (entity.isImmobile()) {
            return false;
        }
        if (!iGame.getBoard().contains(coords2)) {
            return false;
        }
        if (iHex2.containsTerrain(30)) {
            return false;
        }
        if (!(entity instanceof VTOL) && this.isThisStepBackwards() && entity.elevationOccupied(iHex2) != entity.elevationOccupied(iHex)) {
            return false;
        }
        if (-1 != entity.getSwarmTargetId()) {
            return false;
        }
        if (this.type == 16) {
            if (!this.firstStep) {
                return false;
            }
            Entity entity2 = null;
            enumeration = iGame.getEntities(coords);
            while (enumeration.hasMoreElements()) {
                entity2 = (Entity)enumeration.nextElement();
                if (entity.getOwner() == entity2.getOwner() && !entity.equals(entity2)) {
                    if (!entity.canLoad(entity2)) {
                        return false;
                    }
                    if (entity2.isSelectableThisTurn()) break;
                    return false;
                }
                entity2 = null;
            }
            if (entity2 == null) {
                return false;
            }
        }
        boolean bl = false;
        enumeration = entity.getAmmo();
        while (enumeration.hasMoreElements()) {
            if (!((Mounted)enumeration.nextElement()).isDumping()) continue;
            bl = true;
            break;
        }
        if (bl && (this.movementType == 2 || this.movementType == 5 || this.movementType == 3)) {
            return false;
        }
        int n = entity.elevationOccupied(iHex);
        int n2 = entity.elevationOccupied(iHex2);
        int n3 = entity.getMovementMode();
        if (this.movementType == 3 && n3 == 6) {
            return false;
        }
        if (this.movementType != 3 && n3 != 6 && Math.abs(n - n2) > entity.getMaxElevationChange()) {
            return false;
        }
        if (!(this.type != 2 && this.type != 13 && this.type != 14 || n == n2 || entity instanceof VTOL)) {
            return false;
        }
        if (!(this.movementType != 2 && this.movementType != 5 || n3 == 5 || n3 == 7 || n3 == 8 || n3 == 9 || n3 == 6 || iHex2.terrainLevel(4) <= 0 || iHex2.containsTerrain(20) && n2 >= iHex2.surface() || coords2.equals(entity.getPosition()) || this.firstStep || this.isPavementStep)) {
            return false;
        }
        if (!this.parent.isJumping() && this.type != 8 && this.type != 9) {
            if (entity instanceof Mech && Compute.isEnemyIn(iGame, entity.getId(), coords2, true)) {
                return false;
            }
            if (Compute.isEnemyIn(iGame, entity.getId(), coords, false, this.getElevation()) && !coords.equals(entity.getPosition()) && this.type != 3 && this.type != 4 && this.type != 17 && this.type != 6) {
                return false;
            }
        }
        if (this.movementType == 3 && iHex2.getElevation() > entity.getElevation() + entity.game.getBoard().getHex(entity.getPosition()).getElevation() + entity.getJumpMPWithTerrain()) {
            return false;
        }
        if (entity.isHexProhibited(iHex2) && !this.isPavementStep() && this.movementType != 4 && this.movementType != 5) {
            if (this.parent.isJumping()) {
                this.terrainInvalid = true;
            } else {
                return false;
            }
        }
        if (this.movementType != 3 && this.movementType != 4 && this.movementType != 5 && entity.isHexProhibited(iHex) && !this.isPavementStep) {
            return false;
        }
        if (this.type == 20 && !entity.canGoUp(this.elevation - 1, this.getPosition())) {
            return false;
        }
        if (this.type == 21 && !entity.canGoDown(this.elevation + 1, this.getPosition())) {
            return false;
        }
        if (entity instanceof VTOL && (this.type == 2 || this.type == 1 || this.type == 3 || this.type == 4) && this.elevation == 0) {
            return false;
        }
        if (entity instanceof VTOL && (this.type == 2 || this.type == 1) && this.elevation <= iHex2.ceiling() - iHex2.surface()) {
            return false;
        }
        return entity.isElevationValid(this.elevation, this.getPosition());
    }

    public boolean canReuseSprite(MoveStep moveStep) {
        boolean bl = false;
        if (this.type == moveStep.type && this.facing == moveStep.facing && this.mpUsed == moveStep.mpUsed && this.movementType == moveStep.movementType && this.isProne == moveStep.isProne && this.isHullDown == moveStep.isHullDown && this.danger == moveStep.danger && this.pastDanger == moveStep.pastDanger && this.isUsingMASC == moveStep.isUsingMASC && this.targetNumberMASC == moveStep.targetNumberMASC && this.isPavementStep == moveStep.isPavementStep && this.isLegalEndPos() && moveStep.isLegalEndPos()) {
            bl = true;
        }
        return bl;
    }

    public int getElevation() {
        return this.elevation;
    }

    public int getMineToLay() {
        return this.mineToLay;
    }

    public void setMineToLay(int n) {
        this.mineToLay = n;
    }
}

