/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.util.Vector;
import megamek.common.Entity;
import megamek.common.Infantry;
import megamek.common.Transporter;

public final class TroopSpace
implements Transporter {
    Vector troops = new Vector();
    int totalSpace;
    int currentSpace;

    protected TroopSpace() {
        this.totalSpace = 0;
        this.currentSpace = 0;
    }

    public TroopSpace(int n) {
        this.totalSpace = n;
        this.currentSpace = n;
    }

    public boolean canLoad(Entity entity) {
        boolean bl = true;
        if (!(entity instanceof Infantry)) {
            bl = false;
        } else if (this.currentSpace < (int)entity.getWeight()) {
            bl = false;
        }
        return bl;
    }

    public void load(Entity entity) throws IllegalArgumentException {
        if (!this.canLoad(entity)) {
            throw new IllegalArgumentException("Can not load " + entity.getShortName() + " into this troop space.");
        }
        this.currentSpace = (int)((float)this.currentSpace - entity.getWeight());
        this.troops.addElement(entity);
    }

    public Vector getLoadedUnits() {
        return (Vector)this.troops.clone();
    }

    public boolean unload(Entity entity) {
        boolean bl = this.troops.removeElement(entity);
        if (bl) {
            this.currentSpace = (int)((float)this.currentSpace + entity.getWeight());
        }
        return bl;
    }

    public String getUnusedString() {
        return "Troops - " + this.currentSpace + " tons";
    }

    public boolean isWeaponBlockedAt(int n, boolean bl) {
        return false;
    }

    public Entity getExteriorUnitAt(int n, boolean bl) {
        return null;
    }
}

