/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.actions;

import megamek.common.BattleArmor;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Mech;
import megamek.common.Tank;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.actions.AbstractAttackAction;

public class PunchAttackAction
extends AbstractAttackAction {
    public static final int BOTH = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    private int arm;

    public PunchAttackAction(int n, int n2, int n3) {
        super(n, n2);
        this.arm = n3;
    }

    public PunchAttackAction(int n, int n2, int n3, int n4) {
        super(n, n2, n3);
        this.arm = n4;
    }

    public int getArm() {
        return this.arm;
    }

    public void setArm(int n) {
        this.arm = n;
    }

    public ToHitData toHit(IGame iGame) {
        return PunchAttackAction.toHit(iGame, this.getEntityId(), iGame.getTarget(this.getTargetType(), this.getTargetId()), this.getArm());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ToHitData toHit(IGame iGame, int n, Targetable targetable, int n2) {
        Entity entity = iGame.getEntity(n);
        int n3 = -1;
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
            n3 = targetable.getTargetId();
        }
        if (entity == null) {
            return new ToHitData(Integer.MAX_VALUE, "You can't attack from a null entity!");
        }
        if (entity2 == null) {
            return new ToHitData(Integer.MAX_VALUE, "You can't target a null entity!");
        }
        IHex iHex = iGame.getBoard().getHex(entity.getPosition());
        IHex iHex2 = iGame.getBoard().getHex(entity2.getPosition());
        int n4 = entity.absHeight() + iHex.getElevation();
        int n5 = targetable.getElevation() + iHex2.getElevation();
        int n6 = n5 + targetable.getHeight();
        int n7 = n2 == 2 ? 4 : 5;
        int n8 = n2 == 2 ? 3 : 2;
        boolean bl = Compute.isInBuilding(iGame, entity2);
        Building building = null;
        if (bl) {
            building = iGame.getBoard().getBuildingAt(entity2.getPosition());
        }
        if (n2 != 2 && n2 != 1) {
            throw new IllegalArgumentException("Arm must be LEFT or RIGHT");
        }
        if (entity == null || targetable == null) {
            throw new IllegalArgumentException("Attacker or target not valid");
        }
        if (entity.equals(entity2)) {
            return new ToHitData(Integer.MAX_VALUE, "You can't target yourself");
        }
        if (!(entity instanceof Mech)) {
            return new ToHitData(Integer.MAX_VALUE, "Non-mechs can't punch");
        }
        if (entity2 != null && -1 != entity2.getTransportId()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is a passenger.");
        }
        if (entity2 != null && -1 != entity2.getSwarmTargetId()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is swarming a Mek.");
        }
        if (entity.isSpotting()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is spotting this turn");
        }
        if (entity.entityIsQuad()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is a quad");
        }
        if (entity.getArmsFlipped()) {
            return new ToHitData(Integer.MAX_VALUE, "Arms are flipped to the rear. Can not punch.");
        }
        if (entity.isLocationBad(n7)) {
            return new ToHitData(Integer.MAX_VALUE, "Arm missing");
        }
        if (!entity.hasWorkingSystem(7, n7)) {
            return new ToHitData(Integer.MAX_VALUE, "Shoulder destroyed");
        }
        if (entity.weaponFiredFrom(n7)) {
            return new ToHitData(Integer.MAX_VALUE, "Weapons fired from arm this turn");
        }
        if (entity.getPosition().distance(targetable.getPosition()) > 1) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in range");
        }
        if (n4 < n5 || n4 > n6) {
            return new ToHitData(Integer.MAX_VALUE, "Target elevation not in range");
        }
        if (entity2 != null && entity2.isMakingDfa()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is making a DFA attack");
        }
        if (bl) {
            if (!Compute.isInBuilding(iGame, entity)) {
                return new ToHitData(Integer.MAX_VALUE, "Target is inside building");
            }
            if (!iGame.getBoard().getBuildingAt(entity.getPosition()).equals(building)) {
                return new ToHitData(Integer.MAX_VALUE, "Target is inside differnt building");
            }
        }
        int n9 = 4;
        if (iGame.getOptions().booleanOption("maxtech_physical_BTH")) {
            n9 = entity.getCrew().getPiloting() - 1;
        }
        ToHitData toHitData = new ToHitData(n9, "base");
        if (entity.isProne()) {
            if (entity.isLocationBad(4) || entity.isLocationBad(5) || !(entity2 instanceof Tank) || entity.getPosition().distance(targetable.getPosition()) != 0) return new ToHitData(Integer.MAX_VALUE, "Attacker is prone");
            toHitData.addModifier(2, "attacker is prone");
        } else if (!Compute.isInArc(entity.getPosition(), entity.getSecondaryFacing(), targetable.getPosition(), n8)) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in arc");
        }
        if (targetable.getTargetType() == 3) {
            return new ToHitData(Integer.MIN_VALUE, "Targeting adjacent building.");
        }
        if (targetable.getTargetType() == 4 || targetable.getTargetType() == 1 || targetable.getTargetType() == 2) {
            return new ToHitData(Integer.MAX_VALUE, "Invalid attack");
        }
        if (entity2 instanceof BattleArmor) {
            toHitData.addModifier(1, "battle armor target");
        }
        toHitData.append(Compute.getAttackerMovementModifier(iGame, n));
        toHitData.append(Compute.getTargetMovementModifier(iGame, n3));
        toHitData.append(Compute.getAttackerTerrainModifier(iGame, n));
        toHitData.append(Compute.getTargetTerrainModifier(iGame, entity2));
        if (!entity.hasWorkingSystem(8, n7)) {
            toHitData.addModifier(2, "Upper arm actuator destroyed");
        }
        if (!entity.hasWorkingSystem(9, n7)) {
            toHitData.addModifier(2, "Lower arm actuator missing or destroyed");
        }
        if (!entity.hasWorkingSystem(10, n7)) {
            toHitData.addModifier(1, "Hand actuator missing or destroyed");
        }
        if (entity2.isProne()) {
            toHitData.addModifier(-2, "target prone and adjacent");
        }
        if (entity2.height() > 0 && entity2.getElevation() == -1 && iHex2.terrainLevel(4) == entity2.height()) {
            toHitData.addModifier(3, "target has partial cover");
        }
        toHitData.append(PunchAttackAction.nightModifiers(iGame, targetable, null, entity));
        toHitData.append(Compute.getImmobileMod(entity2));
        Compute.modifyPhysicalBTHForAdvantages(entity, entity2, toHitData, iGame);
        if (n4 == n5) {
            if (entity2.height() == 0) {
                toHitData.setHitTable(0);
            } else {
                toHitData.setHitTable(2);
            }
        } else {
            toHitData.setHitTable(1);
        }
        toHitData.setSideTable(Compute.targetSideTable(entity, entity2));
        return toHitData;
    }

    public static int getDamageFor(Entity entity, int n) {
        int n2 = n == 2 ? 4 : 5;
        int n3 = (int)Math.ceil((double)entity.getWeight() / 10.0);
        float f = 1.0f;
        if (!entity.hasWorkingSystem(8, n2)) {
            f /= 2.0f;
        }
        if (!entity.hasWorkingSystem(9, n2)) {
            f /= 2.0f;
        }
        if (!entity.hasWorkingSystem(7, n2)) {
            n3 = 0;
        }
        if (entity.heat >= 9 && ((Mech)entity).hasTSM()) {
            f *= 2.0f;
        }
        int n4 = (int)Math.floor((float)n3 * f) + entity.getCrew().modifyPhysicalDamagaForMeleeSpecialist();
        if (entity.getLocationStatus(n2) == 2) {
            n4 = (int)Math.ceil((float)n4 * 0.5f);
        }
        return n4;
    }
}

