/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.actions;

import java.util.Enumeration;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.HexTarget;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Infantry;
import megamek.common.LosEffects;
import megamek.common.Mech;
import megamek.common.MechWarrior;
import megamek.common.MinefieldTarget;
import megamek.common.Mounted;
import megamek.common.Protomech;
import megamek.common.Tank;
import megamek.common.TargetRoll;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.VTOL;
import megamek.common.WeaponType;
import megamek.common.actions.AbstractAttackAction;
import megamek.common.actions.AbstractEntityAction;

public class WeaponAttackAction
extends AbstractAttackAction {
    private int weaponId;
    private int ammoId = -1;
    private int aimedLocation = -1;
    private int aimMode = 0;
    private int otherAttackInfo = -1;
    private boolean nemesisConfused = false;
    private boolean swarmingMissiles = false;
    private int oldTargetId = -1;
    private transient Vector vCounterEquipment = null;

    public WeaponAttackAction(int n, int n2, int n3) {
        super(n, n2);
        this.weaponId = n3;
    }

    public WeaponAttackAction(int n, int n2, int n3, int n4) {
        super(n, n2, n3);
        this.weaponId = n4;
    }

    public int getWeaponId() {
        return this.weaponId;
    }

    public int getAmmoId() {
        return this.ammoId;
    }

    public int getAimedLocation() {
        return this.aimedLocation;
    }

    public int getAimingMode() {
        return this.aimMode;
    }

    public Vector getCounterEquipment() {
        return this.vCounterEquipment;
    }

    public void setWeaponId(int n) {
        this.weaponId = n;
    }

    public void setAmmoId(int n) {
        this.ammoId = n;
    }

    public void setAimedLocation(int n) {
        this.aimedLocation = n;
    }

    public void setAimingMode(int n) {
        this.aimMode = n;
    }

    public void addCounterEquipment(Mounted mounted) {
        if (this.vCounterEquipment == null) {
            this.vCounterEquipment = new Vector();
        }
        this.vCounterEquipment.addElement(mounted);
    }

    public void setOtherAttackInfo(int n) {
        this.otherAttackInfo = n;
    }

    public int getOtherAttackInfo() {
        return this.otherAttackInfo;
    }

    public ToHitData toHit(IGame iGame) {
        return WeaponAttackAction.toHit(iGame, this.getEntityId(), iGame.getTarget(this.getTargetType(), this.getTargetId()), this.getWeaponId(), this.getAimedLocation(), this.getAimingMode(), this.nemesisConfused, this.swarmingMissiles, iGame.getEntity(this.oldTargetId));
    }

    public static ToHitData toHit(IGame iGame, int n, Targetable targetable, int n2) {
        return WeaponAttackAction.toHit(iGame, n, targetable, n2, -1, 0, false);
    }

    public static ToHitData toHit(IGame iGame, int n, Targetable targetable, int n2, int n3, int n4) {
        return WeaponAttackAction.toHit(iGame, n, targetable, n2, n3, n4, false);
    }

    public static ToHitData toHit(IGame iGame, int n, Targetable targetable, int n2, int n3, int n4, boolean bl) {
        return WeaponAttackAction.toHit(iGame, n, targetable, n2, n3, n4, bl, false, null);
    }

    public static ToHitData toHit(IGame iGame, int n, Targetable targetable, int n2, int n3, int n4, boolean bl, boolean bl2, Entity entity) {
        Object object;
        EquipmentType equipmentType;
        Mounted mounted;
        Enumeration enumeration;
        ToHitData toHitData;
        LosEffects losEffects;
        Targetable targetable2;
        if (bl2) {
            targetable2 = targetable;
            targetable = entity;
            entity = (Entity)targetable2;
        }
        targetable2 = iGame.getEntity(n);
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
        }
        Mounted mounted2 = ((Entity)targetable2).getEquipment(n2);
        WeaponType weaponType = (WeaponType)mounted2.getType();
        boolean bl3 = targetable2 instanceof Infantry;
        boolean bl4 = weaponType.hasFlag(2048);
        boolean bl5 = weaponType.getAmmoType() != -1 && weaponType.getAmmoType() != -2 && weaponType.getAmmoType() != -3 && !bl4;
        Mounted mounted3 = bl5 ? mounted2.getLinked() : null;
        AmmoType ammoType = mounted3 == null ? null : (AmmoType)mounted3.getType();
        boolean bl6 = Compute.isInBuilding(iGame, entity2);
        boolean bl7 = (weaponType.getAmmoType() == 7 || weaponType.getAmmoType() == 8) && mounted2.curMode().equals("Indirect");
        boolean bl8 = ammoType != null && (ammoType.getAmmoType() == 9 || ammoType.getAmmoType() == 25) && ammoType.getMunitionType() == 0x400000L || bl4 && weaponType.hasFlag(1024);
        boolean bl9 = weaponType.hasFlag(65536) && iGame.getPhase() == 12;
        boolean bl10 = weaponType.hasFlag(65536) && (iGame.getPhase() == 7 || iGame.getPhase() == 10);
        boolean bl11 = bl9 && targetable.getTargetType() == 0 && entity2.getMovementMode() == 6 && entity2.getElevation() > 0 && bl5 && ammoType.getMunitionType() == 0L;
        boolean bl12 = weaponType.getInternalName() == "Particle Cannon" && iGame.getOptions().booleanOption("maxtech_ppc_inhibitors") && mounted2.curMode().equals("Field Inhibitor OFF");
        boolean bl13 = ((Entity)targetable2).isINarcedWith(4L);
        boolean bl14 = false;
        boolean bl15 = Compute.isAffectedByECM((Entity)targetable2, ((Entity)targetable2).getPosition(), targetable.getPosition());
        boolean bl16 = weaponType.hasFlag(0x8000000);
        boolean bl17 = false;
        if (!(entity2 == null || !entity2.isINarcedBy(((Entity)targetable2).getOwner().getTeam()) || ammoType == null || ammoType.getAmmoType() != 7 && ammoType.getAmmoType() != 9 || ammoType.getMunitionType() != 1024L || weaponType.getAmmoType() != 7 && weaponType.getAmmoType() != 9)) {
            bl14 = true;
        }
        int n5 = 0;
        int n6 = targetable.getTargetType();
        ToHitData toHitData2 = null;
        String string = null;
        string = WeaponAttackAction.toHitIsImpossible(iGame, (Entity)targetable2, targetable, mounted2, ammoType, weaponType, n6, bl2, bl5, entity2, bl16, bl8, bl3, bl7, n, n2, bl10, mounted3, bl11, bl6, bl9);
        if (string != null) {
            return new ToHitData(Integer.MAX_VALUE, string);
        }
        long l = 0L;
        if (ammoType != null) {
            l = ammoType.getMunitionType();
        }
        if (l == 0x20000000L) {
            bl17 = true;
        }
        int n7 = ((Entity)targetable2).absHeight();
        int n8 = entity2 == null ? iGame.getBoard().getHex(targetable.getPosition()).floor() : entity2.absHeight();
        Entity entity3 = null;
        if (bl7) {
            entity3 = Compute.findSpotter(iGame, (Entity)targetable2, targetable);
        }
        int n9 = 0;
        if (!bl7) {
            losEffects = LosEffects.calculateLos(iGame, n, targetable);
            if (((Entity)targetable2).hasActiveEiCockpit()) {
                n9 = losEffects.getLightWoods() > 0 ? 2 : 1;
            }
            toHitData = losEffects.losModifiers(iGame, n9);
        } else {
            losEffects = LosEffects.calculateLos(iGame, entity3.getId(), targetable);
            losEffects.setAttackerCover(0);
            if (entity3.hasActiveEiCockpit()) {
                n9 = losEffects.getLightWoods() > 0 ? 2 : 1;
            }
            toHitData = losEffects.losModifiers(iGame);
        }
        if ("LegAttack".equals(weaponType.getInternalName())) {
            toHitData2 = Compute.getLegAttackBaseToHit((Entity)targetable2, entity2);
            enumeration = ((Entity)targetable2).getMisc();
            while (enumeration.hasMoreElements()) {
                mounted = (Mounted)enumeration.nextElement();
                equipmentType = mounted.getType();
                if (!"BA-Assault Claws".equals(equipmentType.getInternalName())) continue;
                toHitData2.addModifier(-1, "attacker has assault claws");
                break;
            }
        } else if ("SwarmMek".equals(weaponType.getInternalName())) {
            toHitData2 = Compute.getSwarmMekBaseToHit((Entity)targetable2, entity2);
            enumeration = ((Entity)targetable2).getMisc();
            while (enumeration.hasMoreElements()) {
                mounted = (Mounted)enumeration.nextElement();
                equipmentType = mounted.getType();
                if (!"BA-Assault Claws".equals(equipmentType.getInternalName())) continue;
                toHitData2.addModifier(-1, "attacker has assault claws");
                break;
            }
        } else {
            if ("StopSwarm".equals(weaponType.getInternalName())) {
                return new ToHitData(Integer.MIN_VALUE, "End swarm attack.");
            }
            if ("BAMineLauncher".equals(weaponType.getInternalName())) {
                toHitData2 = new ToHitData(8, "magnetic mine attack");
            } else {
                if (entity2 != null && ((Entity)targetable2).getSwarmTargetId() == entity2.getId()) {
                    return new ToHitData(Integer.MIN_VALUE, "Attack during swarm.", 3, 0);
                }
                toHitData2 = bl11 ? new ToHitData(9, "artillery FLAK") : new ToHitData(((Entity)targetable2).crew.getGunnery(), "gunnery skill");
            }
        }
        if (((Entity)targetable2).crew.getOptions().stringOption("weapon_specialist").equals(weaponType.getName())) {
            toHitData2.addModifier(-2, "weapon specialist");
        }
        if (((Entity)targetable2).crew.getOptions().booleanOption("gunnery_laser") && weaponType.hasFlag(262144)) {
            toHitData2.addModifier(-1, "Gunnery/Laser");
        }
        if (((Entity)targetable2).crew.getOptions().booleanOption("gunnery_ballistic") && weaponType.hasFlag(131072)) {
            toHitData2.addModifier(-1, "Gunnery/Ballistic");
        }
        if (((Entity)targetable2).crew.getOptions().booleanOption("gunnery_missile") && weaponType.hasFlag(524288)) {
            toHitData2.addModifier(-1, "Gunnery/Missile");
        }
        if (!(bl15 || ammoType == null || ammoType.getAmmoType() != 7 && ammoType.getAmmoType() != 9 || ammoType.getMunitionType() != 256L || entity2 != null && entity2.isClan())) {
            toHitData2.addModifier(-1, "Listen-Kill ammo");
        }
        int n10 = ((Entity)targetable2).getElevation();
        int n11 = targetable.getElevation();
        int n12 = Compute.effectiveDistance(iGame, (Entity)targetable2, targetable);
        toHitData2.append(WeaponAttackAction.nightModifiers(iGame, targetable, ammoType, (Entity)targetable2));
        if (bl9) {
            if (!bl11) {
                toHitData2.addModifier(5, "direct artillery modifer");
            }
            toHitData2.append(Compute.getAttackerMovementModifier(iGame, n));
            toHitData2.append(toHitData);
            toHitData2.append(Compute.getSecondaryTargetMod(iGame, (Entity)targetable2, targetable));
            toHitData2.append(Compute.getDamageWeaponMods((Entity)targetable2, mounted2));
            if (((Entity)targetable2).getHeatFiringModifier() != 0) {
                toHitData2.addModifier(((Entity)targetable2).getHeatFiringModifier(), "heat");
            }
            if (weaponType.getToHitModifier() != 0) {
                toHitData2.addModifier(weaponType.getToHitModifier(), "weapon to-hit modifier");
            }
            if (bl5 && ammoType.getToHitModifier() != 0) {
                toHitData2.addModifier(ammoType.getToHitModifier(), "ammunition to-hit modifier");
            }
            if (bl17) {
                return new ToHitData(4, "Homing shot");
            }
            if (iGame.getEntity(n).getOwner().getArtyAutoHitHexes().contains(targetable.getPosition()) && !bl11) {
                return new ToHitData(Integer.MIN_VALUE, "Artillery firing at designated artillery target.");
            }
            return toHitData2;
        }
        if (bl10) {
            int n13 = (int)Math.ceil((float)n12 / 17.0f);
            if (bl17) {
                return new ToHitData(4, "Homing shot (will miss if TAG misses)");
            }
            if (iGame.getEntity(n).getOwner().getArtyAutoHitHexes().contains(targetable.getPosition())) {
                return new ToHitData(Integer.MIN_VALUE, "Artillery firing at designated artillery target.");
            }
            toHitData2.addModifier(7, "indirect artillery modifier");
            int n14 = ((Entity)targetable2).aTracker.getModifier(mounted2, targetable.getPosition());
            if (n14 == Integer.MIN_VALUE) {
                return new ToHitData(Integer.MIN_VALUE, "Artillery firing at target that's been hit before.");
            }
            if (n14 != 0) {
                toHitData2.addModifier(n14, "adjusted fire");
            }
            return toHitData2;
        }
        if (n12 == 1 && (targetable.getTargetType() == 3 || targetable.getTargetType() == 4)) {
            return new ToHitData(Integer.MIN_VALUE, "Targeting adjacent building.");
        }
        if (null != losEffects.getThruBldg() && (targetable.getTargetType() == 3 || targetable.getTargetType() == 4)) {
            return new ToHitData(Integer.MIN_VALUE, "Targeting building from inside (are you SURE this is a good idea?).");
        }
        toHitData2.append(Compute.getRangeMods(iGame, (Entity)targetable2, n2, targetable));
        if (((Entity)targetable2).getTargSysType() == 5 && targetable instanceof Entity) {
            if (targetable instanceof VTOL) {
                toHitData2.addModifier(-2, "anti-air targetting system vs. VTOL");
            } else {
                toHitData2.addModifier(1, "anti-air targetting system vs. non-aerial unit");
            }
        }
        if (!bl3 && entity2 != null && entity2 instanceof BattleArmor) {
            toHitData2.addModifier(1, "battle armor target");
        }
        if (entity2 != null && entity2 instanceof MechWarrior) {
            toHitData2.addModifier(2, "ejected MechWarrior target");
        }
        if (bl7) {
            toHitData2.addModifier(1, "indirect fire");
        }
        toHitData2.append(Compute.getAttackerMovementModifier(iGame, n));
        if (entity2 != null) {
            int n15;
            object = Compute.getTargetMovementModifier(iGame, targetable.getTargetId());
            toHitData2.append((TargetRoll)object);
            n5 += ((TargetRoll)object).getValue();
            if (ammoType != null && ammoType.getAmmoType() == 7 && ammoType.getMunitionType() == 16384L && entity2.getTaggedBy() != -1) {
                n15 = ((TargetRoll)object).getValue();
                if (n15 > 0) {
                    toHitData2.append(new ToHitData(-n15, "Semi-guided ammo vs tagged target"));
                }
            } else if (ammoType != null && ammoType.getAmmoType() == 1 && ammoType.getAmmoType() == 1 && ammoType.getMunitionType() == 16L && (n15 = Math.min(2, ((TargetRoll)object).getValue())) > 0) {
                toHitData2.append(new ToHitData(-n15, "Precision Ammo"));
            }
        }
        if (ammoType != null && ammoType.getAmmoType() == 1 && ammoType.getMunitionType() == 2L) {
            toHitData2.addModifier(1, "Armor-Piercing Ammo");
        }
        if (bl7) {
            if (ammoType != null && ammoType.getAmmoType() == 7 && ammoType.getMunitionType() == 16384L && entity2.getTaggedBy() != -1) {
                toHitData2.addModifier(-1, "semiguided ignores spotter movement & indirect fire penalties");
            } else {
                toHitData2.append(Compute.getSpotterMovementModifier(iGame, entity3.getId()));
            }
        }
        toHitData2.append(Compute.getAttackerTerrainModifier(iGame, n));
        if (targetable.getTargetType() != 6) {
            toHitData2.append(Compute.getTargetTerrainModifier(iGame, targetable, n9));
            n5 += Compute.getTargetTerrainModifier(iGame, targetable, n9).getValue();
        }
        object = iGame.getBoard().getHex(((Entity)targetable2).getPosition());
        IHex iHex = iGame.getBoard().getHex(targetable.getPosition());
        if (iHex.containsTerrain(4) && iHex.terrainLevel(4) == 1 && n8 == 0 && entity2.height() > 0) {
            losEffects.setTargetCover(losEffects.getTargetCover() | 3);
            toHitData = losEffects.losModifiers(iGame, n9);
        }
        toHitData2.append(toHitData);
        if (entity2 != null && entity2.isHullDown() && (entity2 instanceof Mech && losEffects.getTargetCover() > 0 || entity2 instanceof Tank && iHex.containsTerrain(21) && entity2.sideTable(((Entity)targetable2).getPosition()) == 0)) {
            toHitData2.addModifier(2, "Hull down target");
        }
        if (!bl) {
            toHitData2.append(Compute.getSecondaryTargetMod(iGame, (Entity)targetable2, targetable, bl2));
        }
        if (((Entity)targetable2).getHeatFiringModifier() != 0) {
            toHitData2.addModifier(((Entity)targetable2).getHeatFiringModifier(), "heat");
        }
        toHitData2.append(Compute.getDamageWeaponMods((Entity)targetable2, mounted2));
        toHitData2.append(Compute.getImmobileMod(targetable, n3, n4));
        toHitData2.append(Compute.getProneMods(iGame, (Entity)targetable2, n2));
        if (entity2 != null && entity2.isProne()) {
            if (n12 <= 1) {
                if ("SwarmMek".equals(weaponType.getInternalName())) {
                    if (!entity2.isImmobile()) {
                        toHitData2.addModifier(-4, "swarm prone target");
                    }
                } else {
                    toHitData2.addModifier(-2, "target prone and adjacent");
                }
            } else {
                toHitData2.addModifier(1, "target prone and at range");
            }
        }
        if (weaponType.getToHitModifier() != 0) {
            toHitData2.addModifier(weaponType.getToHitModifier(), "weapon to-hit modifier");
        }
        if (entity2 != null && entity2.getMovementMode() == 6 && ammoType != null && (ammoType.getAmmoType() == 19 || ammoType.getAmmoType() == 33) && ammoType.getMunitionType() == 1L && entity2.getElevation() > iGame.getBoard().getHex(entity2.getPosition()).ceiling()) {
            toHitData2.addModifier(-3, "flak to-hit modifier");
        } else if (bl5 && ammoType.getToHitModifier() != 0) {
            toHitData2.addModifier(ammoType.getToHitModifier(), "ammunition to-hit modifier");
        }
        if (bl14) {
            toHitData2.addModifier(-1, "iNarc homing pod");
        }
        if (bl13) {
            toHitData2.addModifier(1, "iNarc Haywire pod");
        }
        if (n4 == 2 && n3 != -1) {
            if (((Entity)targetable2).hasActiveEiCockpit()) {
                if (((Entity)targetable2).hasTargComp()) {
                    toHitData2.addModifier(2, "aiming with targeting computer & EI system");
                } else {
                    toHitData2.addModifier(6, "aiming with EI system");
                }
            } else {
                toHitData2.addModifier(3, "aiming with targeting computer");
            }
        } else if (((Entity)targetable2).hasTargComp() && weaponType.hasFlag(1) && (!bl5 || ammoType.getAmmoType() != 19 && ammoType.getAmmoType() != 33 || ammoType.getMunitionType() != 1L)) {
            toHitData2.addModifier(-1, "targeting computer");
        }
        if (null != losEffects.getThruBldg() && n10 != n11) {
            if (targetable instanceof Tank) {
                toHitData2.setSideTable(4);
            } else if (targetable instanceof Mech) {
                if (n10 > n11) {
                    toHitData2.setHitTable(4);
                } else {
                    toHitData2.setHitTable(5);
                }
            }
        }
        if (losEffects.getTargetCover() != 0) {
            if (((Entity)targetable2).getLocationStatus(mounted2.getLocation()) == 2 && iHex.containsTerrain(4) && n8 == 0 && entity2.height() > 0) {
                toHitData2.setHitTable(2);
            } else if (iGame.getOptions().booleanOption("maxtech_partial_cover")) {
                toHitData2.setHitTable(6);
                toHitData2.setCover(losEffects.getTargetCover());
            } else {
                toHitData2.setHitTable(1);
                toHitData2.setCover(3);
            }
        }
        if (bl3 && 0 == n12) {
            toHitData2.setSideTable(0);
        } else {
            toHitData2.setSideTable(Compute.targetSideTable((Entity)targetable2, targetable));
        }
        if (bl2) {
            toHitData2.addModifier(-n5, "original target mods");
            toHitData2.append(Compute.getTargetMovementModifier(iGame, entity.getId()));
            toHitData2.append(Compute.getTargetTerrainModifier(iGame, iGame.getEntity(entity.getId())));
            if (!bl15 && !entity.isEnemyOf((Entity)targetable2) && entity.getBadCriticals(0, 1, 0) <= 0 && ammoType.getMunitionType() == 65536L) {
                toHitData2.addModifier(2, "Swarm-I at friendly unit with intact sensors");
            }
        }
        return toHitData2;
    }

    private static String toHitIsImpossible(IGame iGame, Entity entity, Targetable targetable, Mounted mounted, AmmoType ammoType, WeaponType weaponType, int n, boolean bl, boolean bl2, Entity entity2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n2, int n3, boolean bl7, Mounted mounted2, boolean bl8, boolean bl9, boolean bl10) {
        ToHitData toHitData;
        Object object;
        Object object2;
        boolean bl11 = false;
        ToHitData toHitData2 = null;
        if (!mounted.canFire()) {
            return new String("Weapon is not in a state where it can be fired");
        }
        if (entity.isLayingMines()) {
            return new String("Can't fire weapons when laying mines");
        }
        if (targetable.getTargetType() == 6 && !AmmoType.canDeliverMinefield(ammoType)) {
            return new String("Weapon can't deliver minefields");
        }
        if (!(targetable.getTargetType() != 13 || bl2 && ammoType.getAmmoType() == 7 && ammoType.getMunitionType() == 8192L)) {
            return new String("Weapon can't deliver flares");
        }
        if (iGame.getPhase() == 7 && !bl7) {
            return new String("Only indirect artillery can be fired in the targeting phase");
        }
        if (iGame.getPhase() == 10 && !bl3) {
            return new String("Only TAG can be fired in the offboard attack phase");
        }
        if (iGame.getPhase() != 10 && bl3) {
            return new String("TAG can only be fired in the offboard attack phase");
        }
        if (ammoType != null && ammoType.getAmmoType() == 7 && (ammoType.getMunitionType() == 131072L || ammoType.getMunitionType() == 0x200000L || ammoType.getMunitionType() == 524288L || ammoType.getMunitionType() == 0x100000L || ammoType.getMunitionType() == 262144L) && targetable.getTargetType() != 6) {
            return new String("Weapon can only deliver minefields");
        }
        if (ammoType != null && ammoType.getAmmoType() == 7 && ammoType.getMunitionType() == 8192L && targetable.getTargetType() != 13) {
            return new String("Weapon can only deliver flares");
        }
        if (weaponType.hasFlag(0x4000000) && (entity2 != null && !(entity2 instanceof Infantry) || targetable.getTargetType() != 0)) {
            return new String("Weapon can only be used against infantry");
        }
        if (targetable instanceof MinefieldTarget && !AmmoType.canClearMinefield(ammoType)) {
            return new String("Weapon can't clear minefields");
        }
        if (weaponType.hasFlag(65536)) {
            long l = 0L;
            if (ammoType != null) {
                l = ammoType.getMunitionType();
            }
            if (l == 0x40000000L) {
                if (n != 8) {
                    return new String("FASCAM ammo must be used with target hex (FASCAM)");
                }
            } else if (l == 0x80000000L) {
                if (n != 9) {
                    return new String("Inferno IV ammo must be used with target hex (Inferno IV)");
                }
            } else if (l == 0x100000000L) {
                if (n != 10) {
                    return new String("Vibrabomb IV ammo must be used with target hex (Vibrabomb IV)");
                }
            } else if (l == 0x20000000L) {
                bl11 = true;
            } else if (n != 7 && !bl8) {
                return new String("Weapon must make artillery attacks.");
            }
        } else if (n == 7 || n == 8 || n == 9 || n == 10) {
            return new String("Weapon can't make artillery attacks.");
        }
        if (entity.equals(entity2) && !bl) {
            return new String("You can't target yourself");
        }
        if (mounted.isDestroyed() || mounted.isBreached()) {
            return new String("Weapon not operational.");
        }
        if (bl2 && !bl && (mounted2 == null || mounted2.getShotsLeft() == 0 || mounted2.isBreached())) {
            return new String("Weapon out of ammo.");
        }
        if (bl2 && mounted2.isDumping()) {
            entity.loadWeaponWithSameAmmo(mounted);
            if (mounted2.getShotsLeft() == 0 || mounted2.isDumping()) {
                return new String("Dumping remaining ammo.");
            }
        }
        if (entity.isShutDown() || !entity.getCrew().isActive()) {
            return new String("Attacker is in no condition to fire weapons.");
        }
        int n4 = entity.getBadCriticals(0, 1, 0);
        if (n4 > 1) {
            return new String("Attacker sensors destroyed.");
        }
        if (entity.isWeaponBlockedAt(mounted.getLocation(), mounted.isRearMounted())) {
            return new String("Weapon blocked by passenger.");
        }
        if (entity2 != null && -1 != entity2.getSwarmTargetId()) {
            return new String("Target is swarming a Mek.");
        }
        if (1 == targetable.getTargetType()) {
            object2 = iGame.getBoard().getHex(targetable.getPosition());
            if (!(object2.containsTerrain(1) || object2.containsTerrain(23) || object2.containsTerrain(20) && object2.containsTerrain(4))) {
                return new String("Target terrain cannot be cleared.");
            }
            if (bl5) {
                return new String("Infantry can not clear terrain.");
            }
        }
        if (bl5 && 1 == targetable.getTargetType()) {
            return new String("Infantry can not clear woods.");
        }
        if (weaponType.hasFlag(32) && !bl4 && 2 == targetable.getTargetType()) {
            return new String("Weapon can not cause fires.");
        }
        if (!(bl4 || targetable.getTargetType() != 2 || iGame.getBoard().getHex(((HexTarget)targetable).getPosition()).containsTerrain(1) || iGame.getBoard().getHex(((HexTarget)targetable).getPosition()).containsTerrain(23) || iGame.getBoard().getHex(((HexTarget)targetable).getPosition()).containsTerrain(10))) {
            return new String("Only Infernos can start fires except woods and building hexes.");
        }
        if (bl4 && (entity2 instanceof Infantry || entity2 instanceof Tank && iGame.getOptions().booleanOption("vehicles_safe_from_infernos") || entity2 instanceof Protomech && iGame.getOptions().booleanOption("protos_safe_from_infernos"))) {
            return new String("Can not target that unit type with Inferno rounds.");
        }
        if (bl3 && entity2 instanceof Infantry) {
            return new String("Can not target infantry with TAG.");
        }
        if (weaponType.hasFlag(2) && weaponType.hasModes() && mounted.curMode().equals("Heat") && !(entity2 instanceof Mech)) {
            return new String("Can only raise the heat level of Meks.");
        }
        if (weaponType.hasFlag(128)) {
            object2 = iGame.getActions();
            while (object2.hasMoreElements()) {
                Object e = object2.nextElement();
                if (!(e instanceof WeaponAttackAction) || ((AbstractEntityAction)(object = (WeaponAttackAction)e)).getEntityId() != n2 || n3 == ((WeaponAttackAction)object).getWeaponId()) continue;
                return new String("Other weapon attacks declared.");
            }
        }
        if (bl6 && !iGame.getOptions().booleanOption("indirect_fire")) {
            return new String("Indirect fire option not enabled");
        }
        if (bl6 && iGame.getOptions().booleanOption("indirect_fire") && !iGame.getOptions().booleanOption("indirect_always_possible") && LosEffects.calculateLos(iGame, n2, targetable).canSee()) {
            return new String("Indirect fire impossible with direct LOS");
        }
        if (entity instanceof Tank && entity.isHullDown() && mounted.getLocation() == 1) {
            return new String("Nearby terrain blocks front weapons.");
        }
        if (!Compute.isInArc(iGame, n2, n3, targetable)) {
            return new String("Target not in arc.");
        }
        if (ammoType != null && ammoType.getAmmoType() == 26) {
            if (entity.getElevation() == 0) {
                return new String("attacker must be at least at elevation 1");
            }
            if (targetable.getTargetType() != 14) {
                return new String("must target hex with bombs");
            }
        }
        if (!(targetable.getTargetType() != 14 || bl2 && ammoType.getAmmoType() == 26)) {
            return new String("Weapon can't deliver bombs");
        }
        object2 = null;
        if (bl6 && (object2 = Compute.findSpotter(iGame, entity, targetable)) == null) {
            return new String("No available spotter");
        }
        int n5 = 0;
        if (!bl6) {
            object = LosEffects.calculateLos(iGame, n2, targetable);
            if (entity.hasActiveEiCockpit()) {
                n5 = ((LosEffects)object).getLightWoods() > 0 ? 2 : 1;
            }
            toHitData = ((LosEffects)object).losModifiers(iGame, n5);
        } else {
            object = LosEffects.calculateLos(iGame, ((Entity)object2).getId(), targetable);
            ((LosEffects)object).setAttackerCover(0);
            if (((Entity)object2).hasActiveEiCockpit()) {
                n5 = ((LosEffects)object).getLightWoods() > 0 ? 2 : 1;
            }
            toHitData = ((LosEffects)object).losModifiers(iGame);
        }
        if (toHitData.getValue() == Integer.MAX_VALUE && !bl7) {
            return toHitData.getDesc();
        }
        if (bl9 && entity2 instanceof Infantry && null == ((LosEffects)object).getThruBldg()) {
            return new String("Attack on infantry crosses building exterior wall.");
        }
        if (((LosEffects)object).isAttackerCover() && entity.locationIsLeg(mounted.getLocation()) && entity.getLocationStatus(mounted.getLocation()) != 2) {
            return new String("Nearby terrain blocks leg weapons.");
        }
        if ("LegAttack".equals(weaponType.getInternalName())) {
            toHitData2 = Compute.getLegAttackBaseToHit(entity, entity2);
            if (Integer.MAX_VALUE == toHitData2.getValue()) {
                return toHitData2.getDesc();
            }
        } else if ("SwarmMek".equals(weaponType.getInternalName())) {
            toHitData2 = Compute.getSwarmMekBaseToHit(entity, entity2);
            if (Integer.MAX_VALUE == toHitData2.getValue()) {
                return toHitData2.getDesc();
            }
        } else if ("StopSwarm".equals(weaponType.getInternalName())) {
            if (-1 == entity.getSwarmTargetId()) {
                return new String("Not swarming a Mek.");
            }
        } else if ("BAMineLauncher".equals(weaponType.getInternalName())) {
            if (entity2 instanceof Infantry) {
                return new String("Can not attack infantry.");
            }
        } else if (entity2 != null && entity.getSwarmTargetId() == entity2.getId()) {
            if (weaponType.getDamage() == 0) {
                return new String("Weapon causes no damage.");
            }
        } else if (-1 != entity.getSwarmTargetId()) {
            return new String("Must target the Mek being swarmed.");
        }
        int n6 = entity.getElevation();
        int n7 = targetable.getElevation();
        int n8 = Compute.effectiveDistance(iGame, entity, targetable);
        if (ammoType != null && ammoType.getAmmoType() == 7 && ammoType.getMunitionType() == 16384L && (entity2 == null || entity2.getTaggedBy() == -1)) {
            return new String("Semi-guided LRMs must target a unit tagged this turn");
        }
        if (bl10) {
            if (n8 > 17) {
                return new String("Direct artillery attack at range >17 hexes.");
            }
            if (bl11 && (entity2 == null || entity2.getTaggedBy() == -1)) {
                return new String("On board homing shot must target a unit tagged this turn");
            }
        }
        if (bl7) {
            int n9 = (int)Math.ceil((float)n8 / 17.0f);
            if (n9 > weaponType.getLongRange()) {
                return new String("Indirect artillery attack out of range");
            }
            if (n8 <= 17 && toHitData.getValue() != Integer.MAX_VALUE) {
                return new String("Cannot fire indirectly at range <=17 hexes unless no LOS.");
            }
            if (bl11 && n != 7) {
                return new String("Off board homing shot must target a map sheet");
            }
        }
        return null;
    }

    public boolean isNemesisConfused() {
        return this.nemesisConfused;
    }

    public void setNemesisConfused(boolean bl) {
        this.nemesisConfused = bl;
    }

    public boolean isSwarmingMissiles() {
        return this.swarmingMissiles;
    }

    public void setSwarmingMissiles(boolean bl) {
        this.swarmingMissiles = bl;
    }

    public void setOldTargetId(int n) {
        this.oldTargetId = n;
    }
}

