/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import megamek.common.net.Connection;

class DataStreamConnection
extends Connection {
    private DataInputStream in;
    private DataOutputStream out;

    public DataStreamConnection(Socket socket, int n) {
        super(socket, n);
    }

    public DataStreamConnection(String string, int n, int n2) {
        super(string, n, n2);
    }

    protected Connection.INetworkPacket readNetworkPacket() throws Exception {
        NetworkPacket networkPacket = null;
        if (this.in == null) {
            this.in = new DataInputStream(this.getInputStream());
        }
        boolean bl = this.in.readBoolean();
        int n = this.in.readInt();
        int n2 = this.in.readInt();
        byte[] byArray = new byte[n2];
        this.in.readFully(byArray);
        networkPacket = new NetworkPacket(bl, n, byArray);
        return networkPacket;
    }

    protected void sendNetworkPacket(byte[] byArray, boolean bl) throws Exception {
        if (this.out == null) {
            this.out = new DataOutputStream(this.getOutputStream());
            this.out.flush();
        }
        this.out.writeBoolean(bl);
        this.out.writeInt(this.marshallingType);
        this.out.writeInt(byArray.length);
        this.out.write(byArray);
        this.out.flush();
    }

    private static class NetworkPacket
    implements Connection.INetworkPacket {
        private boolean compressed;
        private int marshallingType;
        private byte[] data;

        NetworkPacket(boolean bl, int n, byte[] byArray) {
            this.compressed = bl;
            this.marshallingType = n;
            this.data = byArray;
        }

        public int getMarshallingType() {
            return this.marshallingType;
        }

        public byte[] getData() {
            return this.data;
        }

        public boolean isCompressed() {
            return this.compressed;
        }
    }
}

