/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.options;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import megamek.common.options.AbstractOptionsInfo;
import megamek.common.options.IBasicOptionGroup;
import megamek.common.options.IOption;
import megamek.common.options.IOptionGroup;
import megamek.common.options.IOptionInfo;
import megamek.common.options.IOptions;
import megamek.common.options.IOptionsInfo;
import megamek.common.options.Option;
import megamek.common.options.OptionGroup;

public abstract class AbstractOptions
implements IOptions,
Serializable {
    private Hashtable optionsHash = new Hashtable();

    protected AbstractOptions() {
        this.initialize();
        this.getOptionsInfoImp().finish();
    }

    protected abstract void initialize();

    public Enumeration getGroups() {
        return new GroupsEnumeration();
    }

    public Enumeration getOptions() {
        return this.optionsHash.elements();
    }

    public IOptionInfo getOptionInfo(String string) {
        return this.getOptionsInfo().getOptionInfo(string);
    }

    public IOption getOption(String string) {
        return (IOption)this.optionsHash.get(string);
    }

    public boolean booleanOption(String string) {
        return this.getOption(string).booleanValue();
    }

    public int intOption(String string) {
        return this.getOption(string).intValue();
    }

    public float floatOption(String string) {
        return this.getOption(string).floatValue();
    }

    public String stringOption(String string) {
        return this.getOption(string).stringValue();
    }

    IOptionsInfo getOptionsInfo() {
        return this.getOptionsInfoImp();
    }

    protected abstract AbstractOptionsInfo getOptionsInfoImp();

    protected OptionGroup addGroup(String string) {
        return this.getOptionsInfoImp().addGroup(string);
    }

    protected OptionGroup addGroup(String string, String string2) {
        return this.getOptionsInfoImp().addGroup(string, string2);
    }

    protected void addOption(OptionGroup optionGroup, String string, String string2) {
        this.addOption(optionGroup, string, 3, string2);
    }

    protected void addOption(OptionGroup optionGroup, String string, boolean bl) {
        this.addOption(optionGroup, string, 0, new Boolean(bl));
    }

    protected void addOption(OptionGroup optionGroup, String string, int n) {
        this.addOption(optionGroup, string, 1, new Integer(n));
    }

    protected void addOption(OptionGroup optionGroup, String string, float f) {
        this.addOption(optionGroup, string, 2, new Float(f));
    }

    protected void addOption(OptionGroup optionGroup, String string, Vector vector) {
        this.addOption(optionGroup, string, 4, "");
    }

    protected void addOption(OptionGroup optionGroup, String string, int n, Object object) {
        this.optionsHash.put(string, new Option(this, string, n, object));
        this.getOptionsInfoImp().addOptionInfo(optionGroup, string);
    }

    protected class GroupsEnumeration
    implements Enumeration {
        private Enumeration groups;

        GroupsEnumeration() {
            this.groups = AbstractOptions.this.getOptionsInfo().getGroups();
        }

        public boolean hasMoreElements() {
            return this.groups.hasMoreElements();
        }

        public Object nextElement() {
            return new GroupProxy((IBasicOptionGroup)this.groups.nextElement());
        }

        protected class GroupProxy
        implements IOptionGroup {
            private IBasicOptionGroup group;

            GroupProxy(IBasicOptionGroup iBasicOptionGroup) {
                this.group = iBasicOptionGroup;
            }

            public String getKey() {
                return this.group.getKey();
            }

            public String getName() {
                return this.group.getName();
            }

            public String getDisplayableName() {
                return AbstractOptions.this.getOptionsInfoImp().getGroupDisplayableName(this.group.getName());
            }

            public Enumeration getOptionNames() {
                return this.group.getOptionNames();
            }

            public Enumeration getOptions() {
                return new OptionsEnumeration();
            }

            protected class OptionsEnumeration
            implements Enumeration {
                private Enumeration optionNames;

                OptionsEnumeration() {
                    this.optionNames = GroupProxy.this.group.getOptionNames();
                }

                public boolean hasMoreElements() {
                    return this.optionNames.hasMoreElements();
                }

                public Object nextElement() {
                    return AbstractOptions.this.getOption((String)this.optionNames.nextElement());
                }
            }
        }
    }
}

