/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.util;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;

public class LocaleParser {
    protected StreamTokenizer st;
    protected String language = "";
    protected String country = "";
    protected String variant = "";
    protected int currentToken;
    protected ParseException exception;

    public String getLanguage() {
        return this.language;
    }

    public String getCountry() {
        return this.country;
    }

    public String getVariant() {
        return this.variant;
    }

    public boolean parse(String string) {
        this.clear();
        StringReader stringReader = new StringReader(string);
        this.st = new StreamTokenizer(stringReader);
        return this.parse();
    }

    public boolean parse(StreamTokenizer streamTokenizer) {
        this.clear();
        this.st = streamTokenizer;
        return this.parse();
    }

    public ParseException getException() {
        return this.exception;
    }

    protected void clear() {
        this.language = "";
        this.country = "";
        this.variant = "";
        this.exception = null;
        this.st = null;
    }

    protected boolean parse() {
        boolean bl = false;
        this.nextToken();
        try {
            this.parseLocale();
        }
        catch (ParseException parseException) {
            bl = true;
            this.exception = parseException;
        }
        return bl;
    }

    protected void parseLocale() throws ParseException {
        if (this.currentToken != -3) {
            throw new ParseException("language expected");
        }
        this.language = this.st.sval;
        this.nextToken();
        if (this.currentToken == 95) {
            this.nextToken();
            this.parseCountry();
        }
    }

    protected void parseCountry() throws ParseException {
        if (this.currentToken != -3) {
            throw new ParseException("country expected");
        }
        this.country = this.st.sval;
        this.nextToken();
        if (this.currentToken == 95) {
            this.parseVariant();
        }
    }

    protected void parseVariant() throws ParseException {
        if (this.currentToken != -3) {
            throw new ParseException("variant expected");
        }
        this.variant = this.st.sval;
        this.nextToken();
    }

    protected void nextToken() {
        try {
            this.currentToken = this.st.nextToken();
        }
        catch (IOException iOException) {
            this.currentToken = -1;
        }
    }

    public static class ParseException
    extends Exception {
        public ParseException(String string) {
            super(string);
        }
    }
}

