/*
 * Decompiled with CFR 0.152.
 */
package megamek.test;

import java.awt.Button;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import megamek.common.Board;
import megamek.common.net.Connection;
import megamek.common.net.ConnectionFactory;
import megamek.common.net.ConnectionListenerAdapter;
import megamek.common.net.DisconnectedEvent;
import megamek.common.net.Packet;
import megamek.common.net.PacketReceivedEvent;

public class PacketTool
extends Frame
implements Runnable {
    private Board board = null;
    private Panel panConnect = null;
    private Panel panXmit = null;
    private TextField hostName = null;
    private TextField hostPort = null;
    private Label boardName = null;
    private String fileName = null;
    private Button butSend = null;
    private Connection conn = null;
    private ConnectionListenerAdapter connectionListener = new ConnectionListenerAdapter(){

        public void disconnected(DisconnectedEvent disconnectedEvent) {
            PacketTool.this.disconnected(disconnectedEvent.getConnection());
        }

        public void packetReceived(PacketReceivedEvent packetReceivedEvent) {
            PacketTool.this.handle(packetReceivedEvent.getConnection().getId(), packetReceivedEvent.getPacket());
        }
    };

    public static void main(String[] stringArray) {
        PacketTool packetTool = new PacketTool();
        Dimension dimension = packetTool.getToolkit().getScreenSize();
        packetTool.pack();
        packetTool.setLocation(dimension.width / 2 - packetTool.getSize().width / 2, dimension.height / 2 - packetTool.getSize().height / 2);
        packetTool.setVisible(true);
    }

    public PacketTool() {
        super("Board Transmition");
        Button button = null;
        Panel panel = null;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PacketTool.this.quit();
            }
        });
        panel = new Panel();
        panel.setLayout(new GridLayout(0, 1));
        this.panConnect = new Panel();
        this.panConnect.setLayout(new GridLayout(0, 2));
        panel.add(this.panConnect);
        this.panXmit = new Panel();
        this.panXmit.setLayout(new GridLayout(0, 1));
        this.panXmit.setEnabled(false);
        panel.add(this.panXmit);
        this.add(panel);
        this.panConnect.add(new Label(" Connect To:"));
        this.hostName = new TextField("localhost", 10);
        this.panConnect.add(this.hostName);
        this.panConnect.add(new Label("Port Number:"));
        this.hostPort = new TextField("2346", 10);
        this.panConnect.add(this.hostPort);
        button = new Button("Listen");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new Thread((Runnable)PacketTool.this, "Packet Reader").start();
            }
        });
        this.panConnect.add(button);
        button = new Button("Connect");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PacketTool.this.connect();
            }
        });
        this.panConnect.add(button);
        button = new Button("Load Board");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PacketTool.this.boardLoad();
            }
        });
        this.panXmit.add(button);
        this.boardName = new Label();
        this.boardName.setAlignment(1);
        this.panXmit.add(this.boardName);
        this.butSend = new Button("Send");
        this.butSend.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PacketTool.this.send();
            }
        });
        this.butSend.setEnabled(false);
        this.panXmit.add(this.butSend);
    }

    public synchronized void quit() {
        if (null != this.conn) {
            this.conn.close();
        }
        System.exit(0);
    }

    public void connect() {
        String string = this.hostName.getText();
        int n = 0;
        try {
            n = Integer.parseInt(this.hostPort.getText());
            this.conn = ConnectionFactory.getInstance().createServerConnection(new Socket(string, n), 1);
            System.out.println("Connected to peer.");
            this.conn.addConnectionListener(this.connectionListener);
            this.board = new Board();
            this.panConnect.setEnabled(false);
            this.panXmit.setEnabled(true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void boardLoad() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Load Board...", 0);
        fileDialog.setDirectory("data" + File.separator + "boards");
        if (this.boardName.getText().length() > 0) {
            fileDialog.setFile(this.boardName.getText());
        }
        fileDialog.setLocation(this.getLocation().x + 150, this.getLocation().y + 100);
        fileDialog.show();
        if (fileDialog.getFile() == null) {
            return;
        }
        String string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(string, string2));
            this.board.load(fileInputStream);
            ((InputStream)fileInputStream).close();
            this.boardName.setText(string2);
            this.butSend.setEnabled(true);
        }
        catch (IOException iOException) {
            System.err.println("error opening file to save!");
            System.err.println(iOException);
        }
    }

    public void send() {
        long l = this.conn.bytesSent();
        Packet packet = new Packet(270, this.board);
        this.conn.send(packet);
        System.out.print("Bytes sent: ");
        System.out.print(this.conn.bytesSent() - l);
        System.out.print(", total sent: ");
        System.out.println(this.conn.bytesSent());
    }

    public void run() {
        int n = 0;
        try {
            n = Integer.parseInt(this.hostPort.getText());
            ServerSocket serverSocket = new ServerSocket(n);
            Socket socket = serverSocket.accept();
            serverSocket.close();
            System.out.println("Accepted peer connection.");
            this.conn = ConnectionFactory.getInstance().createServerConnection(socket, 0);
            this.conn.addConnectionListener(this.connectionListener);
            this.board = new Board();
            this.panConnect.setEnabled(false);
            this.panXmit.setEnabled(true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public synchronized void handle(int n, Packet packet) {
        System.out.print("Connection #");
        System.out.print(n);
        System.out.print(", received a ");
        if (null == packet) {
            System.out.print("null");
        } else {
            switch (packet.getCommand()) {
                case 10: {
                    System.out.print("COMMAND_SERVER_GREETING");
                    break;
                }
                case 20: {
                    System.out.print("COMMAND_CLIENT_NAME");
                    break;
                }
                case 30: {
                    System.out.print("COMMAND_LOCAL_PN");
                    break;
                }
                case 40: {
                    System.out.print("COMMAND_PLAYER_ADD");
                    break;
                }
                case 50: {
                    System.out.print("COMMAND_PLAYER_REMOVE");
                    break;
                }
                case 60: {
                    System.out.print("COMMAND_PLAYER_UPDATE");
                    break;
                }
                case 70: {
                    System.out.print("COMMAND_PLAYER_READY");
                    break;
                }
                case 80: {
                    System.out.print("COMMAND_CHAT");
                    break;
                }
                case 90: {
                    System.out.print("COMMAND_ENTITY_ADD");
                    break;
                }
                case 100: {
                    System.out.print("COMMAND_ENTITY_REMOVE");
                    break;
                }
                case 110: {
                    System.out.print("COMMAND_ENTITY_MOVE");
                    break;
                }
                case 120: {
                    System.out.print("COMMAND_ENTITY_DEPLOY");
                    break;
                }
                case 130: {
                    System.out.print("COMMAND_ENTITY_ATTACK");
                    break;
                }
                case 140: {
                    System.out.print("COMMAND_ENTITY_UPDATE");
                    break;
                }
                case 150: {
                    System.out.print("COMMAND_ENTITY_MODECHANGE");
                    break;
                }
                case 160: {
                    System.out.print("COMMAND_ENTITY_AMMOCHANGE");
                    break;
                }
                case 180: {
                    System.out.print("COMMAND_ENTITY_VISIBILITY_INDICATOR");
                    break;
                }
                case 190: {
                    System.out.print("COMMAND_CHANGE_HEX");
                    break;
                }
                case 200: {
                    System.out.print("COMMAND_BLDG_ADD");
                    break;
                }
                case 210: {
                    System.out.print("COMMAND_BLDG_REMOVE");
                    break;
                }
                case 220: {
                    System.out.print("COMMAND_BLDG_UPDATE_CF");
                    break;
                }
                case 230: {
                    System.out.print("COMMAND_BLDG_COLLAPSE");
                    break;
                }
                case 240: {
                    System.out.print("COMMAND_PHASE_CHANGE");
                    break;
                }
                case 250: {
                    System.out.print("COMMAND_TURN");
                    break;
                }
                case 260: {
                    System.out.print("COMMAND_ROUND_UPDATE");
                    break;
                }
                case 270: {
                    System.out.print("COMMAND_SENDING_BOARD");
                    Board board = (Board)packet.getObject(0);
                    try {
                        board.save(new FileOutputStream("xmit.board"));
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    break;
                }
                case 280: {
                    System.out.print("COMMAND_SENDING_ENTITIES");
                    break;
                }
                case 290: {
                    System.out.print("COMMAND_SENDING_PLAYERS");
                    break;
                }
                case 300: {
                    System.out.print("COMMAND_SENDING_TURNS");
                    break;
                }
                case 310: {
                    System.out.print("COMMAND_SENDING_REPORTS");
                    break;
                }
                case 350: {
                    System.out.print("COMMAND_SENDING_GAME_SETTINGS");
                    break;
                }
                case 360: {
                    System.out.print("COMMAND_SENDING_MAP_SETTINGS");
                    break;
                }
                case 370: {
                    System.out.print("COMMAND_QUERY_MAP_SETTINGS");
                    break;
                }
                case 380: {
                    System.out.print("COMMAND_END_OF_GAME");
                    break;
                }
                case 390: {
                    System.out.print("COMMAND_DEPLOY_MINEFIELDS");
                    break;
                }
                case 400: {
                    System.out.print("COMMAND_REVEAL_MINEFIELD");
                    break;
                }
                case 410: {
                    System.out.print("COMMAND_REMOVE_MINEFIELD");
                    break;
                }
                case 420: {
                    System.out.print("COMMAND_SENDING_MINEFIELDS");
                    break;
                }
                case 430: {
                    System.out.print("COMMAND_REROLL_INITIATIVE");
                    break;
                }
                case 450: {
                    System.out.print("COMMAND_SET_ARTYAUTOHITHEXES");
                    break;
                }
                default: {
                    System.out.print("unknown");
                }
            }
        }
        System.out.println(" packet.");
    }

    public synchronized void disconnected(Connection connection) {
        System.out.println("s: connection " + connection.getId() + " disconnected");
        this.panXmit.setEnabled(false);
        this.butSend.setEnabled(false);
        this.boardName.setText("");
        this.board = null;
        connection = null;
        this.panConnect.setEnabled(true);
    }
}

