#!/bin/sh
#
# by Bluebird

UPDATEFIX="./updatefix.sh"
FIX="./data/fix.sh"
LOGFILE="./update.log"

# Is JAVADIR set ?
if [ ! -x "$JAVABIN" -a -d "$JAVADIR" ]
then
  JAVABIN="$JAVADIR/bin/java"
fi

# Is 'java' in PATH ?
if [ ! -x "$JAVABIN" ]
then
  JAVABIN=`which java`
fi

# Can 'java' be found using 'locate' ?
if [ ! -x "$JAVABIN" ]
then 
  JAVABIN=`locate /bin/java | grep "java$" | head -1`
fi

# Surrender ...
if [ ! -x "$JAVABIN" ]
then
  echo "Java not found, please set the JAVABIN environment variable."
  exit 1
fi

echo "Java Binary: $JAVABIN" > $LOGFILE

echo "--------------------" >> $LOGFILE
echo "Autoupdater:" >> $LOGFILE
echo "--------------------" >> $LOGFILE

$JAVABIN -cp autoupdater.jar com.navtools.autoupdate.AutoUpdater . http://www.megamek.com/mmnet/autoupdate >> $LOGFILE 2>&1

if [ -f $UPDATEFIX ]
then
  echo "Update-Fix:" >> $LOGFILE
  echo "--------------------" >> $LOGFILE
  . $UPDATEFIX >> $LOGFILE 2>&1
fi

if [ -f $FIX ]
then
  echo "Fix:" >> $LOGFILE
  echo "--------------------" >> $LOGFILE
  . $FIX >> $LOGFILE 2>&1
fi

