/*
 * BuildInfo
 *
 * Copyright ? Equinoxe Solutions Corporation.
 * All rights reserved.
 *
 * User: Joe Gergis
 *
 * Date: Jun 15, 2003
 * Time: 1:52:29 PM
 */
package com.equinoxe;

/**
 * This class is where the build information for BuildInfo is stored.
 * The version and build variables are updated by the Ant task used to
 * build the code.
 *
 * @author Joe Gergis
 * @version 5.1.1
 */
public class BuildInfo
{
	/** Product Name */
	private static final String productName = "ARMI";

	/** Current Version */
	private static final String version = "1.0.0";

	/** Current Build */
	private static final String build = "326301";

	/**
	 * Get the product name
	 *
	 */
	public static String getProductName()
	{
		return productName;
	}


	/**
	 * Get the current version of BuildInfo
	 *
	 * @return version string
	 */
	public static String getVersion()
	{
		return version;
	}


	/**
	 * Get the current build of BuildInfo
	 *
	 * @return build string
	 */
	public static String getBuild()
	{
		return build;
	}
}
