//
// ARMILogger
//
// Copyright  Equinoxe Solutions Corporation.
//  All rights reserved.
//
// User: Joe Gergis
//
// Date: Aug 7, 2003
// Time: 10:45:27 AM
//
package com.navtools.armi;

import java.util.logging.Logger;

/**
 * This class is used to hold the singleton logging variable.  All classes who wish to log should use this classes
 * static logging methods, which hide the logger's operation.
 * Also included are methods to set how the logger should output its data.
 *
 * @author Joe Gergis
 * @version 1.0.0
 */
public class ARMILogger
{
	private static ARMILogger _instance = new ARMILogger();
	private static Logger _logger;
	private String sARMILogger = "ARMILogger";


	/**
	 * Singleton object retrieval method.
	 *
	 * @return An instance of ARMILogger
	 */
	public static ARMILogger getInstance()
	{
		return _instance;
	}

	/**
	 * Private constructor for singleton use.
	 */
	private ARMILogger()
	{
		_logger = Logger.getLogger( sARMILogger );
	}

	/**
	 * Get a logger.
	 *
	 * @return Logger
	 */
	public static Logger getLogger()
	{
		return _logger;
	}
}

