/*
 * $Id: RMIMessage.java,v 1.1 2003/09/06 21:49:21 wurp Exp $
 */

package com.navtools.armi;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import com.navtools.armi.networking.Message;
import com.navtools.util.Prototype;
import org.apache.log4j.Category;

public class RMIMessage extends Message
{
	public static final Category LOG =
	Category.getInstance( RMIMessage.class.getName() );

	public RMIMessage( long messageID, int instanceID, int methodID )
	{
		super( messageID );
		instanceID_ = instanceID;
		methodID_ = methodID;
	}

	public RMIMessage()
	{
	}

	public static void register()
	{
		register( TYPE, new RMIMessage() );
	}

	public Prototype defaultInstance()
	{
		return new RMIMessage();
	}

	public int getInstanceID()
	{
		return instanceID_;
	}

	public int getMethodID()
	{
		return methodID_;
	}

	public void writeTo( DataOutputStream out ) throws IOException
	{
		super.writeTo( out );
		out.writeInt( instanceID_ );
		out.writeInt( methodID_ );
	}

	public void readFrom( DataInputStream in ) throws IOException
	{
		super.readFrom( in );
		instanceID_ = in.readInt();
		methodID_ = in.readInt();
	}

	public int getType()
	{
		return TYPE;
	}

	public static final int TYPE = 2;

	protected int instanceID_;
	protected int methodID_;
}
