/*
 * $Id: RMIResponseMessage.java,v 1.1 2003/09/06 21:49:21 wurp Exp $
 */

package com.navtools.armi;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import com.navtools.armi.networking.AckMessage;
import com.navtools.util.Prototype;

public class RMIResponseMessage extends AckMessage
{

	public RMIResponseMessage( long messageID, long ackedMessageID,
	                           int methodID, int returnTypeID )
	{
		super( messageID, ackedMessageID );
		methodID_ = methodID;
		returnTypeID_ = returnTypeID;
	}

	public RMIResponseMessage()
	{
	}

	public static void register()
	{
		register( TYPE, new RMIResponseMessage() );
	}

	public Prototype defaultInstance()
	{
		return new RMIResponseMessage();
	}

	public int getType()
	{
		return TYPE;
	}

	/**
	 * The ClassAndMethodTable id of the method for which this is a return value.
	 */
	public int getMethodID()
	{
		return methodID_;
	}

	/**
	 * The ClassAndMethodTable id of the class of the return type.
	 */
	public int getReturnTypeID()
	{
		return returnTypeID_;
	}

	public void writeTo( DataOutputStream out ) throws IOException
	{
		super.writeTo( out );
		out.writeInt( methodID_ );
		out.writeInt( returnTypeID_ );
	}

	public void readFrom( DataInputStream in ) throws IOException
	{
		super.readFrom( in );
		methodID_ = in.readInt();
		returnTypeID_ = in.readInt();
	}

	protected int methodID_;
	protected int returnTypeID_;

	public static final int TYPE = 3;
}
