/*
 * $Id: RMIResponseMessageListener.java,v 1.2 2003/09/12 04:14:58 wurp Exp $
 */

package com.navtools.armi;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

import com.navtools.armi.networking.ChannelMessenger;
import com.navtools.armi.networking.Message;
import com.navtools.armi.networking.MessageListener;
import com.navtools.thread.Lock;
import com.navtools.thread.TaskMaster;
import com.navtools.util.*;
import org.apache.log4j.Category;
import org.apache.log4j.NDC;

public class RMIResponseMessageListener implements MessageListener
{
	public static final Category LOG =
	Category.getInstance( RMIResponseMessageListener.class.getName() );


	/**
	 * Gives return values to those waiting for them.
	 * @param msg the message to process
	 * @return true if message is RMIResponseMessage, false otherwise
	 */
	public boolean processMessage( final Message msgArg )
	{
		if ( !( msgArg instanceof RMIResponseMessage ) )
		{
			return false;
		}

		LOG.info( "RMIResponseMessageListener processing message id " + msgArg.getMessageID() );
		final RMIResponseMessage msg = (RMIResponseMessage) msgArg;

		final Long msgID = new Long( msg.getAckedMessageID() );
		final UnaryFunction handler = (UnaryFunction) handlerMap_.get( msgID );

		if ( LOG.isDebugEnabled() )
		{
			NDC.push( "Response to msg ID:" + msgID );
		}
		LOG.info( "***response recvd***" );

		if ( ChannelMessenger.MSG_PERF.isDebugEnabled() )
		{
			ChannelMessenger.MSG_PERF.debug( "got processMessage request for message id " +
			                                 msg.getMessageID() );
		}

		try
		{
			if ( handler != null )
			{
				if ( ChannelMessenger.MSG_PERF.isDebugEnabled() )
				{
					ChannelMessenger.MSG_PERF.debug( "got processing message id " +
					                                 msg.getMessageID() );
				}

				try
				{
					//remove call for method...
					Method method = ClassAndMethodTable.instance().
					getMethod( new Integer( msg.getMethodID() ) );
					Class returnType = ClassAndMethodTable.instance().getClass( new Integer( msg.getReturnTypeID() ) );
					Object[] retArr = null;

					/*if(RMIResponseMessageListener.LOG.isDebugEnabled())
					{
						NDC.push("Response to msg ID:" + msgID +
							", return received for method " +
							method);
					}*/

					RMIResponseMessageListener.LOG.
					debug( "About to get return value" );

					if ( !( returnType.equals( VoidObject.class ) ) )
					{
						retArr = ARMIProxyFactory.
						readObjsFromMessage( msg, new Class[]
						{returnType} );
					}
					RMIResponseMessageListener.LOG.
					debug( "Got return value" );

					final Object returnedValue =
					retArr != null ? retArr[0] : null;

					handler.execute( returnedValue );
					handlerMap_.remove( msgID );

					RMIResponseMessageListener.LOG.
					debug( "Handled return value" );
				}
				catch ( IOException e )
				{
					RMIResponseMessageListener.LOG.
					error( e.getMessage(), e );
				}
				finally
				{
					if ( RMIResponseMessageListener.LOG.
					isDebugEnabled() )
					{
						NDC.pop();
					}
				}
			}
			else
			{
				if ( LOG.isDebugEnabled() )
				{
					LOG.debug( "Received response for message " + msgID +
					           ", no one was waiting for it" );
				}

				//we retry after a wait period.  First 5 seconds, then
				//10, then 15, then we quit retrying
				//TODO: after we start using ReturnValue, we should keep
				//a list of unhandled return values, checking each handler
				//added to make sure that its message hasn't already been
				//received, and removing the unhandled values from the list
				//in the ReturnValue finalize
				IntWrapper iw = (IntWrapper) retryMap_.get( msgID );
				if ( iw == null )
				{
					iw = new IntWrapper( 1 );
					retryMap_.put( msgID, iw );
				}
				else
				{
					iw.setValue( iw.getValue() + 1 );
				}
				if ( iw.getValue() < 4 )
				{
					int timeToWait = iw.getValue() == 1 ? 1 : iw.getValue() * 5;
					LOG.debug( "waiting " + timeToWait + " seconds then checking again for return value handler" );
					SyncedTimer.instance().
					add( new TimedEvent( timeToWait,
					                     false, new VoidFunction()
					                     {
						                     public Object execute()
						                     {
							                     processMessage( msgArg );
							                     return null;
						                     }
					                     } ) );
				}
				else
				{
					LOG.debug( "finished " + iw.getValue() +
					           " retries; discarding response id " + msgID );
				}
			}
		}
		finally
		{
			if ( LOG.isDebugEnabled() )
			{
				NDC.pop();
			}
		}

		return true;
	}


	public void waitForReturn( long msgID )
	{
		waitForReturn( msgID, void.class );
	}


	public Object waitForReturn( final long msgID, final Class returnType )
	{
		if ( returnType.equals( void.class ) )
		{
			LOG.warn( "waiting for returns on methods returning void (except 'init') is currently not supported",
			          new Exception() );
		}

		final Lock lock = new Lock();
		lock.lock();

		LOG.info( "Waiting for return on msgID " + msgID + ", lock " + lock );
		final Wrapper wrapper = new Wrapper();
		addHandler( msgID, new UnaryFunction()
		{
			public Object execute( Object returnedValue )
			{
				if ( RMIResponseMessageListener.LOG.isDebugEnabled() )
				{
					RMIResponseMessageListener.LOG.
					debug( "Caught return on lock " + lock +
					       " msg id: " + msgID );
				}

				if ( RMIResponseMessageListener.LOG.isDebugEnabled() )
				{
					RMIResponseMessageListener.LOG.
					debug( "In sync" );
				}

				if ( !( returnType.equals( void.class ) ) )
				{
					wrapper.setContents( returnedValue );
				}

				if ( RMIResponseMessageListener.LOG.isDebugEnabled() )
				{
					RMIResponseMessageListener.LOG.debug( "Notifying" );
				}

				lock.unlock();
				return null;
			}
		} );

		lock.waitFor();

		return wrapper.getContents();
	}


	public void addHandler( long msgID, UnaryFunction handler )
	{
		addHandler( new Long( msgID ), handler );
	}


	public void addHandler( Long msgID, UnaryFunction handler )
	{
		handlerMap_.put( msgID, handler );
	}


	protected RMIResponseMessageListener()
	{
	}


	public static RMIResponseMessageListener instance()
	{
		if ( instance_ == null )
		{
			instance_ = new RMIResponseMessageListener();
		}

		return instance_;
	}


	protected Map handlerMap_ = new HashMap();
	protected Map retryMap_ = new HashMap();
	protected TaskMaster taskMaster_ = new TaskMaster( 10, false );

	protected static RMIResponseMessageListener instance_;

	//debugging code follows
}
