package com.navtools.armi;

import com.navtools.serialization.DataStreamable;
import com.navtools.util.UnaryFunction;
import com.navtools.util.VoidObject;
import org.apache.log4j.Category;

public class ReturnValue
{
	public static final Category LOG =
	Category.getInstance( ReturnValue.class.getName() );
	protected Object value;

	//dummy ctor for null return values
	public ReturnValue( boolean dummy1, boolean dummy2 )
	{
		value = null;
	}

	public ReturnValue()
	{
		value = new VoidObject();
	}

	public ReturnValue( Object o )
	{
		value = o;
	}

	public ReturnValue( DataStreamable d )
	{
		value = d;
	}

	public ReturnValue( byte b )
	{
		value = new Byte( b );
	}

	public ReturnValue( Byte b )
	{
		value = b;
	}

	public ReturnValue( boolean b )
	{
		value = new Boolean( b );
	}

	public ReturnValue( Boolean b )
	{
		value = b;
	}

	public ReturnValue( char c )
	{
		value = new Character( c );
	}

	public ReturnValue( Character c )
	{
		value = c;
	}

	public ReturnValue( short s )
	{
		value = new Short( s );
	}

	public ReturnValue( Short s )
	{
		value = s;
	}

	public ReturnValue( int i )
	{
		value = new Integer( i );
	}

	public ReturnValue( Integer i )
	{
		value = i;
	}

	public ReturnValue( long l )
	{
		value = new Long( l );
	}

	public ReturnValue( Long l )
	{
		value = l;
	}

	public ReturnValue( float f )
	{
		value = new Float( f );
	}

	public ReturnValue( Float f )
	{
		value = f;
	}

	public ReturnValue( double d )
	{
		value = new Double( d );
	}

	public ReturnValue( Double d )
	{
		value = d;
	}

	public ReturnValue( String s )
	{
		value = s;
	}

	public Class getReturnType()
	{
		return value.getClass();
	}

	public byte getbyte() throws ARMIException
	{
		try
		{
			return ( (Byte) value ).byteValue();
		}
		catch ( Exception e )
		{
			throw new ARMIException( "Wrong return type. Should be " + value.getClass().getName() + "." );
		}
	}

	public void setbyte( byte b )
	{
		value = new Byte( b );
	}

	public Byte getByte() throws ARMIException
	{
		try
		{
			return (Byte) value;
		}
		catch ( Exception e )
		{
			throw new ARMIException( "Wrong return type. Should be " + value.getClass().getName() + "." );
		}
	}

	public void setByte( Byte b )
	{
		value = b;
	}

	public boolean getboolean() throws ARMIException
	{
		try
		{
			return ( (Boolean) value ).booleanValue();
		}
		catch ( Exception e )
		{
			throw new ARMIException( "Wrong return type. Should be " + value.getClass().getName() + "." );
		}
	}

	public void setboolean( boolean b )
	{
		value = new Boolean( b );
	}

	public Boolean getBoolean() throws ARMIException
	{
		try
		{
			return (Boolean) value;
		}
		catch ( Exception e )
		{
			throw new ARMIException( "Wrong return type. Should be " + value.getClass().getName() + "." );
		}
	}

	public void setBoolean( Boolean b )
	{
		value = b;
	}

	public char getchar() throws ARMIException
	{
		try
		{
			return ( (Character) value ).charValue();
		}
		catch ( Exception e )
		{
			throw new ARMIException( "Wrong return type. Should be " + value.getClass().getName() + "." );
		}
	}

	public void setchar( char c )
	{
		value = new Character( c );
	}

	public Character getCharacter() throws ARMIException
	{
		try
		{
			return (Character) value;
		}
		catch ( Exception e )
		{
			throw new ARMIException( "Wrong return type. Should be " + value.getClass().getName() + "." );
		}
	}

	public void setCharacter( Character c )
	{
		value = c;
	}

	public short getshort() throws ARMIException
	{
		try
		{
			return ( (Short) value ).shortValue();
		}
		catch ( Exception e )
		{
			throw new ARMIException( "Wrong return type. Should be " + value.getClass().getName() + "." );
		}
	}

	public void setshort( short s )
	{
		value = new Short( s );
	}

	public Short getShort() throws ARMIException
	{
		try
		{
			return (Short) value;
		}
		catch ( Exception e )
		{
			throw new ARMIException( "Wrong return type. Should be " + value.getClass().getName() + "." );
		}
	}

	public void setShort( Short s )
	{
		value = s;
	}

	public int getint() throws ARMIException
	{
		try
		{
			return ( (Integer) value ).intValue();
		}
		catch ( Exception e )
		{
			throw new ARMIException( "Wrong return type. Should be " + value.getClass().getName() + "." );
		}
	}

	public void setint( int i )
	{
		value = new Integer( i );
	}

	public Integer getInteger() throws ARMIException
	{
		try
		{
			return (Integer) value;
		}
		catch ( Exception e )
		{
			throw new ARMIException( "Wrong return type. Should be " + value.getClass().getName() + "." );
		}
	}

	public void setInteger( Integer i )
	{
		value = i;
	}

	public long getlong() throws ARMIException
	{
		try
		{
			return ( (Long) value ).longValue();
		}
		catch ( Exception e )
		{
			throw new ARMIException( "Wrong return type. Should be " + value.getClass().getName() + "." );
		}
	}

	public void setlong( long l )
	{
		value = new Long( l );
	}

	public Long getLong() throws ARMIException
	{
		try
		{
			return (Long) value;
		}
		catch ( Exception e )
		{
			throw new ARMIException( "Wrong return type. Should be " + value.getClass().getName() + "." );
		}
	}

	public void setLong( Long l )
	{
		value = l;
	}

	public float getfloat() throws ARMIException
	{
		try
		{
			return ( (Float) value ).floatValue();
		}
		catch ( Exception e )
		{
			throw new ARMIException( "Wrong return type. Should be " + value.getClass().getName() + "." );
		}
	}

	public void setfloat( float f )
	{
		value = new Float( f );
	}

	public Float getFloat() throws ARMIException
	{
		try
		{
			return (Float) value;
		}
		catch ( Exception e )
		{
			throw new ARMIException( "Wrong return type. Should be " + value.getClass().getName() + "." );
		}
	}

	public void setFloat( Float f )
	{
		value = f;
	}

	public double getdouble() throws ARMIException
	{
		try
		{
			return ( (Double) value ).doubleValue();
		}
		catch ( Exception e )
		{
			throw new ARMIException( "Wrong return type. Should be " + value.getClass().getName() + "." );
		}
	}

	public void setdouble( double d )
	{
		value = new Double( d );
	}

	public Double getDouble() throws ARMIException
	{
		try
		{
			return (Double) value;
		}
		catch ( Exception e )
		{
			throw new ARMIException( "Wrong return type. Should be " + value.getClass().getName() + "." );
		}
	}

	public void setDouble( Double d )
	{
		value = d;
	}

	public String getString() throws ARMIException
	{
		try
		{
			return (String) value;
		}
		catch ( Exception e )
		{
		}
		return value.toString();
	}

	public void setString( String s )
	{
		value = s;
	}

	public void onReturn( UnaryFunction listener )
	{
		listener.execute( getValue() );
	}

	public Object getValue()
	{
		return value;
	}

	//call to dummy ctor for null objects
	public static final ReturnValue NULL = new ReturnValue( false, false );
}
