package com.navtools.armi.examples;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.InetAddress;

import javax.swing.*;

import com.navtools.armi.ARMI;
import com.navtools.armi.RMIMessageListener;
import com.navtools.armi.ReturnValue;
import org.apache.log4j.xml.DOMConfigurator;

public class ARMIChatClient extends JFrame implements ARMIChatClientInterface, ActionListener
{
	private JTextArea chatText;
	private JTextArea msgText;
	private JButton sendMessage;

	// A proxy instance of the server that is a remote object.
	private ARMIChatServerInterface server;
	// The host name of the server
	private String host;
	// The name to use in the chat room.
	private String chatAlias;


	public ARMIChatClient( String host, String chatAlias )
	{
		super( "ARMI Chat Client" );
		this.chatAlias = chatAlias;
		this.host = host;
		Container content = getContentPane();
		chatText = new JTextArea();
		chatText.setEditable( false );
		msgText = new JTextArea( 4, 30 );
		sendMessage = new JButton( "Send message" );
		sendMessage.addActionListener( this );
		content.setLayout( new BorderLayout() );
		JPanel p = new JPanel();
		content.add( "Center", new JScrollPane( chatText ) );
		p.add( new JScrollPane( msgText ) );
		p.add( sendMessage );
		content.add( "South", p );

		try
		{
			// Initialize this as  an ARMI client
			ARMI.initialize( InetAddress.getByName( host ) );


			// Get a proxy object to an instance of ARMIChatServerInterface on the Chat Server
			server = (ARMIChatServerInterface)ARMI.getProxy(ARMIChatServerInterface.class, InetAddress.getByName( host ) );
//			server = (ARMIChatServerInterface) ARMIProxyFactory.newInstance( ARMIChatServerInterface.class,
//			                                                                 InetAddress.getByName( host ) );

		}
		catch ( Exception e )
		{
			System.out.println( "Server must be down, I can't connect!" );
			e.printStackTrace();
		}

		setSize( 500, 200 );
		setVisible( true );

		this.addWindowListener( new WindowAdapter()
		{
			public void windowClosing( WindowEvent we )
			{
				System.exit( 0 );
			}
		} );
	}


	public static void main( String[] args )
	{

		/*if(args.length != 2) {
			System.out.println("Usage: java ARMIChatClient <host> <chatAlias>");
			System.exit(0);
		}*/

		DOMConfigurator.configureAndWatch( "log4j_cfg.xml" );

		try
		{
			ARMIChatClient client = new ARMIChatClient( "localhost", "GK" );
			System.out.println( "Establishing connection to " + InetAddress.getByName( "www.ageofstorms.com" ).getHostAddress() );

			// Share the client object to make it remotely accessible
			ARMI.share(client, ARMIChatClientInterface.class); // this is not implemented in ARMI 0.2
//			RMIMessageListener.instance().addInstance( client, ARMIChatClientInterface.class );

			client.connect();
		}
		catch ( Exception e )
		{
			System.out.println( "Server must be down!" );
			e.printStackTrace();
		}
	}


	/**
	 * Method to use when you want to connect this client to the chat server.
	 */
	public void connect()
	{
		// Call addClient on the remote object server
		if ( server == null )
		{
			System.out.println( "No server connection!" );
			System.exit( -1 );
		}
		else
		{
			server.addClient( this );
		}
	}


	/**
	 * Method with a kind of silly name since it doesn't really send a message, but
	 * it's the method the server uses on the remote client objects to send a message
	 * so I guess it makes sense :-) The implementation of the ARMIChatClientInterface.
	 */
	public ReturnValue /*void*/ sendMessage( final String sender, final String message )
	{
		System.out.println( "JS: ARMIChatClient.sendMessage : begin" );

		try
		{
			SwingUtilities.invokeLater( new Runnable()
			{
				public void run()
				{
					chatText.append( sender + ": " + message + "\n" );
				}
			} );
		}
		catch ( Exception e )
		{
			e.printStackTrace();
		}
		System.out.println( "JS: ARMIChatClient.sendMessage -> end" );
		return new ReturnValue();
	}


	public void actionPerformed( ActionEvent ae )
	{
		// When the button is pressed call the submitMessage method on the remote server
		// object to send the message.
		server.submitMessage( chatAlias, msgText.getText() );
		msgText.setText( "" );
	}
}
