package com.navtools.armi.examples;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;

import com.navtools.armi.ARMI;
import com.navtools.armi.RMIMessageListener;
import com.navtools.armi.ReturnValue;
import org.apache.log4j.xml.DOMConfigurator;

/**
 * Simple ARMI chat server.
 * An example of how ARMI can be used in it's simplest form.
 * The concentration is on the ARMI specific code and therefore only
 * those parts are commented.
 *
 * The class implements the ARMIChatServerInterface, which is used
 * by client programs to get a proxy object to the server.
 *
 * @author Henrik Eriksson
 *
 */

public class ARMIChatServer implements ARMIChatServerInterface
{

	private ArrayList clients = new ArrayList();


	public static void main( String[] args )
	{

		try
		{
			DOMConfigurator.configureAndWatch( "log4j_cfg.xml" );
			// Initialize this as the ARMI Registry server
			ARMI.initializeAsRegistryServer();

			// Create a new instance of this class
			ARMIChatServer server = new ARMIChatServer();

			// Call this method to share the instance we just created and start
			// listening for remote method calls on it
			ARMI.share(server, ARMIChatServerInterface.class); // this is not implemented in ARMI 0.2
//			RMIMessageListener.instance().addInstance( server, ARMIChatServerInterface.class );

			BufferedReader input = new BufferedReader( new InputStreamReader( System.in ) );
			String command;
			while ( !( command = input.readLine() ).equals( "quit" ) )
			{
				System.out.println( "To quit enter: quit" );
			}
			System.exit( 0 );

		}
		catch ( Exception e )
		{
			e.printStackTrace();
		}
	}


	/**
	 * Implementation of the ARMIChatServerInterface method.
	 *
	 */
	public ReturnValue /*void*/ addClient( ARMIChatClientInterface client )
	{
		// Adds this remote client object to a list of connected clients
		System.out.println( "JS REMOTE INVOKE: adding client" );
		clients.add( client );
		return new ReturnValue();
	}


	/**
	 * Implementation of the ARMIChatServerInterface method.
	 *
	 */
	public ReturnValue /*void*/ submitMessage( String sender, String message )
	{
		System.out.println( "JS REMOTE INVOKE: got a message from " + sender + ": " + message );
		Iterator it = clients.iterator();

		// Step through the list of connected clients and send the received message
		// to them one at a time by calling the sendMessage method. This will result
		// in a remote method call since the clients are shared objects that reside
		// on the client side.
		while ( it.hasNext() )
		{
			System.out.println( "JS: going to call sendMessage on a client" );
			ARMIChatClientInterface c = (ARMIChatClientInterface) it.next();
			System.out.println( "JS: got the client interface HHHHHHHHHHHHHHH->" );
			c.sendMessage( sender, message );
		}

		System.out.println( "JS: ARMIChatServer.submitMessage() --> end" );
		return new ReturnValue();
	}


}
