package com.navtools.armi.examples;

/**
 * Class that can be used to start multiple clients on the same machine. Starts a new JVM for each.
 * Can (and should) be further developed. Adding a gui where you can change different parameters and
 * see results etc...
 *
 * @author Henrik Eriksson
 */
public class ClientStarter {
	public static void main(String[] args) {
		// lazy check of arguments...
		if(args.length != 7) {
			System.out.println("Usage: ClientStarter <numClients> <clientClass> <host> <numMethodCalls> <minStringSize> <maxStringSize> <timeBetween>");
			return;
		}
		int numClients = Integer.parseInt(args[0]);
		final String[] rtArgs = new String[7];
		rtArgs[0] = "java";
		System.arraycopy(args, 1, rtArgs, 1, args.length - 1);
		
		
		final Runtime rt = Runtime.getRuntime();
		try {
		for(int i = 0; i < numClients; i++) {
			final int x = i;
			new Thread() {public void run() {
				try {
				Process p = rt.exec(rtArgs);
				System.out.println("Client "+x+" started");
				
				java.io.InputStream is = p.getErrorStream();
				StringBuffer buff = new StringBuffer();
				for(int ii = is.read(); ii > -1; ii = is.read()) {
					buff.append((char)ii);
				}
			
				System.out.println(buff.toString());
			
				p.destroy();
			}
			catch(Exception e) {}
			}
		}.start();
		}
	}
	catch(Exception ie ) {ie.printStackTrace();}
}
}
			