package com.navtools.armi.examples;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Set;

import com.navtools.armi.ARMI;
import com.navtools.armi.ARMIProxyFactory;
import com.navtools.util.PerformanceMonitor;
import org.apache.log4j.xml.DOMConfigurator;
public class PerfClient {
	
	public static void main(String[] args) {
		// So we don't need to initialize the PerformanceMonitor when we use it the first time
		PerformanceMonitor.instance();
		PerfInterface server = null;
		DOMConfigurator.configureAndWatch("log4j_cfg.xml");
		// lazy check of arguments...
		if(args.length != 5) {
			System.out.println("Usage: PerfClient <host> <numMethodCalls> <minStringSize> <maxStringSize> <timeBetween>");
			System.exit(0);
		}
		String host = args[0];
		int numCalls = Integer.parseInt(args[1]);
		int minSize = Integer.parseInt(args[2]);
		int maxSize = Integer.parseInt(args[3]);
		int waitTime = Integer.parseInt(args[4]);

		try {
			// Initialize this as  an ARMI client
			ARMI.initialize(InetAddress.getByName(host));

			// Get a proxy object to an instance of ARMIChatServerInterface on the Chat Server
			server = (PerfInterface)ARMIProxyFactory.newInstance(PerfInterface.class,InetAddress.getByName(host));
		}
		catch(Exception e) {e.printStackTrace();}
		
		byte[] b= new byte[maxSize];
		
		for(int i = 0; i < b.length; i++) b[i] = (byte)'A';
		Long x = new Long(3);
		int sizeSpan = maxSize - minSize;
		long start = System.currentTimeMillis();
		for(int i = 0; i < numCalls; i++) {
			try {
				Thread.sleep(waitTime);
			}
			catch(Exception ie) {}
			int random = (int)(Math.random()*sizeSpan) + minSize;
			byte[] b3 = new byte[random];
			System.arraycopy(b,0,b3,0,random);
			server.dummy(new String(b3));
		}
		Set clients = ARMI.getClients();
		Iterator it = clients.iterator();
		while(it.hasNext()) {
			Long l = (new Long(((java.nio.channels.SelectionKey)it.next()).hashCode()+""));
			System.out.println("Average msg build time: " +  PerformanceMonitor.instance().getAverageMsgBuildTime(l));
			System.out.println("Total msg build time: " +  PerformanceMonitor.instance().getTotalMsgBuildTime(l));
			System.out.println("Average message send time: " +PerformanceMonitor.instance().getAverageMsgSendTime(l));
			System.out.println("Total message send time: " +PerformanceMonitor.instance().getTotalMsgSendTime(l));
			
		}
		try {
			BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
			String command;
			while(!(command = input.readLine()).equals("quit")) {
				System.out.println("To quit enter: quit");
			}
		}
		catch(IOException ie) {}
		System.exit(0);
	}
	
	
	
}
