package com.navtools.armi.examples;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Set;

import com.navtools.armi.ARMI;
import com.navtools.armi.ReturnValue;
import com.navtools.util.PerformanceMonitor;
import org.apache.log4j.xml.DOMConfigurator;

/**
 * Server to com.navtools.networking.armi.networking.test the performance monitor and to run stresstests on ARMI.
 * It implements the PerfInterface which has one method that takes a String as
 * argument and returns the same String. The dummy method prints the number of 
 * a static counter everytime it's called.
 *
 * @author Henrik Eriksson
 *
 */

public class PerfServer implements PerfInterface {

	public static int counter = 0;
	public static void main(String[] args) {
		
		try {
			DOMConfigurator.configureAndWatch("log4j_cfg.xml");
			// Initialize this as the ARMI Registry server
			ARMI.initializeAsRegistryServer();
			// Initializes the PerformanceMonitor
			PerformanceMonitor.instance();

			// Create a new instance of this class
			PerfServer server = new PerfServer();

			// Call this method to share the instance we just created and start
			// listening for remote method calls on it
			ARMI.share(server, PerfInterface.class); // this is not implemented in ARMI 0.2
			
			BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
			String command;
			
			while(!(command = input.readLine()).equals("quit")) {
				System.out.println("To quit enter: quit");
			}
			long t = System.currentTimeMillis();
						
			Set clients = ARMI.getClients();
			Iterator it = clients.iterator();
			while(it.hasNext()) {
				 Long m = (new Long(((java.nio.channels.SelectionKey)it.next()).hashCode()+""));
				
				System.out.println("Incoming bytes total for "+m +" "+PerformanceMonitor.instance().getIncomingBytesTotal(m));
				System.out.println("Incoming bytes last second for "+m +" "+PerformanceMonitor.instance().getIncomingBytesLastSec(m));
				System.out.println("Outgoing bytes total for "+m +" "+PerformanceMonitor.instance().getOutgoingBytesTotal(m));
				System.out.println("Outgoing bytes last second for "+m +" "+PerformanceMonitor.instance().getOutgoingBytesLastSec(m));
				System.out.println("Average incoming bytes per second for "+m +" "+PerformanceMonitor.instance().getAverageIncomingBytesSec(m));
				System.out.println("Average outgoing bytes per second for "+m +" "+PerformanceMonitor.instance().getAverageOutgoingBytesSec(m));
				System.out.println("Average throughput bytes per second for "+m +" "+PerformanceMonitor.instance().getAverageThroughputSec(m));
				System.out.println("Total hroughput in bytes per for "+m +" "+PerformanceMonitor.instance().getTotalThroughput(m));
				System.out.println("Average message build time for "+m +" "+PerformanceMonitor.instance().getAverageMsgBuildTime(m));
				System.out.println("Total message build time for "+m +" "+PerformanceMonitor.instance().getTotalMsgBuildTime(m));
				System.out.println("Average message send time for "+m +" "+PerformanceMonitor.instance().getAverageMsgSendTime(m));
				System.out.println("Total message send time for "+m +" "+PerformanceMonitor.instance().getTotalMsgSendTime(m));
				System.out.println("Average method reconstruction time for "+m +" "+PerformanceMonitor.instance().getAverageMcReconstructTime(m));
				System.out.println("Total method reconstruction time for "+m +" "+PerformanceMonitor.instance().getTotalMcReconstructTime(m));
				System.out.println("Throughput last sec for "+m +" "+PerformanceMonitor.instance().getThroughputLastSec(m));
				System.out.println("----------");
			}
			System.out.println("Incoming bytes total "+PerformanceMonitor.instance().getIncomingBytesTotal());
			System.out.println("Incoming bytes last second "+PerformanceMonitor.instance().getIncomingBytesLastSec());
			System.out.println("Outgoing bytes total "+PerformanceMonitor.instance().getOutgoingBytesTotal());
			System.out.println("Outgoing bytes last second "+PerformanceMonitor.instance().getOutgoingBytesLastSec());
			System.out.println("Average incoming bytes per second "+PerformanceMonitor.instance().getAverageIncomingBytesSec());
			System.out.println("Average outgoing bytes per second "+PerformanceMonitor.instance().getAverageOutgoingBytesSec());
			System.out.println("Average throughput bytes per second "+PerformanceMonitor.instance().getAverageThroughputSec());
			System.out.println("Total throughput in bytes "+PerformanceMonitor.instance().getTotalThroughput());
			System.out.println("Throughput last sec for "+PerformanceMonitor.instance().getThroughputLastSec());
			System.exit(0);
		
		}
		catch(Exception e) {e.printStackTrace();}
	}

	/**
  	 * Implementation of the ARMIChatServerInterface method.
  	 *
	 */
	public ReturnValue /*String*/ dummy(String chunk) {
		//System.out.println("Counter = "+ counter++);
		return new ReturnValue(chunk);
	}
	
	
	
}
