package com.navtools.armi.examples;

import java.net.InetAddress;

import com.navtools.armi.ARMI;
import com.navtools.armi.ReturnValue;
import org.apache.log4j.xml.DOMConfigurator;

public class SimpleClient
{

	public static void main( String[] args )
	{
		DOMConfigurator.configureAndWatch( "log4j_cfg.xml" );

		try
		{
			InetAddress serverIP = InetAddress.getByName( "enterprise" );
			System.out.println( "Server " + serverIP.getHostAddress() );
			ARMI.initialize( serverIP );
			System.out.println( "JS:getting the proxy object" );
			SimpleServerInterface server = (SimpleServerInterface) ARMI.getProxy( SimpleServerInterface.class, serverIP );
			System.out.println( "JS: calling the submit method" );
			for ( int i = 0; i < 100; i++ )
			{
				System.out.println( "Sending..." );
				System.out.flush();
				ReturnValue returnValue = server.submitMessage( "Hi there, how are you today " + i );
				System.out.println( "Response was: " + returnValue.getString() );
				System.out.flush();
			}
		}
		catch ( Exception e )
		{
			System.out.println( "Exception thrown in SimpleClient:main " + e.getMessage() );
			e.printStackTrace();
		}
	}
}
