/*
 * $Id: AckMessage.java,v 1.1 2003/09/06 21:49:21 wurp Exp $
 */

package com.navtools.armi.networking;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import com.navtools.util.Prototype;
import org.apache.log4j.Category;

public class AckMessage extends Message
{
	public static final Category LOG =
	Category.getInstance( AckMessage.class.getName() );


	public AckMessage( long messageID, long ackedMessageID )
	{
		super( messageID );
		ackedMessageID_ = ackedMessageID;
	}


	public AckMessage()
	{
	}


	public Prototype defaultInstance()
	{
		return new AckMessage();
	}


	public long getAckedMessageID()
	{
		return ackedMessageID_;
	}


	public void writeTo( DataOutputStream out ) throws IOException
	{
		super.writeTo( out );
		out.writeLong( ackedMessageID_ );
	}


	public void readFrom( DataInputStream in ) throws IOException
	{
		super.readFrom( in );
		ackedMessageID_ = in.readLong();
	}


	public int getType()
	{
		return TYPE;
	}


	public static final int TYPE = 1;

	protected long ackedMessageID_;
}
