/*
 * $Id: AckMessageListener.java,v 1.1 2003/09/06 21:49:21 wurp Exp $
 * $Log: AckMessageListener.java,v $
 * Revision 1.1  2003/09/06 21:49:21  wurp
 * Migrated stuff from ARMI into here
 *
 * Revision 1.1  2003/08/18 17:12:42  gergiskhan
 * Refactoring.  Changed package structure.
 *
 * Revision 1.1  2003/08/08 02:17:20  gergiskhan
 * no message
 *
 * Revision 1.1.1.1  2001/06/26 00:55:29  wurp
 * importing initial rev of source
 *
 * Revision 1.2  2001/06/20 03:36:06  wurp
 * added log4j.
 * debugging character creation issues.
 *
 * Revision 1.1  2001/04/06 05:33:08  wurp
 * Reorganized networking code
 *
 * Revision 1.1  2001/03/19 01:51:31  wurp
 * Adding new Asynchronous Messaging system.  Needs more testing, but superficial
 * tests show it working.
 *
 */

package com.navtools.armi.networking;

import org.apache.log4j.Category;

public class AckMessageListener implements MessageListener
{
	public static final Category LOG =
	Category.getInstance( AckMessageListener.class.getName() );

	/**
	 * Removes the message from the expected ack list, if it's an AckMessage.
	 * @param msg the message to process
	 * @return false
	 */
	public boolean processMessage( Message msg )
	{
		if ( !( msg instanceof AckMessage ) )
		{
			return false;
		}

		ackReceivedFor( ( (AckMessage) msg ).getAckedMessageID() );

		return false;
	}

	public void expectAckFor( long msgID )
	{
		//TODO handle expecting acks; repeat messages if no ack received in
		//timely manner
	}

	public void ackReceivedFor( long msgID )
	{
		//TODO
	}

	protected AckMessageListener()
	{
	}

	public static AckMessageListener instance()
	{
		if ( instance_ == null )
		{
			instance_ = new AckMessageListener();
		}

		return instance_;
	}

	protected static AckMessageListener instance_;
}
