package com.navtools.armi.networking;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.util.Hashtable;
import java.util.Set;
import java.net.ConnectException;

import com.navtools.util.ByteQueue;
import org.apache.log4j.Category;

public class ChannelMessenger
implements UDPMessengerInterface
{

    public static final Category LOG =
    Category.getInstance( UDPMessengerInterface.class.getName() );

    public static final Category MSG_PERF =
    Category.getInstance( "performance.networking" );


    protected ChannelMessenger( int listenPort )
    {
        listenPort_ = listenPort;
        messengerID_ = new MessengerID( new ServerAddress( serverAddress_, serverPort_ ), 0 );
    }


    protected ChannelMessenger( InetAddress serverAddress, int serverPort, int listenPort )
    {
        this( listenPort );
        serverPort_ = serverPort;
        serverAddress_ = serverAddress;
    }


    public static ChannelMessenger establish( int listenPort ) throws Exception
    {
        if ( instance_ == null )
        {
            instance_ = new ChannelMessenger( listenPort );
            instance_.startCommunicator();
            return instance_;
        }
        else
        {
            return instance_;
        }
    }


    public static ChannelMessenger establishAndConnect( InetAddress serverAddress, int serverPort, int listenPort ) throws Exception
    {
        if ( instance_ == null )
        {
            instance_ = new ChannelMessenger( serverAddress, serverPort, listenPort );
            try {
                instance_.startCommunicator();
            }
            catch (Exception e) {
                if ( e.getClass() == SocketException.class || e.getClass() == ConnectException.class )
	        {
                    instance_ = null;
	            throw e;
                }    
            }
            return instance_;
        }
        else
        {
            return instance_;
        }
    }


    protected void startCommunicator() throws Exception
    {

        try
        {
            comm_ = new ChannelCommunicator( serverAddress_, serverPort_, listenPort_, new ChannelDataServerListener()
            {
                public void newData( SelectionKey key, byte[] data )
                {
                    if ( imq_ != null )
                    {
                        imq_.pushNewData( data, key );
                    }
                    else
                    {
                        /*
                        ByteQueue queue = (ByteQueue)clientKeyHash_.get(key);
                        // Check if this is a brand new connection
                                if (queue == null) {
                            queue = new ByteQueue();
                                clientKeyHash_.put(key,queue);
                        }
                        queue.push(data);
                                    */
                    }
                }
            } );
        }
        catch ( Exception e )
        {

            if ( e.getClass() == SocketException.class || e.getClass() == ConnectException.class )
            {
                throw e;
            }
            else
            {
                LOG.error( "Exception thrown when client connection", e );
            }

        }
    }


    public void setLocalAddress( InetAddress localAddress )
    {
        messengerID_.setAddress( localAddress );
    }


    public InetAddress getLocalAddress()
    {
        return messengerID_.getAddress();
    }


    public void send( Packet p ) throws IOException
    {
        comm_.write( p.getChannelKey(), p.getData() );
    }


    public void receive( Packet p ) throws IOException
    {
        System.out.println( "This is deprecated do not call receive on ChannelMessenger" );
    }


    public void close()
    {
        LOG.info( "Close called" );
        try {
           comm_.serverKey_.channel().close();
        }
        catch (Exception e) {
            LOG.error("Exception trying to close channel",e);
        }
        instance_ = null;
    }


    public int getLocalPort()
    {
        return messengerID_.getPort();
    }


    public MessengerID getMessengerID()
    {
        return messengerID_;
    }


    public void addDisconnectionListener(SelectionKey key,
                                         DisconnectionListener dcb)
    {
        if (key != null) {
            LOG.debug("Adding disconnection listener for key: "+key);
            comm_.addDisconnectionListener(dcb, key);
        }
    }

    public void addDisconnectionListener( MessengerID messengerID,
                                          DisconnectionListener dcb )
    {
        SelectionKey key = getKeyForAddress( messengerID.getServerAddress() );
        if ( key != null )
        {
            LOG.debug( "Adding disconnection listener for key: " + key );
            comm_.addDisconnectionListener( dcb, key );
        }
    }


    public Set getClients()
    {
        return comm_.getSelector().keys();
    }


    public void setIncomingMessageQueue( StandardUDPIncomingMessageQueue imq )
    {
        imq_ = imq;
    }


    public static ChannelMessenger getInstance()
    {
        return instance_;
    }


    public InetAddress getServerAddress()
    {
        return serverAddress_;
    }


    public int getPort()
    {
        return serverPort_;
    }


    public SelectionKey getKeyForAddress( ServerAddress address )
    {
        if (comm_ != null) return comm_.getKeyForAddress( address );
        else return null;
    }


    protected MessengerID messengerID_ = null;
    protected static ChannelMessenger instance_ = null;
    protected InetAddress serverAddress_ = null;
    protected int serverPort_ = 0xB0B;
    protected int listenPort_ = 0xB0B;
    protected ChannelCommunicator comm_ = null;
    protected Hashtable clientKeyHash_ = new Hashtable();
    protected ByteQueue fromServerInQueue_ = new ByteQueue();
    protected StandardUDPIncomingMessageQueue imq_ = null;
}
