/*
 * $Id: DisconnectionListened.java,v 1.1 2003/09/06 21:49:21 wurp Exp $
 */

package com.navtools.armi.networking;

/**
 * Your remotely accessed class should implement this if you want
 * to be able to listen for disconnections.  You can just give an
 * empty body for the listenForDisconnection method; calls to this
 * method will be intercepted by ARMI and the listener will thereafter
 * be called whenever the connection for the remote instance is lost.
 */
public interface DisconnectionListened
{
	public void listenForDisconnection( DisconnectionListener dl );

	public static final String DISCONNECT_CALLBACK = "listenForDisconnection";
}
