/*
 * $Id: Message.java,v 1.1 2003/09/06 21:49:21 wurp Exp $
 */

package com.navtools.armi.networking;

import java.io.*;
import java.nio.channels.SelectionKey;
import java.util.HashMap;
import java.util.Map;

import com.navtools.serialization.DataStreamable;
import com.navtools.serialization.DataStreamableUtil;
import com.navtools.util.A;
import com.navtools.util.Prototype;
import org.apache.log4j.Category;

public abstract class Message implements DataStreamable, Prototype
{
	public static final Category LOG =
	Category.getInstance( Message.class.getName() );

	public Message( long messageID )
	{
		messageID_ = messageID;
	}

	public Message()
	{
	}

	public long getMessageID()
	{
		return messageID_;
	}

	public MessengerID getOrigin()
	{
		return origin_;
	}

	public void setOrigin( MessengerID origin )
	{
		origin_ = origin;
	}

	/**
	 * Add an object to the message to be sent.  Objects can be read off
	 * from the received message in the order they were added.
	 */
	public void add( Object element )
	{
		A.ssert( !reading_, "Cannot add elements to a Message after you have " +
		                    "begun reading from it" );

		try
		{
			DataStreamableUtil.writeTo( element, dataOutStream_ );
		}
		catch ( IOException e )
		{
			LOG.error( e.getMessage(), e );
		}
	}

	/**
	 * Add an object to the message to be sent.  Objects can be read off
	 * from the received message in the order they were added.
	 */
	public void add( byte[] bytes )
	{
		A.ssert( !reading_, "Cannot add elements to a Message after you have " +
		                    "begun reading from it" );

		try
		{
			dataOutStream_.write( bytes );
		}
		catch ( IOException e )
		{
			LOG.error( e.getMessage(), e );
		}
	}

	public void writeTo( DataOutputStream out ) throws IOException
	{
		out.writeInt( getType() );
		out.writeLong( messageID_ );
		byte[] bytes = byteStream_.toByteArray();
		out.writeInt( bytes.length );
		out.write( bytes );
	}

	public void readFrom( DataInputStream in ) throws IOException
	{
		//throw away type; we had to use it to get this far
		in.readInt();
		messageID_ = in.readLong();
		int length = in.readInt();
		byte[] data = new byte[length];
		in.read( data );
		dataInputStream_ = new DataInputStream( new ByteArrayInputStream( data ) );
		reading_ = true;
	}

	public abstract int getType();

	public static void register( int type, Message canonicalInstance )
	{
		prototypes_.put( new Integer( type ), canonicalInstance );
	}

	public static Message buildMessage( int type, DataInputStream in )
	throws IOException
	{
		Message msg = (Message) ( (Message) prototypes_.
		get( new Integer( type ) ) ).defaultInstance();
		if ( LOG.isDebugEnabled() )
		{
			LOG.debug( "Populating Message prototype from input stream" );
		}
		msg.readFrom( in );
		if ( LOG.isDebugEnabled() )
		{
			LOG.debug( "Done populating Message prototype from input stream" );
		}
		return msg;
	}

	public DataInputStream getDataInputStream()
	{
		reading_ = true;
		if ( dataInputStream_ == null )
		{
			dataInputStream_ =
			new DataInputStream( new ByteArrayInputStream( byteStream_.toByteArray() ) );
		}

		return dataInputStream_;
	}

	public static long getNextID()
	{
		return ++id_;
	}

	public SelectionKey getClientKey()
	{
		return clientKey_;
	}

	public void setClientKey( SelectionKey key )
	{
		clientKey_ = key;
	}

	protected long messageID_;
	protected ByteArrayOutputStream byteStream_ = new ByteArrayOutputStream();
	protected DataOutputStream dataOutStream_ =
	new DataOutputStream( byteStream_ );
	protected DataInputStream dataInputStream_ = null;
	protected boolean reading_ = false;
	protected MessengerID origin_;

	protected static long id_ = 0;
	protected static Map prototypes_ = new HashMap();

	// Using the selection key of the channel to keep track of what client gets this message
	protected SelectionKey clientKey_ = null;
}
