/*
 * $Id: MessengerID.java,v 1.1 2003/09/06 21:49:21 wurp Exp $
 */

package com.navtools.armi.networking;

/**
 *
 *
 * @author Bobby Martin
 * Copyright (c) 2001, all rights reserved
 * Created UTC 2001/10/13 21:39:28
 */

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;

import com.navtools.serialization.DataStreamable;
import org.apache.log4j.Category;

//import org.omg.CORBA.DataInputStream;

public class MessengerID implements Cloneable, DataStreamable
{
	public Category LOG =
	Category.getInstance( MessengerID.class.getName() );


	public MessengerID( ServerAddress addy, long serverID )
	{
		addy_ = addy == null ? new ServerAddress( null, 0 ) : addy;
		setServerID( serverID );
	}


	public MessengerID( InetAddress addy, int port, long serverID )
	{
		this( new ServerAddress( addy, port ), serverID );
	}


	public MessengerID()
	{
		this( null, -1 );
	}


	public Long getServerIDAsLong()
	{
		return serverIDAsLong_;
	}


	public int hashCode()
	{
		return serverIDAsLong_.hashCode();
	}


	public ServerAddress getServerAddress()
	{
		return addy_;
	}


	public InetAddress getAddress()
	{
		return addy_.getIP();
	}


	public void setAddress( InetAddress addy )
	{
		addy_.setIP( addy );
	}


	public int getPort()
	{
		return addy_.getPort();
	}


	public void setPort( int port )
	{
		addy_.setPort( port );
	}


	public long getServerID()
	{
		return serverID_;
	}


	public void setServerID( long serverID )
	{
		serverID_ = serverID;
		serverIDAsLong_ = new Long( serverID_ );
	}


	public String toString()
	{
		return addy_ + ", serverID: " + serverID_;
	}


	public Object clone()
	{
		MessengerID retval = null;
		try
		{
			retval = (MessengerID) super.clone();
		}
		catch ( Exception e )
		{
			LOG.error( "clone", e );
		}

		return retval;
	}


	public void writeTo( DataOutputStream out ) throws IOException
	{
		LOG.debug( "Writing MessengerID to DataOutputStream" );
		addy_.writeTo( out );
		out.writeLong( serverID_ );
	}


	public void readFrom( DataInputStream in ) throws IOException
	{
		LOG.debug( "Reading MessengerID from DataOutputStream" );
		addy_ = new ServerAddress();
		addy_.readFrom( in );
		setServerID( in.readLong() );
	}


	protected ServerAddress addy_;
	protected long serverID_ = -1;
	protected Long serverIDAsLong_ = new Long( -1 );


	public static void main( String[] args )
	{
	}
}
