/*
 * $Id: Packet.java,v 1.1 2003/09/06 21:49:21 wurp Exp $
 */

package com.navtools.armi.networking;

/**
 *
 *
 * @author Bobby Martin
 * Copyright (c) 2001, all rights reserved
 * Created UTC 2001/10/13 21:46:27
 */

import java.net.InetAddress;
import java.nio.channels.SelectionKey;

import org.apache.log4j.Category;

public class Packet implements Cloneable
{
	public Category LOG =
	Category.getInstance( Packet.class.getName() );

	public Packet( byte[] buffer, int buffLength, MessengerID dest )
	{
		sourceOrDest_ = dest;
		buffer_ = buffer;
		buffLength_ = buffLength;
	}

	public Packet( byte[] buffer, int buffLength )
	{
		this( buffer, buffLength, null );
	}

	public byte[] getData()
	{
		return buffer_;
	}

	public void setData( byte[] buffer )
	{
		buffer_ = buffer;
	}

	public void setLength( int length )
	{
		buffLength_ = length;
	}

	public int getLength()
	{
		return buffLength_;
	}

	public InetAddress getAddress()
	{
		return sourceOrDest_.getAddress();
	}

	public void setAddress( InetAddress address )
	{
		sourceOrDest_.setAddress( address );
	}

	public int getPort()
	{
		return sourceOrDest_.getPort();
	}

	public void setPort( int port )
	{
		sourceOrDest_.setPort( port );
	}

	public void setMessengerID( MessengerID newID )
	{
		sourceOrDest_ = newID;
	}

	public MessengerID getMessengerID()
	{
		return sourceOrDest_;
	}

	public Object clone()
	{
		Packet retval = null;
		try
		{
			retval = (Packet) super.clone();
		}
		catch ( Exception e )
		{
			LOG.error( "clone", e );
		}

		return retval;
	}

	public void setChannelKey( SelectionKey channelKey )
	{
		channelKey_ = channelKey;
	}

	public SelectionKey getChannelKey()
	{
		return channelKey_;
	}

	MessengerID sourceOrDest_;
	byte[] buffer_;
	int buffLength_;
	SelectionKey channelKey_ = null;

	public static void main( String[] args )
	{
	}
}
