package com.navtools.armi.networking;

import java.io.IOException;
import java.net.InetAddress;
import java.util.*;

import com.navtools.thread.Lock;
import com.navtools.util.RFCUtil;
import org.apache.log4j.Category;

//import com.sun.corba.se.internal.orbutil.Lock;
//import sun.misc.Lock;

public class SaferUDPMessenger extends UDPMessengerFilter implements Runnable
{
	public static final Category LOG =
	Category.getInstance( SaferUDPMessenger.class.getName() );

	public SaferUDPMessenger( UDPMessengerInterface inner )
	{
		super( inner );
		new Thread( this ).start();
	}

	public void send( Packet p ) throws IOException
	{
		Lock.logBeforeSync();
		synchronized ( this )
		{
			Lock.logBeginSync();

			int pLength = p.getLength();
			byte[] originalBuffer = p.getData();
			byte[] buffer = originalBuffer;

			final int offset = 8;

			//if buffer isn't long enough to accomodate the message id, lengthen
			//it
			if ( buffer.length < pLength + offset )
			{
				buffer = new byte[pLength + offset];
			}

			//first put original message where it was before + offset bytes
			for ( int i = pLength - 1; i >= 0; --i )
			{
				buffer[i + offset] = originalBuffer[i];
			}
			//prepend message id
			RFCUtil.setLong( buffer, 0, getNextMessageID( p.getAddress(), p.getPort() ) );

			//inform the packet of the expanded data and length
			p.setData( buffer );
			p.setLength( pLength + offset );

			//store message for possible resend
			addUnverifiedMessage( p );

			//send message
			inner_.send( p );

			Lock.logEndSync();
		}
		Lock.logAfterSync();
	}

	protected long getNextMessageID( InetAddress addy, int port )
	{
		long retval = 0;

		ServerAddress key = ServerAddress.make( addy, port );
		//get map entry for client
		ClientStats stats = getClientStats( key );

		//retrieve message id from map
		retval = stats.nextMessageIDToSend_;

		//increment message id in map
		++stats.nextMessageIDToSend_;

		//return message id
		return retval;
	}

	protected ClientStats getClientStats( ServerAddress key )
	{
		//check if map entry for client
		ClientStats stats = (ClientStats) clientStatMap_.get( key );
		if ( stats == null )
		{
			//if not, create one and init message id to zero
			stats = new ClientStats();
			clientStatMap_.put( key, stats );
		}

		return stats;
	}

	protected void addUnverifiedMessage( Packet p )
	{
		ServerAddress key = ServerAddress.make( p.getAddress(), p.getPort() );
		//get map entry for client
		ClientStats stats = getClientStats( key );

		//copy the buffer contents for this message
		byte[] buffCopy = new byte[p.getLength()];
		System.arraycopy( p.getData(), 0, buffCopy, 0, buffCopy.length );

		//add it to the list for this client
		stats.unverifiedMessages_.add( buffCopy );
	}

	public void receive( Packet p ) throws IOException
	{
		//TODO
		byte[] buff = p.getData();
		int length = p.getLength();

		//strip off msgid
		long msgID = RFCUtil.getLong( buff, 0 );

		//message IDs less than zero are special messages; msgID is interpreted
		//as message type
		if ( msgID < 0 )
		{
			//is re-request of a previously sent message
			if ( msgID == REREQUEST )
			{
				//TODO
				//resend requested messages, or an error if message not available
			}
			//is notification of last msgid recvd; indicates that all msgIDs
			//up to and including this one have been received
			else
			{
				if ( msgID == RECVD_NOTIFICATION )
				{
					//TODO
					//check nextMessageID for that client = last recvd msgid + 1
					//if not
					//    resend messages from last recvd msgid + 1 thru nextMessageID_ for that client
				}
			}
		}
		//is a standard message, interpreted by a higher layer
		else
		{
			//TODO
			//    verify that the msgid is the next in the sequence for this client
			//    if not
			//        send re-request
			//    else
			//        change last received message id for this client to msgid
			//        inner_.receive(message w/o id)
			inner_.receive( p );
		}
	}

	public void run()
	{
		//TODO
		//every X seconds, tell each client the last msgid recvd from them
	}

	protected Map clientStatMap_ =
	Collections.synchronizedMap( new HashMap() );

	/**
	 * time between pinging ServerAddresses from which we have received
	 * messages with notifications of last msgID received
	 *
	 * This pinging is done to verify that no messages have been dropped.
	 */
	public static final int PING_PERIOD = 5000;

	public static int REREQUEST = -1;
	public static int RECVD_NOTIFICATION = -2;

	public static class ClientStats
	{
		/**
		 * the ID of the last message received from this client
		 */
		public long lastMessageIDRecvd_;

		/**
		 * a list of the message buffers that have been sent to this client
		 * but the client has not acknowledged that it received them
		 * (acknowledgement is implicit by the client telling us back that the
		 * highest ID it has received is higher than this message id, without
		 * re-requesting the message)
		 */
		public List unverifiedMessages_ = new LinkedList();

		/**
		 * the id to slap on the next message to send.  Should then increment
		 * the id
		 */
		public long nextMessageIDToSend_ = 0;
	}
}
