/*
 * $Id: ServerAddress.java,v 1.1 2003/09/06 21:49:21 wurp Exp $
 */

package com.navtools.armi.networking;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;

import com.navtools.serialization.DataStreamable;
import com.navtools.util.MathUtil;
import org.apache.log4j.Category;

public class ServerAddress implements DataStreamable
{
	public static final Category LOG =
	Category.getInstance( ServerAddress.class.getName() );

	//public default ctor only exists for DataStreamableUtil
	public ServerAddress()
	{
	}

	protected ServerAddress( InetAddress addy, int port )
	{
		addy_ = addy;
		port_ = port;
	}

	public static ServerAddress make( InetAddress addy, int port )
	{
		return new ServerAddress( addy, port );
	}

	public InetAddress getIP()
	{
		return addy_;
	}

	public void setIP( InetAddress addy )
	{
		addy_ = addy;
	}

	public int getPort()
	{
		return port_;
	}

	public void setPort( int port )
	{
		port_ = port;
	}

	public void writeTo( DataOutputStream out ) throws IOException
	{
		if ( addy_ == null )
		{ //go right to the source
			addy_ = ChannelMessenger.getInstance().getServerAddress();
			port_ = ChannelMessenger.getInstance().getPort();
		}
		out.write( addy_.getAddress() );
		out.writeInt( port_ );
	}

	public void readFrom( DataInputStream in ) throws IOException
	{
		byte[] address = new byte[4];
		in.read( address );

		StringBuffer addressName = new StringBuffer();
		boolean first = true;
		byte currByte;
		for ( int i = 0; i < address.length; ++i )
		{
			currByte = address[i];
			if ( !first )
			{
				addressName.append( "." );
			}
			first = false;
			addressName.append( MathUtil.asUnsigned( currByte ) );
		}

		addy_ = InetAddress.getByName( addressName.toString() );
		port_ = in.readInt();
	}

	public String toString()
	{
		return ( addy_ != null ? addy_.getHostAddress() : null ) + ":" + port_;
	}

	public int hashCode()
	{
		return ( addy_ != null ? addy_.hashCode() : 0 ) ^ port_;
	}

	public boolean equals( Object obj )
	{
		if ( !( obj instanceof ServerAddress ) )
		{
			return false;
		}
		else
		{
			ServerAddress rhs = (ServerAddress) obj;
			return addy_.equals( rhs.addy_ ) && port_ == rhs.port_;
		}
	}

	protected InetAddress addy_;
	protected int port_;

	//com.navtools.networking.armi.networking.test code follows
	public static void main( String[] args )
	{
	}
}
