/*
 * $Id: StandardUDPOutgoingMessageQueue.java,v 1.1 2003/09/06 21:49:21 wurp Exp $
 */

package com.navtools.armi.networking;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.channels.SelectionKey;

import com.navtools.util.ArrayUtil;
import com.navtools.util.PerformanceMonitor;
import com.navtools.util.ThreadLocalInstance;
import org.apache.log4j.Category;

public class StandardUDPOutgoingMessageQueue implements OutgoingMessageQueue
{
	public static final Category LOG =
	Category.getInstance( StandardUDPOutgoingMessageQueue.class.getName() );

	static private ThreadLocalInstance baosTLI_ = new ThreadLocalInstance()
	{
		public Object make()
		{
			return new ByteArrayOutputStream();
		}

		public void init( Object obj )
		{
			( (ByteArrayOutputStream) obj ).reset();
		}
	};
	static private ThreadLocalInstance dosTLI_ = new ThreadLocalInstance()
	{
		public Object make()
		{
			return new DataOutputStream( (ByteArrayOutputStream) baosTLI_.get() );
		}
	};

	public void send( Message messageToSend, MessengerID destination )
	{
		System.out.println( "THIS IS A BLANK, deprecated METHOD SEND() AND SHOULD NOT BE CALLED!" );
	}

	public void send( Message messageToSend, SelectionKey key )
	{
		ByteArrayOutputStream baos = (ByteArrayOutputStream) baosTLI_.get();
		DataOutputStream dos = new DataOutputStream( baos );

		try
		{
			long sendTimeStart = System.currentTimeMillis();

			if ( LOG.isDebugEnabled() )
			{
				LOG.debug( "Sending message id " +
				           messageToSend.getMessageID() +
				           " to " + key.hashCode() );
			}

			messageToSend.writeTo( dos );
			byte[] messageData = baos.toByteArray();

			if ( LOG.isDebugEnabled() )
			{
				LOG.debug( "Outgoing Buffer data: " +
				           ArrayUtil.toHexString( messageData, 0,
				                                  messageData.length ) );
			}

			Packet tempPacket = new Packet( messageData, messageData.length );
			tempPacket.setChannelKey( key );
			StandardUDPIncomingMessageQueue.instance().socket_.send( tempPacket );

			if ( PerformanceMonitor.instance().isMsgSendTimeEnabled() )
			{
				PerformanceMonitor.instance().addMsgSendTime( new Long( key.hashCode() + "" ),
				                                              System.currentTimeMillis() - sendTimeStart );
			}
		}
		catch ( IOException e )
		{
			LOG.error( e.getMessage(), e );
		}
	}

	public StandardUDPIncomingMessageQueue
	getCorrespondingIncomingMessageQueue()
	{
		return StandardUDPIncomingMessageQueue.instance();
	}

	public int getLocalPort()
	{
		return StandardUDPIncomingMessageQueue.instance().socket_.
		getLocalPort();
	}

	public static StandardUDPOutgoingMessageQueue instance()
	{
		if ( instance_ == null )
		{
			instance_ = new StandardUDPOutgoingMessageQueue();
		}

		return instance_;
	}


	protected static StandardUDPOutgoingMessageQueue instance_;

	//debugging code follows
}
