package com.navtools.armi.networking;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import com.navtools.util.Prototype;
import com.navtools.util.StringUtil;
import org.apache.log4j.Category;

public class TestMessage extends Message
{
	public static final Category LOG =
	Category.getInstance( TestMessage.class.getName() );

	public TestMessage( long msgID, String text )
	{
		super( msgID );
		setText( text );
	}

	public Prototype defaultInstance()
	{
		return new TestMessage( -1, "" );
	}

	//subclasses should register prototypical messages in their static block
	public static void register()
	{
		register( TYPE, new TestMessage( -1, "" ) );
	}

	public int getType()
	{
		return TYPE;
	}

	public void writeTo( DataOutputStream dos ) throws IOException
	{
		super.writeTo( dos );
		dos.writeUTF( text_ );
	}

	public void readFrom( DataInputStream dis ) throws IOException
	{
		super.readFrom( dis );
		if ( LOG.isDebugEnabled() )
		{
			LOG.debug( "in readFrom_" );
		}
		text_ = dis.readUTF();
		if ( LOG.isDebugEnabled() )
		{
			LOG.debug( "read UTF" );
		}
	}

	public String toString()
	{
		StringBuffer b = new StringBuffer( super.toString() );
		b.append( "Text: " );
		b.append( text_ );

		return b.toString();
	}

	public void setText( String text )
	{
		text_ = StringUtil.denull( text );
	}

	public String getText()
	{
		return text_;
	}

	protected String text_;
	public static final int TYPE = 0xB0BBE;//arbitrary BS number

	//com.navtools.networking.armi.networking.test code follows
}
